<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/css/main.css" media="all">

    <style>

        .error {color:#FF0000;}
        .chat-connection-ack{color: #26af26;}
        .chat-message {border-bottom-left-radius: 4px;border-bottom-right-radius: 4px;
        }
        #btnSend {background: #26af26;border: #26af26 1px solid;	border-radius: 4px;color: #FFF;display: block;margin: 15px 0px;padding: 10px 50px;cursor: pointer;
        }
        #chat-box {background: #fff8f8;border: 1px solid #ffdddd;border-radius: 4px;border-bottom-left-radius:0px;border-bottom-right-radius: 0px;min-height: 300px;padding: 10px;overflow: auto;
        }
        .chat-box-html{color: #09F;margin: 10px 0px;font-size:0.8em;}
        .chat-box-message{color: #09F;padding: 5px 10px; background-color: #fff;border: 1px solid #ffdddd;border-radius:4px;display:inline-block;}
        .chat-input{border: 1px solid #ffdddd;border-top: 0px;width: 100%;box-sizing: border-box;padding: 10px 8px;color: #191919;
        }
    </style>
    <script type="text/javascript" src="<?php gURLE('public');?>/js/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="<?php gURLE('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>
    <script>
        function showMessage(messageHTML) {
            $('#chat-box').append(messageHTML);
        }

        var escapeHTML = (function() {
            var entityMap = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': '&quot;',
                "'": '&#39;'
            };

            return function(str) {
                return String(str).replace(/[&<>"']/g, function (s) {
                    return entityMap[s];
                });
            };
        })();

        $(document).ready(function(){
            var websocket = new WebSocket("ws://localhost:8090/"); // It is not careful as ws://200.173.91.204:8090/websocket/php-socket.php
            websocket.onopen = function(event) {
                showMessage("<div class='chat-connection-ack'>Connection is established!</div>");
            };
            websocket.onmessage = function(event) {
                var Data = JSON.parse(event.data);
                showMessage("<div class='"+Data.message_type+"'>"+Data.message+"</div>");
                $('#chat-message').val('');
            };

            websocket.onerror = function(event){
                showMessage("<div class='error'>Problem due to some Error</div>");
            };
            websocket.onclose = function(event){
                showMessage("<div class='chat-connection-ack'>Connection Closed</div>");
            };

            $('#frmChat').on("submit",function(event){
                event.preventDefault();
                $('#chat-user').attr("type","hidden");
                var messageJSON = {
                    chat_user: $('#chat-user').val(),
                    chat_message: $('#chat-message').val()
                };
                websocket.send(JSON.stringify(messageJSON));
            });
        });

    </script>
</head>
<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>

<div class="w3-panel w3-info intro" style="margin: 0;">
    <div style="padding: 10px 0;">
        <?php
            $url = 'http://'.$_SERVER['HTTP_HOST'].gURL('root').'/chat/server';
            $replace = array('http_link'=>$url);
            gTextE('guide_3', $replace);
        ?>
    </div>
</div>

<div class="contanier">
<form name="frmChat" id="frmChat">
    <div id="chat-box"></div>
    <input type="text" name="chat-user" id="chat-user" placeholder="Name" class="chat-input" required />
    <textarea type="textarea" name="chat-message" id="chat-message" placeholder="Message"  class="chat-input chat-message" required></textarea>
    <input type="submit" id="btnSend" name="send-chat-message" value="Send" >
</form>
</div>

</body>
</html>