<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/css/main.css" media="all">
</head>

<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>

<div class="w3-panel w3-info intro" style="margin: 0;">
    <div style="padding: 10px 0;"><?php echo $contents; ?></div>
</div>

<div style="padding: 20px;position: relative">
    <form enctype="multipart/form-data" id="frm" name="frm">

        <input type="file" id="userfile" name="userfile" class="form-control-file border" required style="display: inline">
        <button class="btn btn-success btn-sm custom_btn1" type="submit"><?php gTextE('btn_upload')?></button>
        <img id="progress" src="<?php echo gURL('public');?>/images/wait.gif">
    </form>
</div>

<div id="files" style="padding: 20px;">
    <?php for ($i = 0; $i < count($files); ++$i): ?>
        <div>
            <a href="javascript:download('<?php echo $files[$i]?>')"><?php echo $files[$i]?></a>
            <span class="del" onclick="remove('<?php echo $files[$i]?>')"><?php gTextE('btn_delete')?></span>
        </div>
    <?php endfor; ?>
</div>


<script type="text/javascript" src="<?php gURLE('public');?>/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="<?php gURLE('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>

<script>

    $(document).ready(function(){
        init();
    });

    function download(filename) {
        window.location.href = "<?php gURLE('root');?>/files/download?filename="+filename;
    }

    function init() {
        $('#progress').hide();
        $("#frm").submit(function(e)
        {
            e.preventDefault(); /*STOP default action*/
            $('#progress').show();
            var url = "<?php gURLE('root')?>/files/upload";
            var postData = $(this).serializeArray();
            var formURL = $(this).attr("action");
            $.ajax({
                url : url,
                type: "POST",
                data: new FormData(this),
                processData: false,
                contentType: false,
                success: function(result, textStatus, jqXHR)
                {
                    $("#frm")[0].reset();
                    $('#progress').hide();
                    if(result == 1) {
                        alert("<?php gTextE('msg_success');?>");
                        readAll();
                    } else {
                        alert("<?php gTextE('msg_fail');?>");
                    }

                },
                error: function(jqXHR, textStatus, errorThrown)
                {
                    $('#progress').hide();
                    /*if fails*/
                    alert('Network Error!');
                }
            });

        });
    }

    function readAll() {
        var url = "<?php gURLE('root')?>/files/all";
        $.ajax({
            url : url,
            type: "GET",
            data: {},
            success: function(result, textStatus, jqXHR)
            {
                var files = JSON.parse(result);
                var html = '';
                files.forEach(function(item) {
                    html += '<div>\n' +
                        '            <a href="javascript:download(\''+item+'\')">'+item+'</a>\n' +
                        '            <span class="del" onclick="remove(\''+item+'\')"><?php gTextE('btn_delete');?></span>\n' +
                        '        </div>';
                });
                $('#files').html(html);
            },
            error: function(jqXHR, textStatus, errorThrown)
            {
                /*if fails*/
                alert('Network Error!');
            }
        });
    }

    function remove(filename) {
        if(!window.confirm("<?php gTextE('msg_sure');?>")) return false;
        var url = "<?php gURLE('root')?>/files/delete";
        $.ajax({
            url : url,
            type: "POST",
            data: { filename: filename },
            success: function(result, textStatus, jqXHR)
            {
                if(!result) {
                    alert(result);
                    return;
                }
                readAll();
            },
            error: function(jqXHR, textStatus, errorThrown)
            {
                /*if fails*/
                alert('Network Error!');
            }
        });
    }

</script>

</body>

</html>