<button type="button" id="button_top">
  <i class="fa fa-arrows-v" aria-hidden="true"></i><span class="sound_only">상단으로</span>
</button>

<script>
jQuery(function($) {
  var $elem = $("html, body");
  var where = 0;
  $("#button_top").on("click", function() {
    var windowHeight = $(document).height() - $(window).height();
    var winhalf = windowHeight * 0.5; // Calculate the new winhalf value

    if ($elem.scrollTop() < winhalf) {
      $elem.animate({ scrollTop: $elem.prop("scrollHeight") }, 400);
      where = 1;
    } else {
      $elem.animate({ scrollTop: 0 }, 400);
      where = 0;
    }
  });
});

$(document).ready(function() {
  $(window).scroll(function() {
    var windowHeight = $(document).height() - $(window).height();
    var winhalf = windowHeight * 0.5; // Calculate the new winhalf value
    var scrollPos = $(document).scrollTop();
    var scrollPercent = (scrollPos / windowHeight) * 100;
    var $buttonTop = $('#button_top'); // Selector variable

    if (scrollPos > winhalf) {
      $buttonTop.css({
        "border-color": "red",
        "color": "red"
      }).html("<i class='fa fa-arrow-up' aria-hidden='true'></i>");
    } else {
      $buttonTop.css({
        "border-color": "blue",
        "color": "blue"
      }).html("<i class='fa fa-arrow-down' aria-hidden='true'></i>");
    }

	// 퍼센트 출력 시작.
    if ($('#scroll_percentage').length === 0)
		{
			$('<p id="scroll_percentage"></p>').appendTo($buttonTop);
		}
		$('#scroll_percentage').text(Math.round(scrollPercent));
	// 퍼센트 출력 끝.
	// 다크모드 시작.
	var xhr = new XMLHttpRequest();
	xhr.open('HEAD', '<?php echo G5_THEME_CSS_URL?>/default_dark.css', false);
	xhr.send();

	if (xhr.status == "200") {
		if (scrollPos > 100 && scrollPos < 200) {
		  $('#button_top').css("display", "none");
		  $('.fix_ch').css("display", "block");
		} else {
		  $('.fix_ch').css("display", "none");
		  $('#button_top').css("display", "block");
		}
	} else {
	//	alert(xhr.status + "파일이 없습니다.");
	}
	// 다크모드 끝.
	// 메뉴 상단고정 시작.
	if (!g5_is_mobile) {
		$('#gnb').css({
		  "display": "block",
		  "z-index": "10000"
		});
		if (scrollPos > 186) {
		  $('#gnb').css({
			"position": "fixed",
			"top": "0",
			"width": "100%"
		  });
		} else {
		  $('#gnb').css({
			"position": "relative"
		  });
		}
	}
	// 메뉴 상단고정 끝.
  });
});
</script>

<style>
  #top_btn, .fix_ch {
	display:none
  }

  #button_top {
    position: fixed;
    bottom: 20px;
    right: 3px;
    width: 43px;
    height: 43px;
    line-height: 40px;
    border-radius: 50%;
    border: 1px solid #33333310;
    color: #333;
    text-align: center;
    font-size: 15px;
    z-index: 220;
    background: rgba(255, 255, 255, 0.5);
  }

  #button_top:hover {
    border-color: #3059c750;
    background: #3059c750;
    color: #333;
  }

  #scroll_percentage {
    font-size: 12px;
    margin-top: -27px;
    font-weight: bold;
    z-index: 999;
  }
</style>