<?php
/*
 * jQuery File Upload Plugin PHP Example 5.14
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */
include_once("./_common.php");




@include_once("./JSON.php");

if( !function_exists('json_encode') ) {
    function json_encode($data) {
        $json = new Services_JSON();
        return( $json->encode($data) );
    }
}

@ini_set('gd.jpeg_ignore_warning', 1);


function g4_path()
{
    $chroot = substr($_SERVER['SCRIPT_FILENAME'], 0, strpos($_SERVER['SCRIPT_FILENAME'], dirname(__FILE__))); 
    $result['path'] = str_replace('\\', '/', $chroot.dirname(__FILE__)); 
    $server_script_name = preg_replace('/\/+/', '/', str_replace('\\', '/', $_SERVER['SCRIPT_NAME'])); 
    $server_script_filename = preg_replace('/\/+/', '/', str_replace('\\', '/', $_SERVER['SCRIPT_FILENAME'])); 
    $tilde_remove = preg_replace('/^\/\~[^\/]+(.*)$/', '$1', $server_script_name); 
    $document_root = str_replace($tilde_remove, '', $server_script_filename); 
    $pattern = '/.*?' . preg_quote($document_root, '/') . '/i';
    $root = preg_replace($pattern, '', $result['path']); 
    $port = ($_SERVER['SERVER_PORT'] == 80 || $_SERVER['SERVER_PORT'] == 443) ? '' : ':'.$_SERVER['SERVER_PORT']; 
    $http = 'http' . ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on') ? 's' : '') . '://'; 
    $user = str_replace(preg_replace($pattern, '', $server_script_filename), '', $server_script_name); 
    $host = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_NAME']; 
    if(isset($_SERVER['HTTP_HOST']) && preg_match('/:[0-9]+$/', $host)) 
        $host = preg_replace('/:[0-9]+$/', '', $host); 
    $host = preg_replace("/[\<\>\'\"\\\'\\\"\%\=\(\)\/\^\*]/", '', $host); 
    $result['url'] = $http.$host.$port.$user.$root; 
    return $result;
}

// 마이크로 타임을 얻어 계산 형식으로 만듦
function get_microtime()
{
    list($usec, $sec) = explode(" ",microtime());
    return ((float)$usec + (float)$sec);
}

// 파일명에서 특수문자 제거
function get_safe_filename($name)
{
    $pattern = '/["\'<>=#&!%\\\\(\)\*\+\?]/';
    $name = preg_replace($pattern, '', $name);

    return $name;
}

// 파일명 치환
function replace_filename($name)
{
    @session_start();
    $ss_id = session_id();
    $usec = get_microtime();
    $file_path = pathinfo($name);
    $ext = $file_path['extension'];
    $return_filename = sha1($ss_id.$_SERVER['REMOTE_ADDR'].$usec); 
    if( $ext )
        $return_filename .= '.'.$ext;

    return $return_filename;
}

$ym = date('ym');


//$data_dir = $_SERVER["DOCUMENT_ROOT"].'/files/_etc/popup/';
//$data_url = 'http://'.$_SERVER["SERVER_NAME"].'/files/_etc/popup/';

$data_dir = $_SERVER["DOCUMENT_ROOT"].'/files/'.$ym.'/';
$data_url = '/files/'.$ym.'/';


@mkdir($data_dir, 0707);
@chmod($data_dir, 0707);



$is_editor_upload = true;


if( $is_editor_upload ) {

    //require('UploadHandler.php');
    $options = array(
        'upload_dir' => $data_dir,
        'upload_url' => $data_url,
        // This option will disable creating thumbnail images and will not create that extra folder.
        // However, due to this, the images preview will not be displayed after upload
        'image_versions' => array()
    );

    //$upload_handler = new UploadHandler($options);

	$upload_max_filesize = 1024*1024*20;
	$chars_array = array_merge(range(0,9), range('a','z'), range('A','Z'));

	// 가변 파일 업로드
	$file_upload_msg = '';
	$upload = array();

	if(isset($_FILES['bf_file']['name']) && is_array($_FILES['bf_file']['name'])) {
		for ($i=0; $i<count($_FILES['bf_file']['name']); $i++) {
			$upload[$i]['files']     = '';
			$upload[$i]['source']   = '';
			$upload[$i]['filesize'] = 0;
			$upload[$i]['image']    = array();
			$upload[$i]['image'][0] = 0;
			$upload[$i]['image'][1] = 0;
			$upload[$i]['image'][2] = 0;
			$upload[$i]['url'] = '';
			$upload[$i]['thumburl'] = '';
			$upload[$i]['storage'] = '';


			$tmp_file  = $_FILES['bf_file']['tmp_name'][$i];
			$filesize  = $_FILES['bf_file']['size'][$i];
			$filename  = $_FILES['bf_file']['name'][$i];
			$filename  = get_safe_filename($filename);

			// 서버에 설정된 값보다 큰파일을 업로드 한다면
			if ($filename) {
				if ($_FILES['bf_file']['error'][$i] == 1) {
					$file_upload_msg .= '\"'.$filename.'\" 파일의 용량이 서버에 설정('.$upload_max_filesize.')된 값보다 크므로 업로드 할 수 없습니다.\\n';
					continue;
				}
				else if ($_FILES['bf_file']['error'][$i] != 0) {
					$file_upload_msg .= '\"'.$filename.'\" 파일이 정상적으로 업로드 되지 않았습니다.\\n';
					continue;
				}
			}

			if (is_uploaded_file($tmp_file)) {
				// 관리자가 아니면서 설정한 업로드 사이즈보다 크다면 건너뜀
				if (!$my['admin'] && $filesize > $upload_max_filesize) {
					$file_upload_msg .= '\"'.$filename.'\" 파일의 용량('.number_format($filesize).' 바이트)이 게시판에 설정('.number_format($board['bo_upload_size']).' 바이트)된 값보다 크므로 업로드 하지 않습니다.\\n';
					continue;
				}

				//=================================================================\
				// 090714
				// 이미지나 플래시 파일에 악성코드를 심어 업로드 하는 경우를 방지
				// 에러메세지는 출력하지 않는다.
				//-----------------------------------------------------------------
				$timg = @getimagesize($tmp_file);
				// image type
				if ( preg_match("/\.({$config['cf_image_extension']})$/i", $filename) ||
					 preg_match("/\.({$config['cf_flash_extension']})$/i", $filename) ) {
					if ($timg['2'] < 1 || $timg['2'] > 18)
						continue;
				}
				//=================================================================

				$upload[$i]['image'] = $timg;

				$upload[$i]['width'] = $timg[0];
				$upload[$i]['height'] = $timg[1];

				// 프로그램 원래 파일명
				$upload[$i]['source'] = $filename;
				$upload[$i]['filesize'] = $filesize;

				// 아래의 문자열이 들어간 파일은 -x 를 붙여서 웹경로를 알더라도 실행을 하지 못하도록 함
				$filename = preg_replace("/\.(php|pht|phtm|htm|cgi|pl|exe|jsp|asp|inc|phar)/i", "$0-x", $filename);

				shuffle($chars_array);
				$shuffle = implode('', $chars_array);

				// 첨부파일 첨부시 첨부파일명에 공백이 포함되어 있으면 일부 PC에서 보이지 않거나 다운로드 되지 않는 현상이 있습니다. (길상여의 님 090925)
				$upload[$i]['files'] = md5(sha1($_SERVER['REMOTE_ADDR'])).'_'.substr($shuffle,0,8).'_'.replace_filename($filename);
				$upload[$i]['url'] = $data_url.$upload[$i]['files'];
				$dest_file = $data_dir.$upload[$i]['files'];

				// 업로드가 안된다면 에러메세지 출력하고 죽어버립니다.
				$error_code = move_uploaded_file($tmp_file, $dest_file) or die($_FILES['bf_file']['error'][$i]);

				// 올라간 파일의 퍼미션을 변경합니다.
				chmod($dest_file, 0707);

			}
		}   // end for
	}   // end if

	echo json_encode($upload);
    exit;

} else {
    echo json_encode(array('files'=>array('0'=>array('error'=>'정상적인 업로드가 아닙니다.'))));
	print_r($_GET);
    exit;
}