<?php
session_start();
include('connect.php');

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$post_id = $_GET['post_id'] ?? null;
if (!$post_id) {
    header("Location: board_list.php");
    exit;
}

// 글 정보 확인
try {
    $sql = "SELECT post_id, user_id FROM zb_posts WHERE post_id = :post_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':post_id', $post_id, PDO::PARAM_INT);
    $stmt->execute();
    $post = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$post) {
        header("Location: board_list.php");
        exit;
    }
} catch (Exception $e) {
    die("오류: " . $e->getMessage());
}

// 작성자 혹은 관리자만 삭제 가능
$isAdmin = $_SESSION['is_admin'] ?? 0;
if ($_SESSION['user_id'] !== $post['user_id'] && !$isAdmin) {
    header("Location: board_list.php");
    exit;
}

// 삭제 처리
try {
    $sql = "DELETE FROM zb_posts WHERE post_id = :post_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':post_id', $post_id, PDO::PARAM_INT);
    $stmt->execute();
} catch (Exception $e) {
    die("삭제 오류: " . $e->getMessage());
}

// 삭제 후 목록으로
header("Location: board_list.php");
exit;
