<?php
session_start();
include('connect.php');

// 파라미터( post_id )가 있어야 함
$post_id = $_GET['post_id'] ?? null;
if (!$post_id) {
    header("Location: board_list.php");
    exit;
}

// 게시글 정보 조회
try {
    $sql = "SELECT p.post_id, p.user_id, p.title, p.content, p.created_at, u.is_admin
            FROM zb_posts p
            JOIN zb_users u ON p.user_id = u.user_id
            WHERE post_id = :post_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':post_id', $post_id, PDO::PARAM_INT);
    $stmt->execute();
    $post = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$post) {
        // 게시글이 존재하지 않으면 목록으로
        header("Location: board_list.php");
        exit;
    }
} catch (Exception $e) {
    die("오류 발생: " . $e->getMessage());
}

// 댓글 목록 조회
try {
    $sqlComment = "SELECT c.comment_id, c.user_id, c.comment, c.created_at 
                   FROM zb_comments c
                   WHERE c.post_id = :post_id
                   ORDER BY c.comment_id ASC";
    $stmtC = $conn->prepare($sqlComment);
    $stmtC->bindValue(':post_id', $post_id, PDO::PARAM_INT);
    $stmtC->execute();
    $comments = $stmtC->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("댓글 조회 오류: " . $e->getMessage());
}

// 현재 로그인 사용자
$currentUserId = $_SESSION['user_id'] ?? null;
$isOwner = ($currentUserId && $currentUserId === $post['user_id']);
$isAdmin = isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1;
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>글 상세보기</title>
    <style>
        /* 전체 레이아웃 */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background: #f9f9f9;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .container {
            width: 90%; /* 모바일 화면에 적합한 너비 */
            max-width: 400px;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            box-sizing: border-box;
        }

        h1 {
            font-size: 1.4rem;
            margin-bottom: 10px;
            color: #333;
            text-align: center;
        }

        .info {
            font-size: 0.9rem;
            color: #666;
            margin-bottom: 15px;
            text-align: center;
        }

        hr {
            margin: 15px 0;
            border: none;
            border-top: 1px solid #eee;
        }

        p {
            font-size: 1rem;
            color: #333;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        .buttons {
            display: flex;
            justify-content: space-between;
            gap: 10px;
        }

        button {
            flex: 1;
            padding: 10px;
            background-color: #007BFF;
            color: #fff;
            border: none;
            border-radius: 6px;
            font-size: 0.9rem;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        button:hover {
            background-color: #0056b3;
        }

        .comment-box {
            margin-top: 20px;
        }

        .comment-box h3 {
            font-size: 1.2rem;
            margin-bottom: 15px;
            color: #007BFF;
        }

        .comment {
            padding: 10px;
            margin-bottom: 10px;
            background: #f1f1f1;
            border-radius: 6px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .comment .info {
            font-size: 0.8rem;
            color: #999;
            margin-bottom: 5px;
        }

        .comment .text {
            font-size: 0.9rem;
            color: #333;
            line-height: 1.4;
        }

        textarea {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 0.9rem;
            box-sizing: border-box;
            resize: none;
        }

        form button {
            width: 100%;
            background-color: #28a745;
        }

        form button:hover {
            background-color: #218838;
        }

        a {
            color: #007BFF;
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
<div class="container">
    <h1><?php echo htmlspecialchars($post['title']); ?></h1>
    <div class="info">
        작성자: <?php echo htmlspecialchars($post['user_id']); ?> | 
        작성일: <?php echo htmlspecialchars($post['created_at']); ?>
    </div>
    <hr>
    <p><?php echo nl2br(htmlspecialchars($post['content'])); ?></p>

    <div class="buttons">
        <button onclick="location.href='board_list_pagenation.php'">목록</button>
        <?php if ($currentUserId && ($isOwner || $isAdmin)): ?>
            <button onclick="location.href='board_edit.php?post_id=<?php echo $post_id; ?>'">수정</button>
            <button onclick="location.href='board_delete.php?post_id=<?php echo $post_id; ?>'">삭제</button>
        <?php endif; ?>
    </div>

    <div class="comment-box">
        <h3>댓글</h3>
        <?php if ($comments): ?>
            <?php foreach ($comments as $cmt): ?>
            <div class="comment">
                <div class="info">
                    작성자: <?php echo htmlspecialchars($cmt['user_id']); ?> | 
                    작성일: <?php echo htmlspecialchars($cmt['created_at']); ?>
                </div>
                <div class="text">
                    <?php echo nl2br(htmlspecialchars($cmt['comment'])); ?>
                </div>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p>댓글이 없습니다.</p>
        <?php endif; ?>

        <?php if ($currentUserId): ?>
            <form method="post" action="comment_process.php">
                <input type="hidden" name="post_id" value="<?php echo $post_id; ?>">
                <textarea name="comment" rows="3" placeholder="댓글을 입력하세요" required></textarea>
                <button type="submit">댓글 달기</button>
            </form>
        <?php else: ?>
            <p>댓글을 달려면 <a href="login.php">로그인</a>하세요.</p>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
