<?php
session_start();
include('connect.php');

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $content = trim($_POST['content'] ?? '');
    $user_id = $_SESSION['user_id']; 

    if ($title === "" || $content === "") {
        $message = "제목과 내용을 모두 입력해주세요.";
    } else {
        try {
            $sql = "INSERT INTO zb_posts (user_id, title, content) 
                    VALUES (:user_id, :title, :content)";
            $stmt = $conn->prepare($sql);
            $stmt->bindValue(':user_id', $user_id);
            $stmt->bindValue(':title', $title);
            $stmt->bindValue(':content', $content);
            $stmt->execute();

            // 작성 완료 후 목록으로 이동
            header("Location: board_list_pagenation.php");
            exit;
        } catch (Exception $e) {
            $message = "글 작성 오류: " . $e->getMessage();
        }
    }
}

?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>글 작성</title>
    <style>
        /* 모바일 전용 스타일 */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background: #f9f9f9;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .container {
            width: 90%; /* 모바일 화면에서 적절한 너비 */
            max-width: 400px;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            font-size: 1.5rem;
            margin-bottom: 20px;
            color: #333;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-size: 0.9rem;
            font-weight: bold;
        }

        input[type="text"], textarea {
            width: 100%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 0.9rem;
            box-sizing: border-box;
        }

        textarea {
            resize: none; /* 사용자가 크기를 조정하지 못하도록 설정 */
        }

        button {
            width: 100%;
            padding: 12px;
            margin-top: 10px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 1rem;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        button:hover {
            background-color: #0056b3;
        }

        .message {
            color: red;
            margin-bottom: 15px;
            font-size: 0.9rem;
            text-align: center;
        }

        button[type="button"] {
            background-color: #6c757d; /* 회색 버튼 */
        }

        button[type="button"]:hover {
            background-color: #5a6268; /* 어두운 회색 */
        }
    </style>
</head>
<body>
<div class="container">
    <h1>글 작성</h1>
    <?php if ($message): ?>
        <div class="message"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    <form method="post" action="">
        <label for="title">제목</label>
        <input type="text" id="title" name="title" placeholder="제목을 입력하세요" required>

        <label for="content">내용</label>
        <textarea id="content" name="content" rows="6" placeholder="내용을 입력하세요" required></textarea>

        <button type="submit">등록하기</button>
        <button type="button" onclick="location.href='board_list.php'">목록으로</button>
    </form>
</div>
</body>
</html>

