<?php
session_start();
include('connect.php');

// 로그인 확인
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$post_id = $_GET['post_id'] ?? null;
if (!$post_id) {
    header("Location: board_list.php");
    exit;
}

// 먼저 글 정보 가져오기
try {
    $sql = "SELECT post_id, user_id, title, content FROM zb_posts WHERE post_id = :post_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':post_id', $post_id, PDO::PARAM_INT);
    $stmt->execute();
    $post = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$post) {
        header("Location: board_list.php");
        exit;
    }
} catch (Exception $e) {
    die("오류: " . $e->getMessage());
}

// 작성자 혹은 관리자만 수정 가능
$isAdmin = $_SESSION['is_admin'] ?? 0;
if ($_SESSION['user_id'] !== $post['user_id'] && !$isAdmin) {
    header("Location: board_list.php");
    exit;
}

$message = "";

// 수정 처리
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $content = trim($_POST['content'] ?? '');

    if ($title === "" || $content === "") {
        $message = "제목과 내용을 모두 입력하세요.";
    } else {
        try {
            $sql = "UPDATE zb_posts
                    SET title = :title, content = :content, updated_at = NOW()
                    WHERE post_id = :post_id";
            $stmt = $conn->prepare($sql);
            $stmt->bindValue(':title', $title);
            $stmt->bindValue(':content', $content);
            $stmt->bindValue(':post_id', $post_id, PDO::PARAM_INT);
            $stmt->execute();

            header("Location: board_view.php?post_id={$post_id}");
            exit;
        } catch (Exception $e) {
            $message = "수정 오류: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>글 수정</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f9f9f9; }
        .container { max-width: 600px; margin: 30px auto; background: #fff; padding: 20px; }
        .message { color: red; }
        label { display: block; margin: 10px 0 5px; }
        input[type="text"], textarea {
            width: 100%; padding: 8px; margin-bottom: 10px; box-sizing: border-box;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>글 수정</h1>
    <?php if ($message): ?>
        <div class="message"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <form method="post" action="">
        <label for="title">제목</label>
        <input type="text" id="title" name="title" 
               value="<?php echo htmlspecialchars($post['title']); ?>">

        <label for="content">내용</label>
        <textarea id="content" name="content" rows="6"><?php echo htmlspecialchars($post['content']); ?></textarea>

        <button type="submit">수정하기</button>
        <button type="button" onclick="location.href='board_view.php?post_id=<?php echo $post_id; ?>'">취소</button>
    </form>
</div>
</body>
</html>
