<?php
session_start();
include('connect.php');

// 로그인 여부 (예: 로그인 안 했다면 로그인 페이지로 이동)
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// 게시글 목록 조회
try {
    $sql = "SELECT post_id, user_id, title, created_at FROM zb_posts ORDER BY post_id DESC";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $posts = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>게시판 목록</title>
<!--	<link rel="stylesheet" href="style.css">-->
	
    <!-- 공통 CSS -->

    <style>
/* 모바일 퍼스트 스타일 */
/* 기본적으로 모바일(600px 이하)을 대상으로 작성합니다. */

body {
  margin: 0;
  padding: 0;
  background-color: #f9f9f9;
  font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
}

.container {
  width: 95%;
  margin: 0 auto;
  padding: 10px;
  background-color: #fff;
}

h1 {
  text-align: center;
  font-size: 1.25rem;
  margin: 10px 0;
}

table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 15px;
}

th, td {
  border: 1px solid #ddd;
  padding: 8px;
  font-size: 0.875rem;
  word-break: break-word; /* 긴 문자열이 넘어가지 않도록 */
}

th {
  background-color: #007BFF;
  color: #fff;
  text-align: left;
}

button {
  width: 100%;
  margin: 10px 0;
  background-color: #007BFF;
  color: #fff;
  padding: 10px;
  border: none;
  cursor: pointer;
  font-size: 0.875rem;
  transition: background-color 0.3s ease;
}

button:hover {
  background-color: #0056b3;
}

/* 데스크톱 등 큰 화면을 위한 스타일(‘min-width’로 화면 크기가 커질 때만 적용) */
@media (min-width: 601px) {
  .container {
    max-width: 800px;
    padding: 20px;
  }
  
  h1 {
    font-size: 1.5rem;
  }

  th, td {
    font-size: 1rem;
  }

  button {
    width: auto;
    margin: 5px 0;
    font-size: 1rem;
  }
}

    </style>

</head>
<body>
<div class="container">
    <h1>게시판 목록</h1>
    <table>
        <thead>
            <tr>
                <th>번호</th>
                <th>제목</th>
                <th>작성자</th>
                <th>작성일</th>
            </tr>
        </thead>
        <tbody>
        <?php if ($posts): ?>
            <?php foreach ($posts as $post): ?>
            <tr>
                <td><?php echo htmlspecialchars($post['post_id']); ?></td>
                <td>
                    <a href="board_view.php?post_id=<?php echo $post['post_id']; ?>">
                        <?php echo htmlspecialchars($post['title']); ?>
                    </a>
                </td>
                <td><?php echo htmlspecialchars($post['user_id']); ?></td>
                <td><?php echo htmlspecialchars($post['created_at']); ?></td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="4">게시글이 없습니다.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>
    <br>
    <button onclick="location.href='board_write.php'">글 작성하기</button>
</div>
</body>
</html>
