<?php
session_start();
include('connect.php');

// 로그인 여부 (예: 로그인 안 했다면 로그인 페이지로 이동)
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// 현재 페이지 설정 (기본값 1)
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;  // 페이지가 1보다 작은 경우 보정

// 페이지당 표시할 게시글 수
$posts_per_page = 10;

// LIMIT 시작점
$start_index = ($page - 1) * $posts_per_page;

// 게시글 총 개수 구하기
try {
    $count_sql = "SELECT COUNT(*) as total FROM zb_posts";
    $count_stmt = $conn->prepare($count_sql);
    $count_stmt->execute();
    $total_posts = $count_stmt->fetchColumn();  // 총 게시글 수
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}

// 총 페이지 수
$total_pages = ceil($total_posts / $posts_per_page);

// 페이지에 해당하는 게시글 목록 조회
try {
    $sql = "SELECT post_id, user_id, title, created_at 
            FROM zb_posts 
            ORDER BY post_id DESC
            LIMIT :start_index, :posts_per_page";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':start_index', $start_index, PDO::PARAM_INT);
    $stmt->bindValue(':posts_per_page', $posts_per_page, PDO::PARAM_INT);
    $stmt->execute();
    $posts = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>게시판 목록</title>
    <style>
        /* 모바일 퍼스트 스타일 */
        body {
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        }

        .container {
            width: 95%;
            margin: 0 auto;
            padding: 10px;
            background-color: #fff;
        }

        h1 {
            text-align: center;
            font-size: 1.25rem;
            margin: 10px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            font-size: 0.875rem;
            word-break: break-word; /* 긴 문자열이 넘어가지 않도록 */
        }

        th {
            background-color: #007BFF;
            color: #fff;
            text-align: left;
        }

        button {
            margin: 10px 0;
            background-color: #007BFF;
            color: #fff;
            padding: 10px;
            border: none;
            cursor: pointer;
            font-size: 0.875rem;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #0056b3;
        }

        /* 페이지네이션 영역 */
        .pagination {
            margin-top: 15px;
            text-align: center;
        }

        .pagination a {
            display: inline-block;
            margin: 0 5px;
            padding: 5px 8px;
            color: #007BFF;
            text-decoration: none;
            border: 1px solid #ddd;
            font-size: 0.875rem;
        }

        .pagination a:hover {
            background-color: #007BFF;
            color: #fff;
        }

        @media (min-width: 601px) {
            .container {
                max-width: 800px;
                padding: 20px;
            }

            h1 {
                font-size: 1.5rem;
            }

            th, td {
                font-size: 1rem;
            }

            button {
                width: auto;
                margin: 5px 0;
                font-size: 1rem;
            }

            .pagination a {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h1>게시판 목록</h1>
    <table>
        <thead>
            <tr>
                <th>번호</th>
                <th>제목</th>
                <th>작성자</th>
                <th>작성일</th>
            </tr>
        </thead>
        <tbody>
        <?php if ($posts): ?>
            <?php foreach ($posts as $post): ?>
                <tr>
                    <td><?php echo htmlspecialchars($post['post_id']); ?></td>
                    <td>
                        <a href="board_view.php?post_id=<?php echo $post['post_id']; ?>">
                            <?php echo htmlspecialchars($post['title']); ?>
                        </a>
                    </td>
                    <td><?php echo htmlspecialchars($post['user_id']); ?></td>
                    <td><?php echo htmlspecialchars($post['created_at']); ?></td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="4">게시글이 없습니다.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>

    <!-- 글 작성하기 버튼 -->
    <button onclick="location.href='board_write.php'">글 작성하기</button>
    <!-- 홈으로 가기 버튼 -->
    <button onclick="location.href='http://gratia.kr/zz/admin_dashboard_pc.php'">게시판 홈으로 가기</button>

    <!-- 페이지네이션 -->
    <?php if ($total_pages > 1): ?>
    <div class="pagination">
        <?php
        // 이전 페이지
        if ($page > 1) {
            echo '<a href="?page=' . ($page - 1) . '">이전</a>';
        }

        // 페이지 번호들
        for ($i = 1; $i <= $total_pages; $i++) {
            echo '<a href="?page=' . $i . '">' . $i . '</a>';
        }

        // 다음 페이지
        if ($page < $total_pages) {
            echo '<a href="?page=' . ($page + 1) . '">다음</a>';
        }
        ?>
    </div>
    <?php endif; ?>
</div>
</body>
</html>
