<?php
session_start();
include('connect.php');

// 파라미터( post_id )가 있어야 함
$post_id = $_GET['post_id'] ?? null;
if (!$post_id) {
    header("Location: board_list.php");
    exit;
}

// 게시글 정보 조회
try {
    $sql = "SELECT p.post_id, p.user_id, p.title, p.content, p.created_at, u.is_admin
            FROM zb_posts p
            JOIN zb_users u ON p.user_id = u.user_id
            WHERE post_id = :post_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':post_id', $post_id, PDO::PARAM_INT);
    $stmt->execute();
    $post = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$post) {
        // 게시글이 존재하지 않으면 목록으로
        header("Location: board_list.php");
        exit;
    }
} catch (Exception $e) {
    die("오류 발생: " . $e->getMessage());
}

// 댓글 목록 조회
try {
    $sqlComment = "SELECT c.comment_id, c.user_id, c.comment, c.created_at 
                   FROM zb_comments c
                   WHERE c.post_id = :post_id
                   ORDER BY c.comment_id ASC";
    $stmtC = $conn->prepare($sqlComment);
    $stmtC->bindValue(':post_id', $post_id, PDO::PARAM_INT);
    $stmtC->execute();
    $comments = $stmtC->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("댓글 조회 오류: " . $e->getMessage());
}

// 현재 로그인 사용자
$currentUserId = $_SESSION['user_id'] ?? null;
$isOwner = ($currentUserId && $currentUserId === $post['user_id']);
$isAdmin = isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1;
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>글 상세보기</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f9f9f9; }
        .container { max-width: 800px; margin: 20px auto; background: #fff; padding: 20px; }
        h1 { margin-bottom: 0; }
        .info { color: #666; font-size: 14px; }
        .buttons { margin-top: 20px; }
        .comment-box { background: #f1f1f1; margin-top: 20px; padding: 10px; }
        .comment { margin-bottom: 10px; padding: 5px; background: #fafafa; }
        .comment .info { font-size: 12px; color: #999; }
    </style>
</head>
<body>
<div class="container">
    <h1><?php echo htmlspecialchars($post['title']); ?></h1>
    <div class="info">
        작성자: <?php echo htmlspecialchars($post['user_id']); ?> | 
        작성일: <?php echo htmlspecialchars($post['created_at']); ?>
    </div>
    <hr>
    <p><?php echo nl2br(htmlspecialchars($post['content'])); ?></p>

    <div class="buttons">
        <button onclick="location.href='board_list_pagenation.php'">목록</button>
        <?php if ($currentUserId && ($isOwner || $isAdmin)): ?>
            <button onclick="location.href='board_edit.php?post_id=<?php echo $post_id; ?>'">수정</button>
            <button onclick="location.href='board_delete.php?post_id=<?php echo $post_id; ?>'">삭제</button>
        <?php endif; ?>
    </div>

    <!-- 댓글 목록 표시 -->
    <div class="comment-box">
        <h3>댓글</h3>
        <?php if ($comments): ?>
            <?php foreach ($comments as $cmt): ?>
            <div class="comment">
                <div class="info">
                    작성자: <?php echo htmlspecialchars($cmt['user_id']); ?> | 
                    작성일: <?php echo htmlspecialchars($cmt['created_at']); ?>
                </div>
                <div class="text">
                    <?php echo nl2br(htmlspecialchars($cmt['comment'])); ?>
                </div>
                <!-- 본인 혹은 관리자면 수정/삭제 가능(선택 구현) -->
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p>댓글이 없습니다.</p>
        <?php endif; ?>

        <!-- 댓글 작성 폼 (로그인한 유저만) -->
        <?php if ($currentUserId): ?>
            <form method="post" action="comment_process.php">
                <input type="hidden" name="post_id" value="<?php echo $post_id; ?>">
                <textarea name="comment" rows="3" style="width:100%;"></textarea>
                <button type="submit">댓글 달기</button>
            </form>
        <?php else: ?>
            <p>댓글을 달려면 <a href="login.php">로그인</a>하세요.</p>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
