<?php
session_start();
include('connect.php');

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $content = trim($_POST['content'] ?? '');
    $user_id = $_SESSION['user_id']; 

    if ($title === "" || $content === "") {
        $message = "제목과 내용을 모두 입력해주세요.";
    } else {
        try {
            $sql = "INSERT INTO zb_posts (user_id, title, content) 
                    VALUES (:user_id, :title, :content)";
            $stmt = $conn->prepare($sql);
            $stmt->bindValue(':user_id', $user_id);
            $stmt->bindValue(':title', $title);
            $stmt->bindValue(':content', $content);
            $stmt->execute();

            // 작성 완료 후 목록으로 이동
            header("Location: board_list_pagenation.php");
            exit;
        } catch (Exception $e) {
            $message = "글 작성 오류: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>글 작성</title>
    <style>
        /* 공통 스타일(생략 가능) */
        body { font-family: Arial, sans-serif; background: #f9f9f9; }
        .container { max-width: 600px; margin: 30px auto; background: #fff; padding: 20px; }
        label { display: block; margin: 10px 0 5px; }
        input[type="text"], textarea {
            width: 100%; padding: 8px; margin-bottom: 10px; box-sizing: border-box;
        }
        .message { color: red; margin-top: 10px; }
    </style>
</head>
<body>
<div class="container">
    <h1>글 작성</h1>
    <?php if ($message): ?>
        <div class="message"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    <form method="post" action="">
        <label for="title">제목</label>
        <input type="text" id="title" name="title">

        <label for="content">내용</label>
        <textarea id="content" name="content" rows="6"></textarea>

        <button type="submit">등록하기</button>
        <button type="button" onclick="location.href='board_list_pagenation.php'">목록으로</button>
    </form>
</div>
</body>
</html>
