<!DOCTYPE html>
<html>
<body>

<?php
// 데이터베이스 연결 파일 포함
include('connect.php');

echo "<div style='font-family: Arial, sans-serif; margin: 20px;'>";

try {
    // SQL 쿼리 준비 및 실행
    $stmt = $conn->prepare("SELECT id, user_id, email, is_admin, photo,  created_at FROM zb_users");
    $stmt->execute();

    // 결과를 반복문으로 출력
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "<div style='border: 1px solid black; margin-bottom: 20px; padding: 15px; border-radius: 5px;'>";
        echo "<div><strong>No:</strong> {$row['id']}</div>";
        echo "<div><strong>User:</strong> {$row['user_id']}</div>";
        echo "<div><strong>Email:</strong> {$row['email']}</div>";
        echo "<div><strong>Role:</strong> {$row['is_admin']}</div>";
		
       echo "<div><strong>Photo:</strong> <br>";
if (file_exists($row['photo'])) {
    echo "<img src='" . htmlspecialchars($row['photo']) . "' alt='Image' style='width:200px; height:auto;'>";
} else {
    echo "이미지가 존재하지 않습니다.";
}
echo "</div>";

				
        echo "<div><strong>Created At:</strong> {$row['created_at']}</div>";
        echo "</div>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}

// 연결 종료
$conn = null;

echo "</div>";
?>

<!-- 인덱스 페이지로 돌아가기 버튼 -->
<div style="text-align: center; margin-top: 20px;">
    <a href='index.php' style='display: inline-block; padding: 10px 20px; background-color: #007BFF; color: white; text-decoration: none; border-radius: 5px;'>Go to Index</a>
</div>

</body>
</html>
