<?php
session_start();

// (옵션) 관리자 로그인 체크 등 (예: if (!isset($_SESSION['is_admin']) ... )

// DB 연결
include('db/connect.php');

// "체크박스에서 선택한 회원의 id"를 GET 파라미터로 받음.
// 예: view_users_pc.php?action=edit&selected_ids[]=123 → edit_info_checked.php?id=123
if (!isset($_GET['id'])) {
    // id 파라미터가 없으면 에러 처리
    die("수정할 회원의 id가 지정되지 않았습니다.");
}

// 수정할 회원의 PK (zb_users 테이블의 'id'라고 가정)
$edit_id = (int)$_GET['id'];

$message = "";

// 1) 폼이 제출(POST)되었다면 → DB UPDATE 로직
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 입력값 가져오기
    $email = trim($_POST['email']);
    $is_admin = trim($_POST['is_admin']);  // 1이면 관리자, 0이면 일반회원

    // 비밀번호(옵션)
    $password = trim($_POST['password']);
    $confirmPassword = trim($_POST['confirm_password']);

    // 사진(옵션)
    $photo = isset($_FILES['photo']) ? $_FILES['photo'] : null;

    // 이메일 검증
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "유효한 이메일 주소를 입력하세요.";
    } else {
        // 비밀번호 해시화
        $hashedPassword = null;
        if (!empty($password) || !empty($confirmPassword)) {
            if ($password !== $confirmPassword) {
                $message = "비밀번호가 일치하지 않습니다.";
            } else {
                $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            }
        }

        // 사진 업로드 처리
        $photoPath = null;
        if ($photo && $photo['error'] === UPLOAD_ERR_OK) {
            $uploadDir = 'uploads/photos/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
            $photoPath = $uploadDir . uniqid() . "_" . basename($photo['name']);

            if (!move_uploaded_file($photo['tmp_name'], $photoPath)) {
                $message = "사진 업로드 실패.";
            }
        }

        // 에러 메시지가 없다면 DB 업데이트
        if (empty($message)) {
            try {
                // 기존 데이터(사진) 가져오기
                $sqlSelect = "SELECT photo FROM zb_users WHERE id = :id";
                $stmtSelect = $conn->prepare($sqlSelect);
                $stmtSelect->bindValue(':id', $edit_id, PDO::PARAM_INT);
                $stmtSelect->execute();
                $oldData = $stmtSelect->fetch(PDO::FETCH_ASSOC);

                if (!$oldData) {
                    die("해당 사용자가 존재하지 않습니다. (id=$edit_id)");
                }
                $oldPhotoPath = $oldData['photo'];

                // 업데이트할 필드 동적 구성
                $fieldsToUpdate = "email = :email, is_admin = :is_admin";
                if ($hashedPassword) {
                    $fieldsToUpdate .= ", password = :password";
                }
                if ($photoPath) {
                    $fieldsToUpdate .= ", photo = :photo";
                }

                $sqlUpdate = "UPDATE zb_users 
                              SET $fieldsToUpdate 
                              WHERE id = :id";
                $stmtUpdate = $conn->prepare($sqlUpdate);

                $stmtUpdate->bindValue(':email', $email);
                $stmtUpdate->bindValue(':is_admin', $is_admin, PDO::PARAM_INT);

                if ($hashedPassword) {
                    $stmtUpdate->bindValue(':password', $hashedPassword);
                }
                if ($photoPath) {
                    $stmtUpdate->bindValue(':photo', $photoPath);
                }
                $stmtUpdate->bindValue(':id', $edit_id, PDO::PARAM_INT);

                if ($stmtUpdate->execute()) {
                    // (선택) 기존 사진 삭제
                    // if ($photoPath && $oldPhotoPath && file_exists($oldPhotoPath)) {
                    //     unlink($oldPhotoPath);
                    // }

                    // 업데이트 성공 시 alert 후, 목록 페이지 이동 (예: view_users_pc.php)
                    if ($is_admin == 1) {
                        echo "<script>
                                alert('회원(ID: $edit_id) → 관리자 계정 정보가 수정되었습니다.');
                                window.location.href = 'view_users_mobile.php';
                              </script>";
                        exit;
                    } else {
                        echo "<script>
                                alert('회원(ID: $edit_id) 정보가 수정되었습니다.');
                                window.location.href = 'view_users_mobile.php';
                              </script>";
                        exit;
                    }
                } else {
                    $message = "회원정보 업데이트 실패.";
                }
            } catch (Exception $e) {
                $message = "오류 발생: " . $e->getMessage();
            }
        }
    }
}

// 2) 페이지가 처음 열리거나, 수정 오류가 있을 때 → DB에서 해당 user 정보 다시 조회
$sql = "SELECT id, user_id, email, is_admin, photo 
        FROM zb_users 
        WHERE id = :id";
$stmt = $conn->prepare($sql);
$stmt->bindValue(':id', $edit_id, PDO::PARAM_INT);
$stmt->execute();
$userData = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$userData) {
    die("수정 대상 회원이 존재하지 않습니다. (id=$edit_id)");
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>회원정보 수정(선택된 ID: <?= htmlspecialchars($edit_id) ?>)</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        /* 공통 스타일 */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
        }
        .container {
            max-width: 480px;
            margin: 20px auto;
            padding: 20px;
            background: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
        }
        input, select {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }
        button {
            margin-top: 20px;
            width: 100%;
            padding: 12px;
            background: #007BFF;
            color: white;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
        }
        button:hover {
            background: #0056b3;
        }
        .message {
            margin-top: 15px;
            color: red;
            font-weight: bold;
        }
        img {
            max-width: 100%; 
            height: auto; 
            margin-top: 10px;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>회원정보 수정</h2>

    <!-- 에러/알림 메시지 -->
    <?php if (!empty($message)): ?>
        <div class="message"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form action="" method="POST" enctype="multipart/form-data">
        <label>User ID (읽기 전용)</label>
        <input type="text" value="<?= htmlspecialchars($userData['user_id']) ?>" readonly>

        <label for="email">Email</label>
        <input type="email" id="email" name="email"
               value="<?= htmlspecialchars($userData['email']) ?>" required>

        <label for="is_admin">Role</label>
        <select id="is_admin" name="is_admin" required>
            <option value="0" <?= ($userData['is_admin'] == 0) ? 'selected' : '' ?>>일반회원</option>
            <option value="1" <?= ($userData['is_admin'] == 1) ? 'selected' : '' ?>>관리자</option>
        </select>

        <label for="password">새 비밀번호 (변경시만 입력)</label>
        <input type="password" id="password" name="password">

        <label for="confirm_password">새 비밀번호 확인</label>
        <input type="password" id="confirm_password" name="confirm_password">

        <?php if (!empty($userData['photo'])): ?>
            <label>현재 사진</label>
            <img src="<?= htmlspecialchars($userData['photo']) ?>" alt="Current Photo">
        <?php endif; ?>

        <label for="photo">프로필 사진 변경</label>
        <input type="file" id="photo" name="photo" accept="image/*">

        <button type="submit">정보 수정</button>
    </form>
</div>
</body>
</html>
