<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>회원가입</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f9f9f9;
        }
        form {
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            box-sizing: border-box;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input, select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }
        button {
            width: 100%;
            padding: 10px;
            background: #007BFF;
            color: white;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
        }
        button:hover {
            background: #0056b3;
        }
    </style>
    <script>
        function validateForm() {
            const userId = document.getElementById('user_id').value;
            const password = document.getElementById('password').value;
            const confirmPassword = document.getElementById('confirm_password').value;

            // user_id 검증
            const userIdPattern = /^[a-zA-Z0-9_-]+$/;
            if (!userIdPattern.test(userId)) {
                alert("User ID는 영문자, 숫자, '_', '-'만 사용할 수 있습니다.");
                return false;
            }

            // 비밀번호 확인
            if (password !== confirmPassword) {
                alert("비밀번호가 일치하지 않습니다.");
                return false;
            }

            return true;
        }
    </script>
</head>
<body>
    <form action="signup_action.php" method="POST" enctype="multipart/form-data" onsubmit="return validateForm();">
        <h1>회원가입</h1>
        
        <label for="user_id">User ID:</label>
        <input type="text" id="user_id" name="user_id" required>

        <label for="password">Password:</label>
        <input type="password" id="password" name="password" required>

        <label for="confirm_password">Confirm Password:</label>
        <input type="password" id="confirm_password" required>

        <label for="email">Email:</label>
        <input type="email" id="email" name="email" required>

        <label for="is_admin">Role:</label>
        <select id="is_admin" name="is_admin" required>
            <option value="0">일반회원</option>
            <option value="1">관리자</option>
        </select>

        <label for="photo">Photo:</label>
        <input type="file" id="photo" name="photo" accept="image/*">

        <button type="submit">회원가입</button>
    </form>
</body>
</html>
