<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// 모바일 여부 감지
function isMobile() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $mobileAgents = ['iPhone', 'iPad', 'Android', 'webOS', 'BlackBerry', 'Windows Phone', 'Opera Mini', 'IEMobile'];
    foreach ($mobileAgents as $device) {
        if (stripos($userAgent, $device) !== false) {
            return true;
        }
    }
    return false;
}

// 게시판 경로 설정
$boardListUrl = isMobile() ? 'bbs/mobile/board_list_pagenation.php' : 'bbs/pc/board_list_pagenation.php';
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>유저 대시보드</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f4f4;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            max-width: 600px;
            width: 90%;
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        h1 {
            color: #333;
        }
        .welcome {
            font-size: 18px;
            margin-bottom: 20px;
            color: #555;
        }
        .button-group {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        a {
            display: block;
            padding: 10px 20px;
            background: #007BFF;
            color: #ffffff;
            text-decoration: none;
            border-radius: 4px;
            font-size: 16px;
        }
        a:hover {
            background: #0056b3;
        }
        .logout {
            margin-top: 20px;
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        
        <h2>User_Dashboard_Mobile</h2>
		<p class="welcome">환영합니다, <?= htmlspecialchars($_SESSION['user_id']) ?>님!</p>
        <div class="button-group">
			<a href="<?= $boardListUrl ?>">게시판 보기</a>
			<a href="view_login_user_mobile.php">로그인한 회원 정보보기</a>
            <a href="edit_info_mobile.php">본인정보수정</a>
			<a href="skin/list_player/index.php">WittaZury Music</a>
        </div>
        <a href="logout.php" class="logout">로그아웃</a>
    </div>
</body>
</html>
