<?php
session_start();

// 로그인 여부 확인
if (!isset($_SESSION['user_id'])) {
    // 로그인하지 않았다면 로그인 페이지로 이동
    header("Location: login.php");
    exit;
}

// DB 연결 파일 포함
include('connect.php');

// 에러 표시 활성화(개발 중에만 사용)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 로그인한 사용자 정보
$loggedInUserId = $_SESSION['user_id'];
$isAdmin = $_SESSION['is_admin'];  // 1이면 관리자, 0이면 일반회원

try {
    if ($isAdmin == 1) {
        // 관리자: 모든 회원 정보 조회
        $sql = "SELECT id, user_id, email, is_admin, photo, created_at
                FROM zb_users
                ORDER BY id ASC";
        $stmt = $conn->prepare($sql);
        $stmt->execute();
    } else {
        // 일반회원: 본인 정보만 조회
        $sql = "SELECT id, user_id, email, is_admin, photo, created_at
                FROM zb_users
                WHERE user_id = :loggedInUserId
                LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->bindValue(':loggedInUserId', $loggedInUserId);
        $stmt->execute();
    }
    
    // 결과 세트 가져오기
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("회원 정보를 불러오는 중 오류 발생: " . $e->getMessage());
}

// DB 연결 해제 (선택적으로 수행)
$conn = null;
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>회원정보 조회</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 10px;
            padding: 0;
            background-color: #f5f5f5;
        }
        h1.center {
            text-align: center;
            font-size: 1.5rem;
            margin-bottom: 20px;
        }
        .user-info {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin: 10px auto;
            padding: 10px;
            max-width: 500px;
            background-color: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        .user-info div {
            display: flex;
            justify-content: space-between;
            font-size: 0.9rem;
        }
        .user-info div strong {
            width: 40%;
        }
        .user-info div span, .user-info div img {
            width: 60%;
        }
        .user-info img {
            max-width: 100px;
            height: auto;
            border-radius: 5px;
        }
        .edit-btn {
            display: inline-block;
            padding: 6px 12px;
            font-size: 0.8rem;
            color: #fff;
            background-color: #28a745;
            text-decoration: none;
            border-radius: 4px;
            text-align: center;
        }
        .edit-btn:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>

<h1 class="center">회원정보 조회</h1>

<?php if (count($users) > 0): ?>
    <?php foreach ($users as $user): ?>
        <div class="user-info">
            <div><strong>No:</strong> <span><?php echo htmlspecialchars($user['id']); ?></span></div>
            <div><strong>User ID:</strong> <span><?php echo htmlspecialchars($user['user_id']); ?></span></div>
            <div><strong>Role:</strong> <span><?php echo $user['is_admin'] ? '관리자' : '일반회원'; ?></span></div>
            <div><strong>Photo:</strong> 
                <?php if (!empty($user['photo'])): ?>
                    <img src="<?php echo htmlspecialchars($user['photo']); ?>" alt="User Photo">
                <?php else: ?>
                    <span>사진 없음</span>
                <?php endif; ?>
            </div>
            <div><strong>가입일:</strong> <span><?php echo htmlspecialchars($user['created_at']); ?></span></div>
            <div><strong>개인정보수정:</strong> 
                <a class="edit-btn" href="edit_info_mobile.php?user_id=<?php echo urlencode($user['user_id']); ?>">수정</a>
            </div>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="no-data">등록된 회원이 없습니다.</div>
<?php endif; ?>

</body>
</html>
