<?php
// CSV 파일 경로
$csv_file = "KR_NIPLIST_CLEANED.csv";
// 방문자의 실제 IP 주소 가져오기
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return $_SERVER['HTTP_X_FORWARDED_FOR'];
    return $_SERVER['REMOTE_ADDR'];
}

$visitor_ip = getUserIP();
// IP가 한국 대역인지 확인하는 함수
function isIpAllowed($ip, $csv_file) {
    if (($handle = fopen($csv_file, "r")) !== FALSE) {
        fgetcsv($handle); // 헤더 건너뛰기
        while (($data = fgetcsv($handle)) !== FALSE) {
            $start_ip = trim($data[1]);
            $end_ip = trim($data[2]);

            if (ip2long($ip) >= ip2long($start_ip) && ip2long($ip) <= ip2long($end_ip)) {
                fclose($handle);
                return true;
            }
        }
        fclose($handle);
    }
    return false;
}
// 해외 IP 차단
if (!isIpAllowed($visitor_ip, $csv_file)) {
	echo '<meta http-equiv="refresh" content="0;url=http://'.$_SERVER["REMOTE_ADDR"].'">';
	exit;
}