
var spawn = require('child_process').spawn;
var path = (require('os').platform().indexOf('win') == 0) ? __dirname+'/bin/iconv' : 'iconv';

var iconv = function(/*charset, data, callback, bool */) {

	var args = {
		charset  : undefined,
		data     : undefined,
		bool     : true,
		callback : undefined,
		error    : undefined,
		type     : undefined
	};
	
	for (var i=0; i < arguments.length;i++ ) 
	{
		var type = typeof arguments[i];
		switch (type)
		{
		case 'function':
			if (args.callback) args.error =  arguments[i];
			else args.callback =  arguments[i];
			continue;
		case 'string':
			if (args.charset) args.data = arguments[i];
			else args.charset = arguments[i];
			continue;
		case 'boolean':
			args.bool = arguments[i];
			continue;
		default :
			args.data = arguments[i];
		}
	}

	// check type
	switch (typeof args.data)
	{
	case "string":
		args.type = "string";
		break;
	case "object":
		args.type =  (Buffer.isBuffer(args.data)) ? "buffer" : "stream"	
	}

	var option = []; // ['-s','-f','utf-8','-t','utf-8'];

	if (args.bool === undefined) option.push('-sc'); // ignore character && error
	else if (args.bool) option.push('-c'); // ignore character
	else option.push('-s'); //ignore error

	if (args.type == "string") {
		option.push('-f');
		option.push('utf-8');
		option.push('-t');
		option.push(args.charset);
	} else {
		option.push('-f');
		option.push(args.charset);
		option.push('-t');
		option.push('utf-8');
	}

	var _iconv = spawn(path, option);
	
	_iconv.stdout.on('data', function (data) {
		if (args.callback) {
			if (args.type!='string') args.callback(data.toString('utf-8'));
			else args.callback(data);
		}
	});

	_iconv.stderr.on('data', function (data) {
		if (args.error) args.error(data);
	});

	if (args.type=="stream") {
		args.data.pipe(_iconv.stdin);
	} else if (args.type=="buffer")	{
		_iconv.stdin.write(args.data);
		_iconv.stdin.end();
	} else if (args.type=="string")	{
		_iconv.stdin.write(new Buffer(args.data, 'utf-8'));
		_iconv.stdin.end();
	}
}

module.exports = iconv;