﻿import mx.transitions.Tween;
import mx.transitions.easing.*;

class PhotoSlide{
	
	private var urls:Array;
	private var links:Array;
	private var list_num:Number;
	
	private var target_mc:MovieClip;
	private var container_mc:MovieClip;
	private var image_mc:MovieClip;
	private var button_mc:MovieClip;
	
	private var containerDepth:Number;
	private static var imageDepth:Number = 0;
	private static var buttonDepth:Number = 1;
	
	private var imageLoader:MovieClipLoader;
	private var WhoIsOn:Number;
	
	private var slideTimer:Number;
	
	
	/*생성자---------------------------------------------------------------------------*/
	public function PhotoSlide(url:String, target:MovieClip, depth:Number, x:Number, y:Number){
		urls = new Array();
		links = new Array();
		
		target_mc = target;
		containerDepth = depth;
		
		imageLoader = new MovieClipLoader();
		imageLoader.addListener(this);
		
		initXML(url);
		buildViewer(x, y);
	}
	
	/*XML데이타 파싱-------------------------------------------------*/
	private function initXML(url:String):Void{
		var photo_xml:XML = new XML();
		photo_xml.ignoreWhite = true;
		
		var thisObj:PhotoSlide = this; 
		
		photo_xml.onLoad = function(success:Boolean){
			if(success){
				var photos:Array = this.firstChild.childNodes;
				thisObj.list_num = photos.length;
				
				for(var i:Number = 0; i<thisObj.list_num; i++){
					thisObj.urls.push(photos[i].attributes.url);
					thisObj.links.push(photos[i].attributes.link);
				}
				thisObj.WhoIsOn = 0;
				thisObj.loadImage(thisObj.urls[thisObj.WhoIsOn]);
			}
		}
		photo_xml.load(url);
	}
	
	/*불러올 VIsual이 들어갈 컨테이너 생성-------------------------*/
	private function buildViewer(x:Number, y:Number):Void{
		createMainContainer(x, y);
		createImageClip();
		createButtonClip();
	}
	
	private function createMainContainer(x:Number, y:Number):Void{
		container_mc = target_mc.createEmptyMovieClip("container_mc" + containerDepth, containerDepth);
		container_mc._x = x;
		container_mc._y = y;

	}
	
	private function createImageClip():Void{
		image_mc = container_mc.createEmptyMovieClip("image_mc", imageDepth);
	}
	
	private function createButtonClip():Void{
		button_mc = container_mc.createEmptyMovieClip("button_mc", buttonDepth);
	}
	
	private function nextPhoto():Void{
		this.WhoIsOn++;
		//image_mc.clear();
		loadImage(this.urls[this.WhoIsOn % this.list_num]);
	}
	
	
		
	/*이미지 로드--------------------------------------------*/	
	private function loadImage(url:String):Void{
		imageLoader.loadClip(url, container_mc.image_mc);
	}
	
	/*이미지가 로드된 시점에 실행될 액션------------------*/
	private function onLoadInit(target:MovieClip):Void{
		
		var thisObj:PhotoSlide = this;
		var image_mc:MovieClip = container_mc.image_mc;
		
		
		var tw1:Tween = new Tween(image_mc, "_alpha", Regular.easeOut, 0, 100, 1, true);
		tw1.FPS = 30;
		

		
		clearInterval(slideTimer);
		slideTimer = setInterval(this, "nextPhoto", 3000);
	}
		
}
