package pe.kr.theeye.cameracrop;

import java.io.File;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;


public class CameraCropActivity extends Activity 
{
	private static final int PICK_FROM_CAMERA = 0;
	private static final int PICK_FROM_ALBUM = 1;
	private static final int CROP_FROM_CAMERA = 2;

	private Uri mImageCaptureUri;
	private ImageView mPhotoImageView;
	Bitmap photo;
	private int currentAngle = 0;
	// ѹ ȸؾ Ǵ 
	private static final int ROTATE_VALUE = 90;
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		mPhotoImageView = (ImageView) findViewById(R.id.image);


		findViewById(R.id.button).setOnClickListener(mClickListener);
		findViewById(R.id.button1).setOnClickListener(mClickListener);


	}
	//ư   κ 
	Button.OnClickListener mClickListener = new View.OnClickListener(){
		public void onClick(View v){
			switch (v.getId()){
			case R.id.button1:
//				mOrgImage = BitmapFactory.decodeResource(getResources(), R.id.image);

				int width = mPhotoImageView.getWidth();
				int height = mPhotoImageView.getHeight();
				currentAngle = ROTATE_VALUE + (currentAngle % 360);
				Bitmap resize = getImageProcess(photo, currentAngle, width, height);
				mPhotoImageView.setImageBitmap(resize);
				return;

			case R.id.button:
				Dialog_Test();
				return;
			}
			return;
		}
	};

	private Bitmap getImageProcess(Bitmap bmp, int nRotate, int viewW, int viewH){

		Matrix matrix = new Matrix();


		matrix.postRotate(nRotate); // ȸ
		Bitmap rotateBitmap = Bitmap.createBitmap(bmp, 0, 0, bmp.getWidth(), bmp.getHeight(), matrix, true);

		Bitmap resize = Bitmap.createScaledBitmap(rotateBitmap, viewW, viewH, true);

		return resize;
	}
	/**
	 * ī޶󿡼 ̹ 
	 */
	private void doTakePhotoAction()
	{
		/*
		 *  غ
		 * http://2009.hfoss.org/Tutorial:Camera_and_Gallery_Demo
		 * http://stackoverflow.com/questions/1050297/how-to-get-the-url-of-the-captured-image
		 * http://www.damonkohler.com/2009/02/android-recipes.html
		 * http://www.firstclown.us/tag/android/
		 */

		Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);

		// ӽ÷   θ 
		String url = "tmp_" + String.valueOf(System.currentTimeMillis()) + ".jpg";
		mImageCaptureUri = Uri.fromFile(new File(Environment.getExternalStorageDirectory(), url));

		intent.putExtra(android.provider.MediaStore.EXTRA_OUTPUT, mImageCaptureUri);
		intent.putExtra("return-data", true);
		startActivityForResult(intent, PICK_FROM_CAMERA);
	}

	/**
	 * ٹ ̹ 
	 */
	private void doTakeAlbumAction()
	{
		// ٹ ȣ
		Intent intent = new Intent(Intent.ACTION_PICK);
		intent.setType(android.provider.MediaStore.Images.Media.CONTENT_TYPE);
		startActivityForResult(intent, PICK_FROM_ALBUM);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if(resultCode != RESULT_OK)
		{
			return;
		}

		switch(requestCode)
		{
		case CROP_FROM_CAMERA:
		{
			// ũ   ̹ Ѱ ޽ϴ. ̹信 ̹ شٰų ΰ ۾ Ŀ
			// ӽ  մϴ.
			final Bundle extras = data.getExtras();

			if(extras != null)
			{
				photo = extras.getParcelable("data");
				mPhotoImageView.setImageBitmap(photo);
			}

			// ӽ  
			File f = new File(mImageCaptureUri.getPath());
			if(f.exists())
			{
				f.delete();
			}

			break;
		}

		case PICK_FROM_ALBUM:
		{
			//  ó ī޶ Ƿ ϴ  break մϴ.
			//  ڵ忡  ո  Ͻñ ٶϴ.

			mImageCaptureUri = data.getData();
		}

		case PICK_FROM_CAMERA:
		{
			// ̹    ̹ ũ⸦ մϴ.
			// Ŀ ̹ ũ ø̼ ȣϰ ˴ϴ.

			Intent intent = new Intent("com.android.camera.action.CROP");
			intent.setDataAndType(mImageCaptureUri, "image/*");

			intent.putExtra("outputX", 90);
			intent.putExtra("outputY", 90);
			intent.putExtra("aspectX", 1);
			intent.putExtra("aspectY", 1);
			intent.putExtra("scale", true);
			intent.putExtra("return-data", true);
			startActivityForResult(intent, CROP_FROM_CAMERA);

			break;
		}
		}
	}
	private void Dialog_Test()
	{
		DialogInterface.OnClickListener cameraListener = new DialogInterface.OnClickListener()
		{
			@Override
			public void onClick(DialogInterface dialog, int which)
			{
				doTakePhotoAction();
			}
		};

		DialogInterface.OnClickListener albumListener = new DialogInterface.OnClickListener()
		{
			@Override
			public void onClick(DialogInterface dialog, int which)
			{
				doTakeAlbumAction();
			}
		};

		DialogInterface.OnClickListener cancelListener = new DialogInterface.OnClickListener()
		{
			@Override
			public void onClick(DialogInterface dialog, int which)
			{
				dialog.dismiss();
			}
		};

		new AlertDialog.Builder(this)
		.setTitle("ε ̹ ")
		.setPositiveButton("Կ", cameraListener)
		.setNeutralButton("ٹ", albumListener)
		.setNegativeButton("", cancelListener)
		.show();
	}
}