<?
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

/* SNS 출력 설정 -------------------------------------------------------------------------------------------------------

	1. 본 자료는 기존 SNS관련 자료(배추 베이직 스킨, 테러보이님 스킨, 활용팁 내용 등)를 짜집기 해 만든 것입니다.

	2. 반드시 아래의 기본 설정을 자신에게 맞도록 먼저 설정해 주시고, 문의는 http://amina.co.kr의 묻고 답하기에 남겨 주세요.

	3. 스킨 제작시 참고사항
		- 그누보드 짧은 주소 사용 : http://sir.co.kr/bbs/board.php?bo_table=g4_tiptech&wr_id=20648
		- 페이스북 좋아요 모양 : http://developers.facebook.com/docs/reference/plugins/like/
		- 트위터 버튼 모양 : https://twitter.com/about/resources/buttons 와 https://dev.twitter.com/docs/tweet-button 참고
		- 구글 플러스원 모양 : http://www.google.com/intl/ko/webmasters/+1/button/
		- 네이트온 쪽지 관련 : http://devsquare.nate.com/openApi/NateOnSendNotePlugin
			: 쪽지가 작동하지 않을 경우 위 주소에서 다시 코드를 발급받아 스킨을 수정해 주던지, 아래 내용으로 쪽지 부분 내용 교체 
			<script language="javascript" type="text/javascript" src="http://api.nateon.nate.com/js/note/type_small.js"></script>
			<meta name="nate-note" content="<?=$tw_txt?>">
   --------------------------------------------------------------------------------------------------------------------
*/

// SNS 기본 환경 설정

//사이트 주소 - 보안서버 사용시 $g4[url]의 값이 변경되므로 아예 고정시킴, 주소 마지막 슬래쉬(/)는 빼주세요.
$sns[url] = "http://amina.co.kr"; 

//그누보드 bbs 주소 - 보안서버 사용시 $g4[url]의 값이 변경되므로 아예 고정시킴, 주소 마지막 슬래쉬(/)는 빼주세요.
$sns[g4_url] = "http://amina.co.kr/bbs";

// Bit.ly 짧은 주소 사용 - bitly.com에 가입후 https://bitly.com/a/your_api_key 주소에서 Username과 API Key 확인가능
$sns[username] = "Bitly Username을 입력하세요.";
$sns[api_key] = "Bitlly Api Key을 입력하세요."; 

//---------------------------------------------------------------------------------------------------------------------

// SNS 아이콘 출력하기
function sns_icon($skin_dir, $sns_subj, $lurl, $surl=''){
	global $g4, $config, $sns;

    if ($skin_dir)
        $sns_skin_path = "$g4[path]/skin/sns/$skin_dir";
    else
        $sns_skin_path = "$g4[path]/skin/sns/basic";

	if(!$surl) $surl = $lurl;

    $org_url = trim($lurl);
    $sns_url = trim($surl);

    $me2day_url = "http://me2day.net/posts/new?new_post[body]=".urlencode(set_utf8($sns_subj)." - \"$sns_url\":$sns_url");
    //$twitter_url = "http://twitter.com/home?status=".urlencode(set_utf8($view[wr_subject])." - $sns_url");
    $twitter_url = "http://twitter.com/?status=".str_replace("+", " ", urlencode(set_utf8($sns_subj)." - $sns_url"));
	$tw_url = $org_url;
	$tw_txt = $sns_subj;
	$facebook_url = "http://www.facebook.com/share.php?u=".urlencode($org_url);
	$fb_url = urlencode($org_url);
	$yozm_url = "http://yozm.daum.net/api/popup/prePost?sourceid=41&link={$sns_url}&prefix=".urlencode(set_utf8($sns_subj));
    $cy_url = "javascript:window.open('http://csp.cyworld.com/bi/bi_recommend_pop.php?url={$sns_url}', ";
    $cy_url.= "'recom_icon_pop', 'width=400,height=364,scrollbars=no,resizable=no');";
	$google_url = "https://www.google.com/bookmarks/mark?op=add&title=".urlencode(set_utf8($sns_subj))."&bkmk=".$sns_url;
	$naver_url = "http://bookmark.naver.com/post?ns=1&title=".urlencode(set_utf8($sns_subj))."&url=".$sns_url;
	$evernote_url = "Evernote.doClip({providerName:'{$config[cf_title]}',url:'{$sns_url}',suggestNotebook:'$sns_subj',contentId:'writeContents'}); return false;";

    ob_start();
    include "$sns_skin_path/sns.skin.php";
    $view_sns = ob_get_contents();
    ob_end_clean();

	return $view_sns;
}

// Good 아이콘 출력하기
function good_icon($skin, $bo_table, $wr_id){
	global $g4, $board;

    if ($skin)
        $good_skin_path = "$g4[path]/skin/good/$skin";
    else
        $good_skin_path = "$g4[path]/skin/good/basic";

	ob_start();
	include $g4[bbs_path]."/good.skin.php";
    $view_good = ob_get_contents();
    ob_end_clean();

	return $view_good;
}

//그누보드 긴글 주소 만들기
function sns_lurl($bo_table, $wr_id, $opt=''){
	global $g4, $sns;

	$lurl = $sns[g4_url]."/board.php?bo_table={$bo_table}&wr_id={$wr_id}";
	if($opt) $lurl = $sns[url]."/".$bo_table."/".$wr_id;

	return $lurl;
}

//그누보드 짧은 주소 만들기
function sns_surl($surl, $opt=''){
	global $g4, $sns;

	if($opt) $surl = bitly_url($surl);

	return $surl;

}

//Bit.ly 짧은 주소 사용하기
function bitly_url($url){  
	global $g4, $sns;

	$result = "http://api.bit.ly/shorten?version=2.0.1&longUrl=".urlencode($url)."&login=".$sns[username]."&apiKey=".$sns[api_key]."&format=json&history=1";
	$data = file_get_contents_curl($result);
    $data = json_decode($data);
    foreach($data->results as $row) {
		$burl = $row->shortCNAMEUrl;
	}
	return $burl;
} 

if(!function_exists("file_get_contents_curl")) {
function file_get_contents_curl($url) {
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_HEADER, 0);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_URL, $url); 
  $data = curl_exec($ch);
  curl_close($ch); 
  return $data;
}}

// euckr -> utf8 
if (!function_exists("set_utf8")) {
function set_utf8($str)
{
    if (!is_utf8($str))
        $str = convert_charset('cp949', 'utf-8', $str);

    $str = trim($str);

    return $str;
}}

// utf8 -> euckr 
if (!function_exists("set_euckr")) {
function set_euckr($str)
{
    if (is_utf8($str))
        $str = convert_charset('utf-8', 'cp949', $str);

    $str = trim($str);

    return $str;
}}

// Charset 을 변환하는 함수 
if (!function_exists("convert_charset")) {
function convert_charset($from_charset, $to_charset, $str) {
    if( function_exists('iconv') )
        return iconv($from_charset, $to_charset, $str);
    elseif( function_exists('mb_convert_encoding') )
        return mb_convert_encoding($str, $to_charset, $from_charset);
    else
        die("Not found 'iconv' or 'mbstring' library in server.");
}}

// 텍스트가 utf-8 인지 검사하는 함수 
if (!function_exists("is_utf8")) {
function is_utf8($string) {

  // From http://w3.org/International/questions/qa-forms-utf-8.html
  return preg_match('%^(?:
        [\x09\x0A\x0D\x20-\x7E]            # ASCII
      | [\xC2-\xDF][\x80-\xBF]            # non-overlong 2-byte
      |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
      | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
      |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
      |  \xF0[\x90-\xBF][\x80-\xBF]{2}    # planes 1-3
      | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
      |  \xF4[\x80-\x8F][\x80-\xBF]{2}    # plane 16
 )*$%xs', $string);
}}

// 텍스트만 출력하기
if(!function_exists("txt_utf8")) {
function txt_utf8($str) {
	global $g4;

	$str = strip_tags($str);
	$str = preg_replace("/{이미지\:([0-9]+)[:]?([^}]*)}/ie", "", $str); //본문첨부 이미지 제외
	$str = str_replace("&nbsp;"," ",$str); //공백으로 변환
	$str = preg_replace('/\s\s+/', ' ', $str); //연속된 공백 1개로
	$str = trim($str); //앞뒤 공백 제거

	return $str;
}}

// 글 자르기
if(!function_exists("cut_utf8")) {
function cut_utf8($str, $len, $suffix="…") {
	global $g4;

	//텍스트만 뽑아오기
	$str = txt_utf8($str);

	//mb_strlen, mb_substr는 PHP 4이상에서는 내장함수에서 지원하지만, 확장모듈로 설치가 되어있어야 사용 가능함.
	$slen = mb_strlen($str,"utf-8");
	if($slen <= $len) return $str; 

	$str = mb_substr($str,0,$len,"utf-8");
	$str = $str."".$tail;

	return $str;
}}

?>