<?php
include_once('./_common.php');

define('_INDEX_', true);
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
// 이미지 파일 검사 및 배열 저장 함수
function getImageFiles($folderPath,$action = '') {
    $directory = "data/item/" . $folderPath;
    $images = [];

    if (is_dir($directory)) {
        $files = scandir($directory);
        
        foreach ($files as $file) {
            $filePath = $directory . '/' . $file;
            if (is_file($filePath) && !preg_match('/^thumb-/i', $file) && preg_match('/\.(jpg|jpeg|png|gif)$/i', $file)) {
                $images[] = $file;
            }
        }
             
        if (!empty($images)) {
            echo "<h3>이미지 파일 목록:</h3><ul>";
            foreach ($images as $image) {
                echo "<li>" . $directory .'/'. htmlspecialchars($image) . "</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>이미지 파일이 없습니다.</p>";
        }

    } else {
        echo "폴더가 존재하지 않습니다.";
    }
    
    return $images;
}

if(isset($_POST['folder_path']) && $_POST['folder_path']){    
    $folderPath = $_POST['folder_path'];
    $ca_id = $_POST['ca_id'];
   
    // 이미지 파일 검사 및 배열 저장
    if (isset($_POST['action']) && $_POST['action'] === 'view') $action = 'view'; else $action = '';
    $imageFiles = getImageFiles($folderPath,$action);
    echo "<span style='position: absolute;top:10px;right:10px;'>이미지 파일 수: " . count($imageFiles).'</span><br>'; // 이미지 파일 배열의 수 출력
    if($action == 'view') {
        unset($_POST);
        exit;
    }
  
    
    $succ_count = 0;    
    for ($i = 0; $i < count($imageFiles); $i++) {
        $it_id = time()  . sprintf('%04d', $i);
        $it_img1 = $folderPath.'/'.$imageFiles[$i];

        if(isset($_POST['product_name']) && trim($_POST['product_name'])) {
            $it_name = trim($_POST['product_name']); 
        }
        else $it_name = pathinfo($imageFiles[$i], PATHINFO_FILENAME);

        // it_img1 중복체크
        $sql2 = " select count(*) as cnt from {$g5['g5_shop_item_table']} where it_img1 = '$it_img1' ";
        $row2 = sql_fetch($sql2);
        if(isset($row2['cnt']) && $row2['cnt']) {
            $fail_it_id[] = $it_id;
            $dup_it_id[] = $it_id;
            $dup_count++;
            $fail_count++;
            continue;
        }

        // it_id 중복체크
        $sql2 = " select count(*) as cnt from {$g5['g5_shop_item_table']} where it_id = '$it_id' ";
        $row2 = sql_fetch($sql2);
        if(isset($row2['cnt']) && $row2['cnt']) {
            $fail_it_id[] = $it_id;
            $dup_it_id[] = $it_id;
            $dup_count++;
            $fail_count++;
            continue;
        }

        // 기본분류체크
        $sql2 = " select count(*) as cnt from {$g5['g5_shop_category_table']} where ca_id = '$ca_id' ";
        $row2 = sql_fetch($sql2);
        if(! (isset($row2['cnt']) && $row2['cnt'])) {
            $fail_it_id[] = $it_id;
            $fail_count++;
            continue;
        }

        $sql = " INSERT INTO {$g5['g5_shop_item_table']}
                     SET it_id = '$it_id',
                         ca_id = '$ca_id',
                         ca_id2 = '',
                         ca_id3 = '',
                         it_skin = 'theme/basic',
                         it_name = '$it_name',
                         it_maker = '',
                         it_origin = '',
                         it_brand = '',
                         it_model = '',
                         it_type1 = '0',
                         it_type2 = '0',
                         it_type3 = '0',
                         it_type4 = '0',
                         it_type5 = '0',
                         it_basic = '',
                         it_explan = '',
                         it_explan2 = '',
                         it_mobile_explan = '',
                         it_cust_price = '0',
                         it_price = '0',
                         it_point = '0',
                         it_point_type = '0',
                         it_stock_qty = '9999',
                         it_noti_qty = '0',
                         it_buy_min_qty = '0',
                         it_buy_max_qty = '0',
                         it_notax = '0',
                         it_use = '1',
                         it_time = '".G5_TIME_YMDHIS."',
                         it_ip = '{$_SERVER['REMOTE_ADDR']}',
                         it_order = '0',
                         it_tel_inq = '0',
                         it_img1 = '$it_img1',
                         it_img2 = '',
                         it_img3 = '',
                         it_img4 = '',
                         it_img5 = '',
                         it_img6 = '',
                         it_img7 = '',
                         it_img8 = '',
                         it_img9 = '',
                         it_img10 = '' ";

        sql_query($sql);

        $succ_count++;        
    }    
    unset($_POST);
    echo "총 업로드 상품수 : ". $succ_count.'개';
    
    // 확인 버튼 추가
    echo '<button onclick="clearPostAndRefresh()">끝났으면 확인 이동</button>';
    echo '<a href="/shop/list-'.$ca_id.'"  target="_blank" style="margin-left:20px;">상품분류로 이동</a>';
    echo '<script>
    function clearPostAndRefresh() {
        history.replaceState(null, null, location.href);
        location.reload(); // 페이지 새로 고침
    }
    </script>';
    exit;
}
?>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
    <label for="folder_path">폴더 경로: /data/item/</label>
    <input type="text" name="folder_path" id="folder_path" required>
    <button type="button" onclick="fetchImageFiles()">조회</button><br>

    <label for="product_name">일괄 상품명 : (공란이면 파일명으로 [.확장자 제외] 변경:) </label>
    <input type="text" name="product_name" id="product_name"><br>

    <label for="ca_id">기본분류:</label>   
    <select name="ca_id" id="ca_id" class="category" required>
    <option value="">전체분류</option>
    <?php
    $sql = " select ca_id, ca_name from {$g5['g5_shop_category_table']} order by ca_order, ca_id ";
    $result = sql_query($sql);
    for ($i=0; $row=sql_fetch_array($result); $i++) {
        print_r($row);
        $len = strlen($row['ca_id']) / 2 - 1;
        $nbsp = '';
        for ($i=0; $i<$len; $i++) $nbsp .= '&nbsp;&nbsp;&nbsp;';
        echo '<option value="'.$row['ca_id'].'" '.get_selected('', $row['ca_id']).'>'.$nbsp.$row['ca_name'].'</option>'.PHP_EOL;
    }
    ?>
    </select>

    <button type="submit">작업실행</button>
    <p style="color:red;">ftp로 /data/item/ 아래에 이미지를 올린 폴더 이름 입력 후 조회를 누르면 해당 폴더의 이미지 파일 jpg,png,gif.jpeg 목록 수집<br>
    일부 올리고 다시 올리는 사이 상품리스트라도 조회하게 되면 썸네일이 생성되어서 썸네일 파일은 제외하고 수집<br>
    일괄 상품명 공란이면 무조건 파일이름이 (확장자제외) 상품명이 된다. 기본분류는 필수. <br>
    중복검사는 파일이름 추가해서 같은 파일이면 안올라가는걸로.
    
    </p>
</form>


<!-- 이미지 파일 목록을 표시할 영역 -->
<div id="image-list" style="position:absolute;top:10px;right:10px;"></div>

<script>
function fetchImageFiles() {
    const folderPath = document.getElementById('folder_path').value;
    const imageListDiv = document.getElementById('image-list');

    if (!folderPath) {
        alert('폴더 경로를 입력하세요.');
        return;
    }
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo $_SERVER['PHP_SELF']; ?>', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4 && xhr.status === 200) {
            imageListDiv.innerHTML = xhr.responseText;
        }
    };
    xhr.send('folder_path=' + encodeURIComponent(folderPath) + '&action=view');
}
</script>

