<?php

/**
 * 2025-09-05
 * 추가배송비 검색하기
 * 1. 사용자가 우편번호를 입력하면 추가배송비 디비를 조회한다. 추가배송비를 출력한다.
 * 2. 만약에 1번 내용으로 검색을 통해서 없으면 주소지를 검색해서 추가배송비를 출력한다.
 */


include_once('./_common.php');

$code  = isset($_POST['zipcode']) ? preg_replace('#[^0-9]#', '', $_POST['zipcode']) : '';
$addr  = isset($_POST['address']) ? trim($_POST['address']) : ''; // Assume address is passed

if(!$code && !$addr) {
    die('0');
}

// 1. First, search by zip code range
$sql = "SELECT sc_id, sc_price
          FROM {$g5['g5_shop_sendcost_table']}
         WHERE CAST(sc_zip1 AS UNSIGNED) <= '{$code}'
           AND CAST(sc_zip2 AS UNSIGNED) >= '{$code}'
         LIMIT 1";

$row = sql_fetch($sql);

// 2. If no zip code match, search by address words
if(!$row && $addr) {
    // Split the address into individual words
    $search_words = explode(' ', sql_real_escape_string($addr));

    // Create a WHERE clause for each word
    $where_parts = [];
    foreach ($search_words as $word) {
        if (strlen($word) > 1) { // Ignore very short words to avoid generic matches
            $where_parts[] = "sc_name LIKE '%{$word}%'";
        }
    }

    if (!empty($where_parts)) {
        $where_clause = implode(' OR ', $where_parts);

        $sql = "SELECT sc_id, sc_price
                  FROM {$g5['g5_shop_sendcost_table']}
                 WHERE {$where_clause}
                 LIMIT 1";

        $row = sql_fetch($sql);
    }
}

if(!(isset($row['sc_id']) && $row['sc_id'])) {
    die('0');
}

die($row['sc_price']);