<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 아래 return; 주석 해제시 사용하지 않음
// return;

// 일부 브라우저 또는 앞으로 브라우저가 업데이트 된다면 아래의 방법이 안될수도 있습니다.
function nocache_nostore_headers() {
    if (headers_sent()) return;
    
    header_remove('Last-Modified');

    header('Expires: Sat, 17 Jan 1999 01:00:00 GMT');
    header('Cache-Control: no-transform, no-cache, no-store, must-revalidate');
}

add_event('common_header', 'shoping_add_common_header', 10, 0);

function shoping_add_common_header() {
    $arr = array(
        'shop/cart.php',        // 장바구니 페이지
        'shop/orderform.php',   // 주문서 작성 페이지
    );

    foreach($arr as $url){
        if(stripos($_SERVER['SCRIPT_NAME'], $url) !== false){
            nocache_nostore_headers();
        }
    }
}