<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

if (!defined("_ORDERINQUIRY_")) exit; // 개별 페이지 접근 불가

// 테마에 orderinquiry.sub.php 있으면 include
if(defined('G5_THEME_SHOP_PATH')) {
    $theme_inquiry_file = G5_THEME_SHOP_PATH.'/orderinquiry.sub.php';
    if(is_file($theme_inquiry_file)) {
        include_once($theme_inquiry_file);
        return;
        unset($theme_inquiry_file);
    }
}
?>

<style>
/***********************************************************************

● 오늘,내일 표시 버튼 CSS 2023-09-21
● 제작 : 시리즈8 / 우주정복
● 우주정복시리즈 : https://series8.kr

***********************************************************************/
/* Button 기본 설정 */
.creambtn { border-radius: 2px; border: 1px solid transparent; font-weight: normal; vertical-align: middle; white-space: nowrap; cursor: pointer; -ms-user-select: none; -webkit-user-select: none; -moz-user-select: none; -o-user-select: none; user-select: none; }

.creambtn.btn-yellowblack { 
	color: #000 !important; border-image: none !important; background-image: none !important;
	border: 1px solid rgb(247, 197, 31);  
	background-color: rgb(255, 209, 35); 
}
.creambtn.active.btn-yellowblack, .creambtn.btn-yellowblack:hover, .creambtn.btn-yellowblack:focus, .creambtn.btn-yellowblack:active { 
	background-color: rgb(247, 197, 31); 
}
.btn.btn-black { 
	color: #fff !important; border-image: none !important; background-image: none !important;
	border: 1px solid #111; 
	background-color: #333; 
}
.btn.active.btn-black, .btn.btn-black:hover, .btn.btn-black:focus, .btn.btn-black:active { 
	background-color: #111; 
}

.btn-xs { padding: 2px 2px; }
/**********************************************************************/
</style>

<!-- 주문 내역 목록 시작 { -->
<?php if (!$limit) { ?>총 <?php echo $cnt; ?> 건<?php } ?>

<div class="tbl_head03 tbl_wrap">
    <table>
    <thead>
    <tr>
        <th scope="col">주문서번호</th>
        <th scope="col">주문일시</th>
        <th scope="col">상품수</th>
        <th scope="col">주문금액</th>
        <th scope="col">입금액</th>
        <th scope="col">미입금액</th>
        <th scope="col">상태</th>
    </tr>
    </thead>
    <tbody>
    <?php
    $sql = " select *
               from {$g5['g5_shop_order_table']}
              where mb_id = '{$member['mb_id']}'
              order by od_id desc
              $limit ";
    $result = sql_query($sql);
    for ($i=0; $row=sql_fetch_array($result); $i++)
    {
        $uid = md5($row['od_id'].$row['od_time'].$row['od_ip']);

        switch($row['od_status']) {
            case '주문':
                $od_status = '<span class="status_01">입금확인중</span>';
                break;
            case '입금':
                $od_status = '<span class="status_02">입금완료</span>';
                break;
            case '준비':
                $od_status = '<span class="status_03">상품준비중</span>';
                break;
            case '배송':
                $od_status = '<span class="status_04">상품배송</span>';
                break;
            case '완료':
                $od_status = '<span class="status_05">배송완료</span>';
                break;
            default:
                $od_status = '<span class="status_06">주문취소</span>';
                break;
        }
    ?>

    <tr>
        <td>
            <a href="<?php echo G5_SHOP_URL; ?>/orderinquiryview.php?od_id=<?php echo $row['od_id']; ?>&amp;uid=<?php echo $uid; ?>"><?php echo $row['od_id']; ?></a>
        </td>
        <td>

            <!-- 오늘어제표시 (우주정복S23) 2023-09-21 -->
            <?php
			    // 오늘,어제 상태변화시킨것 오늘아이콘 표시
				$today = date("Y-m-d", G5_SERVER_TIME); //오늘날짜
                $yesterday = date('Y-m-d', strtotime('-1 days', G5_SERVER_TIME)); //어제날짜
			   
			    $ct_time = substr($row['ct_time'],0,10); //주문시간을 주문날짜값만 구함 (예) 2017-05-01
			    $ct_receipt_time = substr($row['ct_receipt_time'],0,10); //입금시간 (예) 2017-05-01
			    $ct_invoice_time = substr($row['ct_invoice_time'],0,10); //배송시간 (예) 2017-05-01
			?>
                <?php echo ($ct_time == $today || $ct_receipt_time == $today || $ct_invoice_time == $today) ? '<span class="creambtn btn-yellowblack btn-xs">오늘</span>&nbsp;' : ''; //오늘표시텍스트아이콘?>
                <?php echo ($ct_time == $yesterday && $ct_receipt_time !== $today && $ct_invoice_time !== $today || $ct_receipt_time == $yesterday && $ct_time !== $today && $ct_invoice_time !== $today|| $ct_invoice_time == $yesterday && $ct_time !== $today && $ct_receipt_time !== $today) ? '<span class="creambtn btn-black btn-xs">어제</span>&nbsp;' : ''; //어제표시텍스트아이콘?>
            <!--//-->

			<?php echo substr($row['od_time'],2,14); ?> (<?php echo get_yoil($row['od_time']); ?>)
        </td>
        <td class="td_numbig"><?php echo $row['od_cart_count']; ?></td>
        <td class="td_numbig text_right"><?php echo display_price($row['od_cart_price'] + $row['od_send_cost'] + $row['od_send_cost2']); ?></td>
        <td class="td_numbig text_right"><?php echo display_price($row['od_receipt_price']); ?></td>
        <td class="td_numbig text_right"><?php echo display_price($row['od_misu']); ?></td>
        <td><?php echo $od_status; ?></td>
    </tr>

    <?php
    }

    if ($i == 0)
        echo '<tr><td colspan="7" class="empty_table">주문 내역이 없습니다.</td></tr>';
    ?>
    </tbody>
    </table>
</div>
<!-- } 주문 내역 목록 끝 -->