<?php
global $board_skin_path;
include_once $board_skin_path.'/_common.php';
include_once $board_skin_path.'/PollInstaller.php';
class Poll{
    private $table;
    public function __construct(){
        $this->table = YJS_CONFIG['table'];
        $this->installer = new PollInstaller();
        $this->installer->install();
        $this->db = new DB();
    }

    public function findPollById($pollId){
        $sql = "SELECT * FROM {$this->table['poll']} WHERE wr_id = '$pollId'";
        $poll = $this->db->fetchOne($sql);
        $poll['questions'] = $this->getQuestions($pollId);
        return $poll;
    }

    public function updatePoll($pollId, $poll)
    {
        $params = [
            'use_date' => $poll['use_date'],
            'start_date' => $poll['start_date'] != '' ? $poll['start_date'] : null,
            'end_date' => $poll['end_date'] != '' ? $poll['end_date'] : null,
        ];

        $this->db->update($this->table['poll'], $params, "wr_id = $pollId");

        foreach ($poll['questions'] as $index => $question) {
            $params = [
                'title' => trim($question['title']),
                'type' => $question['type'],
                'description' => trim($question['description']),
                'use_description' => $question['use_description'],
                'is_required' => $question['is_required'],
                'idx' => $question['idx'],
                'created_at' => date('Y-m-d H:i:s'),
            ];

            if ($question['id']) {
                $this->db->update($this->table['question'], $params, "poll_id = '$pollId' AND id = '{$question['id']}'");
            } else {
                $params['poll_id'] = $pollId;
                $this->db->insert($this->table['question'], $params);
                $question['id'] = sql_insert_id();
            }

            foreach ($question['options'] as $option) {
                $params = [
                    'title' => trim($option['title']),
                    'idx' => $option['idx'],
                ];

                if ($option['id']) {
                    $this->db->update($this->table['option'], $params, "id = '{$option['id']}'");
                } else {
                    $params['question_id'] = $question['id'];
                    $this->db->insert($this->table['option'], $params);
                }
            }
        }

        $poll['delete_questions'] = $poll['delete_questions'] ? explode(',', $poll['delete_questions']): [];
        $poll['delete_options'] = $poll['delete_options'] ? explode(',', $poll['delete_options']) : [];

        foreach ($poll['delete_questions'] as $questionId) {
            $this->db->delete($this->table['question'], "id = '$questionId'");
        }

        foreach ($poll['delete_options'] as $optionId) {
            $this->db->delete($this->table['option'], "id = '$optionId'");
        }
    }

    public function getQuestions($pollId)
    {
        $sql = "SELECT 
                    *,
                    (SELECT COUNT(*) FROM {$this->table['answer']} WHERE question_id = {$this->table['question']}.id) AS answer_count
                FROM {$this->table['question']} WHERE poll_id = '$pollId' ORDER BY idx ASC";
        $questions = $this->db->fetchAll($sql);

        foreach ($questions as $index => $question) {
            $sql = "SELECT 
                        *,
                        (SELECT COUNT(*) FROM {$this->table['answer']} WHERE option_id = {$this->table['option']}.id) AS answer_count
                    FROM {$this->table['option']} WHERE question_id = '{$question['id']}' ORDER BY idx ASC";
            $questions[$index]['options'] = $this->db->fetchAll($sql);
        }

        return $questions;
    }

    public function findResponseById($id)
    {
        $sql = "SELECT * FROM {$this->table['response']} WHERE id = '$id'";
        return $this->db->fetchOne($sql);
    }

    public function insertResponse($response)
    {
        $params = [
            'poll_id' => $response['poll_id'],
            'created_at' => date('Y-m-d H:i:s'),
            'ip_address' => $_SERVER['REMOTE_ADDR'],
        ];

        if($response['mb_no']){
            $params['mb_no'] = $response['mb_no'];
        }

        $this->db->insert($this->table['response'], $params);
        $responseId = sql_insert_id();

        foreach ($response['questions'] as $index => $question) {
            foreach ($question['options'] as $index2 => $option) {
                if($option['id']){
                    $this->db->insert($this->table['answer'], [
                        'response_id' => $responseId,
                        'question_id' => $question['id'],
                        'option_id' => $option['id'],
                        'answer_text' => $option['answer_text'],
                    ]);
                }
            }
        }

        return $this->findResponseById($responseId);
    }

    public function isClosed($poll)
    {
        if($poll['use_date']){
            if($poll['start_date'] && $poll['end_date']){
                $start = strtotime($poll['start_date']);
                $end = strtotime($poll['end_date']);
                $now = time();
                if($now < $start || $now > $end){
                    return true;
                }
            }
        }
        return false;
    }
}

class DB{
    public function query($sql) {
        $result = sql_query($sql);
        if (!$result) {
            die("쿼리 실패: " . sql_error());
        }
        return $result;
    }

    public function insert($table, $data) {
        $columns = implode(", ", array_keys($data));

        $values = [];
        foreach ($data as $value) {
            if (is_null($value)) {
                $values[] = "NULL"; // NULL 값 처리 (따옴표 없이)
            } else {
                $values[] = "'" . sql_real_escape_string($value) . "'";
            }
        }

        $sql = "INSERT INTO {$table} ($columns) VALUES (" . implode(", ", $values) . ")";

        return $this->query($sql);
    }

    public function update($table, $data, $where) {
        $setValues = [];
        foreach ($data as $column => $value) {
            if (is_null($value)) {
                $setValues[] = "$column = NULL"; // NULL 값 처리
            } else {
                $setValues[] = "$column = '" . sql_real_escape_string($value) . "'";
            }
        }
        $setClause = implode(", ", $setValues);
        $sql = "UPDATE {$table} SET $setClause WHERE $where";

        return $this->query($sql);
    }

    public function delete($table, $where) {
        $sql = "DELETE FROM {$table} WHERE $where";
        return $this->query($sql);
    }

    public function fetchAll($sql) {
        $result = $this->query($sql);
        $rows = [];
        while ($row = sql_fetch_array($result)) {
            $rows[] = $row;
        }
        return $rows;
    }

    public function fetchOne($sql) {
        return sql_fetch($sql);
    }
}
