<?php
class PollInstaller {
    private $table;

    public function __construct(){
        global $g5, $bo_table;
        $this->table = YJS_CONFIG['table'];
    }

    private function tableExists($tableName) {
        $result = sql_query("SHOW TABLES LIKE '$tableName'");
        return $result->num_rows > 0;
    }

    public function install() {
        foreach ($this->table as $key => $tableName) {
            if (!$this->tableExists($tableName)) {
                $this->createTable($key, $tableName);
            }

            if ($this->tableExists($this->table['poll'])) {
                $columns = $this->getTableColumns($this->table['poll']);

                if (!in_array('use_date', $columns)) {
                    $sql = "ALTER TABLE `{$this->table['poll']}` ADD COLUMN `use_date` BOOLEAN DEFAULT FALSE";
                    sql_query($sql);
                }

                if (!in_array('start_date', $columns)) {
                    $sql = "ALTER TABLE `{$this->table['poll']}` ADD COLUMN `start_date` TIMESTAMP";
                    sql_query($sql);
                }

                if (!in_array('end_date', $columns)) {
                    $sql = "ALTER TABLE `{$this->table['poll']}` ADD COLUMN `end_date` TIMESTAMP";
                    sql_query($sql);
                }

                if (!in_array('status', $columns)) {
                    $sql = "ALTER TABLE `{$this->table['poll']}` ADD COLUMN `status` VARCHAR(255) NOT NULL";
                    sql_query($sql);
                }
            }
        }
    }

    private function getTableColumns($tableName) {
        $columns = [];
        $result = sql_query("SHOW COLUMNS FROM `$tableName`");

        while ($row = sql_fetch_array($result)) {
            $columns[] = $row['Field'];
        }

        return $columns;
    }

    private function createTable($key, $tableName) {
        $sql = "";

        switch ($key) {
            case 'question':
                $sql = "CREATE TABLE `$tableName` (
                    `id` INT AUTO_INCREMENT PRIMARY KEY,
                    `poll_id` INT NOT NULL,
                    `title` TEXT NOT NULL,
                    `use_description` BOOLEAN DEFAULT FALSE,
                    `description` TEXT NULL,
                    `idx` INT NULL,
                    `type` VARCHAR(255) NOT NULL,
                    `is_required` BOOLEAN DEFAULT TRUE,
                    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (`poll_id`) REFERENCES `{$this->table['poll']}`(`wr_id`) ON DELETE CASCADE
                ) charset=utf8mb4 collate=utf8mb4_unicode_ci";
                break;

            case 'option':
                $sql = "CREATE TABLE `$tableName` (
                    `id` INT AUTO_INCREMENT PRIMARY KEY,
                    `question_id` INT NOT NULL,
                    `title` VARCHAR (255) NOT NULL,
                    `idx` INT NULL,
                    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (`question_id`) REFERENCES `{$this->table['question']}`(`id`) ON DELETE CASCADE
                ) charset=utf8mb4 collate=utf8mb4_unicode_ci";
                break;

            case 'response':
                $sql = "CREATE TABLE `$tableName` (
                    `id` INT AUTO_INCREMENT PRIMARY KEY,
                    `poll_id` INT NOT NULL,
                    `mb_no` INT NULL,
                    `ip_address` VARCHAR(45) NULL,
                    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (`poll_id`) REFERENCES `{$this->table['poll']}`(`wr_id`) ON DELETE CASCADE
                ) charset=utf8mb4 collate=utf8mb4_unicode_ci";
                break;

            case 'answer':
                $sql = "CREATE TABLE `$tableName` (
                    `id` INT AUTO_INCREMENT PRIMARY KEY,
                    `response_id` INT NOT NULL,
                    `question_id` INT NOT NULL,
                    `option_id` INT NULL,
                    `answer_text` TEXT NULL,
                    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (`response_id`) REFERENCES `{$this->table['response']}`(`id`) ON DELETE CASCADE,
                    FOREIGN KEY (`question_id`) REFERENCES `{$this->table['question']}`(`id`) ON DELETE CASCADE,
                    FOREIGN KEY (`option_id`) REFERENCES `{$this->table['option']}`(`id`) ON DELETE CASCADE
                ) charset=utf8mb4 collate=utf8mb4_unicode_ci";
                break;
        }

        if (!empty($sql)) {
            if (sql_query($sql) !== TRUE) {
                throw new Exception("Error creating table `$tableName`: " . sql_error_info());
            }
        }
    }
}
