<?php
global $board_skin_path, $bo_table, $wr_id, $member;
include_once $_SERVER['DOCUMENT_ROOT'].'/common.php';
include_once $board_skin_path.'/Poll.php';

if(!$wr_id || !$bo_table){
    throw new Exception('잘못된 접근 입니다.');
}

$poll = new Poll();
$data = $poll->findPollById($wr_id);

if($poll->isClosed($data)){
    alert('이미 종료된 설문조사 입니다.', "/bbs/board.php?bo_table={$bo_table}&wr_id={$wr_id}");
}

if($_POST['response']){
    $request = $_POST['response'];
    if($member['mb_no']){
        $request['mb_no'] = $member['mb_no'];
    }

    $result = $poll->insertResponse($request);
    if($result['id']){
        alert('응답이 완료되었습니다.', "/bbs/board.php?bo_table={$bo_table}&wr_id={$wr_id}");
    } else {
        alert('응답에 실패하였습니다.');
    }
}

?>
<!doctype html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?=$data['wr_subject']?></title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography,aspect-ratio,line-clamp,container-queries"></script>
    <script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>
</head>
<body>
    <div class="container mx-auto" id="app">
        <form action="" method="POST" id="surveyForm" @submit.prevent="handleSubmit">
            <h1 class="text-xl font-bold my-6"><?=$data['wr_subject']?></h1>
            <input type="hidden" name="response[poll_id]" value="<?=$data['wr_id']?>">
            <?php foreach ($data['questions'] as $index => $question) { ?>
                <input type="hidden" name="response[questions][<?=$index?>][id]" value="<?=$question['id']?>">
                <div class="mb-5" id="question_<?=$question['id']?>">
                    <div class="font-bold text-lg mb-2">
                        <span><?=$index+1 .'. '. $question['title']?></span>
                        <?php if($question['is_required']){ ?>
                        <small class="text-red-600 text-xs ms-1">* 필수</small>
                        <?php } ?>
                    </div>
                    <?php if($question['use_description']){ ?>
                        <div class="mb-3"><?=$question['description']?></div>
                    <?php } ?>
                    <div>
                        <?php foreach ($question['options'] as $index2 => $option) { ?>
                            <div class="flex items-center">
                                <input type="hidden" name="response[questions][<?=$index?>][options][<?=$index2?>][answer_text]" value="<?=$option['title']?>">
                                <?if($question['type'] == 'radio'){?>
                                    <input type="radio" name="response[questions][<?=$index?>][options][0][id]" value="<?=$option['id']?>" id="option_<?=$option['id']?>" class="input_option">
                                <?php } ?>
                                <?if($question['type'] == 'checkbox'){?>
                                    <input type="checkbox" name="response[questions][<?=$index?>][options][<?=$index2?>][id]" value="<?=$option['id']?>" id="option_<?=$option['id']?>" class="input_option">
                                <?php } ?>
                                <label for="option_<?=$option['id']?>" class="ms-2"><?=$option['title']?></label>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
            <hr class="my-6">
            <div class="flex justify-between">
                <a href="<?="/bbs/board.php?bo_table={$bo_table}&wr_id={$wr_id}"?>"
                   class="inline-block text-white bg-gray-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg !text-sm px-5 py-2.5 focus:outline-none">뒤로</a>
                <button type="submit"
                        id="sumitBtn"
                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg !text-sm px-5 py-2.5 focus:outline-none"
                >제출</button>
            </div>
        </form>
    </div>
    <script>
        Vue.createApp({
            data() {
                return {
                    poll: JSON.parse('<?=json_encode($data)?>'),
                }
            },
            mounted() {
                console.log(this.poll);
            },
            methods: {
                handleSubmit() {
                    if(this.validate()){
                        event.target.submit();
                    }
                },
                validate() {
                    for (let i = 0; i < this.poll.questions.length; i++) {
                        let question = this.poll.questions[i];
                        if(question.is_required){
                            let checkedCount = 0;
                            for (let i = 0; i < document.querySelectorAll(`#question_${question.id} .input_option`).length; i++) {
                                let el = document.querySelectorAll(`#question_${question.id} .input_option`)[i];
                                checkedCount = el.checked ? checkedCount + 1 : checkedCount;
                            }

                            if(checkedCount === 0) {
                                alert(`${i + 1}번 질문은 필수로 선택해야 합니다.`);
                                return false;
                            }
                        }
                    }

                    return true;
                },
            }
        }).mount('#app')
    </script>
</body>
</html>
