<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
include_once $board_skin_path.'/Poll.php';
$poll = new Poll;
$write['questions']  = $poll->getQuestions($wr_id);
?>
<script src="<?=$board_skin_url?>/js/vue.global.js"></script>
<script src="<?=$board_skin_url?>/js/axios.min.js"></script>
<script src="<?=$board_skin_url?>/js/Sortable.min.js"></script>

<section id="bo_w">
    <h2 class="sound_only"><?php echo $g5['title'] ?></h2>

    <!-- 게시물 작성/수정 시작 { -->
    <form name="fwrite" id="fwrite" action="<?php echo $action_url ?>" onsubmit="return fwrite_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off" style="width:<?php echo $width; ?>">
    <input type="hidden" name="uid" value="<?php echo get_uniqid(); ?>">
    <input type="hidden" name="w" value="<?php echo $w ?>">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="wr_id" value="<?php echo $wr_id ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <?php
    $option = '';
    $option_hidden = '';
    if ($is_notice || $is_html || $is_secret || $is_mail) {
        $option = '';
        if ($is_notice) {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="notice" name="notice"  class="selec_chk" value="1" '.$notice_checked.'>'.PHP_EOL.'<label for="notice"><span></span>공지</label></li>';
        }
        if ($is_html) {
            if ($is_dhtml_editor) {
                $option_hidden .= '<input type="hidden" value="html1" name="html">';
            } else {
                $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="html" name="html" onclick="html_auto_br(this);" class="selec_chk" value="'.$html_value.'" '.$html_checked.'>'.PHP_EOL.'<label for="html"><span></span>html</label></li>';
            }
        }
        if ($is_secret) {
            if ($is_admin || $is_secret==1) {
                $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="secret" name="secret"  class="selec_chk" value="secret" '.$secret_checked.'>'.PHP_EOL.'<label for="secret"><span></span>비밀글</label></li>';
            } else {
                $option_hidden .= '<input type="hidden" name="secret" value="secret">';
            }
        }
        if ($is_mail) {
            $option .= PHP_EOL.'<li class="chk_box"><input type="checkbox" id="mail" name="mail"  class="selec_chk" value="mail" '.$recv_email_checked.'>'.PHP_EOL.'<label for="mail"><span></span>답변메일받기</label></li>';
        }
    }
    echo $option_hidden;
    ?>

    <?php if ($is_category) { ?>
    <div class="bo_w_select write_div">
        <label for="ca_name" class="sound_only">분류<strong>필수</strong></label>
        <select name="ca_name" id="ca_name" required>
            <option value="">분류를 선택하세요</option>
            <?php echo $category_option ?>
        </select>
    </div>
    <?php } ?>

    <div class="bo_w_info write_div">
	    <?php if ($is_name) { ?>
	        <label for="wr_name" class="sound_only">이름<strong>필수</strong></label>
	        <input type="text" name="wr_name" value="<?php echo $name ?>" id="wr_name" required class="frm_input half_input required" placeholder="이름">
	    <?php } ?>

	    <?php if ($is_password) { ?>
	        <label for="wr_password" class="sound_only">비밀번호<strong>필수</strong></label>
	        <input type="password" name="wr_password" id="wr_password" <?php echo $password_required ?> class="frm_input half_input <?php echo $password_required ?>" placeholder="비밀번호">
	    <?php } ?>

	    <?php if ($is_email) { ?>
			<label for="wr_email" class="sound_only">이메일</label>
			<input type="text" name="wr_email" value="<?php echo $email ?>" id="wr_email" class="frm_input half_input email " placeholder="이메일">
	    <?php } ?>


	    <?php if ($is_homepage) { ?>
	        <label for="wr_homepage" class="sound_only">홈페이지</label>
	        <input type="text" name="wr_homepage" value="<?php echo $homepage ?>" id="wr_homepage" class="frm_input half_input" size="50" placeholder="홈페이지">
	    <?php } ?>
	</div>

    <?php if ($option) { ?>
    <div class="write_div">
        <span class="sound_only">옵션</span>
        <ul class="bo_v_option">
        <?php echo $option ?>
        </ul>
    </div>
    <?php } ?>

    <div class="bo_w_tit write_div">
        <label for="wr_subject" class="sound_only">제목<strong>필수</strong></label>

        <div id="autosave_wrapper" class="write_div">
            <input type="text" name="wr_subject" value="<?php echo $subject ?>" id="wr_subject" required class="frm_input full_input required" size="50" maxlength="255" placeholder="제목">
            <?php if ($is_member) { // 임시 저장된 글 기능 ?>
            <script src="<?php echo G5_JS_URL; ?>/autosave.js"></script>
            <?php if($editor_content_js) echo $editor_content_js; ?>
            <button type="button" id="btn_autosave" class="btn_frmline">임시 저장된 글 (<span id="autosave_count"><?php echo $autosave_count; ?></span>)</button>
            <div id="autosave_pop">
                <strong>임시 저장된 글 목록</strong>
                <ul></ul>
                <div><button type="button" class="autosave_close">닫기</button></div>
            </div>
            <?php } ?>
        </div>

    </div>

    <div class="write_div">
        <label for="wr_content" class="sound_only">내용<strong>필수</strong></label>
        <div class="wr_content <?php echo $is_dhtml_editor ? $config['cf_editor'] : ''; ?>">
            <?php if($write_min || $write_max) { ?>
            <!-- 최소/최대 글자 수 사용 시 -->
            <p id="char_count_desc">이 게시판은 최소 <strong><?php echo $write_min; ?></strong>글자 이상, 최대 <strong><?php echo $write_max; ?></strong>글자 이하까지 글을 쓰실 수 있습니다.</p>
            <?php } ?>
            <?php echo $editor_html; // 에디터 사용시는 에디터로, 아니면 textarea 로 노출 ?>
            <?php if($write_min || $write_max) { ?>
            <!-- 최소/최대 글자 수 사용 시 -->
            <div id="char_count_wrap"><span id="char_count"></span>글자</div>
            <?php } ?>
        </div>
    </div>

    <?php for ($i=1; $is_link && $i<=G5_LINK_COUNT; $i++) { ?>
    <div class="bo_w_link write_div">
        <label for="wr_link<?php echo $i ?>"><i class="fa fa-link" aria-hidden="true"></i><span class="sound_only"> 링크  #<?php echo $i ?></span></label>
        <input type="text" name="wr_link<?php echo $i ?>" value="<?php if($w=="u"){ echo $write['wr_link'.$i]; } ?>" id="wr_link<?php echo $i ?>" class="frm_input full_input" size="50">
    </div>
    <?php } ?>

    <?php for ($i=0; $is_file && $i<$file_count; $i++) { ?>
    <div class="bo_w_flie write_div">
        <div class="file_wr write_div">
            <label for="bf_file_<?php echo $i+1 ?>" class="lb_icon"><i class="fa fa-folder-open" aria-hidden="true"></i><span class="sound_only"> 파일 #<?php echo $i+1 ?></span></label>
            <input type="file" name="bf_file[]" id="bf_file_<?php echo $i+1 ?>" title="파일첨부 <?php echo $i+1 ?> : 용량 <?php echo $upload_max_filesize ?> 이하만 업로드 가능" class="frm_file ">
        </div>
        <?php if ($is_file_content) { ?>
        <input type="text" name="bf_content[]" value="<?php echo ($w == 'u') ? $file[$i]['bf_content'] : ''; ?>" title="파일 설명을 입력해주세요." class="full_input frm_input" size="50" placeholder="파일 설명을 입력해주세요.">
        <?php } ?>

        <?php if($w == 'u' && $file[$i]['file']) { ?>
        <span class="file_del">
            <input type="checkbox" id="bf_file_del<?php echo $i ?>" name="bf_file_del[<?php echo $i;  ?>]" value="1"> <label for="bf_file_del<?php echo $i ?>"><?php echo $file[$i]['source'].'('.$file[$i]['size'].')';  ?> 파일 삭제</label>
        </span>
        <?php } ?>

    </div>
    <?php } ?>


    <?php if ($is_use_captcha) { //자동등록방지  ?>
    <div class="write_div">
        <?php echo $captcha_html ?>
    </div>
    <?php } ?>

    <div id="app">
        <div class="write_div" style="display: flex; gap: 10px">
            <div>
                <input type="radio"
                       name="poll[use_date]"
                       value="1"
                       id="use_date_y"
                       class=""
                       style="margin-right: 5px"
                       v-model="poll.use_date"
                >
                <label for="use_date_y">기간 설정 사용</label>
            </div>
            <div>
                <input type="radio"
                       name="poll[use_date]"
                       value="0"
                       id="use_date_n"
                       class=""
                       style="margin-right: 5px"
                       v-model="poll.use_date"
                >
                <label for="use_date_n">미사용</label>
            </div>
        </div>

        <template v-if="poll.use_date == 1 || poll.use_date == true">
            <div class="write_div">
                <label for="start_date" class="sound_only">시작일</label>
                <input type="datetime-local"
                       name="poll[start_date]"
                       id="start_date"
                       class="frm_input half_input"
                       placeholder="시작일"
                       v-model="poll.start_date"
                >
                <label for="end_date" class="sound_only">종료일</label>
                <input type="datetime-local"
                       name="poll[end_date]"
                       id="end_date"
                       class="frm_input half_input"
                       placeholder="종료일"
                       v-model="poll.end_date"
                >
            </div>
        </template>

        <h2 style="font-size: 1.2rem; margin: 20px 0 10px 0;">질문 설정</h2>
        <div class="write_div">
            <input type="hidden" :name="'poll[delete_questions]'" v-model="deleteQuestions">
            <input type="hidden" :name="'poll[delete_options]'" v-model="deleteOptions">
            <div class="sortable_question">
                <template v-for="(question, idx) in poll.questions" :key="question.tmpId">
                    <div class="card" style="margin-bottom: 10px; background: #fff;">
                        <input type="hidden" :name="'poll[questions]['+idx+'][id]'" v-model="question.id">
                        <input type="hidden" :name="'poll[questions]['+idx+'][idx]'" v-model="question.idx">
                        <div class="card-body" style="position: relative" :data-question_id="question.id">
                            <button type="button"
                                    class="button_plain handle"
                                    style="color: #888888; position: absolute; right: 50%; top: 3px; transform: translateX(50%); padding: 0; line-height: 0"
                            >
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="16" height="16" stroke-width="2"> <path d="M5 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> <path d="M5 15m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> <path d="M12 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> <path d="M12 15m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> <path d="M19 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> <path d="M19 15m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> </svg>
                            </button>
                            <div style="display: flex; margin: 10px; 0;">
                                <input type="text"
                                       :name="'poll[questions]['+idx+'][title]'"
                                       placeholder="질문제목"
                                       class="frm_input full_input"
                                       v-model="question.title"
                                >
                                <select :name="'poll[questions]['+idx+'][type]'"
                                        id=""
                                        class="frm_input"
                                        v-model="question.type"
                                        style="flex-shrink: 0; margin-left: 10px"
                                >
                                    <option value="radio">라디오</option>
                                    <option value="checkbox">체크박스</option>
                                </select>
                            </div>
                            <input type="hidden" :name="'poll[questions]['+idx+'][use_description]'" v-model="question.use_description">
                            <textarea v-if="question.use_description == 1"
                                      :name="'poll[questions]['+idx+'][description]'"
                                      id=""
                                      cols="30"
                                      rows="5"
                                      class="frm_input"
                                      v-model="question.description"
                            ></textarea>
                            <div class=""
                                 style="margin-top: 10px"
                                 :data-idx="idx">
                                <div class="sortable_option">
                                    <template v-for="(option, idx2) in question.options" :key="option.tmpId">
                                        <div style="display: flex; margin-bottom: 10px; align-items: center; position: relative">
                                            <button type="button" class="button_plain handle" style="padding:0; line-height: 0; position: absolute; left: -17px; top: 13px; color: #888;">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="16" height="16" stroke-width="2">
                                                    <path d="M9 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                    <path d="M9 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                    <path d="M9 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                    <path d="M15 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                    <path d="M15 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                    <path d="M15 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                                </svg>
                                            </button>
                                            <template v-if="question.type == 'radio'">
                                                <input type="radio" class="" disabled>
                                            </template>
                                            <template v-if="question.type == 'checkbox'">
                                                <input type="checkbox" class="" disabled>
                                            </template>
                                            <input type="hidden" :name="'poll[questions]['+idx+'][options]['+idx2+'][id]'" v-model="option.id">
                                            <input type="hidden" :name="'poll[questions]['+idx+'][options]['+idx2+'][idx]'" v-model="option.idx">
                                            <input type="text"
                                                   :name="'poll[questions]['+idx+'][options]['+idx2+'][title]'"
                                                   placeholder="선택지"
                                                   class="frm_input full_input"
                                                   v-model="option.title"
                                                   style="margin-left: 10px;"
                                            >
                                            <button type="button"
                                                    @click="removeOption(question, idx2)"
                                                    class="button_plain"
                                                    style="flex-shrink: 0; margin-left: 10px; padding: 0; line-height: 0"
                                            >
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="16" height="16" stroke-width="2"> <path d="M18 6l-12 12"></path> <path d="M6 6l12 12"></path> </svg>
                                            </button>
                                        </div>
                                    </template>
                                </div>
                                <div style="display: flex;">
                                    <template v-if="question.type == 'radio'">
                                        <input type="radio" class="" disabled>
                                    </template>
                                    <template v-if="question.type == 'checkbox'">
                                        <input type="checkbox" class="" disabled>
                                    </template>
                                    <button type="button"
                                            @click="addOption(question)"
                                            class="button_plain"
                                            style="margin-left: 10px; padding: 0;"
                                    >선택지 추가</button>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="display: flex; justify-content: right; align-items: center">
                                <div>
                                    <input type="checkbox"
                                           :name="'poll[questions]['+idx+'][is_required]'"
                                           value="1"
                                           v-model="question.is_required"
                                           :id="'is_required_'+idx"
                                           :true-value="1"
                                           :false-value="0"
                                           style="margin-right: 5px"
                                    >
                                    <label :for="'is_required_'+idx">필수</label>
                                </div>
                                <div>
                                    <button type="button"
                                            class="button_plain"
                                            @click="removeQuestion(idx)"
                                    >
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="16" height="16" stroke-width="2"> <path d="M4 7l16 0"></path> <path d="M10 11l0 6"></path> <path d="M14 11l0 6"></path> <path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path> <path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path> </svg>
                                    </button>
                                </div>
                                <div class="dropdown" style="position: relative">
                                    <button type="button"
                                            class="button_plain"
                                            @click="question.showDropdown = !question.showDropdown"
                                    >
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="18" height="18" stroke-width="2"> <path d="M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> <path d="M12 19m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> <path d="M12 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path> </svg>
                                    </button>
                                    <div v-if="question.showDropdown"
                                         style="min-width: 100px; position: absolute; z-index: 100; right:0; top: 30px; background: #fff; border: 1px solid #ccc; border-radius: 10px; overflow: hidden;">
                                        <button type="button"
                                                class="button_plain"
                                                style="padding:10px; display: flex; align-items: center"
                                                @click="toggleDescription(question)"
                                        >
                                            <svg v-if="question.use_description == 1"
                                                 xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="16" height="16" stroke-width="2"> <path d="M5 12l5 5l10 -10"></path> </svg>
                                            <span style="margin-left: 15px">설명</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
            <div style="text-align: center;">
                <button type="button" @click="addQuestion" style="padding: 10px 20px; color:#fff; background: #434a54; border: none; border-radius: 10px">질문 추가</button>
            </div>
        </div>
    </div>
    <script>
        Vue.createApp({
            data(){
              return {
                  id: '<?= $_GET['wr_id']?>',
                  poll: {
                      use_date: 0,
                      start_date: '',
                      end_date: '',
                      questions: []
                  },
                  question: {
                      id: null,
                      title: '',
                      use_description: 0,
                      description: '',
                      type: 'radio',
                      options: [],
                      showDropdown: false,
                      is_required: 1,
                  },
                  option:{
                      id: null,
                      title: '',
                      idx: 0,
                  },
                  deleteQuestions: [],
                  deleteOptions: [],
              }
            },
            mounted(){
                if(this.id){
                    this.poll = JSON.parse('<?php echo json_encode($write); ?>');
                } else {
                    this.addQuestion();
                    this.addOption(this.poll.questions[0]);
                }

                this.poll.questions.map((question, idx) => {
                    question.tmpId = this.getUniqueId();
                    question.options.map((option, idx2) => {
                        option.tmpId = this.getUniqueId();
                    });
                });

                console.log(this.poll);
            },
            updated(){
                this.$nextTick(() => {
                    this.initSortable();
                });
            },
            methods: {
                datetimeChange(type){
                    if(type == 'start_date'){
                        this.poll.start_date = event.target.value;
                        console.log(this.poll.start_date);
                    }

                    if(type == 'end_date'){
                        this.poll.end_date = event.target.value;
                    }
                },
                addQuestion(){
                    let newQuestion = JSON.parse(JSON.stringify(this.question));
                    newQuestion.tmpId = this.getUniqueId();
                    this.poll.questions.push(newQuestion);
                },
                removeQuestion(idx){
                    let question = this.poll.questions[idx];
                    if(question.id){
                        this.deleteQuestions.push(question.id);
                    }
                    this.poll.questions.splice(idx, 1);
                },
                addOption(question){
                    question.options.push({...this.option, tmpId: this.getUniqueId()});
                },
                removeOption(question, idx){
                    let option = question.options[idx];
                    if(option.id){
                        this.deleteOptions.push(option.id);
                    }
                    question.options.splice(idx, 1);
                },
                getUniqueId(){
                    return Math.random().toString(36).substr(2, 9);
                },
                toggleDescription(question){
                    question.use_description = question.use_description == 1 ? 0 : 1;
                    question.showDropdown = false;
                    console.log(question.use_description);
                },
                initSortable(){
                    document.querySelectorAll(".sortable_question").forEach((el) => {
                        new Sortable(el, {
                            handle: '.handle', // handle's class
                            animation: 150,
                            onEnd: (evt) => {
                                let questions = this.poll.questions;
                                let question = questions.splice(evt.oldIndex, 1)[0];
                                questions.splice(evt.newIndex, 0, question);
                                this.poll.questions = questions;
                                this.poll.questions.forEach((question, idx) => {
                                    question.idx = idx;
                                });

                                console.log(this.poll.questions);
                            }
                        });
                    });

                    document.querySelectorAll(".sortable_option").forEach((el) => {
                        new Sortable(el, {
                            handle: '.handle', // handle's class
                            animation: 150,
                            onEnd: (evt) => {
                                let question = this.poll.questions[evt.from.parentElement.dataset.idx];
                                let options = question.options;
                                let option = options.splice(evt.oldIndex, 1)[0];
                                options.splice(evt.newIndex, 0, option);
                                question.options = options;
                                question.options.forEach((option, idx) => {
                                    option.idx = idx;
                                });
                            }
                        });
                    });
                }
            }
        }).mount('#app');
    </script>

    <div class="btn_confirm write_div">
        <a href="<?php echo get_pretty_url($bo_table); ?>" class="btn_cancel btn">취소</a>
        <button type="submit" id="btn_submit" accesskey="s" class="btn_submit btn">작성완료</button>
    </div>
    </form>

    <script>
    <?php if($write_min || $write_max) { ?>
    // 글자수 제한
    var char_min = parseInt(<?php echo $write_min; ?>); // 최소
    var char_max = parseInt(<?php echo $write_max; ?>); // 최대
    check_byte("wr_content", "char_count");

    $(function() {
        $("#wr_content").on("keyup", function() {
            check_byte("wr_content", "char_count");
        });
    });

    <?php } ?>
    function html_auto_br(obj)
    {
        if (obj.checked) {
            result = confirm("자동 줄바꿈을 하시겠습니까?\n\n자동 줄바꿈은 게시물 내용중 줄바뀐 곳을<br>태그로 변환하는 기능입니다.");
            if (result)
                obj.value = "html2";
            else
                obj.value = "html1";
        }
        else
            obj.value = "";
    }

    function fwrite_submit(f)
    {
        <?php echo $editor_js; // 에디터 사용시 자바스크립트에서 내용을 폼필드로 넣어주며 내용이 입력되었는지 검사함   ?>

        var subject = "";
        var content = "";
        $.ajax({
            url: g5_bbs_url+"/ajax.filter.php",
            type: "POST",
            data: {
                "subject": f.wr_subject.value,
                "content": f.wr_content.value
            },
            dataType: "json",
            async: false,
            cache: false,
            success: function(data, textStatus) {
                subject = data.subject;
                content = data.content;
            }
        });

        if (subject) {
            alert("제목에 금지단어('"+subject+"')가 포함되어있습니다");
            f.wr_subject.focus();
            return false;
        }

        if (content) {
            alert("내용에 금지단어('"+content+"')가 포함되어있습니다");
            if (typeof(ed_wr_content) != "undefined")
                ed_wr_content.returnFalse();
            else
                f.wr_content.focus();
            return false;
        }

        if (document.getElementById("char_count")) {
            if (char_min > 0 || char_max > 0) {
                var cnt = parseInt(check_byte("wr_content", "char_count"));
                if (char_min > 0 && char_min > cnt) {
                    alert("내용은 "+char_min+"글자 이상 쓰셔야 합니다.");
                    return false;
                }
                else if (char_max > 0 && char_max < cnt) {
                    alert("내용은 "+char_max+"글자 이하로 쓰셔야 합니다.");
                    return false;
                }
            }
        }

        <?php echo $captcha_js; // 캡챠 사용시 자바스크립트에서 입력된 캡챠를 검사함  ?>

        document.getElementById("btn_submit").disabled = "disabled";

        return true;
    }
    </script>

</section>
<!-- } 게시물 작성/수정 끝 -->
