<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.G5_SHOP_SKIN_URL.'/style.css">', 0);

// 장바구니 또는 위시리스트 ajax 스크립트
add_javascript('<script src="'.G5_THEME_JS_URL.'/theme.shop.list.js"></script>', 10);
?>
<style>
.flip-card {
  display:inline-block;
  /* width:300px;
  height:300px; */
  background-color: transparent;
  perspective: 1000px;
}

.flip-card-inner {
  position: relative;
  width: 100%;
  height: 100%;
  text-align: center;
  transition: transform 0.6s;
  transform-style: preserve-3d;
  box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
}

.flip-card:hover .flip-card-inner {
  transform: rotateY(180deg);
}

.flip-card-front, .flip-card-back {
  position: absolute;
  width: 100%;
  height: 100%;
  -webkit-backface-visibility: hidden;
  backface-visibility: hidden;
}

.flip-card-front {
  background-color: #bbb;
  color: black;
}

.flip-card-back {
  background-color: #2980b9;
  color: white;
  transform: rotateY(180deg);
}
.product_txt{
  z-index: 100;
  position: absolute;
  font-size:1.2rem;
  font-weight:800;
  bottom: 50px;
  left: 50px;
}
.product_txt .sct_cost {
    margin: 5px 0 10px;
    font-size: 1.1rem;
    font-weight: bold;
}
.product_txt .sct_dict {
    display: block;
    text-decoration: line-through;
    font-weight: normal;
    font-size: 0.9rem;
}
.flip-card-back .sct_txt {
    border-bottom: 1px solid #d9dde2;
    font-size:1.2rem;
    font-weight:800;
    margin: 10px 0;
    padding-bottom: 10px;
}
.flip-card-back .sct_txt a{
    color:white;
}
.flip-card-back .sct_bottom {
    position: relative;
    margin:30px;
    min-height: 20px;
}
.flip-card-back .sct_cost {
    margin: 5px 0 10px;
    font-size: 1.25em;
    font-weight: bold;
}
.flip-card-back .sct_dict {
    display: block;
    text-decoration: line-through;
    font-weight: normal;
    font-size: 0.85em;
    color: #858a8d;
}
.flip-card-back .sct_op_btn {
    position: absolute;
    right: 5px;
    bottom: 0;
}
.flip-card-back .sct_op_btn>button {
    border: 0;
    width: 25px;
    height: 20px;
    font-size: 1.25em;
    text-align: center;
    color: #949494;
    background: transparent;
}
.flip-card-back .sct_op_btn>button {
    border: 0;
    width: 25px;
    height: 20px;
    font-size: 1.25em;
    text-align: center;
    color: #949494;
    background: transparent;
}
.flip-card-back .sct_sns_wrap {
    display: none;
    width: 100%;
    height: 100%;
    position: fixed;
    top: 0;
    left: 0;
    z-index: 999;
}
.flip-card-back .sct_sns {
    position: absolute;
    top: 50%;
    left: 50%;
    color:#000;
    text-align: center;
    width: 245px;
    max-height: 300px;
    margin-left: -125px;
    margin-top: -180px;
    overflow-y: auto;
    border-radius: 5px;
    -webkit-box-shadow: 1px 1px 18px rgb(0 0 0 / 20%);
    -moz-box-shadow: 1px 1px 18px rgba(0,0,0,0.2);
    box-shadow: 1px 1px 18px rgb(0 0 0 / 20%);
    border: 1px solid #dde7e9;
    background: #fff;
    border-radius: 3px;
}
.flip-card-back .sct_sns_bg {
    background: rgba(0,0,0,0.1);
    width: 100%;
    height: 100%;
}
.flip-card-back .sct_sns h3 {
    padding: 15px;
    border-bottom: 1px solid #e8e8e8;
    text-align: left;
}
.flip-card-back .sct_sns .share-facebook {
    background: #415b92;
}
.flip-card-back .sct_sns a {
    display: inline-block;
    border-radius: 50%;
    width: 50px;
    height: 50px;
    line-height: 25px;
    text-align: center;
    padding: 10px 0;
    margin: 20px 5px;
}
.flip-card-back .sct_sns img {
    width: 24px;
}
.flip-card-back .sct_sns .share-twitter {
    background: #35b3dc;
}
.flip-card-back .sct_sns .share-googleplus {
    background: #ea3838;
}
.flip-card-back .sct_sns_cls {
    position: absolute;
    right: 0;
    top: 0;
    color: #b5b8bb;
    border: 0;
    padding: 12px 15px;
    font-size: 16px;
    background: #fff;
}
</style>
<!-- 상품진열 10 시작 { -->
<div style="margin:20px 0;">
<?php
$i = 0;

$this->view_star = (method_exists($this, 'view_star')) ? $this->view_star : true;

foreach((array) $list as $row){
    if( empty($row) ) continue;

    $item_link_href = shop_item_url($row['it_id']);     // 상품링크
    $star_score = $row['it_use_avg'] ? (int) get_star($row['it_use_avg']) : '';     //사용자후기 평균별점
    $list_mod = $this->list_mod;    // 분류관리에서 1줄당 이미지 수 값 또는 파일에서 지정한 가로 수
    $is_soldout = is_soldout($row['it_id'], true);   // 품절인지 체크

    $i++;   // 변수 i 를 증가


    echo "<div class=\"flip-card\" style=\"width:".$this->img_width. "px;height:".$this->img_height."px;\">";
    echo "<div class=\"flip-card-inner\">";

        if ($this->view_it_img) {
            $product_img = get_it_image($row['it_id'], $this->img_width, $this->img_height, '', '', stripslashes($row['it_name']));
        }

        ?>
        <div class="flip-card-front">
          <?php echo $product_img;?>
          <div class="product_txt"><?php echo stripslashes($row['it_name']);?>
          <?php
          if ($this->view_it_cust_price || $this->view_it_price) {

                      echo "<div class=\"sct_cost\">";
                      if ($this->view_it_price) {
                          echo display_price(get_price($row), $row['it_tel_inq']);
                      }
                      if ($this->view_it_cust_price && $row['it_cust_price']) {
                          echo "<span class=\"sct_dict\">".display_price($row['it_cust_price'])."</span>";
                      }
                      echo "</div>";
          }
           ?>
         </div>
        </div>
        <div class="flip-card-back">
          <?php
          if ($this->href) {
            echo "<div class=\"sct_txt\"><a href=\"{$item_link_href}\">";
          }

          if ($this->view_it_name) {
              echo stripslashes($row['it_name']);
          }

          if ($this->href) {
              echo "</a></div>";
          }

          if ($this->view_it_icon) {
              // 품절
              if ($is_soldout) {
                  echo '<span class="shop_icon_soldout"><span class="soldout_txt">SOLD OUT</span></span>';
              }
          }

          // 사용후기 평점표시
        	if ($this->view_star && $star_score) {
                echo "<div class=\"sct_star\"><span class=\"sound_only\">고객평점</span><img src=\"".G5_SHOP_URL."/img/s_star".$star_score.".png\" alt=\"별점 ".$star_score."점\" class=\"sit_star\"></div>";
          }

          if ($this->view_it_basic && $row['it_basic']) {
              echo "<div class=\"sct_basic\">".stripslashes($row['it_basic'])."</div>";
          }

          echo "<div class=\"sct_bottom\">";

          if ($this->view_it_cust_price || $this->view_it_price) {

              echo "<div class=\"sct_cost\">";
              if ($this->view_it_price) {
                  echo display_price(get_price($row), $row['it_tel_inq']);
              }
              if ($this->view_it_cust_price && $row['it_cust_price']) {
                  echo "<span class=\"sct_dict\">".display_price($row['it_cust_price'])."</span>";
              }
              echo "</div>";
          }

          // 위시리스트 + 공유 버튼 시작
          echo "<div class=\"sct_op_btn\">";
          echo "<button type=\"button\" class=\"btn_wish\" data-it_id=\"{$row['it_id']}\"><span class=\"sound_only\">위시리스트</span><i class=\"fa fa-heart-o\" aria-hidden=\"true\"></i></button>";
          if ($this->view_sns) {
              echo "<button type=\"button\" class=\"btn_share\"><span class=\"sound_only\">공유하기</span><i class=\"fa fa-share-alt\" aria-hidden=\"true\"></i></button>";
          }

          echo "<div class=\"sct_sns_wrap\">";
          if ($this->view_sns) {
              $sns_top = $this->img_height + 10;
              $sns_url  = $item_link_href;
              $sns_title = get_text($row['it_name']).' | '.get_text($config['cf_title']);
              echo "<div class=\"sct_sns\">";
              echo "<h3>SNS 공유</h3>";
              echo get_sns_share_link('facebook', $sns_url, $sns_title, G5_SHOP_SKIN_URL.'/img/facebook.png');
              echo get_sns_share_link('twitter', $sns_url, $sns_title, G5_SHOP_SKIN_URL.'/img/twitter.png');
              echo get_sns_share_link('googleplus', $sns_url, $sns_title, G5_SHOP_SKIN_URL.'/img/gplus.png');
              echo "<button type=\"button\" class=\"sct_sns_cls\"><span class=\"sound_only\">닫기</span><i class=\"fa fa-times\" aria-hidden=\"true\"></i></button>";
              echo "</div>";
          }
          echo "<div class=\"sct_sns_bg\"></div>";
          echo "</div></div>";
          // 위시리스트 + 공유 버튼 끝

      echo "</div>";

          if ($this->view_it_icon) {
              echo "<div class=\"sit_icon_li\">".item_icon($row)."</div>";
          }

          if ( !$is_soldout ){    // 품절 상태가 아니면 출력합니다.
            echo "<a class=\"btn\" href=\"{$item_link_href}\">상세보기</a>";
      	   }

           ?>           
        </div>
    <?php

	echo "</div>";
    echo "</div>";
}   //end foreach

if($i === 0) echo "<p class=\"sct_noitem\">등록된 상품이 없습니다.</p>\n";
?>
<!-- } 상품진열 10 끝 -->
</div>

<script>
//SNS 공유
$(function (){
	$(".btn_share").on("click", function() {
		$(this).parent("div").children(".sct_sns_wrap").show();
	});
    $('.sct_sns_bg, .sct_sns_cls').click(function(){
	    $('.sct_sns_wrap').hide();
	});
});
</script>
