<?php
include_once('./_common.php');
echo '<meta charset="utf-8">';

$fr_month = preg_replace('/[^0-9]/i', '', $fr_month);
$to_month = preg_replace('/[^0-9]/i', '', $to_month);

$fr_month = preg_replace("/([0-9]{4})([0-9]{2})/", "\\1-\\2", $fr_month);
$to_month = preg_replace("/([0-9]{4})([0-9]{2})/", "\\1-\\2", $to_month);

function print_line($save)
{
    $date = preg_replace("/-/", "", $save['od_date']);

    ?>
    <tr>
        <td class="sty0"><?php echo $save['od_date']; ?></td>
        <td class="sty1"><?php echo number_format($save['ordercount']); ?></td>
        <td class="sty1"><?php echo number_format($save['orderprice']); ?></td>
        <td class="sty1"><?php echo number_format($save['ordercoupon']); ?></td>
        <td class="sty1"><?php echo number_format($save['receiptbank']); ?></td>
        <td class="sty1"><?php echo number_format($save['receiptvbank']); ?></td>
        <td class="sty1"><?php echo number_format($save['receiptiche']); ?></td>
        <td class="sty1"><?php echo number_format($save['receiptcard']); ?></td>
        <td class="sty1"><?php echo number_format($save['receipthp']); ?></td>
        <td class="sty1"><?php echo number_format($save['receiptpoint']); ?></td>
        <td class="sty2"><?php echo number_format($save['ordercancel']); ?></td>
        <td class="sty2"><?php echo number_format($save['misu']); ?></td>
    </tr>
    <?php
}

$sql = " select od_id,
            SUBSTRING(od_time,1,7) as od_date,
            od_send_cost,
            od_settle_case,
            od_receipt_price,
            od_receipt_point,
            od_cart_price,
            od_cancel_price,
            od_misu,
            (od_cart_price + od_send_cost + od_send_cost2) as orderprice,
            (od_cart_coupon + od_coupon + od_send_coupon) as couponprice
       from {$g5['g5_shop_order_table']}
      where SUBSTRING(od_time,1,7) between '$fr_month' and '$to_month'
      order by od_time desc ";
$result = sql_query($sql);

header("Content-Type: application/vnd.ms-excel"); 
header("Content-Type: application/x-msexcel"); 
header("Content-Disposition: attachment; filename=sale1month_ex.xls");
header("Content-Description: PHP4 Generated Data" ); 
?>

<html>
<head>
<style>
.sty { font-family:굴림; font-size:12px; background:#6F809A; color:#fff; text-align:center;}
.sty0 {mso-number-format:"\@";font-family:굴림; font-size:12px; text-align:center;}
.sty1 {mso-number-format:"\@";font-family:굴림; font-size:12px;text-align:right !important}
.sty2 {font-family:굴림; font-size:12px; color:#ff3061;font-weight:bold;text-align:right !important}
.sty3 {font-family:굴림; font-size:12px; color: #000; font-weight:600; background:#EEEEEE;text-align:right !important}
.title {font-family:굴림; font-size:12px; color: #000; font-weight:600; background:#EEEEEE;text-align:center;}
.title_s {font-family:굴림; font-size:16px}
.empty_table {text-align:center}
</style>
</head>
<body bgcolor="#FFFFFF">
<table border="1" style="table-layout:fixed">
<tr align="center"> 
        <td class="sty">주문월</th>
        <td class="sty">주문수</th>
        <td class="sty">주문합계</th>
        <td class="sty">쿠폰</th>
        <td class="sty">무통장</th>
        <td class="sty">가상계좌</th>
        <td class="sty">계좌이체</th>
        <td class="sty">카드입금</th>
        <td class="sty">휴대폰</th>
        <td class="sty">포인트입금</th>
        <td class="sty">주문취소</th>
        <td class="sty">미수금</th>
    </tr>
    <?php
    unset($save);
    unset($tot);
    for ($i=0; $row=sql_fetch_array($result); $i++)
    {
        if ($i == 0)
            $save['od_date'] = $row['od_date'];

        if ($save['od_date'] != $row['od_date']) {
            print_line($save);
            unset($save);
            $save['od_date'] = $row['od_date'];
        }

        $save['ordercount']++;
        $save['orderprice']    += $row['orderprice'];
        $save['ordercancel']   += $row['od_cancel_price'];
        $save['ordercoupon']   += $row['couponprice'];
        if($row['od_settle_case'] == '무통장')
            $save['receiptbank']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '가상계좌')
            $save['receiptvbank']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '계좌이체')
            $save['receiptiche']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '휴대폰')
            $save['receipthp']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '신용카드')
            $save['receiptcard']   += $row['od_receipt_price'];
        $save['receiptpoint']  += $row['od_receipt_point'];
        $save['misu']          += $row['od_misu'];

        $tot['ordercount']++;
        $tot['orderprice']    += $row['orderprice'];
        $tot['ordercancel']   += $row['od_cancel_price'];
        $tot['ordercoupon']   += $row['couponprice'];
        if($row['od_settle_case'] == '무통장')
            $tot['receiptbank']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '가상계좌')
            $tot['receiptvbank']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '계좌이체')
            $tot['receiptiche']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '휴대폰')
            $tot['receipthp']   += $row['od_receipt_price'];
        if($row['od_settle_case'] == '신용카드')
            $tot['receiptcard']   += $row['od_receipt_price'];
        $tot['receiptpoint']  += $row['od_receipt_point'];
        $tot['misu']          += $row['od_misu'];
    }

    if ($i == 0) {
        echo '<tr><td colspan="12" class="empty_table">자료가 없습니다.</td></tr>';
    } else {
        print_line($save);
    }
    ?>
    <tr>
        <td class="title">합 계</td>
        <td class="sty3"><?php echo number_format($tot['ordercount']); ?></td>
        <td class="sty3"><?php echo number_format($tot['orderprice']); ?></td>
        <td class="sty3"><?php echo number_format($tot['ordercoupon']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receiptbank']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receiptvbank']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receiptiche']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receiptcard']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receipthp']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receiptpoint']); ?></td>
        <td class="sty3"><?php echo number_format($tot['ordercancel']); ?></td>
        <td class="sty3"><?php echo number_format($tot['misu']); ?></td>
    </tr>
</body>
</html>