<?php
include_once('./_common.php');
echo '<meta charset="utf-8">';

$date = preg_replace('/[^0-9]/i', '', $date);

$date = preg_replace("/([0-9]{4})([0-9]{2})([0-9]{2})/", "\\1-\\2-\\3", $date);

$sql = " select od_id,
                mb_id,
                od_name,
                od_settle_case,
                od_cart_price,
                od_receipt_price,
                od_receipt_point,
                od_cancel_price,
                od_misu,
                (od_cart_price + od_send_cost + od_send_cost2) as orderprice,
                (od_cart_coupon + od_coupon + od_send_coupon) as couponprice
           from {$g5['g5_shop_order_table']}
          where SUBSTRING(od_time,1,10) = '$date'
          order by od_id desc ";
$result = sql_query($sql);

header("Content-Type: application/vnd.ms-excel"); 
header("Content-Type: application/x-msexcel"); 
header("Content-Disposition: attachment; filename=sale1today_ex.xls");
header("Content-Description: PHP4 Generated Data" ); 
?>



<html>
<head>
<style>
.sty { font-family:굴림; font-size:12px; background:#6F809A; color:#fff; text-align:center;}
.sty0 {mso-number-format:"\@";font-family:굴림; font-size:12px; text-align:center;}
.sty1 {mso-number-format:"\@";font-family:굴림; font-size:12px;text-align:right !important}
.sty2 {font-family:굴림; font-size:12px; color:#ff3061;font-weight:bold;text-align:right !important}
.sty3 {font-family:굴림; font-size:12px; color: #000; font-weight:600; background:#EEEEEE;text-align:right !important}
.title {font-family:굴림; font-size:12px; color: #000; font-weight:600; background:#EEEEEE;text-align:center;}
.title_s {font-family:굴림; font-size:16px}
.empty_table {text-align:center}
</style>
</head>
<body bgcolor="#FFFFFF">
<table border="1" style="table-layout:fixed">
<tr align="center"> 
        <td class="sty">주문번호</td>
        <td class="sty">주문자</td>
        <td class="sty">주문합계</td>
        <td class="sty">쿠폰</td>
        <td class="sty">무통장</td>
        <td class="sty">가상계좌</td>
        <td class="sty">계좌이체</td>
        <td class="sty">카드입금</td>
        <td class="sty">휴대폰</td>
        <td class="sty">포인트입금</td>
        <td class="sty">주문취소</td>
        <td class="sty">미수금</td>
</tr>

    <?php
    unset($tot);
    for ($i=0; $row=sql_fetch_array($result); $i++)
    {
        $receipt_bank = $receipt_card = $receipt_vbank = $receipt_iche = $receipt_hp = 0;
        if($row['od_settle_case'] == '무통장')
            $receipt_bank = $row['od_receipt_price'];
        if($row['od_settle_case'] == '가상계좌')
            $receipt_vbank = $row['od_receipt_price'];
        if($row['od_settle_case'] == '계좌이체')
            $receipt_iche = $row['od_receipt_price'];
        if($row['od_settle_case'] == '휴대폰')
            $receipt_hp = $row['od_receipt_price'];
        if($row['od_settle_case'] == '신용카드')
            $receipt_card = $row['od_receipt_price'];

    ?>
        <tr>
            <td style="mso-number-format:\@;text-align:center;"><?php echo $row['od_id']; ?></td>
            <td class="sty1"><?php echo $row['od_name']; ?></td>
            <td class="sty1"><?php echo number_format($row['orderprice']); ?></td>
            <td class="sty1"><?php echo number_format($row['couponprice']); ?></td>
            <td class="sty1"><?php echo number_format($receipt_bank); ?></td>
            <td class="sty1"><?php echo number_format($receipt_vbank); ?></td>
            <td class="sty1"><?php echo number_format($receipt_iche); ?></td>
            <td class="sty1"><?php echo number_format($receipt_card); ?></td>
            <td class="sty1"><?php echo number_format($receipt_hp); ?></td>
            <td class="sty1"><?php echo number_format($row['od_receipt_point']); ?></td>
            <td class="sty2"><?php echo number_format($row['od_cancel_price']); ?></td>
            <td class="sty2"><?php echo number_format($row['od_misu']); ?></td>
        </tr>
    <?php
        $tot['orderprice']    += $row['orderprice'];
        $tot['ordercancel']   += $row['od_cancel_price'];
        $tot['coupon']        += $row['couponprice'] ;
        $tot['receipt_bank']  += $receipt_bank;
        $tot['receipt_vbank'] += $receipt_vbank;
        $tot['receipt_iche']  += $receipt_iche;
        $tot['receipt_card']  += $receipt_card;
        $tot['receipt_hp']    += $receipt_hp;
        $tot['receipt_point'] += $row['od_receipt_point'];
        $tot['misu']          += $row['od_misu'];
    }

	if ($i == 0) {
        echo '<tr><td colspan="12" class="empty_table">자료가 없습니다</td></tr>';
    }
    ?>
    <tr>
        <td class="title" colspan="2">합 계</td>
        <td class="sty3"><?php echo number_format($tot['orderprice']); ?></td>
        <td class="sty3"><?php echo number_format($tot['coupon']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receipt_bank']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receipt_vbank']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receipt_iche']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receipt_card']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receipt_hp']); ?></td>
        <td class="sty3"><?php echo number_format($tot['receipt_point']); ?></td>
        <td class="sty3"><?php echo number_format($tot['ordercancel']); ?></td>
        <td class="sty3"><?php echo number_format($tot['misu']); ?></td>
    </tr>
    </table>
</body>
</html>