/**
 * 소스코드 편집기
 * Ace editor
 * 
 */

function loadScript(src, callback) {
  let script = document.createElement('script');
  script.src = src;
  script.onload = () => callback(script);
  document.head.append(script);
}

function loadStylesheet(href) {
  let link = document.createElement('link');
  link.rel = 'stylesheet';
  link.href = href;
  document.head.append(link);
}
tinymce.PluginManager.add('ace', function (editor, url) {
  editor.ui.registry.addButton('ace', {
    text: '소스',
    onAction: function () {

      // 외부 스크립트를 불러옵니다.
      loadScript('https://cdnjs.cloudflare.com/ajax/libs/ace/1.23.1/ace.min.js', function () {

        editor.windowManager.open({
          title: '소스코드 편집기',
          size: "large",
          body: {
            type: 'panel',
            items: [
              {
                type: 'textarea',
                name: 'sources',
                label: 'Source Code'
              }
            ]
          },
          buttons: [
            {
              type: 'cancel',
              name: 'closeButton',
              text: 'Close'
            },
            {
              type: 'submit',
              name: 'submitButton',
              text: '저장',
              primary: true
            }
          ],
          initialData: {
            sources: editor.getContent()
          },
          onSubmit: function (api) {
            var data = api.getData();
            editor.setContent(data.sources);
            var textarea = document.querySelector("textarea[class='tox-textarea']");
            var aceEditor = ace.edit(textarea);
            aceEditor.destroy();
            aceEditor.container.remove();

            api.close();
          }
        });


        var textarea = document.querySelector("textarea[class='tox-textarea']");
        var aceEditor = ace.edit(textarea);
        aceEditor.$blockScrolling = Infinity;
        aceEditor.setTheme("ace/theme/twilight");
        aceEditor.session.setMode("ace/mode/html_ruby");
        aceEditor.setValue(textarea.value, 1);
        aceEditor.setOptions({
          autoScrollEditorIntoView: true,
          copyWithEmptySelection: true,
          wrap: true,
          displayIndentGuides: true,
          highlightActiveLine: false,
          showPrintMargin: false,
          minLines: Math.round(600 / 17),
          maxLines: Math.round(600 / 17)
        });
        aceEditor.on('change', function () {
          textarea.value = aceEditor.getValue();
          editor.setContent(aceEditor.getValue());
        });
        setTimeout(function () {
          var editor_select = document.querySelector("pre.ace_editor");
          editor_select.style.width = '100%';
          editor_select.style.height = 'auto';
        }, 10);

      });
    }
  });
});
