<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.G5_URL.'/rb/rb.config/style.css">', 0);

?>

<div class="sh-side-options sh-side-options-pages">

   
    <div class="sh-side-options-container" style="margin-top:100px">
       
        <a href="javascript:void(0);" class="sh-side-options-item sh-accent-color" id="saveOrderButton" title="모듈정렬 저장">
            <div class="sh-side-options-item-container"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_check.svg"></div>
        </a>
        
        <a href="<?php echo G5_ADMIN_URL  ?>" target="_blank" class="sh-side-options-item sh-accent-color" title="관리자모드">
            <div class="sh-side-options-item-container"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_setting.svg"></div>
        </a>

        <a class="sh-side-options-item sh-accent-color mobule_set_btn" title="모듈설정" onclick="toggleSideOptions();">
            <div class="sh-side-options-item-container"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_mod.svg"></div>
        </a>
        
        <a class="sh-side-options-item sh-accent-color setting_set_btn" title="환경설정" onclick="toggleSideOptions_open_set();">
            <div class="sh-side-options-item-container"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_set.svg"></div>
        </a>
    </div>


    <div class="sh-side-demos-container">

        <div class="sh-side-demos-container-close" onclick="toggleSideOptions_close();">
            <img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_close.svg">
        </div>


        <div class="sh-side-demos-loop">
            <div class="sh-side-demos-loop-container">
                
                <div class="rb_config rb_config_mod2" id="inq_res">
                    <h2 class="font-B">모듈설정</h2>
                    <div class="rb_config_sec">
                       <div class="no_data">
                        변경할 모듈을 선택해주세요.<br>
                        메인페이지의 각 영역에 마우스를 오버해주세요.
                        </div>
                    </div>
                </div>
                
                <div class="rb_config rb_config_mod1">

                    <h2 class="font-B">환경설정</h2>
                    <h6 class="font-R rb_config_sub_txt">레이아웃 및 웹폰트는 새로고침 후 확인해주세요.<br>모든 설정은 변경즉시 적용 됩니다.</h6>
                    <ul class="rb_config_sec">
                        <h6 class="font-B">강조컬러 설정 (공용)</h6>
                        <div class="config_wrap">
                            <ul>
                                <style>
                                    #color_AA20FF + label:before {background-color: #AA20FF !important; border:0px !important}
                                    #color_AA20FF:checked + label:before {background-color: #AA20FF !important}
                                    
                                    #color_FFC700 + label:before {background-color: #FFC700 !important; border:0px !important}
                                    #color_FFC700:checked + label:before {background-color: #FFC700 !important}
                                    
                                    #color_00A3FF + label:before {background-color: #00A3FF !important; border:0px !important}
                                    #color_00A3FF:checked + label:before {background-color: #00A3FF !important}
                                    
                                    #color_8ED100 + label:before {background-color: #8ED100 !important; border:0px !important}
                                    #color_8ED100:checked + label:before {background-color: #8ED100 !important}
                                    
                                    #color_FF5A5A + label:before {background-color: #FF5A5A !important; border:0px !important}
                                    #color_FF5A5AF:checked + label:before {background-color: #FF5A5A !important}
                                    
                                    #color_25282B + label:before {background-color: #25282B !important; border:0px !important}
                                    #color_25282B:checked + label:before {background-color: #25282B !important}
                                    
                                    
                                    
                                    .mod_co_color + label:before{
                                        width: 25px !important; height:25px !important;
                                    }
                                    
                                    .mod_co_color + label:after {
                                        top: 5px !important;
                                        left: 9px !important;
                                        box-sizing: border-box !important;
                                        width: 7px !important;
                                        height: 12px !important;
                                        transform: rotate(45deg) !important;
                                        border-width: 2px !important;
                                        border-style: solid !important;
                                        border-color: #fff !important;
                                        border-top: 0 !important;
                                        border-left: 0 !important;
                                        border-radius: 0 !important;
                                        background: transparent !important;
                                    }
                                </style>

                                <input type="radio" name="co_color" value="AA20FF" class="magic-radio mod_co_color" id="color_AA20FF" <?php if(isset($rb_config['co_color']) && $rb_config['co_color'] == "AA20FF") { ?>checked<?php } ?>>
                                <label for="color_AA20FF"></label>
                                <input type="radio" name="co_color" value="FFC700" class="magic-radio mod_co_color" id="color_FFC700" <?php if(isset($rb_config['co_color']) && $rb_config['co_color'] == "FFC700") { ?>checked<?php } ?>>
                                <label for="color_FFC700"></label>
                                <input type="radio" name="co_color" value="00A3FF" class="magic-radio mod_co_color" id="color_00A3FF" <?php if(isset($rb_config['co_color']) && $rb_config['co_color'] == "00A3FF") { ?>checked<?php } ?>>
                                <label for="color_00A3FF"></label>
                                <input type="radio" name="co_color" value="8ED100" class="magic-radio mod_co_color" id="color_8ED100" <?php if(isset($rb_config['co_color']) && $rb_config['co_color'] == "8ED100") { ?>checked<?php } ?>>
                                <label for="color_8ED100"></label>
                                <input type="radio" name="co_color" value="FF5A5A" class="magic-radio mod_co_color" id="color_FF5A5A" <?php if(isset($rb_config['co_color']) && $rb_config['co_color'] == "FF5A5A") { ?>checked<?php } ?>>
                                <label for="color_FF5A5A"></label>
                                <input type="radio" name="co_color" value="25282B" class="magic-radio mod_co_color" id="color_25282B" <?php if(isset($rb_config['co_color']) && $rb_config['co_color'] == "25282B") { ?>checked<?php } ?>>
                                <label for="color_25282B"></label>
                            </ul>
                        </div>
                    </ul>
                    

                    
                    <ul class="rb_config_sec">
                        <h6 class="font-B">헤더컬러 설정 (공용)</h6>
                        <div class="config_wrap">
                            <style>
                                .co_header_ex {float:left; width: 70%;}
                                .co_header_chk {float:left; width: 30%; padding-left: 15px; line-height: 40px;}
                                .co_header_ex dd {border-radius: 10px; width: 100%; padding: 12px 20px 12px 20px; margin-bottom: 5px;}
                                .co_header_ex dd span {float:left; margin-top: 3px;}
                                .co_header_ex dd i {float:right; margin-top: 2px;}
                            </style>
                            
                            <ul>
                                <li class="co_header_ex">
                                    <dd style="background-color:#ffffff; border:1px solid #ddd;">
                                        <span class="font-B" style="color:#25282B">Aa 가 123</span>
                                        <i>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49928 1.91687e-08C7.14387 0.000115492 5.80814 0.324364 4.60353 0.945694C3.39893 1.56702 2.36037 2.46742 1.57451 3.57175C0.788656 4.67609 0.278287 5.95235 0.0859852 7.29404C-0.106316 8.63574 0.0250263 10.004 0.469055 11.2846C0.913084 12.5652 1.65692 13.7211 2.63851 14.6557C3.6201 15.5904 4.81098 16.2768 6.11179 16.6576C7.4126 17.0384 8.78562 17.1026 10.1163 16.8449C11.447 16.5872 12.6967 16.015 13.7613 15.176L17.4133 18.828C17.6019 19.0102 17.8545 19.111 18.1167 19.1087C18.3789 19.1064 18.6297 19.0012 18.8151 18.8158C19.0005 18.6304 19.1057 18.3796 19.108 18.1174C19.1102 17.8552 19.0094 17.6026 18.8273 17.414L15.1753 13.762C16.1633 12.5086 16.7784 11.0024 16.9504 9.41573C17.1223 7.82905 16.8441 6.22602 16.1475 4.79009C15.4509 3.35417 14.3642 2.14336 13.0116 1.29623C11.659 0.449106 10.0952 -0.000107143 8.49928 1.91687e-08ZM1.99928 8.5C1.99928 6.77609 2.6841 5.12279 3.90308 3.90381C5.12207 2.68482 6.77537 2 8.49928 2C10.2232 2 11.8765 2.68482 13.0955 3.90381C14.3145 5.12279 14.9993 6.77609 14.9993 8.5C14.9993 10.2239 14.3145 11.8772 13.0955 13.0962C11.8765 14.3152 10.2232 15 8.49928 15C6.77537 15 5.12207 14.3152 3.90308 13.0962C2.6841 11.8772 1.99928 10.2239 1.99928 8.5Z" fill="#25282B"/>
                                            </svg>
                                        </i>
                                        <div class="cb"></div>
                                    </dd>
                                </li>
                                <li class="co_header_chk">
                                    <input type="radio" name="co_header" value="0" class="magic-radio mod_co_header" id="co_header0" <?php if(isset($rb_config['co_header']) && $rb_config['co_header'] == "0") { ?>checked<?php } ?>>
                                    <label for="co_header0">선택</label>
                                </li>
                                <div class="cb"></div>
                            </ul>
                            
                            <ul>
                                <li class="co_header_ex">
                                    <dd style="background-color:#AA20FF">
                                        <span class="font-B" style="color:#ffffff">Aa 가 123</span>
                                        <i>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49928 1.91687e-08C7.14387 0.000115492 5.80814 0.324364 4.60353 0.945694C3.39893 1.56702 2.36037 2.46742 1.57451 3.57175C0.788656 4.67609 0.278287 5.95235 0.0859852 7.29404C-0.106316 8.63574 0.0250263 10.004 0.469055 11.2846C0.913084 12.5652 1.65692 13.7211 2.63851 14.6557C3.6201 15.5904 4.81098 16.2768 6.11179 16.6576C7.4126 17.0384 8.78562 17.1026 10.1163 16.8449C11.447 16.5872 12.6967 16.015 13.7613 15.176L17.4133 18.828C17.6019 19.0102 17.8545 19.111 18.1167 19.1087C18.3789 19.1064 18.6297 19.0012 18.8151 18.8158C19.0005 18.6304 19.1057 18.3796 19.108 18.1174C19.1102 17.8552 19.0094 17.6026 18.8273 17.414L15.1753 13.762C16.1633 12.5086 16.7784 11.0024 16.9504 9.41573C17.1223 7.82905 16.8441 6.22602 16.1475 4.79009C15.4509 3.35417 14.3642 2.14336 13.0116 1.29623C11.659 0.449106 10.0952 -0.000107143 8.49928 1.91687e-08ZM1.99928 8.5C1.99928 6.77609 2.6841 5.12279 3.90308 3.90381C5.12207 2.68482 6.77537 2 8.49928 2C10.2232 2 11.8765 2.68482 13.0955 3.90381C14.3145 5.12279 14.9993 6.77609 14.9993 8.5C14.9993 10.2239 14.3145 11.8772 13.0955 13.0962C11.8765 14.3152 10.2232 15 8.49928 15C6.77537 15 5.12207 14.3152 3.90308 13.0962C2.6841 11.8772 1.99928 10.2239 1.99928 8.5Z" fill="#ffffff"/>
                                            </svg>
                                        </i>
                                        <div class="cb"></div>
                                    </dd>
                                </li>
                                <li class="co_header_chk">
                                    <input type="radio" name="co_header" value="1" class="magic-radio mod_co_header" id="co_header1" <?php if(isset($rb_config['co_header']) && $rb_config['co_header'] == "1") { ?>checked<?php } ?>>
                                    <label for="co_header1">선택</label>
                                </li>
                                <div class="cb"></div>
                            </ul>
                            
                            <ul>
                                <li class="co_header_ex">
                                    <dd style="background-color:#FFC700">
                                        <span class="font-B" style="color:#ffffff">Aa 가 123</span>
                                        <i>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49928 1.91687e-08C7.14387 0.000115492 5.80814 0.324364 4.60353 0.945694C3.39893 1.56702 2.36037 2.46742 1.57451 3.57175C0.788656 4.67609 0.278287 5.95235 0.0859852 7.29404C-0.106316 8.63574 0.0250263 10.004 0.469055 11.2846C0.913084 12.5652 1.65692 13.7211 2.63851 14.6557C3.6201 15.5904 4.81098 16.2768 6.11179 16.6576C7.4126 17.0384 8.78562 17.1026 10.1163 16.8449C11.447 16.5872 12.6967 16.015 13.7613 15.176L17.4133 18.828C17.6019 19.0102 17.8545 19.111 18.1167 19.1087C18.3789 19.1064 18.6297 19.0012 18.8151 18.8158C19.0005 18.6304 19.1057 18.3796 19.108 18.1174C19.1102 17.8552 19.0094 17.6026 18.8273 17.414L15.1753 13.762C16.1633 12.5086 16.7784 11.0024 16.9504 9.41573C17.1223 7.82905 16.8441 6.22602 16.1475 4.79009C15.4509 3.35417 14.3642 2.14336 13.0116 1.29623C11.659 0.449106 10.0952 -0.000107143 8.49928 1.91687e-08ZM1.99928 8.5C1.99928 6.77609 2.6841 5.12279 3.90308 3.90381C5.12207 2.68482 6.77537 2 8.49928 2C10.2232 2 11.8765 2.68482 13.0955 3.90381C14.3145 5.12279 14.9993 6.77609 14.9993 8.5C14.9993 10.2239 14.3145 11.8772 13.0955 13.0962C11.8765 14.3152 10.2232 15 8.49928 15C6.77537 15 5.12207 14.3152 3.90308 13.0962C2.6841 11.8772 1.99928 10.2239 1.99928 8.5Z" fill="#ffffff"/>
                                            </svg>
                                        </i>
                                        <div class="cb"></div>
                                    </dd>
                                </li>
                                <li class="co_header_chk">
                                    <input type="radio" name="co_header" value="2" class="magic-radio mod_co_header" id="co_header2" <?php if(isset($rb_config['co_header']) && $rb_config['co_header'] == "2") { ?>checked<?php } ?>>
                                    <label for="co_header2">선택</label>
                                </li>
                                <div class="cb"></div>
                            </ul>
                            
                            <ul>
                                <li class="co_header_ex">
                                    <dd style="background-color:#00A3FF">
                                        <span class="font-B" style="color:#ffffff">Aa 가 123</span>
                                        <i>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49928 1.91687e-08C7.14387 0.000115492 5.80814 0.324364 4.60353 0.945694C3.39893 1.56702 2.36037 2.46742 1.57451 3.57175C0.788656 4.67609 0.278287 5.95235 0.0859852 7.29404C-0.106316 8.63574 0.0250263 10.004 0.469055 11.2846C0.913084 12.5652 1.65692 13.7211 2.63851 14.6557C3.6201 15.5904 4.81098 16.2768 6.11179 16.6576C7.4126 17.0384 8.78562 17.1026 10.1163 16.8449C11.447 16.5872 12.6967 16.015 13.7613 15.176L17.4133 18.828C17.6019 19.0102 17.8545 19.111 18.1167 19.1087C18.3789 19.1064 18.6297 19.0012 18.8151 18.8158C19.0005 18.6304 19.1057 18.3796 19.108 18.1174C19.1102 17.8552 19.0094 17.6026 18.8273 17.414L15.1753 13.762C16.1633 12.5086 16.7784 11.0024 16.9504 9.41573C17.1223 7.82905 16.8441 6.22602 16.1475 4.79009C15.4509 3.35417 14.3642 2.14336 13.0116 1.29623C11.659 0.449106 10.0952 -0.000107143 8.49928 1.91687e-08ZM1.99928 8.5C1.99928 6.77609 2.6841 5.12279 3.90308 3.90381C5.12207 2.68482 6.77537 2 8.49928 2C10.2232 2 11.8765 2.68482 13.0955 3.90381C14.3145 5.12279 14.9993 6.77609 14.9993 8.5C14.9993 10.2239 14.3145 11.8772 13.0955 13.0962C11.8765 14.3152 10.2232 15 8.49928 15C6.77537 15 5.12207 14.3152 3.90308 13.0962C2.6841 11.8772 1.99928 10.2239 1.99928 8.5Z" fill="#ffffff"/>
                                            </svg>
                                        </i>
                                        <div class="cb"></div>
                                    </dd>
                                </li>
                                <li class="co_header_chk">
                                    <input type="radio" name="co_header" value="3" class="magic-radio mod_co_header" id="co_header3" <?php if(isset($rb_config['co_header']) && $rb_config['co_header'] == "3") { ?>checked<?php } ?>>
                                    <label for="co_header3">선택</label>
                                </li>
                                <div class="cb"></div>
                            </ul>
                            
                            <ul>
                                <li class="co_header_ex">
                                    <dd style="background-color:#8ED100">
                                        <span class="font-B" style="color:#ffffff">Aa 가 123</span>
                                        <i>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49928 1.91687e-08C7.14387 0.000115492 5.80814 0.324364 4.60353 0.945694C3.39893 1.56702 2.36037 2.46742 1.57451 3.57175C0.788656 4.67609 0.278287 5.95235 0.0859852 7.29404C-0.106316 8.63574 0.0250263 10.004 0.469055 11.2846C0.913084 12.5652 1.65692 13.7211 2.63851 14.6557C3.6201 15.5904 4.81098 16.2768 6.11179 16.6576C7.4126 17.0384 8.78562 17.1026 10.1163 16.8449C11.447 16.5872 12.6967 16.015 13.7613 15.176L17.4133 18.828C17.6019 19.0102 17.8545 19.111 18.1167 19.1087C18.3789 19.1064 18.6297 19.0012 18.8151 18.8158C19.0005 18.6304 19.1057 18.3796 19.108 18.1174C19.1102 17.8552 19.0094 17.6026 18.8273 17.414L15.1753 13.762C16.1633 12.5086 16.7784 11.0024 16.9504 9.41573C17.1223 7.82905 16.8441 6.22602 16.1475 4.79009C15.4509 3.35417 14.3642 2.14336 13.0116 1.29623C11.659 0.449106 10.0952 -0.000107143 8.49928 1.91687e-08ZM1.99928 8.5C1.99928 6.77609 2.6841 5.12279 3.90308 3.90381C5.12207 2.68482 6.77537 2 8.49928 2C10.2232 2 11.8765 2.68482 13.0955 3.90381C14.3145 5.12279 14.9993 6.77609 14.9993 8.5C14.9993 10.2239 14.3145 11.8772 13.0955 13.0962C11.8765 14.3152 10.2232 15 8.49928 15C6.77537 15 5.12207 14.3152 3.90308 13.0962C2.6841 11.8772 1.99928 10.2239 1.99928 8.5Z" fill="#ffffff"/>
                                            </svg>
                                        </i>
                                        <div class="cb"></div>
                                    </dd>
                                </li>
                                <li class="co_header_chk">
                                    <input type="radio" name="co_header" value="4" class="magic-radio mod_co_header" id="co_header4" <?php if(isset($rb_config['co_header']) && $rb_config['co_header'] == "4") { ?>checked<?php } ?>>
                                    <label for="co_header4">선택</label>
                                </li>
                                <div class="cb"></div>
                            </ul>
                            
                            
                            <ul>
                                <li class="co_header_ex">
                                    <dd style="background-color:#FF5A5A">
                                        <span class="font-B" style="color:#ffffff">Aa 가 123</span>
                                        <i>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49928 1.91687e-08C7.14387 0.000115492 5.80814 0.324364 4.60353 0.945694C3.39893 1.56702 2.36037 2.46742 1.57451 3.57175C0.788656 4.67609 0.278287 5.95235 0.0859852 7.29404C-0.106316 8.63574 0.0250263 10.004 0.469055 11.2846C0.913084 12.5652 1.65692 13.7211 2.63851 14.6557C3.6201 15.5904 4.81098 16.2768 6.11179 16.6576C7.4126 17.0384 8.78562 17.1026 10.1163 16.8449C11.447 16.5872 12.6967 16.015 13.7613 15.176L17.4133 18.828C17.6019 19.0102 17.8545 19.111 18.1167 19.1087C18.3789 19.1064 18.6297 19.0012 18.8151 18.8158C19.0005 18.6304 19.1057 18.3796 19.108 18.1174C19.1102 17.8552 19.0094 17.6026 18.8273 17.414L15.1753 13.762C16.1633 12.5086 16.7784 11.0024 16.9504 9.41573C17.1223 7.82905 16.8441 6.22602 16.1475 4.79009C15.4509 3.35417 14.3642 2.14336 13.0116 1.29623C11.659 0.449106 10.0952 -0.000107143 8.49928 1.91687e-08ZM1.99928 8.5C1.99928 6.77609 2.6841 5.12279 3.90308 3.90381C5.12207 2.68482 6.77537 2 8.49928 2C10.2232 2 11.8765 2.68482 13.0955 3.90381C14.3145 5.12279 14.9993 6.77609 14.9993 8.5C14.9993 10.2239 14.3145 11.8772 13.0955 13.0962C11.8765 14.3152 10.2232 15 8.49928 15C6.77537 15 5.12207 14.3152 3.90308 13.0962C2.6841 11.8772 1.99928 10.2239 1.99928 8.5Z" fill="#ffffff"/>
                                            </svg>
                                        </i>
                                        <div class="cb"></div>
                                    </dd>
                                </li>
                                <li class="co_header_chk">
                                    <input type="radio" name="co_header" value="5" class="magic-radio mod_co_header" id="co_header5" <?php if(isset($rb_config['co_header']) && $rb_config['co_header'] == "5") { ?>checked<?php } ?>>
                                    <label for="co_header5">선택</label>
                                </li>
                                <div class="cb"></div>
                            </ul>
                            
                            
                            <ul>
                                <li class="co_header_ex">
                                    <dd style="background-color:#25282B">
                                        <span class="font-B" style="color:#ffffff">Aa 가 123</span>
                                        <i>
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49928 1.91687e-08C7.14387 0.000115492 5.80814 0.324364 4.60353 0.945694C3.39893 1.56702 2.36037 2.46742 1.57451 3.57175C0.788656 4.67609 0.278287 5.95235 0.0859852 7.29404C-0.106316 8.63574 0.0250263 10.004 0.469055 11.2846C0.913084 12.5652 1.65692 13.7211 2.63851 14.6557C3.6201 15.5904 4.81098 16.2768 6.11179 16.6576C7.4126 17.0384 8.78562 17.1026 10.1163 16.8449C11.447 16.5872 12.6967 16.015 13.7613 15.176L17.4133 18.828C17.6019 19.0102 17.8545 19.111 18.1167 19.1087C18.3789 19.1064 18.6297 19.0012 18.8151 18.8158C19.0005 18.6304 19.1057 18.3796 19.108 18.1174C19.1102 17.8552 19.0094 17.6026 18.8273 17.414L15.1753 13.762C16.1633 12.5086 16.7784 11.0024 16.9504 9.41573C17.1223 7.82905 16.8441 6.22602 16.1475 4.79009C15.4509 3.35417 14.3642 2.14336 13.0116 1.29623C11.659 0.449106 10.0952 -0.000107143 8.49928 1.91687e-08ZM1.99928 8.5C1.99928 6.77609 2.6841 5.12279 3.90308 3.90381C5.12207 2.68482 6.77537 2 8.49928 2C10.2232 2 11.8765 2.68482 13.0955 3.90381C14.3145 5.12279 14.9993 6.77609 14.9993 8.5C14.9993 10.2239 14.3145 11.8772 13.0955 13.0962C11.8765 14.3152 10.2232 15 8.49928 15C6.77537 15 5.12207 14.3152 3.90308 13.0962C2.6841 11.8772 1.99928 10.2239 1.99928 8.5Z" fill="#ffffff"/>
                                            </svg>
                                        </i>
                                        <div class="cb"></div>
                                    </dd>
                                </li>
                                <li class="co_header_chk">
                                    <input type="radio" name="co_header" value="6" class="magic-radio mod_co_header" id="co_header6" <?php if(isset($rb_config['co_header']) && $rb_config['co_header'] == "6") { ?>checked<?php } ?>>
                                    <label for="co_header6">선택</label>
                                </li>
                                <div class="cb"></div>
                            </ul>
                            
                            
                            
                        </div>
                    </ul>
                    
                    <ul class="rb_config_sec">
                        <h6 class="font-B"><?php if (defined('_SHOP_')) { // 영카트?>마켓 <?php } ?>레이아웃 설정</h6>
                        <h6 class="font-R rb_config_sub_txt">
                            메인, 헤더, 푸터 레이아웃을 설정 합니다.<br>레아아웃 세트는 자유롭게 추가할 수 있습니다.
                        </h6>
                        
                        
                        <div <?php if(defined('_SHOP_')) { // 영카트?>style="display:block !important;"<?php } else { ?>style="display:none !important;"<?php } ?>>
                        
                            <div class="config_wrap">
                                <ul>
                                    <select class="select w100 mod_send" name="co_layout_shop">
                                        <option value="">메인 레이아웃 선택</option>
                                        <?php echo rb_dir_select_shop("rb.layout", $rb_core['layout_shop']); ?>
                                    </select>
                                </ul>

                                <?php if(isset($rb_core['layout_shop']) && $rb_core['layout_shop']) { ?>
                                <ul class="skin_path_url mt-5">
                                    <li class="skin_path_url_img"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_fd.svg"></li>
                                    <li class="skin_path_url_txt">
                                    /theme/rb.basic/shop/rb.layout/<?php echo $rb_core['layout_shop'] ?>/
                                    </li>
                                    <div class="cb"></div>
                                </ul>
                                <?php } ?>

                            </div>
                            
                            <div class="config_wrap">
                                <ul>
                                    <select class="select w100 mod_send" name="co_layout_hd_shop">
                                        <option value="">헤더 레이아웃 선택</option>
                                        <?php echo rb_dir_select_shop("rb.layout_hd", $rb_core['layout_hd_shop']); ?>
                                    </select>
                                </ul>

                                <?php if(isset($rb_core['layout_hd_shop']) && $rb_core['layout_hd_shop']) { ?>
                                <ul class="skin_path_url mt-5">
                                    <li class="skin_path_url_img"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_fd.svg"></li>
                                    <li class="skin_path_url_txt">
                                    /theme/rb.basic/shop/rb.layout_hd/<?php echo $rb_core['layout_hd_shop'] ?>/
                                    </li>
                                    <div class="cb"></div>
                                </ul>
                                <?php } ?>

                            </div>
                            
                            <div class="config_wrap">
                                <ul>
                                    <select class="select w100 mod_send" name="co_layout_ft_shop">
                                        <option value="">푸터 레이아웃 선택</option>
                                        <?php echo rb_dir_select_shop("rb.layout_ft", $rb_core['layout_ft_shop']); ?>
                                    </select>
                                </ul>

                                <?php if(isset($rb_core['layout_ft_shop']) && $rb_core['layout_ft_shop']) { ?>
                                <ul class="skin_path_url mt-5">
                                    <li class="skin_path_url_img"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_fd.svg"></li>
                                    <li class="skin_path_url_txt">
                                    /theme/rb.basic/shop/rb.layout_ft/<?php echo $rb_core['layout_ft_shop'] ?>/
                                    </li>
                                    <div class="cb"></div>
                                </ul>
                                <?php } ?>

                            </div>
                            
                        </div>
                          
                        <div <?php if(defined('_SHOP_')) { // 영카트?>style="display:none !important;"<?php } else { ?>style="display:block !important;"<?php } ?>>
                            <div class="config_wrap">
                                <ul>
                                    <select class="select w100 mod_send" name="co_layout">
                                        <option value="">메인 레이아웃 선택</option>
                                        <?php echo rb_dir_select("rb.layout", $rb_core['layout']); ?>
                                    </select>
                                </ul>

                                <?php if(isset($rb_core['layout']) && $rb_core['layout']) { ?>
                                <ul class="skin_path_url mt-5">
                                    <li class="skin_path_url_img"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_fd.svg"></li>
                                    <li class="skin_path_url_txt">
                                    /theme/rb.basic/rb.layout/<?php echo $rb_core['layout'] ?>/
                                    </li>
                                    <div class="cb"></div>
                                </ul>
                                <?php } ?>

                            </div>
                            
                            <div class="config_wrap">
                                <ul>
                                    <select class="select w100 mod_send" name="co_layout_hd">
                                        <option value="">헤더 레이아웃 선택</option>
                                        <?php echo rb_dir_select("rb.layout_hd", $rb_core['layout_hd']); ?>
                                    </select>
                                </ul>

                                <?php if(isset($rb_core['layout_hd']) && $rb_core['layout_hd']) { ?>
                                <ul class="skin_path_url mt-5">
                                    <li class="skin_path_url_img"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_fd.svg"></li>
                                    <li class="skin_path_url_txt">
                                    /theme/rb.basic/rb.layout_hd/<?php echo $rb_core['layout_hd'] ?>/
                                    </li>
                                    <div class="cb"></div>
                                </ul>
                                <?php } ?>

                            </div>
                            
                            <div class="config_wrap">
                                <ul>
                                    <select class="select w100 mod_send" name="co_layout_ft">
                                        <option value="">푸터 레이아웃 선택</option>
                                        <?php echo rb_dir_select("rb.layout_ft", $rb_core['layout_ft']); ?>
                                    </select>
                                </ul>

                                <?php if(isset($rb_core['layout_ft']) && $rb_core['layout_ft']) { ?>
                                <ul class="skin_path_url mt-5">
                                    <li class="skin_path_url_img"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_fd.svg"></li>
                                    <li class="skin_path_url_txt">
                                    /theme/rb.basic/rb.layout_ft/<?php echo $rb_core['layout_ft'] ?>/
                                    </li>
                                    <div class="cb"></div>
                                </ul>
                                <?php } ?>

                            </div>
                        
                        </div>
                           

                        
                    </ul>


                    
                    
                    <ul class="rb_config_sec">
                        <h6 class="font-B">가로폭 설정 (공용)</h6>
                        <h6 class="font-R rb_config_sub_txt">
                            상단/하단, 메인 및 서브 컨텐츠 영역의 가로폭을 설정해주세요.<br>
                            설정이 없는 경우 1400px 으로 고정 됩니다.
                        </h6>
                        <div class="config_wrap">
                            <ul>
                              
                                <select class="select w30 mod_send" name="co_tb_width">
                                    <option value="">상단/하단</option>
                                    <option value="100" <?php if(isset($rb_core['tb_width']) && $rb_core['tb_width'] == "100") { ?>selected<?php } ?>>100%</option>
                                    <option value="1400" <?php if(isset($rb_core['tb_width']) && $rb_core['tb_width'] == "1400") { ?>selected<?php } ?>>1400px</option>
                                    <option value="1280" <?php if(isset($rb_core['tb_width']) && $rb_core['tb_width'] == "1280") { ?>selected<?php } ?>>1280px</option>
                                    <option value="1024" <?php if(isset($rb_core['tb_width']) && $rb_core['tb_width'] == "1024") { ?>selected<?php } ?>>1024px</option>
                                    <option value="960" <?php if(isset($rb_core['tb_width']) && $rb_core['tb_width'] == "960") { ?>selected<?php } ?>>960px</option>
                                    <option value="750" <?php if(isset($rb_core['tb_width']) && $rb_core['tb_width'] == "750") { ?>selected<?php } ?>>750px</option>
                                </select>
                               
                                <select class="select w30 mod_send" name="co_main_width">
                                    <option value="">메인</option>
                                    <option value="1400" <?php if(isset($rb_core['main_width']) && $rb_core['main_width'] == "1400") { ?>selected<?php } ?>>1400px</option>
                                    <option value="1280" <?php if(isset($rb_core['main_width']) && $rb_core['main_width'] == "1280") { ?>selected<?php } ?>>1280px</option>
                                    <option value="1024" <?php if(isset($rb_core['main_width']) && $rb_core['main_width'] == "1024") { ?>selected<?php } ?>>1024px</option>
                                    <option value="960" <?php if(isset($rb_core['main_width']) && $rb_core['main_width'] == "960") { ?>selected<?php } ?>>960px</option>
                                    <option value="750" <?php if(isset($rb_core['main_width']) && $rb_core['main_width'] == "750") { ?>selected<?php } ?>>750px</option>
                                </select>
                                
                                <select class="select w30 mod_send" name="co_sub_width">
                                    <option value="">서브</option>
                                    <option value="1400" <?php if(isset($rb_core['sub_width']) && $rb_core['sub_width'] == "1400") { ?>selected<?php } ?>>1400px</option>
                                    <option value="1280" <?php if(isset($rb_core['sub_width']) && $rb_core['sub_width'] == "1280") { ?>selected<?php } ?>>1280px</option>
                                    <option value="1024" <?php if(isset($rb_core['sub_width']) && $rb_core['sub_width'] == "1024") { ?>selected<?php } ?>>1024px</option>
                                    <option value="960" <?php if(isset($rb_core['sub_width']) && $rb_core['sub_width'] == "960") { ?>selected<?php } ?>>960px</option>
                                    <option value="750" <?php if(isset($rb_core['sub_width']) && $rb_core['sub_width'] == "750") { ?>selected<?php } ?>>750px</option>
                                </select>

                                
                            </ul>
                        </div>
                    </ul>
                    
                    <ul class="rb_config_sec">
                        <h6 class="font-B"><?php if(defined('_SHOP_')) { // 영카트?>마켓 <?php } ?>상단여백 설정 (PC)</h6>
                        <h6 class="font-R rb_config_sub_txt">
                            PC버전 상단의 여백을 제거할 수 있습니다.
                        </h6>
                        <div class="config_wrap">
                            <ul>
                                <?php if(defined('_SHOP_')) { // 영카트?>
                                <input type="checkbox" name="co_main_padding_top_shop" id="co_main_padding_top_shop" class="magic-checkbox mod_send" value="1" <?php if(isset($rb_core['padding_top_shop']) && $rb_core['padding_top_shop'] == 1) { ?>checked<?php } ?>><label for="co_main_padding_top_shop">여백제거</label>
                                <?php } else { ?>
                                <input type="checkbox" name="co_main_padding_top" id="co_main_padding_top" class="magic-checkbox mod_send" value="1" <?php if(isset($rb_core['padding_top']) && $rb_core['padding_top'] == 1) { ?>checked<?php } ?>><label for="co_main_padding_top">여백제거</label>
                                <?php } ?>
                                
                            </ul>
                        </div>
                    </ul>
                    
                    
                    
                    <ul class="rb_config_sec">
                        <h6 class="font-B">웹폰트 설정 (공용)</h6>
                        <h6 class="font-R rb_config_sub_txt">선택하신 폰트가 웹사이트 전체에 적용 됩니다.<br>웹폰트 세트를 자유롭게 추가할 수 있습니다.</h6>
                        <div class="config_wrap">
                            <ul>
                                <select class="select w100 mod_send" name="co_font">
                                    <option value="">웹폰트 선택</option>
                                    <?php echo rb_dir_select("rb.fonts", $rb_core['font']); ?>
                                </select>
                            </ul>
                            
                            <?php if(isset($rb_core['font']) && $rb_core['font']) { ?>
                            <ul class="skin_path_url mt-5">
                                <li class="skin_path_url_img"><img src="<?php echo G5_URL ?>/rb/rb.config/image/icon_fd.svg"></li>
                                <li class="skin_path_url_txt">
                                /theme/rb.basic/rb.fonts/<?php echo $rb_core['font'] ?>/
                                </li>
                                <div class="cb"></div>
                            </ul>
                            <?php } ?>
                            
                        </div>
                    </ul>
                    
                    <ul class="rb_config_sec">
                        <button type="button" class="rb_config_reload font-B" onclick="javascript:location.reload();">새로고침</button>
                        <button type="button" class="rb_config_close font-B" onclick="toggleSideOptions_close()">닫기</button>
                        <div class="cb"></div>
                    </ul>
                    
                    
                    
                    
                    
                </div>


            </div>
        </div>

    </div>


</div>


<script type="text/javascript">
    
        $(document).ready(function() {
            $('.rb_config_mod1').hide();
            $('.rb_config_mod2').hide();
            $("#saveOrderButton").hide();
        });
    
    
        //모듈설정 토글
        function toggleSideOptions() {
            
            //클래스로 확인한다.
            if ($('.content_box').hasClass('content_box_set')) {
                toggleSideOptions_close_mod();
            } else {
                toggleSideOptions_open_mod();
            }
        }
    
        // 모듈설정 오픈
        function toggleSideOptions_open_mod() {
            $('.rb_config_mod1').hide();
            $('.rb_config_mod2').show();

            // 모듈설정 활성
            $('.content_box').addClass('content_box_set');
            $('.mobule_set_btn').addClass('open');
            $('.setting_set_btn').removeClass('open');

            // 모듈이동
            $(function() {
                var originalWidth, originalHeight;

                $(".flex_box").sortable({
                    placeholder: "placeholders_box", // 드랍될 위치를 표시할 클래스 이름
                    tolerance: "pointer", // pointer를 기준으로 tolerance 설정
                    helper: "clone", // helper를 clone으로 설정
                    start: function(event, ui) {
                        // 드래그 시작할 때 원래 크기 저장 (padding과 border 포함)
                        originalWidth = ui.item.outerWidth();
                        originalHeight = ui.item.outerHeight();
                        ui.helper.addClass("dragging");
                        ui.helper.css({
                            width: originalWidth,
                            height: originalHeight
                        });

                        // placeholder의 크기를 드래그되는 아이템에서 padding을 뺀 크기로 설정하고, margin 추가
                        var paddingLeft = parseInt(ui.helper.css('padding-left'), 10);
                        var paddingRight = parseInt(ui.helper.css('padding-right'), 10);
                        var paddingTop = parseInt(ui.helper.css('padding-top'), 10);
                        var paddingBottom = parseInt(ui.helper.css('padding-bottom'), 10);

                        $(".placeholders_box").css({
                            width: originalWidth - paddingLeft - paddingRight,
                            height: originalHeight - paddingTop - paddingBottom,
                            margin: '20px'
                        });
                    },
                    stop: function(event, ui) {
                        // 드래그 멈출 때 원래 크기로 복원하고 그림자 제거
                        ui.item.removeClass("dragging");
                        ui.item.css({
                            width: originalWidth,
                            height: originalHeight
                        });

                        // 마우스 포인터가 .flex_box 내부에 있는지 확인
                        var parentOffset = $(".flex_box").offset();
                        if (parentOffset) {
                            var itemOffset = ui.helper ? ui.helper.offset() : null; // 드랍 위치의 오프셋
                            var itemWidth = ui.helper ? ui.helper.outerWidth() : 0;
                            var itemHeight = ui.helper ? ui.helper.outerHeight() : 0;

                            if (itemOffset && (itemOffset.left < parentOffset.left ||
                                itemOffset.top < parentOffset.top ||
                                itemOffset.left + itemWidth > parentOffset.left + $(".flex_box").outerWidth() ||
                                itemOffset.top + itemHeight > parentOffset.top + $(".flex_box").outerHeight())) {

                                // .flex_box 외부라면 원래 위치로 되돌리기
                                $(".flex_box").sortable("cancel");
                            }
                        }

                        // data-order-id 업데이트
                        $(".flex_box .content_box").each(function(index) {
                            $(this).attr("data-order-id", index + 1);
                        });
                        
                        $("#saveOrderButton").show();
                    },
                    update: function(event, ui) {
                        // 순서가 변경된 후 data-order-id 업데이트
                        $(".flex_box .content_box").each(function(index) {
                            $(this).attr("data-order-id", index + 1);
                        });

                        // 변경된 순서를 배열로 저장
                        var order = $(this).sortable('toArray', { attribute: 'data-id' });
                        console.log(order);

                        // order 값을 전역 변수로 저장
                        window.currentOrder = order;
                        //saveOrder(order); // 순서를 저장하는 함수 호출
                    }
                }).disableSelection();
                
                // 저장 버튼 클릭 이벤트 핸들러
                $("#saveOrderButton").on("click", function() {
                    
                    <?php if($is_admin) { ?>
                    <?php } else { ?>
                    alert('편집 권한이 없습니다.');
                    return false;
                    <?php } ?>
                    
                    if (window.currentOrder) {
                        saveOrder(window.currentOrder); // 순서를 저장하는 함수 호출
                    } else {
                        console.log("순서저장에 문제가 있습니다.");
                    }
                });

                // content_box를 클릭할 때 원래 크기 저장
                $(".content_box").on("mousedown", function(event) {
                    $(".content_box").removeClass("dragging");
                    var $this = $(this);
                    originalWidth = $this.outerWidth();
                    originalHeight = $this.outerHeight();
                    $this.css({
                        width: originalWidth,
                        height: originalHeight
                    });
                    $this.addClass("clicked");
                });

                // 마우스를 놓을 때 크기 초기화
                $(".content_box").on("mouseup", function(event) {
                    var $this = $(this);
                    $this.css({
                        width: originalWidth,
                        height: originalHeight
                    });
                });

                // 순서를 저장하는 함수
                function saveOrder() {
                    var orderData = [];
                    $(".flex_box .content_box").each(function(index) {
                        orderData.push({
                            id: $(this).data('id'),
                            order_id: index + 1
                        });
                    });

                    $.ajax({
                        url: '<?php echo G5_URL ?>/rb/rb.lib/ajax.res.php',
                        method: 'POST',
                        
                        data: { 
                            order: orderData, 
                            mod_type: "mod_order", 
                            <?php if (defined('_SHOP_')) { ?>
                            is_shop:"1" 
                            <?php } else { ?>
                            is_shop:"0" 
                            <?php } ?>
                        },

                        success: function(response) {
                            console.log('Order saved:', response);
                            $("#saveOrderButton").hide();
                            alert('모듈의 순서를 변경하였습니다.');
                        },
                        error: function(xhr, status, error) {
                            console.error('Error saving order:', error);
                        }
                    });
                }
            });

        }
    

        // 모듈설정 닫기
        function toggleSideOptions_close_mod() {
            $('.rb_config_mod1').hide();
            $('.rb_config_mod2').hide();

            // 모듈설정 비활성
            $(".flex_box").sortable("destroy");
            $('.content_box').removeClass('handles');
            $('.mobule_set_btn').removeClass('open');
            $('.setting_set_btn').removeClass('open');
            
            toggleSideOptions_close();
        }

    

        //환경설정 오픈
        function toggleSideOptions_open_set() {
            toggleSideOptions_open()
            
            $('.rb_config_mod1').show();
            $('.rb_config_mod2').hide();
            
            //환경설정 활성
            $('.setting_set_btn').addClass('open');
            $('.mobule_set_btn').removeClass('open');
            $('.content_box').removeClass('content_box_set');
        }

        //환경설정 열기
        function toggleSideOptions_open() {
            $('.sh-side-options').css('transition', 'all 600ms cubic-bezier(0.86, 0, 0.07, 1)');
            $('.sh-side-options').addClass('open');
        }
    
        //환경설정 닫기
        function toggleSideOptions_close() {
            $('.sh-side-options').css('transition', 'all 600ms cubic-bezier(0.86, 0, 0.07, 1)');
            $('.sh-side-options').removeClass('open');
            
            $('.setting_set_btn').removeClass('open');
            $('.mobule_set_btn').removeClass('open');
            $('.content_box').removeClass('content_box_set');
            
        }
    

        //모듈설정
        function set_module_send(element) {

            // 부모 요소의 값을 가져옴
            var set_layout = $(element).closest('.flex_box').data('layout');
            var set_title = $(element).closest('.content_box').data('title');
            var set_id = $(element).closest('.content_box').data('id');
            var theme_name = '<?php echo $rb_core['theme']; ?>';
            var mod_type = '2';

            
            $.ajax({
                url: '<?php echo G5_URL ?>/rb/rb.config/ajax.config_set.php', // PHP 파일 경로
                method: 'POST', // POST 방식으로 전송
                dataType: 'html',
                data: { 
                    "set_layout": set_layout,
                    "set_id": set_id,
                    "set_title": set_title,
                    "theme_name": theme_name,
                    "mod_type": mod_type,
                    <?php if (defined('_SHOP_')) { ?>
                    "is_shop":"1",
                    <?php } else { ?>
                    "is_shop":"0",
                    <?php } ?>
                    
                },
                success: function(response) {
                    $("#inq_res").html(response); //성공
                    toggleSideOptions_open_mod()
                    toggleSideOptions_open()
                    
                },
                error: function(xhr, status, error) {
                    console.error('처리에 문제가 있습니다. 잠시 후 이용해주세요.');
                }
            });
            
            // input 요소에 가져온 값을 설정
            //$('input[name="aaa"]').val(title + ' - ' + id);
        }
    
        //모듈 삭제
        function set_module_del(element) {

            // 부모 요소의 값을 가져옴
            var set_layout = $(element).closest('.flex_box').data('layout');
            var set_title = $(element).closest('.content_box').data('title');
            var set_id = $(element).closest('.content_box').data('id');
            var theme_name = '<?php echo $rb_core['theme']; ?>';
            var mod_type = 'del';
            
            <?php if($is_admin) { ?>
            <?php } else { ?>
            alert('편집 권한이 없습니다.');
            return false;
            <?php } ?>


            // Ajax를 사용하여 PHP로 값 전달
            $.ajax({
                url: '<?php echo G5_URL ?>/rb/rb.config/ajax.config_set.php', // PHP 파일 경로
                method: 'POST', // POST 방식으로 전송
                dataType: 'html',
                data: { 
                    "set_layout": set_layout,
                    "set_id": set_id,
                    "set_title": set_title,
                    "theme_name": theme_name,
                    "mod_type": mod_type,
                    <?php if (defined('_SHOP_')) { ?>
                    "is_shop":"1",
                    <?php } else { ?>
                    "is_shop":"0",
                    <?php } ?>
                    
                },
                success: function(response) {
                    $("#inq_res").html(response); //성공
                    toggleSideOptions_open_mod()
                    toggleSideOptions_open()
                    
                },
                error: function(xhr, status, error) {
                    console.error('처리에 문제가 있습니다. 잠시 후 이용해주세요.');
                }
            });

        }

    
    
        //설정패널
        $(document).ready(function() {

            // 라디오 버튼에 대한 이벤트 핸들러 추가
            $('.mod_co_color').change(function() {
                executeAjax();
            });

            $('.mod_co_header').change(function() {
                executeAjax();
            });

            $('.mod_send').change(function() {
                executeAjax();
            });
            
        });
    
    
            // Ajax 실행 함수 정의
            function executeAjax() {
                
                var co_color = $('input[name="co_color"]:checked').val();
                var co_header = $('input[name="co_header"]:checked').val();
                var co_font = $('select[name="co_font"]').val();
                
                    var co_layout_shop = $('select[name="co_layout_shop"]').val();
                    var co_layout_hd_shop = $('select[name="co_layout_hd_shop"]').val();
                    var co_layout_ft_shop = $('select[name="co_layout_ft_shop"]').val();

                    var co_layout = $('select[name="co_layout"]').val();
                    var co_layout_hd = $('select[name="co_layout_hd"]').val();
                    var co_layout_ft = $('select[name="co_layout_ft"]').val();

                var co_sub_width = $('select[name="co_sub_width"]').val();
                var co_main_width = $('select[name="co_main_width"]').val();
                var co_tb_width = $('select[name="co_tb_width"]').val();
                
                var co_main_padding_top = $('input[name="co_main_padding_top"]:checked').val();
                var co_main_padding_top_shop = $('input[name="co_main_padding_top_shop"]:checked').val();
                var mod_type = '1';
                
                <?php if($is_admin) { ?>
                <?php } else { ?>
                alert('편집 권한이 없습니다.');
                return false;
                <?php } ?>


                // Ajax 요청 실행
                $.ajax({
                    url: '<?php echo G5_URL ?>/rb/rb.config/ajax.config_set.php', // Ajax 요청을 보낼 엔드포인트 URL
                    method: 'POST', // 또는 'GET' 등의 HTTP 메서드
                    dataType: 'json',
                    data: {
                        "co_color":co_color,
                        "co_header":co_header,
                        "co_font":co_font,

                            "co_layout_shop":co_layout_shop,
                            "co_layout_hd_shop":co_layout_hd_shop,
                            "co_layout_ft_shop":co_layout_ft_shop,

                            "co_layout":co_layout,
                            "co_layout_hd":co_layout_hd,
                            "co_layout_ft":co_layout_ft,

                        "co_sub_width":co_sub_width,
                        "co_main_width":co_main_width,
                        "co_tb_width":co_tb_width,
                        "co_main_padding_top":co_main_padding_top,
                        "co_main_padding_top_shop":co_main_padding_top_shop,
                        "mod_type":mod_type,
                    },
                    success: function(data) {
                        if (data.status == 'ok') {
                            
                            $('main').removeClass();
                            $('main').addClass('co_'+ data.co_color);
                            $('main').addClass(' co_header'+ data.co_header);

                            //console.log('강조컬러 설정:#'+ data.co_color);
                            //console.log('헤더 설정:header'+ data.co_header);
                            //console.log('메인 레이아웃 설정:'+ data.co_layout);
                            //console.log('헤더 레이아웃 설정:'+ data.co_layout_hd);
                            //console.log('풋터 레이아웃 설정:'+ data.co_layout_ft);
                            //console.log('폰트 설정:'+ data.co_font);
                            //console.log('서브 가로폭 설정:'+ data.co_sub_width);
                            //console.log('메인 가로폭 설정:'+ data.co_main_width);
                            //console.log('상단/하단 가로폭 설정:'+ data.co_tb_width);
                            
                            //header의 로고이미지 설정 (흰색배경이 기본)
                            if(data.co_header == 0) {
                                
                                <?php if (!empty($rb_builder['bu_logo_mo'])) { ?>
                                    $('#sourceSmall').attr('srcset', '<?php echo G5_URL ?>/data/logos/mo?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } else { ?>
                                    $('#sourceSmall').attr('srcset', '<?php echo G5_THEME_URL ?>/rb.img/logos/mo.png?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } ?>
                                
                                <?php if (!empty($rb_builder['bu_logo_pc'])) { ?>
                                    $('#sourceLarge').attr('srcset', '<?php echo G5_URL ?>/data/logos/pc?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } else { ?>
                                    $('#sourceLarge').attr('srcset', '<?php echo G5_THEME_URL ?>/rb.img/logos/pc.png?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } ?>
                                
                                <?php if (!empty($rb_builder['bu_logo_pc'])) { ?>
                                    $('#fallbackImage').attr('src', '<?php echo G5_URL ?>/data/logos/pc?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } else { ?>
                                    $('#fallbackImage').attr('src', '<?php echo G5_THEME_URL ?>/rb.img/logos/pc.png?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } ?>
                                
                            } else {
                                
                                <?php if (!empty($rb_builder['bu_logo_mo_w'])) { ?>
                                    $('#sourceSmall').attr('srcset', '<?php echo G5_URL ?>/data/logos/mo_w?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } else { ?>
                                    $('#sourceSmall').attr('srcset', '<?php echo G5_THEME_URL ?>/rb.img/logos/mo_w.png?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } ?>
                                
                                <?php if (!empty($rb_builder['bu_logo_pc_w'])) { ?>
                                    $('#sourceLarge').attr('srcset', '<?php echo G5_URL ?>/data/logos/pc_w?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } else { ?>
                                    $('#sourceLarge').attr('srcset', '<?php echo G5_THEME_URL ?>/rb.img/logos/pc_w.png?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } ?>
                                
                                <?php if (!empty($rb_builder['bu_logo_pc_w'])) { ?>
                                    $('#fallbackImage').attr('src', '<?php echo G5_URL ?>/data/logos/pc_w?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } else { ?>
                                    $('#fallbackImage').attr('src', '<?php echo G5_THEME_URL ?>/rb.img/logos/pc_w.png?ver=<?php echo G5_SERVER_TIME ?>');
                                <?php } ?>
                            }

                        } else {
                            console.log('변경실패');
                        }
                    },
                    error: function(err) {
                        alert('문제가 발생 했습니다. 다시 시도해주세요.');
                    }
                });
            }
    
    
    
            // Ajax 실행 함수 정의 (모듈저장)
            function executeAjax_module() {
                
                if($('input[name="md_id"]').val()) {
                    var md_id = $('input[name="md_id"]').val();
                } else { 
                    var md_id = "new";
                }
                
                var md_type = $('select[name="md_type"]').val();
                
                var md_title = $('input[name="md_title"]').val();
                var md_layout = $('input[name="md_layout"]').val();
                var md_theme = $('input[name="md_theme"]').val();
                
                if(md_type == "item") {
                    var md_skin = $('#md_skin_shop').val();
                    var md_sca = $('#md_sca_shop').val();
                } else { 
                    var md_skin = $('#md_skin').val();
                    var md_sca = $('#md_sca').val();
                }

                var md_bo_table = $('select[name="md_bo_table"]').val();
                var md_widget = $('select[name="md_widget"]').val();
                var md_banner = $('select[name="md_banner"]').val();
                var md_banner_id = $('select[name="md_banner_id"]').val();
                var md_banner_bg = $('input[name="md_banner_bg"]').val();
                var md_banner_skin = $('select[name="md_banner_skin"]').val();
                var md_poll = $('select[name="md_poll"]').val();
                var md_poll_id = $('select[name="md_poll_id"]').val();
                
                <?php if(defined('_SHOP_')) { // 영카트?>
                    var layout_name = '<?php echo $rb_core['layout_shop'] ?>';
                <?php } else { ?>
                    var layout_name = '<?php echo $rb_core['layout'] ?>';
                <?php } ?>
                
                
                
                if(md_type == "item") {
                    var md_cnt = $('#md_cnt_shop').val();
                    var md_col = $('#md_col_shop').val();
                    var md_row = $('#md_row_shop').val();
                    var md_col_mo = $('#md_col_mo_shop').val();
                    var md_row_mo = $('#md_row_mo_shop').val();
                } else { 
                    var md_cnt = $('#md_cnt').val();
                    var md_col = $('#md_col').val();
                    var md_row = $('#md_row').val();
                    var md_col_mo = $('#md_col_mo').val();
                    var md_row_mo = $('#md_row_mo').val();
                }
                
                var md_width = $('input[name="md_width"]').val();
                var md_height = $('input[name="md_height"]').val();
                
                if(md_type == "item") {
                    var md_subject_is = $('#md_subject_is_shop:checked').val();
                    var md_thumb_is = $('#md_thumb_is_shop:checked').val();
                    var md_nick_is = $('#md_nick_is_shop:checked').val();
                    var md_date_is = $('#md_date_is_shop:checked').val();
                    var md_comment_is = $('#md_comment_is_shop:checked').val();
                    var md_content_is = $('#md_content_is_shop:checked').val();
                    var md_icon_is = $('#md_icon_is_shop:checked').val();
                    var md_ca_is = $('#md_ca_is_shop:checked').val();
                    var md_gap = $('#md_gap_shop').val();
                    var md_gap_mo = $('#md_gap_mo_shop').val();
                    var md_swiper_is = $('#md_swiper_is_shop:checked').val();
                    var md_auto_is = $('#md_auto_is_shop:checked').val();
                    var md_auto_time = $('#md_auto_time_shop').val();
                } else { 
                    var md_subject_is = $('#md_subject_is:checked').val();
                    var md_thumb_is = $('#md_thumb_is:checked').val();
                    var md_nick_is = $('#md_nick_is:checked').val();
                    var md_date_is = $('#md_date_is:checked').val();
                    var md_comment_is = $('#md_comment_is:checked').val();
                    var md_content_is = $('#md_content_is:checked').val();
                    var md_icon_is = $('#md_icon_is:checked').val();
                    var md_ca_is = $('#md_ca_is:checked').val();
                    var md_gap = $('#md_gap').val();
                    var md_gap_mo = $('#md_gap_mo').val();
                    var md_swiper_is = $('#md_swiper_is:checked').val();
                    var md_auto_is = $('#md_auto_is:checked').val();
                    var md_auto_time = $('#md_auto_time').val();
                }
                
                
                var md_module = $('select[name="md_module"]').val();
                var md_order = $('select[name="md_order"]').val();
                

                if(md_title == "") {
                    alert('모듈 타이틀을 입력해주세요.');
                    $('input[name="md_title"]').focus();
                    return false;
                } else if(md_layout == "") {
                    alert('레이아웃 정보가 없습니다. 레이아웃 파일을 확인해주세요.');
                    return false;
                } else if(md_theme == "") {
                    alert('테마 정보가 없습니다. 테마 설정 후 이용해주세요.');
                    return false;
                } else if(layout_name == "") {
                    alert('레이아웃 정보가 없습니다. 레이아웃을 먼저 설정해주세요.');
                    return false;
                } else if(md_type == "") {
                    alert('출력 타입을 선택해주세요.');
                    $('select[name="md_type"]').focus();
                    return false;
                } else if(md_type == "latest" && md_skin == "") {
                    alert('최신글 스킨을 선택해주세요.');
                    $('#md_skin').focus();
                    return false;
                } else if(md_type == "latest" && md_bo_table == "") {
                    alert('연결할 게시판을 선택해주세요.');
                    $('select[name="md_bo_table"]').focus();
                    return false;
                } else if(md_type == "latest" && md_cnt < 1) {
                    alert('게시물 출력갯수를 입력해주세요.');
                    $('#md_cnt').focus();
                    return false;
                } else if(md_type == "latest" && md_col < 1 || md_type == "latest" && md_row < 1 || md_type == "latest" && md_col_mo < 1 || md_type == "latest" && md_row_mo < 1) {
                    alert('게시물 출력(열X행) 옵션을 설정해주세요.');
                    return false;
                } else if(md_type == "widget" && md_widget == "") {
                    alert('출력 위젯을 선택해주세요.');
                    $('select[name="md_widget"]').focus();
                    return false;
                } else if(md_type == "banner" && md_banner == "") {
                    alert('출력할 배너그룹을 선택해주세요.');
                    $('select[name="md_banner"]').focus();
                    return false;
                } else if(md_type == "banner" && md_banner_skin == "") {
                    alert('배너 스킨을 선택해주세요.');
                    $('select[name="md_banner_skin"]').focus();
                    return false;
                } else if(md_type == "poll" && md_poll == "") {
                    alert('투표 스킨을 선택해주세요.');
                    $('select[name="md_poll"]').focus();
                    return false;
                } else if(md_type == "item" && md_module == "") {
                    alert('상품 타입을 선택해주세요.');
                    $('#md_module_shop').focus();
                    return false;
                } else if(md_type == "item" && md_order == "") {
                    alert('상품 출력옵션을 선택해주세요.');
                    $('#md_order_shop').focus();
                    return false;
                } else if(md_type == "item" && md_cnt < 1) {
                    alert('상품 출력갯수를 입력해주세요.');
                    $('#md_cnt_shop').focus();
                    return false;
                } else if(md_type == "item" && md_col < 1 || md_type == "item" && md_row < 1 || md_type == "item" && md_col_mo < 1 || md_type == "item" && md_row_mo < 1) {
                    alert('상품 출력(열X행) 옵션을 설정해주세요.');
                    return false;
                } else if(md_type == "item" && md_skin == "") {
                    alert('출력 스킨을 선택해주세요.');
                    $('#md_skin_shop').focus();
                    return false;
                } else {
                
                    
                    <?php if($is_admin) { ?>
                    <?php } else { ?>
                    alert('편집 권한이 없습니다.');
                    return false;
                    <?php } ?>
                    
                
                    // Ajax 요청 실행
                    $.ajax({
                        url: '<?php echo G5_URL ?>/rb/rb.config/ajax.module_set.php', // Ajax 요청을 보낼 엔드포인트 URL
                        method: 'POST',
                        dataType: 'json',
                        data: {
                            <?php if(defined('_SHOP_')) { // 영카트?>
                                "is_shop":"1",
                            <?php } else { ?>
                                "is_shop":"0",
                            <?php } ?>
                            "md_id":md_id,
                            "md_title":md_title,
                            "md_layout":md_layout,
                            "md_skin":md_skin,
                            "md_type":md_type,
                            "md_bo_table":md_bo_table,
                            "md_sca":md_sca,
                            "md_widget":md_widget,
                            "md_banner":md_banner,
                            "md_banner_id":md_banner_id,
                            "md_banner_bg":md_banner_bg,
                            "md_banner_skin":md_banner_skin,
                            "md_poll":md_poll,
                            "md_poll_id":md_poll_id,
                            "md_theme":md_theme,
                            "md_layout_name":layout_name,
                            "md_cnt":md_cnt,
                            "md_col":md_col,
                            "md_row":md_row,
                            "md_col_mo":md_col_mo,
                            "md_row_mo":md_row_mo,
                            "md_width":md_width,
                            "md_height":md_height,
                            "md_subject_is":md_subject_is,
                            "md_thumb_is":md_thumb_is,
                            "md_nick_is":md_nick_is,
                            "md_date_is":md_date_is,
                            "md_comment_is":md_comment_is,
                            "md_content_is":md_content_is,
                            "md_icon_is":md_icon_is,
                            "md_ca_is":md_ca_is,
                            "md_gap":md_gap,
                            "md_gap_mo":md_gap_mo,
                            "md_swiper_is":md_swiper_is,
                            "md_auto_is":md_auto_is,
                            "md_auto_time":md_auto_time,
                            "md_module":md_module,
                            "md_order":md_order,
                            
                        },
                        success: function(data) {
                            if (data.status == 'ok') {

                                console.log('모듈저장:'+ data.md_title);
                                alert(data.md_title+' 모듈이 저장 되었습니다.');
                                location.reload();

                            } else {
                                console.log('변경실패');
                            }
                        },
                        error: function(err) {
                            alert('문제가 발생 했습니다. 다시 시도해주세요.');
                        }
                    });
                    
                }
            }
    
    
            // Ajax 실행 함수 정의 (모듈삭제)
            function executeAjax_module_del() {
                

                var md_id = $('input[name="md_id"]').val();
                var md_layout = $('input[name="md_layout"]').val();
                var md_theme = $('input[name="md_theme"]').val();
                <?php if(defined('_SHOP_')) { // 영카트?>
                    var layout_name = '<?php echo $rb_core['layout_shop'] ?>';
                <?php } else { ?>
                    var layout_name = '<?php echo $rb_core['layout'] ?>';
                <?php } ?>
                var del = 'true';

                if(md_id == "") {
                    alert('모듈 ID정보가 없습니다. 다시 시도해주세요.');
                    return false;
                } else {
                    
                    <?php if($is_admin) { ?>
                    <?php } else { ?>
                    alert('편집 권한이 없습니다.');
                    return false;
                    <?php } ?>
                
                
                    // Ajax 요청 실행
                    $.ajax({
                        url: '<?php echo G5_URL ?>/rb/rb.config/ajax.module_set.php', // Ajax 요청을 보낼 엔드포인트 URL
                        method: 'POST',
                        dataType: 'json',
                        data: {
                            "md_id":md_id,
                            "md_layout":md_layout,
                            "md_theme":md_theme,
                            "md_layout_name":layout_name,
                            "del":del,
                            <?php if(defined('_SHOP_')) { // 영카트?>
                                "is_shop":"1",
                            <?php } else { ?>
                                "is_shop":"0",
                            <?php } ?>
                        },
                        success: function(data) {
                            if (data.status == 'ok') {
                                location.reload();
                            } else {
                                console.log('변경실패');
                            }
                        },
                        error: function(err) {
                            alert('문제가 발생 했습니다. 다시 시도해주세요.');
                        }
                    });
                    
                }
            }

</script>

