<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$member_skin_url.'/style.css">', 0);
?>

<div id="mb_join" class="mbskin">
    <script src="<?php echo G5_JS_URL ?>/jquery.register_form.js"></script>
    <?php if($config['cf_cert_use'] && ($config['cf_cert_ipin'] || $config['cf_cert_hp'])) { ?>
    <script src="<?php echo G5_JS_URL ?>/certify.js"></script>
    <?php } ?>

    <form name="fregisterform" id="fregisterform" action="<?php echo $register_action_url ?>" onsubmit="return fregisterform_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off">
    <input type="hidden" name="w" value="<?php echo $w ?>">
    <input type="hidden" name="url" value="<?php echo $urlencode ?>">
    <input type="hidden" name="agree" value="<?php echo $agree ?>">
    <input type="hidden" name="agree2" value="<?php echo $agree2 ?>">
    <input type="hidden" name="cert_type" value="<?php echo $member['mb_certify']; ?>">
    <input type="hidden" name="cert_no" value="">
    <?php if (isset($member['mb_sex'])) { ?><input type="hidden" name="mb_sex" value="<?php echo $member['mb_sex'] ?>"><?php } ?>
    <?php if (isset($member['mb_nick_date']) && $member['mb_nick_date'] > date("Y-m-d", G5_SERVER_TIME - ($config['cf_nick_modify'] * 86400))) { // 닉네임수정일이 지나지 않았다면 ?>
    <input type="hidden" name="mb_nick_default" value="<?php echo $member['mb_nick'] ?>">
    <input type="hidden" name="mb_nick" value="<?php echo $member['mb_nick'] ?>">
    <?php } ?>

	<div class="writebox">

		<h2 class="writebox_title">사이트 이용정보 입력</h2>
	
		<div class="inputbox">
			
			<fieldset>
			<legend>사이트 이용정보 입력</legend>

			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_id">아이디 필수</label></strong>
				<input type="text" name="mb_id" value="<?php echo $member['mb_id'] ?>" id="reg_mb_id" placeholder="아이디" class="frm_input minlength=3 <?php echo $required ?> <?php echo $readonly ?>" maxlength="20" <?php echo $required ?> <?php echo $readonly ?>>
				<div class="frm_info" style="padding-bottom:4px;" id="msg_mb_id">영문자, 숫자, _ 만 입력 가능. 최소 3자이상 입력하세요.</div>
			</p>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_password">비밀번호 필수</label></strong>
				<input type="password" name="mb_password" id="reg_mb_password" placeholder="비밀번호" class="frm_input minlength=3 <?php echo $required ?>" maxlength="20" <?php echo $required ?>>
			</p>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_password_re">비밀번호 확인 필수</label></strong>
				<input type="password" name="mb_password_re" id="reg_mb_password_re" placeholder="비밀번호 확인" class="frm_input minlength=3 <?php echo $required ?>" maxlength="20" <?php echo $required ?>>
			</p>
			
			</fieldset>

		</div>

	</div>

	<div class="gheight"></div>

	<div class="writebox">

		<h2 class="writebox_title">개인정보 입력</h2>
	
		<div class="inputbox">
			
			<fieldset>
			<legend>개인정보 입력</legend>

			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_name">이름 필수</label></strong>
				<input type="text" id="reg_mb_name" name="mb_name" value="<?php echo $member['mb_name'] ?>" <?php echo $required ?> <?php if ($w=='u') echo 'readonly'; ?> placeholder="이름" class="frm_input nospace <?php echo $required ?> <?php echo $readonly ?>">
				<?php if ($config['cf_cert_use']) { ?>
                <div class="frm_info" style="padding-bottom:4px;">아이핀 본인확인 후에는 이름이 자동 입력되고 휴대폰 본인확인 후에는 이름과 휴대폰번호가 자동 입력되어 수동으로 입력할수 없게 됩니다.</div>
				<?php } ?>

				<?php
                if($config['cf_cert_use']) {
				echo '<div style="padding-top:0px;padding-bottom:6px;">'.PHP_EOL;
                    if($config['cf_cert_ipin'])
                        echo '<button type="button" id="win_ipin_cert" class="btn_frmline">아이핀 본인확인</button>'.PHP_EOL;
                    if($config['cf_cert_hp'] && $config['cf_cert_hp'] != 'lg')
                        echo '<button type="button" id="win_hp_cert" class="btn_frmline">휴대폰 본인확인</button>'.PHP_EOL;

                    echo '<noscript>본인확인을 위해서는 자바스크립트 사용이 가능해야합니다.</noscript>'.PHP_EOL;
				echo '</div>'.PHP_EOL;
                }
                ?>
                <?php
                if ($config['cf_cert_use'] && $member['mb_certify']) {
                    if($member['mb_certify'] == 'ipin')
                        $mb_cert = '아이핀';
                    else
                        $mb_cert = '휴대폰';
                ?>
                <div id="msg_certify">
                    <strong><?php echo $mb_cert; ?> 본인확인</strong><?php if ($member['mb_adult']) { ?> 및 <strong>성인인증</strong><?php } ?> 완료
                </div>
                <?php } ?>
				
			</p>
			<?php if ($req_nick) { ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_nick">닉네임 필수</label></strong>
				<input type="hidden" name="mb_nick_default" value="<?php echo isset($member['mb_nick'])?$member['mb_nick']:''; ?>">
                <input type="text" name="mb_nick" value="<?php echo isset($member['mb_nick'])?$member['mb_nick']:''; ?>" id="reg_mb_nick" placeholder="닉네임" required class="frm_input required nospace" maxlength="20">
                <div id="msg_mb_nick"></div>
				<div class="frm_info" style="padding-bottom:4px;">
					공백없이 한글,영문,숫자만 입력 가능 (한글2자, 영문4자 이상)<br>
                    닉네임을 바꾸시면 앞으로 <?php echo (int)$config['cf_nick_modify'] ?>일 이내에는 변경 할 수 없습니다.
				</div>
			</p>
			<?php } ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_email">E-mail 필수</label></strong>
				<input type="hidden" name="old_email" value="<?php echo $member['mb_email'] ?>">
                <input type="email" name="mb_email" value="<?php echo isset($member['mb_email'])?$member['mb_email']:''; ?>" id="reg_mb_email" placeholder="E-mail" required class="frm_input email required" size="50" maxlength="100">
				<?php if ($config['cf_use_email_certify']) {  ?>
                <div class="frm_info" style="padding-bottom:4px;">
                    <?php if ($w=='') { echo "E-mail 로 발송된 내용을 확인한 후 인증하셔야 회원가입이 완료됩니다."; }  ?>
                    <?php if ($w=='u') { echo "E-mail 주소를 변경하시면 다시 인증하셔야 합니다."; }  ?>
                </div>
                <?php }  ?>
			</p>

			<?php if ($config['cf_use_homepage']) { ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_homepage">홈페이지 <?php if ($config['cf_req_homepage']){ ?><strong class="sound_only">필수</strong><?php } ?></label></strong>
				<input type="url" name="mb_homepage" value="<?php echo $member['mb_homepage'] ?>" id="reg_mb_homepage" placeholder="홈페이지" class="frm_input <?php echo $config['cf_req_homepage']?"required":""; ?>" maxlength="255" <?php echo $config['cf_req_homepage']?"required":""; ?>>
			</p>
			<?php } ?>

			<?php if ($config['cf_use_tel']) { ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_tel">전화번호 <?php if ($config['cf_req_tel']) { ?><strong class="sound_only">필수</strong><?php } ?></label></strong>
				<input type="number" name="mb_tel" value="<?php echo $member['mb_tel'] ?>" id="reg_mb_tel" placeholder="전화번호" class="frm_input <?php echo $config['cf_req_tel']?"required":""; ?>" maxlength="20" <?php echo $config['cf_req_tel']?"required":""; ?>>
			</p>
			<?php } ?>

			<?php if ($config['cf_use_hp']) {  ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_hp">휴대폰번호 <?php if ($config['cf_req_hp']) { ?><strong class="sound_only">필수</strong><?php } ?></label></strong>
				<input type="text" name="mb_hp" value="<?php echo $member['mb_hp'] ?>" id="reg_mb_hp" <?php echo ($config['cf_req_hp'])?"required":""; ?> placeholder="휴대폰번호" class="frm_input <?php echo ($config['cf_req_hp'])?"required":""; ?>" maxlength="20">
				<?php if ($config['cf_cert_use'] && $config['cf_cert_hp']) { ?>
				<input type="hidden" name="old_mb_hp" value="<?php echo $member['mb_hp'] ?>">
				<?php } ?>
			</p>
			<?php } ?>

			<?php if ($config['cf_use_addr']) { ?>
			<p>
				<strong class="sound_only"><label for="reg_mb_zip1">우편번호 <?php if ($config['cf_req_addr']) { ?><strong class="sound_only">필수</strong><?php } ?></label></strong>
				<div class="inputnt" style="float:left;width:50px;">	
					<input type="number" name="mb_zip1" value="<?php echo $member['mb_zip1'] ?>" id="reg_mb_zip1" <?php echo $config['cf_req_addr']?"required":""; ?> placeholder="우편번호 앞자리" class="frm_input <?php echo $config['cf_req_addr']?"required":""; ?>" size="3" maxlength="3">
				</div>
				<div style="float:left;width:10px;height:30px;line-height:30px;text-align:center;">-</div>
				<div class="inputnt" style="float:left;width:50px;">	
					<input type="number" name="mb_zip2" value="<?php echo $member['mb_zip2'] ?>" id="reg_mb_zip2" <?php echo $config['cf_req_addr']?"required":""; ?> placeholder="우편번호 뒷자리" class="frm_input <?php echo $config['cf_req_addr']?"required":""; ?>" size="3" maxlength="3">
				</div>
				<div style="float:left;width:5px;height:30px;line-height:30px;text-align:center;"></div>
				<div style="float:left;width:80px;">	
					<a href="javascript:showDaumPostcode();" id="reg_zip_find" class="btn_frmline ly_zip_find">주소 검색</a><br>
				</div>
			</p>
			<div style="clear:both;"></div>

			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_addr1">주소 <?php if ($config['cf_req_addr']) { ?><strong class="sound_only">필수</strong><?php } ?></label></strong>	
				<input type="text" name="mb_addr1" value="<?php echo $member['mb_addr1'] ?>" id="reg_mb_addr1" placeholder="주소" <?php echo $config['cf_req_addr']?"required":""; ?> class="frm_input <?php echo $config['cf_req_addr']?"required":""; ?>" size="50">
			</p>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_addr2">상세주소 <?php if ($config['cf_req_addr']) { ?><strong class="sound_only">필수</strong><?php } ?></label></strong>	
				<input type="text" name="mb_addr2" value="<?php echo $member['mb_addr2'] ?>" id="reg_mb_addr2" placeholder="상세주소" class="frm_input" size="50"><br>
			</p>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_addr3">참고항목</label></strong>	
				<input type="text" name="mb_addr3" value="<?php echo $member['mb_addr3'] ?>" id="reg_mb_addr3" placeholder="참고항목" readonly="readonly" class="frm_input" size="50">
				<input type="hidden" name="mb_addr_jibeon" value="<?php echo $member['mb_addr_jibeon']; ?>">
				<div id="mb_addr_jibeon"><?php echo ($member['mb_addr_jibeon'] ? '지번주소 : '.$member['mb_addr_jibeon'] : ''); ?></div>
			</p>
			<?php } ?>
			
			</fieldset>

		</div>

	</div>

	<div class="gheight"></div>

	<div class="writebox">

		<h2 class="writebox_title">기타 개인설정</h2>
	
		<div class="inputbox">
			
			<fieldset>
			<legend>기타 개인설정</legend>

			<?php if ($config['cf_use_signature']) { ?>
			<p class="inputarea">
				<strong class="sound_only"><label for="reg_mb_signature">서명 <?php if ($config['cf_req_signature']){ ?><strong class="sound_only">필수</strong><?php } ?></label></strong>	
				<textarea name="mb_signature" id="reg_mb_signature" placeholder="서명" class="<?php echo $config['cf_req_signature']?"required":""; ?>" <?php echo $config['cf_req_signature']?"required":""; ?> style="height:100px;"><?php echo $member['mb_signature'] ?></textarea>
			</p>
			<?php } ?>

			<?php if ($config['cf_use_profile']) { ?>
			<p class="inputarea">
				<strong class="sound_only"><label for="reg_mb_profile">자기소개</label></strong>	
				<textarea name="mb_profile" id="reg_mb_profile" placeholder="자기소개" class="<?php echo $config['cf_req_profile']?"required":""; ?>" <?php echo $config['cf_req_profile']?"required":""; ?> style="height:100px;"><?php echo $member['mb_profile'] ?></textarea>
			</tr>
			<?php } ?>

			<?php if ($config['cf_use_member_icon'] && $member['mb_level'] >= $config['cf_icon_level']) { ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_icon">회원아이콘</label></strong>	
				<input type="file" name="mb_icon" id="reg_mb_icon" class="frm_input">
				<?php if ($w == 'u' && file_exists($mb_icon)) { ?>
					<img src="<?php echo $mb_icon_url ?>" alt="회원아이콘">
					<input type="checkbox" name="del_mb_icon" value="1" id="del_mb_icon">
					<label for="del_mb_icon">삭제</label>
				<?php } ?>
				<div class="frm_info" style="padding-bottom:4px;">
					이미지 크기는 가로 <?php echo $config['cf_member_icon_width'] ?>픽셀, 세로 <?php echo $config['cf_member_icon_height'] ?>픽셀 이하로 해주세요.<br>
					gif만 가능하며 용량 <?php echo number_format($config['cf_member_icon_size']) ?>바이트 이하만 등록됩니다.
				</div>
			</p>
			<?php } ?>
			
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_mailling">메일링서비스</label></strong>	
				<input type="checkbox" class="wzcheckbox" name="mb_mailling" value="1" id="reg_mb_mailling" <?php echo ($w=='' || $member['mb_mailling'])?'checked':''; ?>>
				정보 메일을 받겠습니다.
			</p>

			<?php if ($config['cf_use_hp']) { ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_sms">메일링서비스</label></strong>
				<input type="checkbox" class="wzcheckbox" name="mb_sms" value="1" id="reg_mb_sms" <?php echo ($w=='' || $member['mb_sms'])?'checked':''; ?>>
				휴대폰 문자메세지를 받겠습니다.
			</p>
			<?php } ?>

			<?php if (isset($member['mb_open_date']) && $member['mb_open_date'] <= date("Y-m-d", G5_SERVER_TIME - ($config['cf_open_modify'] * 86400)) || empty($member['mb_open_date'])) { // 정보공개 수정일이 지났다면 수정가능 ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_open">메일링서비스</label></strong>
				<input type="hidden" name="mb_open_default" value="<?php echo $member['mb_open'] ?>">
				<input type="checkbox" class="wzcheckbox" name="mb_open" value="1" id="reg_mb_open" <?php echo ($w=='' || $member['mb_open'])?'checked':''; ?>>
				다른분들이 나의 정보를 볼 수 있도록 합니다.
				<div class="frm_info" style="padding-bottom:4px;">정보공개를 바꾸시면 앞으로 <?php echo (int)$config['cf_open_modify'] ?>일 이내에는 변경이 안됩니다.</div>
			</p>
			<?php } else { ?>
			<p>
				<strong class="sound_only"><label>정보공개</label></strong>
				정보공개는 수정후 <?php echo (int)$config['cf_open_modify'] ?>일 이내, <?php echo date("Y년 m월 j일", isset($member['mb_open_date']) ? strtotime("{$member['mb_open_date']} 00:00:00")+$config['cf_open_modify']*86400:G5_SERVER_TIME+$config['cf_open_modify']*86400); ?> 까지는 변경이 안됩니다.<br>
				이렇게 하는 이유는 잦은 정보공개 수정으로 인하여 쪽지를 보낸 후 받지 않는 경우를 막기 위해서 입니다.
				<input type="hidden" name="mb_open" value="<?php echo $member['mb_open'] ?>">
			</p>
			<?php } ?>

			<?php if ($w == "" && $config['cf_use_recommend']) { ?>
			<p class="inputnt">
				<strong class="sound_only"><label for="reg_mb_recommend">추천인아이디</label></strong>
				<input type="text" name="mb_recommend" id="reg_mb_recommend" placeholder="추천인아이디" class="frm_input">
			</p>
			<?php } ?>

			<?php echo captcha_html(); ?>
			
			</fieldset>

		</div>

	</div>

	<div class="gheight"></div>

	<div class="btn_confirm">
		<div class="wz_btn_wide">
			<div class="wz_btn_wide_box" style="width:50%;"><button type="submit" id="btn_submit" accesskey="s"><span><strong><?php echo $w==''?'회원가입':'정보수정'; ?></strong></span></button></div>
			<div class="wz_btn_wide_box" style="width:50%;"><button type="button" onclick="location.href='<?php echo G5_URL; ?>/'"><span><strong>취소</strong></span></button></div>
		</div>
    </div>

    </form>

	<div class="gheight"></div>

    <script>
    $(function() {
        $("#reg_zip_find").css("display", "inline-block");
        $("#reg_mb_zip1, #reg_mb_zip2, #reg_mb_addr1").attr("readonly", true);

        <?php if($config['cf_cert_use'] && $config['cf_cert_ipin']) { ?>
        // 아이핀인증
        $("#win_ipin_cert").click(function() {
            if(!cert_confirm())
                return false;

            var url = "<?php echo G5_OKNAME_URL; ?>/ipin1.php";
            certify_win_open('kcb-ipin', url);
            return;
        });

        <?php } ?>
        <?php if($config['cf_cert_use'] && $config['cf_cert_hp']) { ?>
        // 휴대폰인증
        $("#win_hp_cert").click(function() {
            if(!cert_confirm())
                return false;

            <?php
            switch($config['cf_cert_hp']) {
                case 'kcb':
                    $cert_url = G5_OKNAME_URL.'/hpcert1.php';
                    $cert_type = 'kcb-hp';
                    break;
                case 'kcp':
                    $cert_url = G5_KCPCERT_URL.'/kcpcert_form.php';
                    $cert_type = 'kcp-hp';
                    break;
                default:
                    echo 'alert("기본환경설정에서 휴대폰 본인확인 설정을 해주십시오");';
                    echo 'return false;';
                    break;
            }
            ?>

            certify_win_open("<?php echo $cert_type; ?>", "<?php echo $cert_url; ?>");
            return;
        });
        <?php } ?>
    });

    // 인증체크
    function cert_confirm()
    {
        var val = document.fregisterform.cert_type.value;
        var type;

        switch(val) {
            case "ipin":
                type = "아이핀";
                break;
            case "hp":
                type = "휴대폰";
                break;
            default:
                return true;
        }

        if(confirm("이미 "+type+"으로 본인확인을 완료하셨습니다.\n\n이전 인증을 취소하고 다시 인증하시겠습니까?"))
            return true;
        else
            return false;
    }

    // submit 최종 폼체크
    function fregisterform_submit(f)
    {
        // 회원아이디 검사
        if (f.w.value == "") {
            var msg = reg_mb_id_check();
            if (msg) {
                alert(msg);
                f.mb_id.select();
                return false;
            }
        }

        if (f.w.value == '') {
            if (f.mb_password.value.length < 3) {
                alert('비밀번호를 3글자 이상 입력하십시오.');
                f.mb_password.focus();
                return false;
            }
        }

        if (f.mb_password.value != f.mb_password_re.value) {
            alert('비밀번호가 같지 않습니다.');
            f.mb_password_re.focus();
            return false;
        }

        if (f.mb_password.value.length > 0) {
            if (f.mb_password_re.value.length < 3) {
                alert('비밀번호를 3글자 이상 입력하십시오.');
                f.mb_password_re.focus();
                return false;
            }
        }

        // 이름 검사
        if (f.w.value=='') {
            if (f.mb_name.value.length < 1) {
                alert('이름을 입력하십시오.');
                f.mb_name.focus();
                return false;
            }
        }

        <?php if($w == '' && $config['cf_cert_use'] && $config['cf_cert_req']) { ?>
        // 본인확인 체크
        if(f.cert_no.value=="") {
            alert("회원가입을 위해서는 본인확인을 해주셔야 합니다.");
            return false;
        }
        <?php } ?>

        // 닉네임 검사
        if ((f.w.value == "") || (f.w.value == "u" && f.mb_nick.defaultValue != f.mb_nick.value)) {
            var msg = reg_mb_nick_check();
            if (msg) {
                alert(msg);
                f.reg_mb_nick.select();
                return false;
            }
        }

        // E-mail 검사
        if ((f.w.value == "") || (f.w.value == "u" && f.mb_email.defaultValue != f.mb_email.value)) {
            var msg = reg_mb_email_check();
            if (msg) {
                alert(msg);
                f.reg_mb_email.select();
                return false;
            }
        }

		<?php if (($config['cf_use_hp'] || $config['cf_cert_hp']) && $config['cf_req_hp']) {  ?>
        // 휴대폰번호 체크
        var msg = reg_mb_hp_check();
        if (msg) {
            alert(msg);
            f.reg_mb_hp.select();
            return false;
        }
        <?php } ?>

        if (typeof f.mb_icon != 'undefined') {
            if (f.mb_icon.value) {
                if (!f.mb_icon.value.toLowerCase().match(/.(gif)$/i)) {
                    alert('회원아이콘이 gif 파일이 아닙니다.');
                    f.mb_icon.focus();
                    return false;
                }
            }
        }

        if (typeof(f.mb_recommend) != 'undefined' && f.mb_recommend.value) {
            if (f.mb_id.value == f.mb_recommend.value) {
                alert('본인을 추천할 수 없습니다.');
                f.mb_recommend.focus();
                return false;
            }

            var msg = reg_mb_recommend_check();
            if (msg) {
                alert(msg);
                f.mb_recommend.select();
                return false;
            }
        }

        <?php echo chk_captcha_js(); ?>

        document.getElementById("btn_submit").disabled = "disabled";

        return true;
    }
    </script>
    
    <div id="ly_searchzip" class="popup_bx" style="width:300px;margin-left:-150px;left:50%;height:460px;">
        <div class="header_popup">
            <h1>주소조회</h1>
        </div>
        <div id="searchzip_frm" class="content_popup" style="padding:0;margin:0;">

        </div>
        <button type="button" class="btn close_popup" onclick="closeDaumPostcode();"></button>
    </div>

    <script src="http://dmaps.daum.net/map_js_init/postcode.js"></script>
    <script>
        // 우편번호 찾기 iframe을 넣을 element
        var element = document.getElementById('searchzip_frm');

        function closeDaumPostcode() {
            // iframe을 넣은 element를 안보이게 한다.
            //element.style.display = 'none';
            $(".dimm").hide();
			$(".popup_bx").hide();
        }

        function showDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    // 검색결과 항목을 클릭했을때 실행할 코드를 작성하는 부분.
                    // 우편번호와 주소 및 영문주소 정보를 해당 필드에 넣는다.
                    document.getElementById('reg_mb_zip1').value = data.postcode1;
                    document.getElementById('reg_mb_zip2').value = data.postcode2;
                    document.getElementById('reg_mb_addr1').value = data.address;
                    document.getElementById('reg_mb_addr2').focus();
                    document.getElementById('reg_mb_addr3').value = data.addressEnglish;
                    // iframe을 넣은 element를 안보이게 한다.
                    //element.style.display = 'none';
                    $(".dimm").hide();
        			$(".popup_bx").hide();
                },
                width : '100%',
                height : '100%'
            }).embed(element);

            // iframe을 넣은 element를 보이게 한다.
            //element.style.display = 'block';
            $('.popup_bx').hide();
            $('.dimm').width($(document).width()).height($(document).height()).show();
			var headerHeight = $("#mhd").height(); // 헤더의 height
			var top = $(window).scrollTop() - headerHeight;
			$("#ly_searchzip").css({"top": top}).fadeIn();

        }
        
        jQuery(document).ready(function () {
            $('.dimm').click(function()
            {
                $(".dimm").hide(); 
                $(".popup_bx").hide();
            });
		});

    </script>

</div>