<?php
include_once('./_common.php');
include_once(G5_PATH.'/head.sub.php');

if($act == 'ok') {

	check_admin_token();

	//자료가 많을 경우 대비 설정변경
	@ini_set('memory_limit', '-1');

	//새글DB 날짜설정
	$new_date = 0;
	if(isset($config['cf_new_del']) && $config['cf_new_del'] > 0) {
		$new_date = G5_SERVER_TIME - $config['cf_new_del'] * 86400;
	}

	//한 번에 100개씩 처리
	$rows = 100;

	//게시물 업데이트
	$result1 = sql_query(" select bo_table, as_new from {$g5['board_table']} ", false);
	while($row1=sql_fetch_array($result1)) {

		$bo_table = $row1['bo_table'];

		if(!$bo_table) continue;

		// 새글등록이 아니면 새글 DB에서 지우기
		if($row1['as_new']) {
			sql_query(" delete from {$g5['board_new_table']} where bo_table = '{$bo_table}' ", false);			
			continue;
		}

		$tmp_write_table = $g5['write_prefix'] . $bo_table;

		//게시물 페이지 계산
		$total = sql_fetch("select count(*) as cnt from {$tmp_write_table} ", false);
		$total_count = $total['cnt'];
		$total_page  = ceil($total_count / $rows);

		for($i=1; $i <= $total_page; $i++) {

			//시작 열을 구함
			$start_rows = ($i - 1) * $rows; 

			//글 업데이트
			$result = sql_query(" select * from {$tmp_write_table} limit $start_rows, $rows ", false);
			while($row=sql_fetch_array($result)) {
				
				// 새글 업데이트 체크
				$is_new = (strtotime($row['wr_datetime']) < $new_date) ? false : true;

				// 비밀글 체크
				$as_secret = (strstr($row['wr_option'], 'secret')) ? 1 : 0;

				if($row['wr_is_comment']) { //댓글 

					if($is_new) { //새글DB 댓글
						$sql = " update {$g5['board_new_table']} 
									set as_lucky = '{$row['as_lucky']}',
										as_secret = '{$as_secret}',
										as_re_mb = '{$row['as_re_mb']}'
									where bo_table = '{$bo_table}' and wr_id = '{$row['wr_id']}' ";
						sql_query($sql, false);
					}

				} else { //글

					//첨부파일이 있으면
					$fa = sql_fetch(" select sum(bf_download) as download from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$row['wr_id']}' ", false);
					$as_download = $fa['download'];

					//글타입 체크
					$row['chk_img'] = true;
					$p_image = true;
					$p_thumb = apms_wr_thumbnail($bo_table, $row, 0, 0);
					if($p_thumb) {
						$p_thumb = addslashes($p_thumb);
					} else {
						$p_image = false;	
						$p_thumb = 1;
					}

					//동영상글 체크 - 링크 URL만 체크
					$p_video = false;
					if($row['wr_link1']) { // Link1
						$p_video = (apms_video($row['wr_link1'])) ? true : false;
					}

					if($row['wr_link2'] && !$p_video) { // Link2
						$p_video = (apms_video($row['wr_link2'])) ? true : false;
					}

					// 글타입정리
					if($p_image && $p_video) { //이미지도 있고, 비디오도 있으면
						$as_list = 3;
					} else if(!$p_image && $p_video) { //이미지 없고, 비디오 있으면
						$as_list = 2;
					} else if($p_image && !$p_video) { //이미지 있고, 비디오 없으면
						$as_list = 1;
					} else { // 모두 없으면
						$as_list = 0;
					}

					// 글업데이트
					sql_query(" update {$tmp_write_table} set as_download = '{$as_download}', as_list = '{$as_list}', as_thumb = '{$p_thumb}' where wr_id = '{$row['wr_id']}' ", false);
					
					// 새글 업데이트
					if($is_new) {
						// 링크수
						$as_link = $row['wr_link1_hit'] + $row['wr_link2_hit'];

						// 이벤트
						$ea = sql_fetch(" select count(*) as event from {$g5['apms_event']} where bo_table = '{$bo_table}' and wr_id = '{$row['wr_id']}' ", false);
						$sql = " update {$g5['board_new_table']} 
									set as_comment = '{$row['wr_comment']}',
										as_hit = '{$row['wr_hit']}',
										as_good = '{$row['wr_good']}',
										as_nogood = '{$row['wr_nogood']}',
										as_link = '{$as_link}',
										as_poll = '{$row['as_poll']}',
										as_download = '{$as_download}',
										as_event = '{$ea['event']}',
										as_secret = '{$as_secret}',
										as_type = '{$row['as_type']}',
										as_list = '{$as_list}',
										as_publish = '{$row['as_publish']}',
										as_extra = '{$row['as_extra']}',
										as_reply = '{$row['wr_reply']}',
										as_re_mb = '{$row['as_re_mb']}',
										as_update = '{$row['as_update']}'
									where bo_table = '{$bo_table}' and wr_id = '{$row['wr_id']}' ";
						sql_query($sql, false);
					}
				}
			}
			sql_free_result($result);
		}
	}

?>	
    <script type='text/javascript'> 
		alert('게시물 업데이트를 완료했습니다.'); 
		self.close();
	</script>
<?php } else { ?>
	<script src="<?php echo G5_ADMIN_URL ?>/admin.js"></script>
	<form id="defaultform" name="defaultform" method="post" onsubmit="return update_submit(this);">
	<input type="hidden" name="act" value="ok">
	<div style="padding:10px">
		<div style="border:1px solid #ddd; background:#f5f5f5; color:#000; padding:10px; line-height:20px;">
			<b><i class="fa fa-bolt"></i> 게시물 업데이트</b>
		</div>
		<div style="border:1px solid #ddd; border-top:0px; padding:10px;line-height:22px;">
			<ul>
				<li><b class="red">[주의] 반드시 DB 백업을 먼저 하신 이후 실행해 주시기 바랍니다.</b></li>
				<li>회원레벨, 글타입 등 게시물에 필요한 추가정보를 업데이트합니다.</li>
				<li>전체 게시물 및 새글DB 자료에 자동으로 반영되므로 시간이 걸릴 수 있습니다.</li>
			</ul>
		</div>
		<br>
		<div class="btn_confirm01 btn_confirm">
			<input type="submit" value="실행하기" class="btn_submit" accesskey="s">
		</div>
	</div>
	</form>
	<script>
		function update_submit(f) {
			if(!confirm("실행후 완료메시지가 나올 때까지 기다려 주세요.\n\n정말 실행하시겠습니까?")) {
				return false;	
			} 

			return true;
		}
	</script>
<?php } ?>
<?php include_once(G5_PATH.'/tail.sub.php'); ?>