<?php
if (!defined('_GNUBOARD_')) exit;

function get_login_oauth($type, $img='') {

	if(!$type) return;
	
	if(!defined('G5_LOGIN_OAUTH')) {
		define('G5_LOGIN_OAUTH', true);
		echo '<script>'.PHP_EOL;
		echo 'function login_oauth(type,ww,wh) {'.PHP_EOL;
		echo 'var url = "'.G5_PLUGIN_URL.'/login-oauth/login_with_" + type + ".php";'.PHP_EOL;
		echo 'var opt = "width=" + ww + ",height=" + wh + ",left=0,top=0,scrollbars=1,toolbars=no,resizable=yes";'.PHP_EOL;
		echo 'popup_window(url,type,opt);'.PHP_EOL;
		echo '}'.PHP_EOL;
		echo '</script>'.PHP_EOL;
	}

	// Size
	switch($type) {
		case 'facebook'	: $ww = 1024; $wh = 640; break;
		case 'twitter'	: $ww = 600; $wh = 600; break;
		case 'google'	: $ww = 460; $wh = 640; break;
		case 'naver'	: $ww = 460; $wh = 517; break;
		case 'kakao'	: $ww = 480; $wh = 680;	break;
		default			: $ww = 600; $wh = 600; break;
	}

	$str = "login_oauth('".$type."','".$ww."','".$wh."');";
	if($img) {
		if ($img == 'none') { // Link
		    return $str; 
		} else {
			$str = '<a href="javascript:'.$str.'"><img src="'.$img.'"></a>';
		}
	} else {
		$img = G5_PLUGIN_URL.'/login-oauth/img/'.$type.'.png';
			$str = '<a href="javascript:'.$str.'"><img src="'.$img.'"></a>';
	}

    return $str;
}

?>