## ̿ť dump 9.11
##
## Host: localhost    Database: gblog
## ######################################################
## Server version	4.0.27-log

##
## Table structure for table `$gb4[blog_table]`
##

DROP TABLE IF EXISTS $gb4[blog_table];
CREATE TABLE $gb4[blog_table] (
  id int(11) NOT NULL auto_increment,
  mb_id varchar(20) NOT NULL default '',
  writer varchar(30) NOT NULL default '',
  regdate datetime NOT NULL default '0000-00-00 00:00:00',
  last_update datetime NOT NULL default '0000-00-00 00:00:00',
  total_file_size int(10) unsigned NOT NULL default '0',
  page_count int(11) NOT NULL default '5',
  list_count int(11) NOT NULL default '10',
  post_count int(11) NOT NULL default '0',
  secret_count int(11) NOT NULL default '0',
  comment_count int(11) NOT NULL default '0',
  trackback_count int(11) NOT NULL default '0',
  blog_name varchar(255) NOT NULL default '',
  blog_about varchar(255) NOT NULL default '',
  rss_open tinyint(4) NOT NULL default '0',
  rss_count int(11) NOT NULL default '0',
  use_table varchar(255) NOT NULL default '',
  use_comment tinyint(4) NOT NULL default '0',
  use_trackback tinyint(4) NOT NULL default '0',
  use_random tinyint(4) NOT NULL default '0',
  editor_mode tinyint(4) NOT NULL default '0',
  visit_today int(11) NOT NULL default '0',
  visit_yesterday int(11) NOT NULL default '0',
  visit_total int(11) NOT NULL default '0',
  visit_max int(11) NOT NULL default '0',
  blog_head text NOT NULL,
  blog_tail text NOT NULL,
  content_head text NOT NULL,
  content_tail text NOT NULL,
  skin_id int(11) NOT NULL default '0',
  blog_align varchar(10) NOT NULL default 'center',
  image_width int(11) NOT NULL default '500',
  blog_width tinyint(4) NOT NULL default '0',
  top_menu_color varchar(10) NOT NULL default '#5A5A5A',
  background_repeat varchar(30) NOT NULL default 'repeat',
  sidebar_post_num int(11) NOT NULL default '5',
  sidebar_comment_num int(11) NOT NULL default '5',
  sidebar_trackback_num int(11) NOT NULL default '5',
  sidebar_post_length int(11) NOT NULL default '20',
  sidebar_comment_length int(11) NOT NULL default '25',
  sidebar_trackback_length int(11) NOT NULL default '25',
  sidebar_tag_print int(11) NOT NULL default '1',
  sidebar_tag_length int(11) NOT NULL default '10',
  sidebar_tag_gap int(11) NOT NULL default '0',
  sidebar_user1_title varchar(255) NOT NULL default ' ̵1 ',
  sidebar_user2_title varchar(255) NOT NULL default ' ̵2 ',
  sidebar_user3_title varchar(255) NOT NULL default ' ̵3 ',
  sidebar_user4_title varchar(255) NOT NULL default ' ̵4 ',
  sidebar_user5_title varchar(255) NOT NULL default ' ̵5 ',
  sidebar_user1_content text NOT NULL,
  sidebar_user2_content text NOT NULL,
  sidebar_user3_content text NOT NULL,
  sidebar_user4_content text NOT NULL,
  sidebar_user5_content text NOT NULL,
  sidebar_left varchar(255) NOT NULL default '',
  sidebar_right varchar(255) NOT NULL default '',
  sidebar_garbage varchar(255) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY mb_id (mb_id),
  KEY last_update (last_update)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[category_table]`
##

DROP TABLE IF EXISTS $gb4[category_table];
CREATE TABLE $gb4[category_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  category_name varchar(255) NOT NULL default '',
  post_count int(11) NOT NULL default '0',
  secret_count int(11) NOT NULL default '0',
  rank tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY blog_id (blog_id,rank)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[comment_table]`
##

DROP TABLE IF EXISTS $gb4[comment_table];
CREATE TABLE $gb4[comment_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  post_id int(11) NOT NULL default '0',
  comment_num int(11) NOT NULL default '0',
  comment_re_num int(11) NOT NULL default '0',
  mb_id varchar(30) NOT NULL default '',
  secret tinyint(4) NOT NULL default '0',
  writer_name varchar(30) NOT NULL default '',
  writer_pw varchar(255) NOT NULL default '',
  writer_email varchar(255) NOT NULL default '',
  writer_url varchar(255) NOT NULL default '',
  writer_content text NOT NULL,
  writer_ip varchar(15) NOT NULL default '',
  regdate datetime NOT NULL default '0000-00-00 00:00:00',
  moddate datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id),
  KEY post_id (post_id,comment_num,comment_re_num)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[file_table]`
##

DROP TABLE IF EXISTS $gb4[file_table];
CREATE TABLE $gb4[file_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  post_id int(11) NOT NULL default '0',
  file_num int(11) NOT NULL default '0',
  file_size int(11) NOT NULL default '0',
  save_name varchar(255) NOT NULL default '',
  real_name varchar(255) NOT NULL default '',
  download_count int(11) NOT NULL default '0',
  file_datetime datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id),
  KEY post_id (post_id,file_num)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[link_table]`
##

DROP TABLE IF EXISTS $gb4[link_table];
CREATE TABLE $gb4[link_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  category_id int(11) NOT NULL default '0',
  site_name varchar(255) NOT NULL default '',
  site_url varchar(255) NOT NULL default '',
  rank tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY blog_id (blog_id,category_id,rank)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[link_category_table]`
##

DROP TABLE IF EXISTS $gb4[link_category_table];
CREATE TABLE $gb4[link_category_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  category_name varchar(255) NOT NULL default '',
  category_count int(11) NOT NULL default '0',
  rank tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY blog_id (blog_id,rank)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[monthly_table]`
##

DROP TABLE IF EXISTS $gb4[monthly_table];
CREATE TABLE $gb4[monthly_table] (
  blog_id int(11) NOT NULL default '0',
  monthly char(7) NOT NULL default '',
  post_count int(11) NOT NULL default '0',
  secret_count int(11) NOT NULL default '0',
  PRIMARY KEY  (blog_id,monthly)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[post_table]`
##

DROP TABLE IF EXISTS $gb4[post_table];
CREATE TABLE $gb4[post_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  category_id int(11) NOT NULL default '0',
  division_id int(11) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  content text NOT NULL,
  trackback_url varchar(255) NOT NULL default '',
  post_date datetime NOT NULL default '0000-00-00 00:00:00',
  secret tinyint(4) NOT NULL default '0',
  use_rss tinyint(4) NOT NULL default '0',
  use_comment tinyint(4) NOT NULL default '0',
  use_trackback tinyint(4) NOT NULL default '0',
  use_eolin tinyint(4) NOT NULL default '0',
  comment_count int(11) NOT NULL default '0',
  trackback_count int(11) NOT NULL default '0',
  real_date datetime NOT NULL default '0000-00-00 00:00:00',
  hit int(11) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY blog_id (blog_id,category_id)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[skin_table]`
##

DROP TABLE IF EXISTS $gb4[skin_table];
CREATE TABLE $gb4[skin_table] (
  id int(11) NOT NULL auto_increment,
  skin varchar(255) NOT NULL default '',
  used tinyint(4) NOT NULL default '0',
  use_count int(11) NOT NULL default '0',
  regdate datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[tag_table]`
##

DROP TABLE IF EXISTS $gb4[tag_table];
CREATE TABLE $gb4[tag_table] (
  id int(11) NOT NULL auto_increment,
  tag varchar(255) NOT NULL default '',
  tag_count int(11) NOT NULL default '0',
  regdate datetime NOT NULL default '0000-00-00 00:00:00',
  lastdate datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id),
  KEY tag (tag,lastdate)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[taglog_table]`
##

DROP TABLE IF EXISTS $gb4[taglog_table];
CREATE TABLE $gb4[taglog_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  post_id int(11) NOT NULL default '0',
  tag_id int(11) NOT NULL default '0',
  regdate datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id),
  KEY blog_id (blog_id,post_id,tag_id)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[trackback_table]`
##

DROP TABLE IF EXISTS $gb4[trackback_table];
CREATE TABLE $gb4[trackback_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  post_id int(11) NOT NULL default '0',
  writer_name varchar(30) NOT NULL default '',
  writer_pw varchar(32) NOT NULL default '',
  writer_email varchar(255) NOT NULL default '',
  writer_url varchar(255) NOT NULL default '',
  writer_subject varchar(255) NOT NULL default '',
  writer_content varchar(255) NOT NULL default '',
  writer_ip varchar(255) NOT NULL default '',
  referer varchar(255) NOT NULL default '',
  regdate datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id),
  KEY post_id (post_id),
  KEY blog_id (blog_id)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[guestbook_table]`
##

DROP TABLE IF EXISTS $gb4[guestbook_table];
CREATE TABLE $gb4[guestbook_table] (
  id int(11) NOT NULL auto_increment,
  blog_id int(11) NOT NULL default '0',
  mb_id varchar(30) NOT NULL default '',
  secret tinyint(4) NOT NULL default '0',
  writer_name varchar(255) NOT NULL default '',
  writer_pw varchar(255) NOT NULL default '',
  writer_email varchar(255) NOT NULL default '',
  writer_url varchar(255) NOT NULL default '',
  writer_content text NOT NULL,
  answer_content text NOT NULL,
  writer_ip varchar(255) NOT NULL default '',
  regdate datetime NOT NULL default '0000-00-00 00:00:00',
  ansdate datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id,blog_id)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[visit_table]`
##

DROP TABLE IF EXISTS $gb4[visit_table];
CREATE TABLE $gb4[visit_table] (
  vi_id int(11) NOT NULL default '0',
  vi_blog_id int(11) NOT NULL default '0',
  vi_mb_id varchar(30) NOT NULL default '',
  vi_ip varchar(255) NOT NULL default '',
  vi_date date NOT NULL default '0000-00-00',
  vi_time time NOT NULL default '00:00:00',
  vi_referer text NOT NULL,
  vi_agent varchar(255) NOT NULL default '',
  PRIMARY KEY  (vi_id),
  UNIQUE KEY index1 (vi_blog_id,vi_ip,vi_date),
  KEY index2 (vi_date,vi_mb_id)
) TYPE=MyISAM;

##
## Table structure for table `gb4_division`
##

DROP TABLE IF EXISTS $gb4[division_table];
CREATE TABLE $gb4[division_table] (
  dv_id int(11) NOT NULL auto_increment,
  dv_name varchar(255) NOT NULL default '',
  dv_rank int(11) NOT NULL default '0',
  PRIMARY KEY  (dv_id)
) TYPE=MyISAM;

##
## Table structure for table `$gb4[visit_sum_table]`
##

DROP TABLE IF EXISTS $gb4[visit_sum_table];
CREATE TABLE $gb4[visit_sum_table] (
  vs_blog_id int(11) NOT NULL default '0',
  vs_date date NOT NULL default '0000-00-00',
  vs_count int(11) NOT NULL default '0',
  PRIMARY KEY  (vs_blog_id,vs_date),
  KEY index1 (vs_count)
) TYPE=MyISAM;

# 0.2.0 - 湮 ̺ Ʃ
ALTER TABLE `$gb4[visit_table]` CHANGE `vi_id` `vi_id` INT( 11 ) NOT NULL AUTO_INCREMENT ;

# 0.2.0 - config Ͽ ̺ 
DROP TABLE IF EXISTS $gb4[config_table];
CREATE TABLE `$gb4[config_table]` (
`root` VARCHAR( 255 ) NOT NULL ,
`make_level` TINYINT( 4 ) NOT NULL ,
`make_point` TINYINT( 4 ) NOT NULL ,
`upload_blog_file_size` INT( 11 ) NOT NULL ,
`upload_file_number` INT( 11 ) NOT NULL ,
`upload_one_file_size` INT( 11 ) NOT NULL ,
`profile_image_size` INT( 11 ) NOT NULL ,
`top_image_size` INT( 11 ) NOT NULL ,
`background_image_size` INT( 11 ) NOT NULL ,
`use_random_blog` TINYINT( 4 ) NOT NULL ,
`use_permalink` VARCHAR( 12 ) NOT NULL ,
`ampersand` VARCHAR( 1 ) NOT NULL 
) TYPE=MyISAM;

# 0.2.0 - α׼ ⼱ 
ALTER TABLE `$gb4[blog_table]` DROP `editor_mode` ;

# 0.2.1 - config ̺ root 
ALTER TABLE `$gb4[config_table]` DROP `root` ;