<?
if (!defined("_GNUBOARD_")) exit; //    Ұ 

/*
-----------------------------------------------------------
    eolin rpc μ 
-----------------------------------------------------------
*/
function eolin_param($name, $value)
{
    if (is_array($value)) 
    {
        $xml  = "<member>";
        $xml .= "<name>".$name."</name>";
        $xml .= "<value><array>";
        for ($i=0, $max=sizeof($value); $i<$max; $i++)
        {
            $value[$i] = str_replace(']]>', ']]&gt;', $value[$i]);
            $value[$i] = strip_tags($value[$i]);
            $value[$i] = htmlspecialchars($value[$i]);
            
            $xml .= "<data><value><string>".$value[$i]."</string></value></data>";
        }
        $xml .= "</array></value></member>";
    }
    else 
    {
        $value = str_replace(']]>', ']]&gt;', $value);
        $value = strip_tags($value);
        $value = htmlspecialchars($value);

        $xml  = "<member>";
        $xml .= "<name>".$name."</name>";
        $xml .= "<value><string>".$value."</string></value>";
        $xml .= "</member>";
    }

    return $xml;
}

/*
-----------------------------------------------------------
    eolin  xml-rpc 
-----------------------------------------------------------
*/
function eolin_sync($id, $mode)
{
    global $g4, $gb4, $current;;

    if (!$id) {
        die("<script language=javascript> alert('̿ø   : id  ϴ.'); </script>");
    }

    $row = sql_fetch("select * from $gb4[post_table] where id='$id'");
    $tag = get_post_tag($id);

    $xml  = eolin_param('blogURL', get_full_url($current[blog_url]));
    $xml .= eolin_param('syncURL', get_full_url("/$gb4[root]/$gb4[blog]/eolin_sync.php?mb_id=$current[mb_id]&id=$id"));

    if ($mode == 'create') {

        $content = strip_tags($row[content]);
        $content = preg_replace('/&nbsp;?|\xc2\xa0\x20/', ' ', $content);
    	$content = trim(preg_replace('/\s+/', ' ', $content));
		$content = str_replace(array('&#39;','&apos;','&quot;'), array('\'','\'','"'), $content);

        $xml .= eolin_param('blogTitle', specialchars_replace($current[blog_name]));
        $xml .= eolin_param('language', 'ko');
        $xml .= eolin_param('permalink', get_full_url(get_post_url($id)));
        $xml .= eolin_param('title', specialchars_replace($row[title]));
        $xml .= eolin_param('content', $content);
        $xml .= eolin_param('author', specialchars_replace($current[writer]));
        $xml .= eolin_param('tags', $tag);
        $xml .= eolin_param('location', '/');
        $xml .= eolin_param('written', date('r', strtotime($row[post_date])));
    }

    $xml = "<?xml version='1.0' encoding='UTF-8'?>
    <methodCall>
        <methodName>sync.{$mode}</methodName>
        <params>
            <param>
                <value>
                    <struct>
                        {$xml}
                    </struct>
                </value>
            </param>
        </params>
    </methodCall>";

    if (!is_utf8($xml))
        $xml = convert_charset('euckr', 'utf8', $xml);

    //if ($mode != 'delete') { echo $xml; exit; }

    $host = "ping.eolin.com";
    $send_str = 'POST / HTTP/1.1'."\r\n".
    'Host: '.$host."\r\n".
    'User-Agent: Mozilla/4.0 (compatible; Eolin)'."\r\n".
    'Content-Type: text/xml'."\r\n".
    'Content-Length: '.strlen($xml)."\r\n".
    'Connection: close'."\r\n".
    "\r\n".
    $xml.
    "\r\n";

    $fp = @fsockopen ($host, 80, $errno, $errstr, 30);
    if (!$fp) 
        die("$errstr ($errno)\n");
    else 
    {
        fputs($fp, $send_str);

        while (trim($buffer = fgets($fp,1024)) != "") 
            $header .= $buffer;

        while (!feof($fp))
            $buffer .= fgets($fp,1024);
    }
    fclose($fp);
}

/*
-----------------------------------------------------------
    ̿ø ũ 
-----------------------------------------------------------
*/
function eolin_die() {
    $xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
            <response>
            <version>1.1</version> 
            <status>0</status> 
            </response>";
    echo_xml($xml);
    exit;
}
?>