<?php
if (!defined('ABSPATH')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 3;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;
if (!$is_show_field['num']) $colspan--;
if (!$is_show_field['writer']) $colspan--;
//if (!$is_show_field['visit']) $colspan--;
//if (!$is_show_field['wdate']) $colspan--;
?>

<div class="gp_skin_list">

<!-- 게시판 목록 시작 { -->
<div id="bo_list" style="width:<?php echo $width; ?>">

    <!-- 게시판 카테고리 시작 { -->
    <?php if ($is_category) { ?>
    <nav id="bo_cate">
        <h2><?php echo $board['bo_subject'] ?> <?php _e('분류', GC_NAME); ?></h2>
        <ul id="bo_cate_ul" class="board_category">
            <?php echo $category_option ?>
        </ul>
    </nav>
    <?php } ?>
    <!-- } 게시판 카테고리 끝 -->

	<!-- 게시판 태그 시작 -->
    <?php if( $is_use_tag ){ //태그 설정이 활성화 되어 있으면 ?>
    <ul class="list_head_tags">
    <?php
        foreach( $board_tag_lists as $s ){
            if( empty( $s ) ) continue;
            //카운트 숫자0인 경우 제외
            if( ! $s['count'] ) continue;

            $span_text = '<span class="tags-cnt"> '.$s['count'].'</span>'; //카운트 숫자
        ?>
        <li><?php echo gc_tag_class_link($s, $search_tag, 'tags-on', 'tags-txt', $span_text);?></li>
    <?php } // foreach end?>
    </ul>
    <?php } //end if ?>
	<!-- 게시판 태그 끝 -->

    <!-- 게시판 페이지 정보 및 버튼 시작 { -->
    <div class="bo_fx">
        <?php if ($rss_href || $write_href) { ?>
        <ul class="btn_bo_user">
            <?php if ($rss_href) { ?><li><a href="<?php echo esc_url( $rss_href ); ?>" class="btn_b01" target="_blank"><i class="fa fa-rss" aria-hidden="true"></i> RSS</a></li><?php } ?>
            <?php if ($admin_href) { ?><li><a href="<?php echo esc_url( $admin_href ); ?>" class="btn_admin" target="_blank"><i class="fa fa-cog" aria-hidden="true"></i> <?php _e('관리', GC_NAME);?></a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo esc_url( $write_href ); ?>" class="btn_b02"><i class="fa fa-pencil" aria-hidden="true"></i> <?php _e('글쓰기', GC_NAME);?></a></li><?php } ?>
        </ul>
        <?php } ?>
    </div>
    <!-- } 게시판 페이지 정보 및 버튼 끝 -->
    
    <form name="fboardlist" id="fboardlist" action="<?php echo $fboardlist_action_url; ?>" onsubmit="return fboardlist_submit(this);" method="post">
    <?php wp_nonce_field( 'gc_list', 'gc_nonce_field' ); ?>
    <input type="hidden" name="action" value="">
    <input type="hidden" name="board_page_id" value="<?php echo $post->ID?>" >
    <input type="hidden" name="bo_table" value="<?php echo esc_attr( $bo_table ); ?>">
    <input type="hidden" name="sfl" value="<?php echo esc_attr( $sfl ); ?>">
    <input type="hidden" name="stx" value="<?php echo esc_attr( $stx ); ?>">
    <input type="hidden" name="spt" value="<?php echo esc_attr( $spt ); ?>">
    <input type="hidden" name="sca" value="<?php echo esc_attr( $sca ); ?>">
    <input type="hidden" name="page" value="<?php echo esc_attr( $page ); ?>">
    <input type="hidden" name="sw" value="">
    <?php if( $board['bo_use_tag'] ){ //게시판에서 태그기능을 사용한다면... ?>
    <input type="hidden" name="tag" value="<?php echo esc_attr( $tag ); ?>" >
    <?php } ?>

    <div class="tbl_head01 tbl_wrap">
        <table>
        <tbody>
        <?php
        for ($i=0, $count_list = count($list); $i<$count_list; $i++) {
			$update_href = apply_filters('gc_view_update_href' , add_query_arg( array_merge((array) $qstr, array('action'=>'write', 'w'=>'u', 'wr_id'=>$list[$i]['wr_id'], 'page'=> $page))) );
		 ?>
<style>
	.click { cursor:pointer }
	.bg_before { display:inline-block; width:21px; height:11px; background:url('<?=$board_skin_url?>/img/dot1.jpg') no-repeat }
	.bg_after { display:inline-block; width:21px; height:11px;  background:url('<?=$board_skin_url?>/img/dot2.jpg') no-repeat }
</style>
<script>
jQuery(document).ready(function() {

	var $view = viewer_<?php echo $list[$i]['wr_id'] ?>;
	var $cl = click_<?php echo $list[$i]['wr_id'] ?>;
	var $cl2 = click2_<?php echo $list[$i]['wr_id'] ?>;

	jQuery('.viewer').hide();

	jQuery($cl).click(
	function() {
		jQuery($cl).toggleClass("bg_before bg_after");
		jQuery($view).slideToggle(1);
	});

	jQuery($cl2).click(
	function() {
		jQuery($cl).toggleClass("bg_before bg_after");
		jQuery($view).slideToggle(1);
	});
});
</script>
        <tr>
            <?php if ($is_checkbox) { ?>
            <td class="td_chk" width="5%">
                <label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
                <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
            </td><?php } ?>
			<td class="td_cate" width="10%" style="text-align:center;">
				 <?php
                echo $list[$i]['icon_reply'];
                if ($is_category && $list[$i]['ca_name']) {
                ?>
                <?php echo $list[$i]['ca_name'] ?>
                <?php } ?>
			</td>
            <td class="td_subject">
				<div id="click2_<?php echo $list[$i]['wr_id'] ?>" style="cursor:pointer">
                    <?php echo $list[$i]['subject'] ?>
                </div>
            </td>
            <td class="td_date" style="text-align:center" width="5%"><?php if ($update_href) { ?><a href="<?php echo $update_href ?>">수정</a><?php } ?><div id="click_<?php echo $list[$i]['wr_id'] ?>" class="click bg_before"></div></td>
        </tr>
		<tr id="viewer_<?php echo $list[$i]['wr_id'] ?>" class="viewer">
			<?php if ($is_checkbox) { ?>
			<td></td>
			<? } ?>
			<td class="td_cate"></td>
			<td colspan="2" style="padding:20px 0 !important; line-height:150% !important">
				<!-- 토글 출력 -->
				<?php echo $list[$i]['wr_content'] ?>
			</td>
		</tr>
        <?php } ?>
        <?php if (count($list) == 0) { echo '<tr><td colspan="'.$colspan.'" class="empty_table">'.__('자료가 없습니다.', GC_NAME).'</td></tr>'; } ?>
        </tbody>
        </table>
    </div>

    <?php if ($list_href || $is_checkbox || $write_href) { ?>
    <div class="bo_fx">
        <?php if ($is_checkbox) { ?>
        <ul class="btn_bo_adm">
            <li><button type="submit" name="btn_submit" value="<?php _e('선택삭제', GC_NAME); //선택삭제 ?>" onclick="document.pressed=this.value"><i class="fa fa-eraser" aria-hidden="true"></i> <?php _e('선택삭제', GC_NAME); //선택삭제 ?></button></li>
            <li><button type="submit" name="btn_submit" value="<?php _e('선택복사', GC_NAME); //선택복사 ?>" onclick="document.pressed=this.value"><i class="fa fa-clipboard" aria-hidden="true"></i> <?php _e('선택복사', GC_NAME); //선택복사 ?></button></li>
            <li><button type="submit" name="btn_submit" value="<?php _e('선택이동', GC_NAME); //선택이동 ?>" onclick="document.pressed=this.value"><i class="fa fa-repeat" aria-hidden="true"></i> <?php _e('선택이동', GC_NAME); //선택이동 ?></button></li>
        </ul>
        <?php } ?>

        <?php if ($list_href || $write_href) { ?>
        <ul class="btn_bo_user">
            <?php if ($list_href) { ?><li><a href="<?php echo $list_href ?>" class="btn_b01"><i class="fa fa-list-ul" aria-hidden="true"></i> <?php _e('목록', GC_NAME); //목록 ?></a></li><?php } ?>
            <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="btn_b02"><i class="fa fa-pencil" aria-hidden="true"></i> <?php _e('글쓰기', GC_NAME); //글쓰기 ?></a></li><?php } ?>
        </ul>
        <?php } ?>
    </div>
    <?php } ?>
    </form>
</div>

<?php if($is_checkbox) { ?>
<noscript>
<p><?php _e('자바스크립트를 사용하지 않는 경우', GC_NAME); //자바스크립트를 사용하지 않는 경우?><br><?php _e('별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.', GC_NAME); //별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.?></p>
</noscript>
<?php } ?>

<!-- 페이지 -->
<?php echo $write_pages;  ?>

<?php if ($is_checkbox) { ?>

<script type='text/javascript'>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i < f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i < f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + " <?php _e('할 게시물을 하나 이상 선택하세요.', GC_NAME);?>");
        return false;
    }

    if(document.pressed == "<?php _e('선택복사', GC_NAME);?>") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "<?php _e('선택이동', GC_NAME);?>") {
        select_copy("move");
        return;
    }

    if(document.pressed == "<?php _e('선택삭제', GC_NAME);?>") {
        if (!confirm("<?php _e('선택한 자료를 정말 삭제하시겠습니까?', GC_NAME);?>\n\n<?php _e('한번 삭제한 자료는 복구할 수 없습니다.', GC_NAME);?>\n\n<?php _e('답변글이 있는 게시글을 선택하신 경우,', GC_NAME)?>\n<?php _e('답변글도 선택하셔야 게시글이 삭제됩니다.', GC_NAME)?>"))
            return false;

        f.removeAttribute("target");
        f.action.value = "delete_all";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "<?php _e('복사', GC_NAME);?>";
    else
        str = "<?php _e('이동', GC_NAME);?>";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = f.action.value = "move";
    f.action = "<?php echo $new_move_url; ?>";
    f.submit();
}
</script>

<?php } ?>
<!-- } 게시판 목록 끝 -->

</div>
