<?
/***********************************************

Yag : This is a program that follows GPL.
Copyright (C) 2006 Miengine Inc.  www.miengine.com,  www.yagne.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.



Yag : 이 프로그램은 GPL을 따르는 프로그램입니다.  
Copyright (C) 2006년 (주)마이엔진,  www.miengine.com, www.yagne.com
 
이 프로그램은 자유 소프트웨어입니다. 소프트웨어의 피양도자는 자유 소프트웨어 재단이 공표한 GNU 일반 공중 사용 허가서 2판 또는 그 이후 판을 임의로 선택해서, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다. 

이 프로그램은 유용하게 사용될 수 있으리라는 희망에서 배포되고 있지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있으리라는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항에 대해서는 GNU 일반 공중 사용 허가서를 참고하시기 바랍니다. 

GNU 일반 공중 사용 허가서는 이 프로그램과 함께 제공됩니다. 만약, 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다. (자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA) 

GPL에 대해서 더 자세한 사항은 www.gnu.org 를 참조하십시오.

***********************************************/


ini_set('display_errors', 'off');
header("Content-Type: text/html; charset=utf-8");

include_once("./func.php");

ConfConstants();


/* get request parameter */
$step = trim($_REQUEST["step"]);


/* check request parameter */
if ($step == "")
{
    $step = "1";
}

if ($step != "1" && $step != "2" && $step != "3")
{
    exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv=Content-Type content="text/html; charset=utf-8" />
<title>yag 설치</title>
<link type="text/css" rel="stylesheet" href="./css/adm.css" />
<script type="text/javascript" language="javascript" src="./script/prototype.js"></script>
<script type="text/javascript" language="javascript" src="./script/yag_adm.js"></script>
</head>
<body>
<?
if ($step == "1")
{
    /* install check */
    if (file_exists(DIRCONF . "/db.php"))
    {
        echo "이미 설치된 상태입니다.";
        exit;
    }
?>
<div id="y_dv_install">
    <table>
        <tr>
            <td class="y_td_top_left"></td>
            <td class="y_td_top_center">
                <div id="y_dv_logo"><img src="./image/yag_2x.gif" width="62" height="40" border="0" /></div>
                <div id="y_dv_title"><span>2.51 판</span> <? echo $step ?>. 설치 시작</div>
                <div id="y_dv_topbutton"></div>
            </td>
            <td class="y_td_top_right"></td>
        </tr>
        <tr>
            <td class="y_td_middle_left"></td>
            <td class="y_td_middle_center">
                <div>1. yag는 <a href="http://www.gnu.org/" target="_blank">GPL</a> 라이센스로 제공됩니다.</div>
                <div>2. yag는 PHP4, MySQL이 설치되어 있어야 합니다.</div>
                <div>3. [yag디렉토리/conf] 에 <span style="color:#FF0000;">쓰기 권한</span>이 있어야 합니다.</div>
                <div style="margin-left:10px;">- 이 사이트의 conf 경로 : <? echo PATH ?>/<span style="color:#FF0000;">conf</span></div>
                <div style="margin-left:10px;">- 텔넷 혹은 FTP를 이용하여 conf 디렉토리의 권한을 수정하면 됩니다. (퍼미션 777)</div>
                <div>4. yag 설치에 대해 궁금한 점은 <a href="http://www.yagne.com/" target="_blank">http://www.yagne.com/</a>에 문의하십시오.</div>
                <div id="y_dv_step"><a href="./install.php?step=2">설치 시작</a></div>
            </td>
            <td class="y_td_middle_right"></td>
        </tr>
        <tr>
            <td class="y_td_bottom_left"></td>
            <td class="y_td_bottom_center"></td>
            <td class="y_td_bottom_right"></td>
        </tr>
    </table>
</div>
<?
}
else if ($step == "2")
{
    /* install check */
    if (file_exists(DIRCONF . "/db.php"))
    {
        echo "이미 설치된 상태입니다.";
        exit;
    }


    /* permission check */
    if (file_exists(DIRCONF))
    {
        if (!is_dir(DIRCONF) || !is_writeable(DIRCONF))
        {
?>
<div id="y_dv_install">
    <table>
        <tr>
            <td class="y_td_top_left"></td>
            <td class="y_td_top_center">
                <div id="y_dv_logo"><img src="./image/yag_2x.gif" width="62" height="40" border="0" /></div>
                <div id="y_dv_title"><span>2.51 판</span> <? echo $step ?>. 환경 설정</div>
                <div id="y_dv_topbutton"></div>
            </td>
            <td class="y_td_top_right"></td>
        </tr>
        <tr>
            <td class="y_td_middle_left"></td>
            <td class="y_td_middle_center">
                <div><? echo PATH; ?>/<span style="color:#FF0000;">conf</span> 디렉토리에 <span style="color:#FF0000;">쓰기 권한</span>이 있어야 합니다.</div>
                <div style="margin-left:10px;">- 텔넷 혹은 FTP를 이용하여 conf 디렉토리의 권한을 '777' 로 수정하면 됩니다.</div>
                <div id="y_dv_step"><a href="./install.php?step=1">이전 단계</a></div>
            </td>
            <td class="y_td_middle_right"></td>
        </tr>
        <tr>
            <td class="y_td_bottom_left"></td>
            <td class="y_td_bottom_center"></td>
            <td class="y_td_bottom_right"></td>
        </tr>
    </table>
</div>
<?
            exit;
        }
    }
    else
    {
?>
<div id="y_dv_install">
    <table>
        <tr>
            <td class="y_td_top_left"></td>
            <td class="y_td_top_center">
                <div id="y_dv_logo"><img src="./image/yag_2x.gif" width="62" height="40" border="0" /></div>
                <div id="y_dv_title"><span>2.51 판</span> <? echo $step ?>. 환경 설정</div>
                <div id="y_dv_topbutton"></div>
            </td>
            <td class="y_td_top_right"></td>
        </tr>
        <tr>
            <td class="y_td_middle_left"></td>
            <td class="y_td_middle_center">
                <div><? echo PATH; ?>/<span style="color:#FF0000;">conf</span> 디렉토리가 없습니다.</div>
                <div><? echo PATH; ?>/<span style="color:#FF0000;">conf</span> 디렉토리를 먼저 만드세요.</div>
                <div id="y_dv_step"><a href="./install.php?step=1">이전 단계</a></div>
            </td>
            <td class="y_td_middle_right"></td>
        </tr>
        <tr>
            <td class="y_td_bottom_left"></td>
            <td class="y_td_bottom_center"></td>
            <td class="y_td_bottom_right"></td>
        </tr>
    </table>
</div>
<?
            exit;
    }
?>
<script language="javascript" type="text/javascript">
function CheckForm()
{
    if (document.getElementById("dbsrv").value == "")
    {
        alert("Host Name을 입력하세요.");
        document.getElementById("dbsrv").focus();
        return;
    }

    if (document.getElementById("dbname").value == "")
    {
        alert("DB Name을 입력하세요.");
        document.getElementById("dbname").focus();
        return;
    }

    if (document.getElementById("dbuser").value == "")
    {
        alert("DB용 User ID를 입력하세요.");
        document.getElementById("dbuser").focus();
        return;
    }

    if (document.getElementById("dbpass").value == "")
    {
        alert("DB용 Password를 입력하세요.");
        document.getElementById("dbpass").focus();
        return;
    }

    if (document.getElementById("admid").value.length < 3 || document.getElementById("admid").value.length > 10)
    {
        alert("yag 으뜸관리자 ID는 3자 이상, 10자 이하이어야 합니다.");
        document.getElementById("admid").focus();
        return;
    }

    if (document.getElementById("admpass").value == "")
    {
        alert("yag 으뜸관리자용 비밀번호를 입력하세요.");
        document.getElementById("admpass").focus();
        return;
    }

    if (document.getElementById("admpass").value.length < 4)
    {
        alert("yag 으뜸관리자용 비밀번호는 4자 이상이어야 합니다.");
        document.getElementById("admpass").focus();
        return;
    }

    if (document.getElementById("admpass_c").value == "")
    {
        alert("yag 으뜸관리자용 비밀번호확인을 입력하세요.");
        document.getElementById("admpass_c").focus();
        return;
    }

    if (document.getElementById("admpass").value != document.getElementById("admpass_c").value)
    {
        alert("yag 으뜸관리자용 비밀번호가 일치하지 않습니다.");
        document.getElementById("admpass").focus();
        return;
    }

    document.getElementById("y_fm_input").submit();
}
</script>
<div id="y_dv_install">
    <table>
        <tr>
            <td class="y_td_top_left"></td>
            <td class="y_td_top_center">
                <div id="y_dv_logo"><img src="./image/yag_2x.gif" width="62" height="40" border="0" /></div>
                <div id="y_dv_title"><span>2.51 판</span> <? echo $step ?>. 환경 설정</div>
                <div id="y_dv_topbutton"></div>
            </td>
            <td class="y_td_top_right"></td>
        </tr>
        <tr>
            <td class="y_td_middle_left"></td>
            <td class="y_td_middle_center">
                <form id="y_fm_input" method="post">
                <input type="hidden" id="step" name="step" value="3">
                <div>
                    <h1>1. 데이터베이스 정보 <span style='margin-left:80px;font-size:12px;'><a href="#db" onclick="ViewInstallHelp('y_dv_ins_help_db');">도움말이 필요하면 눌러보세요</a></span></h1>
                    <table>
                        <tr>
                            <th>Host Name</th>
                            <td><input type="text" id="dbsrv" name="dbsrv" value="localhost" /> </td>
                        </tr>
                        <tr>
                            <th>DB Name</th>
                            <td><input type="text" id="dbname" name="dbname" value="" /> </td>
                        </tr>
                        <tr>
                            <th>User ID</th>
                            <td><input type="text" id="dbuser" name="dbuser" value="" /> </td>
                        </tr>
                        <tr>
                            <th>User Password</th>
                            <td><input type="password" id="dbpass" name="dbpass" value="" /> </td>
                        </tr>
                    </table>
                    <a name="db"></a>
                    <div id="y_dv_ins_help_db" class="y_dv_ins_help">
                        <span class="y_sp_ins_help_close" onclick="CloseInstallHelp('y_dv_ins_help_db');">닫기</span>
                        <ul>
                            <li>
                                <span>Host Name(데이터베이스 서버 이름)</span><br>
                                Host Name이란 서버 이름을 말합니다.
                                대개의 경우, 'localhost' 라는 이름을 사용합니다.
                            </li>
                            <li>
                                <span>DB Name(데이터베이스 이름)</span><br>
                                사용 중인 데이터베이스 이름을 입력합니다.
                                데이터베이스 정보를 모를 경우, 서버관리자 혹은 호스팅 업체에 문의하기 바랍니다.
                            </li>
                            <li>
                                <span>User ID(사용자 계정) / User Password(비밀번호)</span><br>
                                데이터베이스에 접속할 계정을 입력합니다.
                                역시 계정을 모를 경우, 서버관리자 혹은 호스팅 업체에 문의하기 바랍니다.
                            </li>
                        </ul>
                    </div>
                    <div style="margin-top:20px;"></div>
                    <h1>2. 문자 설정(Character Set) <span style='margin-left:20px;font-size:12px;'><a href="#char" onclick="ViewInstallHelp('y_dv_ins_help_char');">도움말이 필요하면 눌러보세요</a></span></h1>
                    <table>
                        <tr>
                            <th>인코딩 선택</th>
                            <td>
                                <select id="charset" name="charset">
                                    <option value="utf-8">utf-8</option>
                                    <option value="euc-kr">euc-kr</option>
                                </select>
                            </td>
                        </tr>
                    </table>
                    <a name="char"></a>
                    <div id="y_dv_ins_help_char" class="y_dv_ins_help">
                        <span class="y_sp_ins_help_close" onclick="CloseInstallHelp('y_dv_ins_help_char');">닫기</span>
                        <ul>
                            <li>
                                <span>utf-8</span><br>
                                utf-8 인코딩은 전 세계 문자를 표시할 수 있는 인코딩으로 태터툴즈 1.x판 이상은 utf-8로 운영됩니다.
                                블로그나 홈페이지가 utf-8일 경우 yag 인코딩 역시 utf-8을 선택하면 됩니다.
                            </li>
                            <li>
                                <span>euc-kr</span><br>
                                euc-kr 인코딩은 한국에서 주로 사용하며 일반 홈페이지는 주로 euc-kr로 운영됩니다.
                                블로그나 홈페이지가 euc-kr일 경우 yag 인코딩 역시 euc-kr을 선택하면 됩니다.
                            </li>
                        </ul>
                    </div>
                    <div style="margin-top:20px;"></div>
                    <h1>3. yag 으뜸관리자 정보 <span style='margin-left:55px;font-size:12px;'><a href="#auth" onclick="ViewInstallHelp('y_dv_ins_help_auth');">도움말이 필요하면 눌러보세요</a></span></h1></h1>
                    <table>
                        <tr>
                            <th>아이디(ID)</th>
                            <td><input type="text" id="admid" name="admid" value="" /></td>
                        </tr>
                        <tr>
                            <th>비밀번호(Password)</th>
                            <td><input type="password" id="admpass" name="admpass" value="" /> </td>
                        </tr>
                        <tr>
                            <th>비밀번호확인(Password)</th>
                            <td><input type="password" id="admpass_c" name="admpass_c" value="" /> </td>
                        </tr>
                    </table>
                    <a name="auth"></a>
                    <div id="y_dv_ins_help_auth" class="y_dv_ins_help">
                        <span class="y_sp_ins_help_close" onclick="CloseInstallHelp('y_dv_ins_help_auth');">닫기</span>
                        <ul>
                            <li>
                                <span>yag 으뜸관리자</span><br>
                                yag 으뜸관리자(main sysop)는 yag 운영에 관한 최고의 권한을 가진 사람입니다.
                                으뜸관리자는 yag와 버금관리자(sub sysop)를 추가하거나 삭제할 수 있습니다.
                                버금관리자는 자신에게 부여된 yag를 관리할 수 있습니다.
                            </li>
                        </ul>
                    </div>
                </div>
                <div id="y_dv_step"><a href="#" onclick="CheckForm();">확인</a> &nbsp; <a href="#" onclick="history.back();">취소</a></div>
                </form>
            </td>
            <td class="y_td_middle_right"></td>
        </tr>
        <tr>
            <td class="y_td_bottom_left"></td>
            <td class="y_td_bottom_center"></td>
            <td class="y_td_bottom_right"></td>
        </tr>
    </table>
</div>
<?
}
else if ($step == 3)
{
    /* install check */
    if (file_exists(DIRCONF . "/db.php"))
    {
        echo "이미 설치된 상태입니다.";
        exit;
    }


    /* get request parameter */
    $dbSrv   = trim($_POST["dbsrv"]);
    $dbName  = trim($_POST["dbname"]);
    $dbUser  = trim($_POST["dbuser"]);
    $dbPass  = trim($_POST["dbpass"]);
    $charSet = trim($_POST["charset"]);
    $admId   = trim($_POST["admid"]);
    $admPass = trim($_POST["admpass"]);


    /* check request parameter */
    if ($dbSrv == "" || $dbName == "" || $dbUser == "" || $dbPass == "" || $charSet == "" || $admId == "" || $admPass == "")
    {
        echo "error - ''";
        exit;
    }

    if (!get_magic_quotes_gpc())
    {
        $admId   = addslashes($admId);
        $charSet = addslashes($charSet);
    }

    if (strlen($admPass) < 4)
    {
        echo "<script>alert(\"으뜸관리자 비밀번호는 4자 이상이어야 합니다.\"); history.back();</script>";
        exit;
    }


    /* get db connection */
    $conn = GetDBConnection($dbSrv, $dbName, $dbUser, $dbPass);
    if (!$conn)
    {
        echo "<script>alert(\"데이터베이스 서버에 연결할 수 없습니다.\\n\\n입력 정보를 확인하세요.\"); history.back();</script>";
        exit;
    }


    /* table check */
    $query = "show tables from " . $_POST['dbname'];
    $exist = "N";

    if ($res = mysql_query($query))
    {
        while($row = mysql_fetch_array($res))
        {
            if ($row[0] == "yag_in_site")
            {
                $exist = "Y";
                break;
            }

            if ($row[0] == "yag_in_user")
            {
                $exist = "Y";
                break;
            }

            if ($row[0] == "yag_in_memo")
            {
                $exist = "Y";
                break;
            }

            if ($row[0] == "yag_in_chatuser")
            {
                $exist = "Y";
                break;
            }

            if ($row[0] == "yag_in_chatlog")
            {
                $exist = "Y";
                break;
            }
        }
        mysql_free_result($res);

        if ($exist == "Y")
        {
            echo "이미 설치된 상태입니다.";
            exit;
        }
    }
    else
    {
        echo "error - res";
        exit;
    }


    /* create table */
    $query = explode(';', trim(GetYagSchema("utf-8")));

    foreach ($query as $sub)
    {
        if (!mysql_query($sub))
        {
            echo "error - create";
            exit;
        }
    }


    /* insert site info */
    $query  = " insert into yag_in_site (yagVersion, domain, alias, path, skin, charset, mainInterval, chatInterval, maxClient, maxChat, admID, pwd, super) ";
    $query .= " values ('" . VERSION . "', '" . DOMAIN . "', '" . ALIAS . "', '" . PATH . "', '" . SKIN . "', '" . $charSet . "', " . MAININTERVAL .", " . CHATINTERVAL . ", " . MAXCLIENT . ", " . MAXCHAT . ", '" . $admId . "', '" . md5($admPass) . "', 'Y')";
    if (!mysql_query($query))
    {
        echo "error - insert";
        exit;
    }
    $siteID = mysql_insert_id();


    /* write config file */
    $dbFname = DIRCONF . "/db.php";
    $cfFname = DIRCONF . "/" . $siteID . ".php";

    $fp = fopen($dbFname, 'w+');
    if ($fp)
    {
        fwrite($fp,
"<?
\$yagDB[\"host\"] = \"{$dbSrv}\";
\$yagDB[\"db\"]   = \"{$dbName}\";
\$yagDB[\"user\"] = \"{$dbUser}\";
\$yagDB[\"pass\"] = \"{$dbPass}\";
?>"
        );
        fclose($fp);
        chmod($dbFname, 0777);
    }
    else
    {
        echo "file1 w fail";
        exit;
    }

    $fp = fopen($cfFname, 'w+');
    if ($fp)
    {
        fwrite($fp,
"<?
\$yagConf[\"domain\"]       = \"" . DOMAIN . "\";
\$yagConf[\"path\"]         = \"" . PATH . "\";
\$yagConf[\"skin\"]         = \"" . SKIN . "\";
\$yagConf[\"charset\"]      = \"" . $charSet . "\";
\$yagConf[\"mainInterval\"] = " . MAININTERVAL . ";
\$yagConf[\"chatInterval\"] = " . CHATINTERVAL . ";
\$yagConf[\"maxClient\"]    = " . MAXCLIENT . ";
\$yagConf[\"maxChat\"]      = " . MAXCHAT . ";
?>"
        );
        fclose($fp);
        chmod($cfFname, 0777);
    }
    else
    {
        echo "file2 w fail";
        exit;
    }
?>
<div id="y_dv_install">
    <table>
        <tr>
            <td class="y_td_top_left"></td>
            <td class="y_td_top_center">
                <div id="y_dv_logo"><img src="./image/yag_2x.gif" width="62" height="40" border="0" /></div>
                <div id="y_dv_title"><span>2.51 판</span> <? echo $step ?>. 설치 완료</div>
                <div id="y_dv_topbutton"></div>
            </td>
            <td class="y_td_top_right"></td>
        </tr>
        <tr>
            <td class="y_td_middle_left"></td>
            <td class="y_td_middle_center">
                <div>yag 설치가 완료되었습니다.</div>
                <div>관리자 페이지에 접속해 홈페이지에 삽입할 yag 스크립트를 확인하세요.</div>
                <div id="y_dv_step"><a href="./login.php?refer=/">관리자 페이지로 이동</a></div>
            </td>
            <td class="y_td_middle_right"></td>
        </tr>
        <tr>
            <td class="y_td_bottom_left"></td>
            <td class="y_td_bottom_center"></td>
            <td class="y_td_bottom_right"></td>
        </tr>
    </table>
</div>
<?
}
?>
</div>
</body>
</html>