/***********************************************

Yag : This is a program that follows GPL.
Copyright (C) 2006 Miengine Inc.  www.miengine.com,  www.yagne.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.



Yag : 이 프로그램은 GPL을 따르는 프로그램입니다.  
Copyright (C) 2006년 (주)마이엔진,  www.miengine.com, www.yagne.com
 
이 프로그램은 자유 소프트웨어입니다. 소프트웨어의 피양도자는 자유 소프트웨어 재단이 공표한 GNU 일반 공중 사용 허가서 2판 또는 그 이후 판을 임의로 선택해서, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다. 

이 프로그램은 유용하게 사용될 수 있으리라는 희망에서 배포되고 있지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있으리라는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항에 대해서는 GNU 일반 공중 사용 허가서를 참고하시기 바랍니다. 

GNU 일반 공중 사용 허가서는 이 프로그램과 함께 제공됩니다. 만약, 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다. (자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA) 

GPL에 대해서 더 자세한 사항은 www.gnu.org 를 참조하십시오.

***********************************************/


function CheckLoginForm(argForm)
{
    if ($F("admid") == "")
    {
        alert("아이디를 입력하세요.");
        $("admid").focus();
        return false;
    }

    if ($F("admpass") == "")
    {
        alert("비밀번호를 입력하세요.");
        $("admpass").focus();
        return false;
    }

    return true;
}

function EditManageValue(argFlag)
{
    var sucFunction = null;
    var reqUrl = "./manage_proc.php";
    var data = "flag=" + argFlag;

    switch (argFlag)
    {
        case "notice" :
            var con = ContentCheck($("y_txa_notice"));
            if (con.length > 100)
            {
                alert("공지사항은 100자까지 입력 가능합니다.\n\n현재 " + con.length + "자 입니다.");
                return;
            }
            sucFunction = XmlResultDefault;
            data += "&notice=" + encodeURIComponent(con);
            break;
        case "skin" :
            var skin = document.getElementsByName("y_ra_skin");
            var val  = "1";
            for (var i = 0; i < skin.length; i++)
            {
                if (skin[i].checked)
                {
                    val = skin[i].value;
                }
            }
            sucFunction = XmlResultDefault;
            data += "&skin=" + val;
            break;
        case "conf" :
            sucFunction = XmlResultDefault;
            data += "&charset=" + $F("y_sel_charset");
            data += "&maxclient=" + $F("y_sel_maxclient");
            data += "&maxchat=" + $F("y_sel_maxchat");
            break;
        case "pwd" :
            if ($F("y_tx_pwd") == "")
            {
                alert("현재 비밀번호를 입력하세요.");
                $("y_tx_pwd").focus();
                return;
            }

            if ($F("y_tx_pwd_new").length < 4)
            {
                alert("비밀번호는 4자 이상이어야 합니다.");
                $("y_tx_pwd_new").focus();
                return;
            }

            if ($F("y_tx_pwd_newc") == "")
            {
                alert("비밀번호 확인을 입력하세요.");
                $("y_tx_pwd_newc").focus();
                return;
            }

            if ($F("y_tx_pwd_new") != $F("y_tx_pwd_newc"))
            {
                alert("새 비밀번호와 비밀번호 확인이 일치하지 않습니다.");
                $("y_tx_pwd_newc").focus();
                return;
            }
            sucFunction = XmlResultPwd;
            data += "&pwd=" + $F("y_tx_pwd");
            data += "&newpwd=" + $F("y_tx_pwd_new");
            break;
        case "site" :
            if ($F("y_tx_sitealias") == "")
            {
                alert("yag 이름을 입력하세요.");
                $("y_tx_sitealias").focus();
                return;
            }

            if ($F("y_tx_siteadmin").length < 3 || $F("y_tx_siteadmin").length > 10)
            {
                alert("관리자 아이디는 3자 이상, 10자 이하이어야 합니다.");
                $("y_tx_siteadmin").focus();
                return;
            }

            if ($F("y_tx_siteadmin_pwd").length < 4)
            {
                alert("비밀번호는 4자 이상이어야 합니다.");
                $("y_tx_siteadmin_pwd").focus();
                return;
            }
            sucFunction = XmlResultSite;
            data += "&alias=" + encodeURIComponent($F("y_tx_sitealias"));
            data += "&admin=" + $F("y_tx_siteadmin");
            data += "&pwd=" + $F("y_tx_siteadmin_pwd");
            break;
        default :
            return;
    }

    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: sucFunction,
            onFailure:function() {alert("오류가 발생하였습니다.");}
        }
    );
}

function XmlResultDefault(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            alert("수정되었습니다.");
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}

function XmlResultPwd(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            alert("비밀번호가 변경되었습니다.");
            $("y_tx_pwd").value = "";
            $("y_tx_pwd_new").value = "";
            $("y_tx_pwd_newc").value = "";
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}

function XmlResultSite(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;
        var str    = "";
        var tr, td1, td2, td3, td4, siteid;

        if (result == "ok")
        {
            siteid = xml.getElementsByTagName("siteid")[0].firstChild.nodeValue;

            tr  = document.createElement("tr");
            tr.id = "y_tr_site_" + siteid;
            td1 = document.createElement("td");
            td2 = document.createElement("td");
            td3 = document.createElement("td");
            td4 = document.createElement("td");
            tr.appendChild(td1);
            tr.appendChild(td2);
            tr.appendChild(td3);
            tr.appendChild(td4);
            td1.innerHTML = siteid;
            td2.innerHTML = $F("y_tx_sitealias");
            td3.innerHTML = $F("y_tx_siteadmin");
            td4.innerHTML = "<input type=\"button\" value=\"삭제\" onclick=\"SiteRemove('" + siteid + "');\">";
            try
            {
                $("y_tb_sites").firstChild.appendChild(tr);
            }
            catch (e)
            {
                $("y_tb_sites").appendChild(tr);
            }            

            $("y_tx_sitealias").value = "";
            $("y_tx_siteadmin").value = "";
            $("y_tx_siteadmin_pwd").value = "";

            alert("yag가 추가되었습니다.");
        }
        else if (result == "id exist")
        {
            alert("이미 사용중인 아이디입니다.\n\n다른 아이디를 입력하세요.");
            return;
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert("fd" + e);
    }
}

function SiteRemove(argId)
{
    if (confirm("삭제하시겠습니까?"))
    {
        var reqUrl = "./manage_proc.php";
        var data = "flag=siteremove";
        data += "&sid=" + argId;

        var ajax = new Ajax.Request(
            reqUrl,
            {
                method: 'post',
                asynchronous: true,
                postBody: data,
                requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
                onSuccess: XmlResultSiteRemove,
                onFailure:function() {alert("오류가 발생하였습니다.");}
            }
        );

    }
}

function XmlResultSiteRemove(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            siteid = xml.getElementsByTagName("siteid")[0].firstChild.nodeValue;
            try
            {
                $("y_tb_sites").firstChild.removeChild($("y_tr_site_" + siteid));
            }
            catch (e)
            {
                try
                {
                    $("y_tb_sites").removeChild($("y_tr_site_" + siteid));
                }
                catch (e1)
                {
                    $("y_tr_site_" + siteid).style.display = "none";
                }
            }
            alert("yag가 삭제되었습니다.");
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}

function ContentCheck(argObject)
{
    var con = "";

    if (argObject)
    {
        con = argObject.value;
        con = con.replace(/(^\s*)|(\s*$)/g, "");
    }

    return con;
}

function HtmlReg(argStr)
{
    var rtn = argStr;
    var regEx1 = /</g;
    var regEx2 = /http:\/\/\w+\.+\w+\S*/;

    rtn = rtn.replace(regEx1, "&lt;");
    var tmp = regEx2.exec(rtn);

    if (tmp != null)
    {
        rtn = rtn.replace(regEx2, "<a href=\"" + tmp + "\" target=\"_blank\">" + tmp + "</a>");
    }

    return rtn;
}

function ImgOverOut(argObj, argFileName)
{
    var strSrc  = argObj.src.toLowerCase();
    var fileDir = strSrc.substr(0, strSrc.lastIndexOf("/") + 1);
    argObj.src  = fileDir + argFileName;
    argObj.style.cursor = "pointer";
}

function ViewInstallHelp(argObjId)
{
    $(argObjId).style.display = "block";
}

function CloseInstallHelp(argObjId)
{
    $(argObjId).style.display = "none";
}

function SkinSampleShow(argSrc)
{
    $("y_img_skin_thum").src = argSrc;
}