/***********************************************

Yag : This is a program that follows GPL.
Copyright (C) 2006 Miengine Inc.  www.miengine.com,  www.yagne.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.



Yag : 이 프로그램은 GPL을 따르는 프로그램입니다.
Copyright (C) 2006년 (주)마이엔진,  www.miengine.com, www.yagne.com

이 프로그램은 자유 소프트웨어입니다. 소프트웨어의 피양도자는 자유 소프트웨어 재단이 공표한 GNU 일반 공중 사용 허가서 2판 또는 그 이후 판을 임의로 선택해서, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다.

이 프로그램은 유용하게 사용될 수 있으리라는 희망에서 배포되고 있지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있으리라는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항에 대해서는 GNU 일반 공중 사용 허가서를 참고하시기 바랍니다.

GNU 일반 공중 사용 허가서는 이 프로그램과 함께 제공됩니다. 만약, 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다. (자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA)

GPL에 대해서 더 자세한 사항은 www.gnu.org 를 참조하십시오.

***********************************************/


Event.observe(window, "load", YFN_InitFirst, false);

/* main */
function YFN_InitFirst()
{
    YFN_YagDisplay();
    setTimeout("YFN_InitSecond()", 100);
}

function YFN_InitSecond()
{
    YFN_MainRequest();
    YFN_ChatStartByCookie();

    Windows.addObserver({ onShow: YFN_ShowByObserver });
    Windows.addObserver({ onClose: YFN_CloseByObserver });
    Windows.addObserver({ onResize: YFN_ResizeByObserver });
    Windows.addObserver({ onMinimize: YFN_ResizeByObserver });
    Windows.addObserver({ onMaximize: YFN_ResizeByObserver });
    Windows.addObserver({ onStartMove: YFN_MoveByObserver });
    Windows.addObserver({ onEndMove: YFN_MoveByObserver });
}

function YFN_YagDisplay()
{
    var str = "";
    str += "<table class=\"y_tb_area\">";
    str += "    <tr class=\"y_tr_top\">";
    str += "        <td class=\"y_td_top_l\"></td>";
    str += "        <td class=\"y_td_top_c\"></td>";
    str += "        <td class=\"y_td_top_r\"></td>";
    str += "    </tr>";
    str += "    <tr class=\"y_tr_middle\">";
    str += "        <td class=\"y_td_middle_l\"></td>";
    str += "        <td class=\"y_td_inner\">";
    str += "            <div id=\"y_dv_title\">";
    str += "                <div id=\"y_dv_logo\"><a href=\"http://www.yagne.com/\" target=\"_blank\"><img src=\"" + YGV_SkinPath + "/yag_logo.gif\" width=\"43\" height=\"27\" border=\"0\" alt=\"yag\" /></a></div>";
    str += "                <div id=\"y_dv_help\">";
    str += "                    <a href=\"" + YGV_Path + "/login.php\"><img src=\"" + YGV_SkinPath + "/admin_01.gif\" width=\"22\" height=\"22\" border=\"0\" alt=\"admin\" onmouseover=\"YFN_ImgOverOut(this, 'admin_02.gif');\" onmouseout=\"YFN_ImgOverOut(this, 'admin_01.gif');\" /></a><a href=\"http://www.yagne.com/help.html\" target=\"_blank\"><img src=\"" + YGV_SkinPath + "/help_01.gif\" width=\"22\" height=\"22\" border=\"0\" alt=\"help\" onmouseover=\"YFN_ImgOverOut(this, 'help_02.gif');\" onmouseout=\"YFN_ImgOverOut(this, 'help_01.gif');\" /></a>";
    str += "                </div>";
    str += "            </div>";
    str += "            <div id=\"y_dv_count\">";
    str += YGV_TableInnerTop;
    str += "                <div id=\"y_dv_count_all\">";
    str += "                    <span onclick=\"YFN_UserListShow('all');\" onmouseover=\"YFN_TextDecoration(this, 'u');\" onmouseout=\"YFN_TextDecoration(this, 'n');\">";
    str += "                        사이트 접속자 <span id=\"y_sp_allcnt\"></span>&nbsp;";
    str += "                        <img id=\"y_img_vc_site\" src=\"" + YGV_SkinPath + "/vc_view.gif\" width=\"9\" height=\"9\" border=\"0\">";
    str += "                    </span>";
    str += "                </div>";
    str += "                <div id=\"y_dv_count_url\">";
    str += "                    <span onclick=\"YFN_UserListShow('url');\" onmouseover=\"YFN_TextDecoration(this, 'u');\" onmouseout=\"YFN_TextDecoration(this, 'n');\">";
    str += "                        페이지 접속자 <span id=\"y_sp_urlcnt\"></span>&nbsp;";
    str += "                        <img id=\"y_img_vc_url\" src=\"" + YGV_SkinPath + "/vc_close.gif\" width=\"9\" height=\"9\" border=\"0\">";
    str += "                    </span>";
    str += "                </div>";
    str += "                <div id=\"y_dv_count_chat\">";
    str += "                    <span onclick=\"YFN_ChatStartByClick();\" onmouseover=\"YFN_TextDecoration(this, 'u');\" onmouseout=\"YFN_TextDecoration(this, 'n');\">";
    str += "                        대화방 접속자 <span id=\"y_sp_chatcnt\"></span>/<span id=\"y_sp_chatmax\"></span>&nbsp;";
    str += "                        <img id=\"y_img_vc_chat\" src=\"" + YGV_SkinPath + "/vc_close.gif\" width=\"9\" height=\"9\" border=\"0\">";
    str += "                    </span>";
    str += "                </div>";
    str += "                <div id=\"y_dv_count_admin\">";
    str += "                        사이트지기 <span id=\"y_sp_adming\">자리비움</span>";
    str += "                </div>";
    str += YGV_TableInnerBottom;
    str += "            </div>";
    str += "            <div id=\"y_dv_list\">";
    str += YGV_TableInnerTop;
    str += "                <div id=\"y_dv_list_title\"><span id=\"y_sp_list_title\">사이트 접속자</span></div>";
    str += "                <div id=\"y_dv_list_close\"><img src=\"" + YGV_SkinPath + "/close.gif\" width=\"11\" height=\"13\" border=\"0\" onclick=\"YFN_UserListClose();\" onmouseover=\"YFN_TextDecoration(this, 'u');\" onmouseout=\"YFN_TextDecoration(this, 'n');\" /></div>";
    str += "                <div id=\"y_dv_list_view\">";
    str += "                    <div id=\"y_dv_list_self\">";
    str += "                        <div id=\"y_dv_mynick_show\">";
    str += "                            <img src=\"" + YGV_SkinPath + "/i.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"나\" />";
    str += "                            <span onclick=\"YFN_NickChangeShow();\" onmouseover=\"YFN_TextDecoration(this, 'u');\" onmouseout=\"YFN_TextDecoration(this, 'n');\">";
    str += "                                <span id=\"y_sp_list_mynick\"></span>&nbsp;<img src=\"" + YGV_SkinPath + "/edit.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"이름바꾸기\" />";
    str += "                            </span>";
    str += "                        </div>";
    str += "                        <div id=\"y_dv_mynick_ctrl\">";
    str += "                            <form onsubmit='return false;'>";
    str += "                            <input type=\"text\" id=\"y_tx_list_mynick\" maxlength=\"" + YGV_NickMaxLen + "\" onkeypress=\"YFN_NickKeypress(event);\">";
    str += "                            <input type=\"button\" id=\"y_bt_list_mynick_ok\" value=\"변경\" onClick=\"YFN_NickCheck($('y_tx_list_mynick'));\">";
    str += "                            <input type=\"button\" id=\"y_bt_list_mynick_cancel\" value=\"취소\" onClick=\"YFN_NickChangeClose();\">";
    str += "                            </form>";
    str += "                        </div>";
    str += "                    </div>";
    str += "                    <div id=\"y_dv_list_all\"></div>";
    str += "                    <div id=\"y_dv_list_url\"></div>";
    str += "                </div>";
    str += YGV_TableInnerBottom;
    str += "            </div>";
    str += "            <div id=\"y_dv_notice\">";
    str += YGV_TableInnerTop;
    str += "                <div id=\"y_dv_notice_title\" onclick=\"YFN_NoticeShow();\" onmouseover=\"YFN_TextDecoration(this, 'u');\" onmouseout=\"YFN_TextDecoration(this, 'n');\"></div>";
    str += "                <div id=\"y_dv_notice_show\" onclick=\"YFN_NoticeShow();\" onmouseover=\"YFN_TextDecoration(this, 'u');\" onmouseout=\"YFN_TextDecoration(this, 'n');\"><img src=\"" + YGV_SkinPath + "/down.gif\" width=\"11\" height=\"12\" border=\"0\"></div>";
    str += "                <div id=\"y_dv_notice_content\" style=\"display:none;\"></div>";
    str += YGV_TableInnerBottom;
    str += "            </div>";
    str += "            <div id=\"y_dv_alert\">";
    str += YGV_TableInnerTop;
    str += "                <div id=\"y_dv_alert_content\"></div>";
    str += YGV_TableInnerBottom;
    str += "            </div>";
    str += "        </td>";
    str += "        <td class=\"y_td_middle_r\"></td>";
    str += "    </tr>";
    str += "</table>";
    str += "<table class=\"y_tb_area\">";
    str += "    <tr class=\"y_tr_bottom\">";
    str += "        <td class=\"y_td_bottom_l\"></td>";
    str += "        <td class=\"y_td_bottom_c\">&nbsp;</td>";
    str += "        <td class=\"y_td_bottom_r\"></td>";
    str += "    </tr>";
    str += "</table>";

    $("y_dv_area").innerHTML = str;
}

function YFN_MainRequest()
{
    var reqUrl = YGV_Path + "/main_start.php";
    var data   = "";
    data  = "";
    data += "sid=" + YGV_Site;
    data += "&mcnt=" + YGV_MainCnt;
    data += "&main=" + YFN_GetCookie(YGV_CookMain);
    data += "&sub=" + YFN_GetCookie(YGV_CookSub);
    data += "&url=" + YFN_UriEncode(YFN_GetCurUrl());
    data += "&refer=" + YFN_UriEncode(YFN_GetReferUrl());
    data += "&nick=" + encodeURIComponent(YFN_GetCookie(YGV_CookNick));
    //document.location.href = reqUrl + "?" + data;

    YFN_MainXhpMonitoring();
    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: YFN_MainView,
            onFailure: YFN_MainXhpError
        }
    );
    YGV_MainXmlHttp = ajax.transport;
    YGV_MainTimeId = setTimeout("YFN_MainRequest()", YGV_MainInterval);
}

function YFN_MainXhpMonitoring()
{
    if (YGV_MainXmlHttp)
    {
        YGV_MainXmlHttp.onreadystatechange = function() {};
        YGV_MainXmlHttp.abort();
    }
}

function YFN_MainXhpError()
{
}

function YFN_MainView(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            // display
            $("y_dv_count").style.display = "block";
            $("y_dv_alert").style.display = "none";

            // admin info
            var admin = xml.getElementsByTagName("admininfo");
            YFN_FillupAdmin(admin);

            // all user list
            var allUser = xml.getElementsByTagName("alluserinfo");
            YFN_FillupUserList(allUser, "all");

            // url user list
            var urlUser = xml.getElementsByTagName("urluserinfo");
            YFN_FillupUserList(urlUser, "url");

            // self list
            YFN_FillupSelfList();

            // chat user cnt
            var chatUserCnt = xml.getElementsByTagName("chat")[0].childNodes[0].firstChild.nodeValue;
            $("y_sp_chatcnt").innerHTML = chatUserCnt;
            $("y_sp_chatmax").innerHTML = YGV_MaxChat;

            // receive(plus) memo list
            if (xml.getElementsByTagName("memo")[0].childNodes[0].firstChild.nodeValue == "Y")
            {
                var rcvMemo = xml.getElementsByTagName("newmemoinfo");
                YFN_FillupRcvMemoList(rcvMemo);
            }

            // notice
            if (YGV_MainCnt == 0)   // first request
            {
                var notice = "";
                if (xml.getElementsByTagName("notice")[0].firstChild)
                {
                    notice = xml.getElementsByTagName("notice")[0].firstChild.nodeValue;
                }
                YFN_FillupNotice(notice);
            }

            YGV_MainCnt        = 1;
            YGV_MainXmlHttp    = null;
        }
        else if (result == "mc overflow")
        {
            YFN_MainOverflow();
        }
        else
        {
            $("y_dv_alert").style.display     = "block";
            $("y_dv_alert_content").innerHTML = result;
        }
    }
    catch (e)
    {
        $("y_dv_alert").style.display     = "block";
        $("y_dv_alert_content").innerHTML = e;
    }
}

function YFN_MainOverflow()
{
    clearTimeout(YGV_MainTimeId);
    $("y_dv_count").style.display     = "none";
    $("y_dv_list").style.display      = "none";
    $("y_dv_alert").style.display     = "block";
    $("y_dv_alert_content").innerHTML = "동시 최대 접속자 " + YGV_MaxClient + "명을 초과했기에 접속자가 표시되지 않습니다. ";
}

/* admin info */
function YFN_FillupAdmin(argXml)
{
    var str = "";
    var a_mainid, a_subid, a_nick;

    if (argXml[0].childNodes[0].firstChild.nodeValue == "Y")
    {
        a_mainid = argXml[0].childNodes[1].firstChild.nodeValue;
        a_subid  = argXml[0].childNodes[2].firstChild.nodeValue;
        a_nick   = argXml[0].childNodes[3].firstChild.nodeValue;

        if (YFN_GetCookie(YGV_CookMain) != a_mainid)
        {
            str += "<span onclick=\"YFN_WriteMemoShow(\'" + a_mainid + "\', \'" + a_subid + "\', \'" + a_nick + "\');\" onmouseover=\"YFN_TextDecoration(this, \'u\');\" onmouseout=\"YFN_TextDecoration(this, \'n\');\" title=\"쪽지보내기\">";
            str += "접속중&nbsp;<img src=\"" + YGV_SkinPath + "/admin_on.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"관리자접속\" />";
            str += "</span>";
        }
        else
        {
            str += "접속중&nbsp;<img src=\"" + YGV_SkinPath + "/admin_on.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"관리자접속\" />";
        }

        YGV_AdmMid = a_mainid;
        $("y_sp_adming").innerHTML = str;
    }
    else
    {
        YGV_AdmMid = "";
        $("y_sp_adming").innerHTML = "자리비움";
    }
}

/* user list */
function YFN_FillupUserList(argList, argTarget)
{
    var u_mainid, u_subid, u_nick;
    var str = "";
    var cnt = argList.length;

    for (var i = 0; i < cnt; i++)
    {
        u_mainid = argList[i].childNodes[0].firstChild.nodeValue;
        u_subid  = argList[i].childNodes[1].firstChild.nodeValue;
        u_nick   = argList[i].childNodes[2].firstChild.nodeValue;

        str += "<div>";
        if (YGV_AdmMid != "" && u_mainid == YGV_AdmMid)
        {
            str += "<span><img src=\"" + YGV_SkinPath + "/sysop.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"사이트지기\" /></span>&nbsp;";
        }
        else
        {
            str += "<span><img src=\"" + YGV_SkinPath + "/guest.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"손님\" /></span>&nbsp;";
        }
        str += "<span onclick=\"YFN_WriteMemoShow(\'" + u_mainid + "\', \'" + u_subid + "\', \'" + u_nick + "\');\" onmouseover=\"YFN_TextDecoration(this, \'u\');\" onmouseout=\"YFN_TextDecoration(this, \'n\');\" title=\"쪽지보내기\">";
        str += u_nick + " (" + u_mainid.substr(0, 4) + ") ";
        str += "</span>";
        str += "</div>";
    }

    if (argTarget == "all")
    {
        $("y_sp_allcnt").innerHTML = cnt + 1;
        $("y_dv_list_all").innerHTML = str;
    }
    else if (argTarget == "url")
    {
        $("y_sp_urlcnt").innerHTML = cnt + 1;
        $("y_dv_list_url").innerHTML = str;
    }
}

function YFN_FillupSelfList()
{
    var u_mainid, u_subid, u_nick;

    u_mainid = YFN_GetCookie(YGV_CookMain);
    u_subid  = YFN_GetCookie(YGV_CookSub);
    u_nick   = YFN_GetCookie(YGV_CookNick);
    if (u_nick == "")
    {
        u_nick = "나";
    }

    $("y_sp_list_mynick").innerHTML = u_nick + " (" + u_mainid.substr(0, 4) + ")";
}

function YFN_UserListShow(argFlag)
{
    $("y_dv_list").style.display = "block";

    if (argFlag == "all")
    {
        $("y_sp_list_title").innerHTML   = "사이트 접속자";
        $("y_dv_list_all").style.display = "block";
        $("y_dv_list_url").style.display = "none";
        $("y_img_vc_site").src = YGV_SkinPath + "/vc_view.gif";
        $("y_img_vc_url").src = YGV_SkinPath + "/vc_close.gif";
    }
    else if (argFlag == "url")
    {
        $("y_sp_list_title").innerHTML   = "페이지 접속자";
        $("y_dv_list_all").style.display = "none";
        $("y_dv_list_url").style.display = "block";
        $("y_img_vc_site").src = YGV_SkinPath + "/vc_close.gif";
        $("y_img_vc_url").src = YGV_SkinPath + "/vc_view.gif";
    }
}

function YFN_UserListClose()
{
    $("y_dv_list").style.display = "none";
    $("y_img_vc_site").src = YGV_SkinPath + "/vc_close.gif";
    $("y_img_vc_url").src  = YGV_SkinPath + "/vc_close.gif";
}


/* nick */
function YFN_NickChangeShow()
{
    $("y_dv_mynick_show").style.display = "none";
    $("y_dv_mynick_ctrl").style.display = "block";
    $("y_tx_list_mynick").focus();
}

function YFN_NickChangeClose()
{
    $("y_dv_mynick_show").style.display = "block";
    $("y_dv_mynick_ctrl").style.display = "none";
}

function YFN_NickKeypress(argEvent)
{
    var obj;

    if (argEvent.srcElement)
    {
        obj = $(argEvent.srcElement.id);
    }
    else if (argEvent.target)
    {
        obj = $(argEvent.target.id);
    }

    if (argEvent.keyCode == 13)
    {
        YFN_NickCheck(obj);
    }
}

function YFN_NickCheck(argObj)
{
    YGV_TempNick = $F(argObj);
    var strLen   = YGV_TempNick.length;
    var notAllow = " ~!@#$%^&*()_+|`-={}:<>?[];,.\/\"\'\\\b\f\n\r\t";

    if (strLen < YGV_NickMinLen || strLen > YGV_NickMaxLen)
    {
        alert("이름은 " + YGV_NickMinLen + "자 이상, " + YGV_NickMaxLen + "자 이하이어야 합니다.");
        YGV_TempNick = "";
        return;
    }

    for (var i = 0; i < strLen; i++)
    {
        if (notAllow.indexOf(YGV_TempNick.substr(i, 1)) != -1)
        {
            alert("특수문자 및 빈칸이 포함된 이름은 사용할 수 없습니다.");
            YGV_TempNick = "";
            return;
        }
    }

    YFN_NickSend(argObj);
}

function YFN_NickSend(argObj)
{
    var func;

    if (argObj.id == "y_tx_list_mynick")
    {
        func = YFN_NickActionList;
    }
    else if (argObj.id == "y_tx_chat_mynick")
    {
        func = YFN_NickActionChat;
    }
    else
    {
        func = null;
    }

    var reqUrl = YGV_Path + "/nick_proc.php";
    var data   = "";
    data  = "";
    data += "sid=" + YGV_Site;
    data += "&main=" + YFN_GetCookie(YGV_CookMain);
    data += "&sub=" + YFN_GetCookie(YGV_CookSub);
    data += "&nick=" + encodeURIComponent(YGV_TempNick);
    //document.location.href = reqUrl + "?" + data;

    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: func
        }
    );
}

function YFN_NickActionList(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            YFN_SetCookie(YGV_CookNick, YGV_TempNick, "/", 7);

            $("y_sp_list_mynick").innerHTML = YGV_TempNick + " (" + YFN_GetCookie(YGV_CookMain).substr(0, 4) + ")";
            $("y_tx_list_mynick").value = "";
            YFN_NickChangeClose();
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}

function YFN_NickActionChat(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            var mainid   = YFN_GetCookie(YGV_CookMain);
            var prevNick = YFN_GetCookie(YGV_CookNick);
            var nextNick = YGV_TempNick;

            YFN_SetCookie(YGV_CookNick, nextNick, "/", 7);
            $("y_sp_list_mynick").innerHTML = nextNick + " (" + mainid.substr(0, 4) + ")";
            $("y_dv_chat_user_self").innerHTML = "<img src=\"" + YGV_SkinPath + "/i.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"나\" /> " + nextNick + " (" + mainid.substr(0, 4) + ")";
            $("y_tx_chat_mynick").value = "";
            $("y_txa_chat").focus();
            YFN_ChatUserAlert("<div class=\"y_chat_alert\">변경: " + prevNick + " (" + mainid.substr(0, 4) + ") 님 → " + nextNick + "</div>");
            YFN_ChatScrollMove();
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}


/* write memo */
function YFN_WriteMemoArea()
{
    var str = "";
    str += "<div id=\"y_dv_write\">";
    str += "<form onsubmit='return false;'>";
    str += YGV_TableInnerTop;
    str += "    <div id=\"y_dv_write_to\"><span id=\"y_sp_write_to\"></span></div>";
    str += "    <div id=\"y_dv_write_txa\">";
    str += "        <div><textarea id=\"y_txa_write\" onkeypress=\"YFN_WriteMemoKeypress(event);\"></textarea></div>";
    str += "        <div id=\"y_dv_write_send\"><img src=\"" + YGV_SkinPath + "/memo_send_01.gif\" width=\"57\" height=\"27\" border=\"0\" alt=\"보내기\" onclick=\"YFN_WriteMemoCheck();\" onmouseover=\"YFN_TextDecoration(this, 'u'); YFN_ImgOverOut(this, 'memo_send_02.gif');\" onmouseout=\"YFN_TextDecoration(this, 'n'); YFN_ImgOverOut(this, 'memo_send_01.gif');\" /></div>";
    str += "    </div>";
    str += YGV_TableInnerBottom;
    str += "<input type=\"hidden\" id=\"y_hd_write_to_mainid\">";
    str += "<input type=\"hidden\" id=\"y_hd_write_to_subid\">";
    str += "</form>";
    str += "</div>";
    return str;
}

function YFN_WriteMemoShow(argMainId, argSubId, argNick)
{
    if (YGV_WinWriteMemo)
    {
        YFN_WriteMemoPutValue(argMainId, argSubId, argNick);
        YGV_WinWriteMemo.toFront();
        setTimeout("$('y_txa_write').focus()", 100);
    }
    else
    {
        var titStr = "";
        titStr += "<a href=\"http://www.yagne.com/\" target=\"_blank\">";
        titStr += "<img src=\"" + YGV_SkinPath + "/yag_logo_s.gif\" width=\"32\" height=\"21\" border=\"0\" alt=\"yag\"/>";
        titStr += "</a>";
        titStr += "<span style='padding-left:10px;'>쪽지 보내기</span>";

        var win = new Window("winWriteMemo", {className: "dialog", title: titStr,
                                           top: YGV_WriteMemoTop, left: YGV_WriteMemoLeft, width: YGV_WriteMemoBW, height: YGV_WriteMemoBH, minWidth: YGV_WriteMemoMW, minHeight: YGV_WriteMemoMH,
                                           resizable: true, closable: true, minimizable:true, maximizable: true, draggable: true,
                                           showEffectOptions: {duration: 0}, hideEffectOptions: {duration: 0}});
        win.getContent().innerHTML = YFN_WriteMemoArea();
        YFN_ResizeWriteMemo(win);
        win.toFront();
        win.showCenter();

        YFN_WriteMemoPutValue(argMainId, argSubId, argNick);
        setTimeout("$('y_txa_write').focus()", 100);

        var winTop  = parseInt(YGV_WinWriteMemo.getLocation().top);
        var winLeft = parseInt(YGV_WinWriteMemo.getLocation().left);
        var scrTop  = parseInt(WindowUtilities.getWindowScroll().top);
        var scrLeft = parseInt(WindowUtilities.getWindowScroll().left);
        YGV_WriteMemoSpaceH = winTop - scrTop;
        YGV_WriteMemoSpaceW = winLeft - scrLeft;
        YFN_WriteMemoMagicFollow();
    }
}

function YFN_WriteMemoPutValue(argMainId, argSubId, argNick)
{
    $("y_hd_write_to_mainid").value = argMainId;
    $("y_hd_write_to_subid").value = argSubId;
    $("y_sp_write_to").innerHTML = "To. " + argNick + " (" + argMainId.substr(0, 4) + ")";
    $("y_txa_write").value = "";
}

function YFN_WriteMemoMagicFollow()
{
    var interval = 500;
    var winTop, winLeft, scrTop, scrLeft, tempSpaceW, tempSpaceH, disW, disH;

    if (YGV_WinWriteMemo)
    {
        if (YGV_WriteMemoMagic == "Y")
        {
            winTop     = parseInt(YGV_WinWriteMemo.getLocation().top);
            winLeft    = parseInt(YGV_WinWriteMemo.getLocation().left);
            scrTop     = parseInt(WindowUtilities.getWindowScroll().top);
            scrLeft    = parseInt(WindowUtilities.getWindowScroll().left);
            tempSpaceH = winTop - scrTop;
            tempSpaceW = winLeft - scrLeft;

            if ((YGV_WriteMemoSpaceH != tempSpaceH) || (YGV_WriteMemoSpaceW != tempSpaceW))
            {
                disH = Math.ceil(Math.abs(YGV_WriteMemoSpaceH - tempSpaceH) / 2);
                disW = Math.ceil(Math.abs(YGV_WriteMemoSpaceW - tempSpaceW) / 2);

                if (YGV_WriteMemoSpaceH < tempSpaceH)
                {
                    disH = -disH;
                }

                if (YGV_WriteMemoSpaceW < tempSpaceW)
                {
                    disW = -disW;
                }

                disW = 0; // do not follow by horizontal scroll

                YGV_WinWriteMemo.setLocation(winTop + disH, winLeft + disW);
                interval = 20;
            }
        }

        YGV_WriteMagicTimeId = setTimeout("YFN_WriteMemoMagicFollow()", interval);
    }
}

function YFN_WriteMemoClose()
{
    if (YGV_WinWriteMemo)
    {
        YGV_WinWriteMemo.destroy();
        YGV_WinWriteMemo = null;
    }
}

function YFN_WriteMemoKeypress(argEvent)
{
    if (argEvent.keyCode == 13)
    {
        YFN_WriteMemoCheck();
    }
}

function YFN_WriteMemoCheck()
{
    var obj = $("y_txa_write");
    var str = YFN_ContentCheck(obj);

    if (str == "")
    {
        alert("내용을 입력하세요.");
        obj.value = "";
        obj.focus();
    }
    else
    {
        obj.blur();
        YFN_WriteMemoSend(str);
    }
}

function YFN_WriteMemoSend(argStr)
{
    var reqUrl = YGV_Path + "/memo_proc.php";
    var data   = "";
    data  = "";
    data += "sid=" + YGV_Site;
    data += "&flag=write";
    data += "&rcvmain=" + $F("y_hd_write_to_mainid");
    data += "&rcvsub=" + $F("y_hd_write_to_subid");
    data += "&sndmain=" + YFN_GetCookie(YGV_CookMain);
    data += "&sndsub=" + YFN_GetCookie(YGV_CookSub);
    data += "&msg=" + encodeURIComponent(argStr);
    //document.location.href = reqUrl + "?" + data;

    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: YFN_WriteMemoAction
        }
    );
}

function YFN_WriteMemoAction(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            YGV_WinWriteMemo.setStatusBar("쪽지를 보냈습니다.");
            setTimeout("YFN_WriteMemoClose()", 300);
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}


/* receive[_reply] memo */
function YFN_FillupRcvMemoList(argList)
{
    var cnt = argList.length;
    var sn, rcvMainId, rcvSubId, sndMainId, sndSubId, sndNick, message, sndTime;
    var obj, str;
    var fsn = 0;

    for (var i = 0; i < cnt; i++)
    {
        sn        = argList[i].childNodes[0].firstChild.nodeValue;
        rcvMainId = argList[i].childNodes[1].firstChild.nodeValue;
        rcvSubId  = argList[i].childNodes[2].firstChild.nodeValue;
        sndMainId = argList[i].childNodes[3].firstChild.nodeValue;
        sndSubId  = argList[i].childNodes[4].firstChild.nodeValue;
        sndNick   = argList[i].childNodes[5].firstChild.nodeValue;
        message   = argList[i].childNodes[6].firstChild.nodeValue;
        sndTime   = argList[i].childNodes[7].firstChild.nodeValue;

        if (i == 0)
        {
            fsn = sn;
        }

        obj = document.createElement("div");
        obj.id = "y_dv_plus_memo_" + sn;
        str = "";
        str += "<form>";
        str += "<input type=\"hidden\" id=\"y_hd_plus_sn_" + sn + "\" value=\""+ sn + "\">";
        str += "<input type=\"hidden\" id=\"y_hd_plus_sndmainid_" + sn + "\" value=\""+ sndMainId + "\">";
        str += "<input type=\"hidden\" id=\"y_hd_plus_sndsubid_" + sn + "\" value=\""+ sndSubId + "\">";
        str += "<input type=\"hidden\" id=\"y_hd_plus_sndnick_" + sn + "\" value=\""+ sndNick + "\">";
        str += "<input type=\"hidden\" id=\"y_hd_plus_sndtime_" + sn + "\" value=\""+ sndTime + "\">";
        str += "<textarea id=\"y_txa_plus_msg_" + sn + "\">"+ message + "</textarea>";
        str += "</form>";
        obj.innerHTML = str;
        $("y_dv_plus_memo_list").appendChild(obj);
    }

    if (fsn != 0)
    {
        if (YGV_WinReceiveMemo)
        {
            YFN_ReceiveMemoCount(0);
            YGV_WinReceiveMemo.toFront();
            YFN_ReceiveMemoNew();
        }
        else
        {
            YFN_ReceiveMemoShow(fsn, true);
        }
    }
}

function YFN_ReceiveMemoArea()
{
    var str = "";
    str += "<div id=\"y_dv_receive\">";
    str += "<form onsubmit='return false;'>";
    str += YGV_TableInnerTop;
    str += "    <div id=\"y_dv_rcv_top\">";
    str += "        <div id=\"y_dv_rcv_from\">";
    str += "            <span id=\"y_sp_rcv_from\"></span>&nbsp;<span id=\"y_sp_rcv_sndtime\"></span>";
    str += "        </div>";
    str += "        <div id=\"y_dv_plus_paging\">";
    str += "            <span id=\"y_sp_plus_paging\">";
    str += "                <span id=\"y_sp_plus_prev\" onclick=\"YFN_ReceiveMemoPrevNext(\'P\');\" onmouseover=\"YFN_TextDecoration(this, \'u\');\" onmouseout=\"YFN_TextDecoration(this, \'n\');\">◀</span><span id=\"y_sp_plus_next\" onclick=\"YFN_ReceiveMemoPrevNext(\'N\');\" onmouseover=\"YFN_TextDecoration(this, \'u\');\" onmouseout=\"YFN_TextDecoration(this, \'n\');\">▶</span>";
    str += "            </span>";
    str += "            (<span id=\"y_sp_plus_cur\"></span>/<span id=\"y_sp_plus_tot\"></span>)";
    str += "        </div>";
    str += "    </div>";
    str += "    <div id=\"y_dv_rcv_msg\"></div>";
    str += YGV_TableInnerBottom;
    str += "    <div id=\"y_dv_rcv_reply\">";
    str += YGV_TableInnerTop;
    str += "        <div id=\"y_dv_rcv_txa\"><textarea id=\"y_txa_rcv\" onkeypress=\"YFN_ReplyMemoKeypress(event);\"></textarea></div>";
    str += "        <div id=\"y_dv_rcv_send\"><img src=\"" + YGV_SkinPath + "/memo_send_01.gif\" width=\"57\" height=\"27\" border=\"0\" alt=\"보내기\" onclick=\"YFN_ReplyMemoCheck();\" onmouseover=\"YFN_TextDecoration(this, 'u'); YFN_ImgOverOut(this, 'memo_send_02.gif');\" onmouseout=\"YFN_TextDecoration(this, 'n'); YFN_ImgOverOut(this, 'memo_send_01.gif');\" /></div>";
    str += YGV_TableInnerBottom;
    str += "    </div>";
    str += "<input type=\"hidden\" id=\"y_hd_rcv_sn\">";
    str += "<input type=\"hidden\" id=\"y_hd_rcv_sndmainid\">";
    str += "<input type=\"hidden\" id=\"y_hd_rcv_sndsubid\">";
    str += "</form>";
    str += "</div>";
    return str;
}

function YFN_ReceiveMemoShow(argSn, argNew)
{
    if (YGV_WinReceiveMemo)
    {
        YFN_ReceiveMemoPutValue(argSn);
        YGV_WinReceiveMemo.setStatusBar("&nbsp;");
        YGV_WinReceiveMemo.toFront();
        YGV_WinReceiveMemo.show();
    }
    else
    {
        if (YGV_ReceiveMemoTop == 0 && YGV_ReceiveMemoLeft == 0)
        {
            YGV_ReceiveMemoTop  = WindowUtilities.getWindowScroll().height + WindowUtilities.getWindowScroll().top - YGV_ReceiveMemoBH - 60;
            YGV_ReceiveMemoLeft = WindowUtilities.getWindowScroll().width + WindowUtilities.getWindowScroll().left - YGV_ReceiveMemoBW - 50;
        }

        var titStr = "";
        titStr += "<a href=\"http://www.yagne.com/\" target=\"_blank\">";
        titStr += "<img src=\"" + YGV_SkinPath + "/yag_logo_s.gif\" width=\"32\" height=\"21\" border=\"0\" alt=\"yag\"/>";
        titStr += "</a>";
        titStr += "<span style='padding-left:10px;'>받은 쪽지</span>";

        var win = new Window("winReceiveMemo", {className: "dialog", title: titStr,
                                           top: YGV_ReceiveMemoTop, left: YGV_ReceiveMemoLeft, width: YGV_ReceiveMemoBW, height: YGV_ReceiveMemoBH, minWidth: YGV_ReceiveMemoMW, minHeight: YGV_ReceiveMemoMH,
                                           resizable: true, closable: true, minimizable:true, maximizable: true, draggable: true,
                                           showEffectOptions: {duration: 0}, hideEffectOptions: {duration: 0}});
        win.getContent().innerHTML = YFN_ReceiveMemoArea();
        YFN_ResizeReceiveMemo(win);
        YFN_ReceiveMemoPutValue(argSn);
        //win.setStatusBar("&nbsp;");
        win.toFront();
        win.show();

        var winTop  = parseInt(win.getLocation().top);
        var winLeft = parseInt(win.getLocation().left);
        var scrTop  = parseInt(WindowUtilities.getWindowScroll().top);
        var scrLeft = parseInt(WindowUtilities.getWindowScroll().left);
        YGV_ReceiveMemoSpaceH = winTop - scrTop;
        YGV_ReceiveMemoSpaceW = winLeft - scrLeft;
        YFN_ReceiveMemoMagicFollow();
    }

    if (argNew)
    {
        //YFN_ReceiveMemoNew();
    }
}

function YFN_ReceiveMemoNew()
{
    new Effect.Pulsate("y_sp_plus_next", {duration:5, from:0.2});
}

function YFN_ReceiveMemoPutValue(argSn)
{
    var obj = $("y_dv_plus_memo_list");
    var cnt = obj.childNodes.length;
    var sn;

    if (cnt < 1)
    {
        return;
    }

    if ($("y_dv_plus_memo_" + argSn))
    {
        sn = argSn;
    }
    else
    {
        sn = obj.childNodes[0].firstChild.childNodes[0].value;
    }

    $("y_hd_rcv_sn").value          = $F("y_hd_plus_sn_" + sn);
    $("y_hd_rcv_sndmainid").value   = $F("y_hd_plus_sndmainid_" + sn);
    $("y_hd_rcv_sndsubid").value    = $F("y_hd_plus_sndsubid_" + sn);
    $("y_sp_rcv_from").innerHTML    = $F("y_hd_plus_sndnick_" + sn) + " (" + $F("y_hd_rcv_sndmainid").substr(0, 4) + ")";
    $("y_sp_rcv_sndtime").innerHTML = $F("y_hd_plus_sndtime_" + sn).substr(11);
    $("y_dv_rcv_msg").innerHTML     = YFN_HtmlReg($F("y_txa_plus_msg_" + sn));
    $("y_txa_rcv").value            = "";

    YFN_ReceiveMemoCount(sn);
}

function YFN_ReceiveMemoCount(argSn)
{
    var obj = $("y_dv_plus_memo_list");
    var cnt = obj.childNodes.length;
    var cur = 0;

    if (cnt < 1)
    {
        return;
    }

    for (var i = 0; i < cnt; i++)
    {
        if (obj.childNodes[i].firstChild.childNodes[0])
        {
            if (argSn == obj.childNodes[i].firstChild.childNodes[0].value)
            {
                cur = i + 1;
                break;
            }
        }
        else // for opera
        {
            if (argSn == obj.childNodes[i].firstChild.value)
            {
                cur = i + 1;
                break;
            }
        }
    }

    if (cur != 0)
    {
        $("y_sp_plus_cur").innerHTML = cur;
    }
    $("y_sp_plus_tot").innerHTML = cnt;

    if (cnt > 1)
    {
        $("y_sp_plus_paging").style.display = "inline";
    }
    else
    {
        $("y_sp_plus_paging").style.display = "none";
    }
}

function YFN_ReceiveMemoPrevNext(argFlag)
{
    var obj = $("y_dv_plus_memo_list");
    var cnt = obj.childNodes.length;
    var curSn = $("y_hd_rcv_sn").value;
    var cur;

    for (var i = 0; i < cnt; i++)
    {
        if (curSn == obj.childNodes[i].firstChild.childNodes[0].value)
        {
            cur = i;
            break;
        }
    }

    if (argFlag == "P")
    {
        if (cur == 0)
        {
            return;
        }
        else if (obj.childNodes[cur - 1])
        {
            YFN_ReceiveMemoShow(obj.childNodes[cur - 1].firstChild.childNodes[0].value, false)
            return;
        }
    }
    else if (argFlag == "N")
    {
        if (cur == cnt)
        {
        }
        else if (obj.childNodes[i + 1])
        {
            YFN_ReceiveMemoShow(obj.childNodes[cur + 1].firstChild.childNodes[0].value, false)
            return;
        }
    }
}

function YFN_ReceiveMemoCloseSend()
{
    var sn = $("y_hd_rcv_sn").value;

    var reqUrl = YGV_Path + "/memo_proc.php";
    var data   = "";
    data  = "";
    data += "sid=" + YGV_Site;
    data += "&flag=close";
    data += "&main=" + YFN_GetCookie(YGV_CookMain);
    data += "&sub=" + YFN_GetCookie(YGV_CookSub);
    data += "&sn=" + sn;
    //document.location.href = reqUrl + "?" + data;

    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: YFN_ReceiveMemoCloseAction
        }
    );
}

function YFN_ReceiveMemoCloseAction(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            var obj = $("y_dv_plus_memo_list");
            var sn = $("y_hd_rcv_sn").value;
            obj.removeChild($("y_dv_plus_memo_" + sn));

            var cnt = obj.childNodes.length;
            if (cnt > 0)
            {
                YFN_ReceiveMemoShow(obj.childNodes[0].firstChild.childNodes[0].value, false);
            }
            else
            {
                YFN_ReceiveMemoClose();
            }
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}

function YFN_ReceiveMemoMagicFollow()
{
    var interval = 500;
    var winTop, winLeft, scrTop, scrLeft, tempSpaceW, tempSpaceH, disW, disH;

    if (YGV_WinReceiveMemo)
    {
        if (YGV_ReceiveMemoMagic == "Y")
        {
            winTop     = parseInt(YGV_WinReceiveMemo.getLocation().top);
            winLeft    = parseInt(YGV_WinReceiveMemo.getLocation().left);
            scrTop     = parseInt(WindowUtilities.getWindowScroll().top);
            scrLeft    = parseInt(WindowUtilities.getWindowScroll().left);
            tempSpaceH = winTop - scrTop;
            tempSpaceW = winLeft - scrLeft;

            if ((YGV_ReceiveMemoSpaceH != tempSpaceH) || (YGV_ReceiveMemoSpaceW != tempSpaceW))
            {
                disH = Math.ceil(Math.abs(YGV_ReceiveMemoSpaceH - tempSpaceH) / 2);
                disW = Math.ceil(Math.abs(YGV_ReceiveMemoSpaceW - tempSpaceW) / 2);

                if (YGV_ReceiveMemoSpaceH < tempSpaceH)
                {
                    disH = -disH;
                }

                if (YGV_ReceiveMemoSpaceW < tempSpaceW)
                {
                    disW = -disW;
                }

                disW = 0; // do not follow by horizontal scroll

                YGV_WinReceiveMemo.setLocation(winTop + disH, winLeft + disW);
                interval = 20;
            }
        }

        YGV_ReceiveMagicTimeId = setTimeout("YFN_ReceiveMemoMagicFollow()", interval);
    }
}

function YFN_ReceiveMemoClose()
{
    if (YGV_WinReceiveMemo)
    {
        YGV_WinReceiveMemo.destroy();
        YGV_WinReceiveMemo = null;
        YGV_ReceiveMemoTop  = 0;
        YGV_ReceiveMemoLeft = 0;
    }
}

function YFN_ReplyMemoKeypress(argEvent)
{
    if (argEvent.keyCode == 13)
    {
        YFN_ReplyMemoCheck();
    }
}

function YFN_ReplyMemoCheck()
{
    var obj = $("y_txa_rcv");
    var str = YFN_ContentCheck(obj);

    if (str == "")
    {
        alert("내용을 입력하세요.");
        obj.value = "";
        obj.focus();
    }
    else
    {
        YFN_ReplyMemoSend(str);
    }
}

function YFN_ReplyMemoSend(argStr)
{
    var reqUrl = YGV_Path + "/memo_proc.php";
    var data   = "";
    data  = "";
    data += "sid=" + YGV_Site;
    data += "&flag=write";
    data += "&rcvmain=" + $F("y_hd_rcv_sndmainid");
    data += "&rcvsub=" + $F("y_hd_rcv_sndsubid");
    data += "&sndmain=" + YFN_GetCookie(YGV_CookMain);
    data += "&sndsub=" + YFN_GetCookie(YGV_CookSub);
    data += "&msg=" + encodeURIComponent(argStr);
    //document.location.href = reqUrl + "?" + data;

    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: YFN_ReplyMemoAction
        }
    );
}

function YFN_ReplyMemoAction(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            YGV_WinReceiveMemo.setStatusBar("쪽지를 보냈습니다.");
            setTimeout("YFN_ReceiveMemoCloseSend()", 300);
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}


/* chat */
function YFN_ChatStartByClick()
{
    if (YGV_ChatCnt == 0)
    {
        YFN_ChatRequest();
        YFN_SetCookie(YGV_CookChatStart, "Y", "/", "");
        $("y_img_vc_chat").src = YGV_SkinPath + "/vc_view.gif";
    }
}

function YFN_ChatStartByCookie()
{
    if (YGV_ChatCnt == 0)
    {
        if (YFN_GetCookie(YGV_CookChatStart) == "Y")
        {
            YFN_ChatRequest();
            $("y_img_vc_chat").src = YGV_SkinPath + "/vc_view.gif";
        }
    }
}

function YFN_ChatRequest()
{
    var reqUrl = YGV_Path + "/chat_start.php";
    var data   = "";
    data += "sid=" + YGV_Site;
    data += "&ccnt=" + YGV_ChatCnt;
    data += "&csn=" + YGV_ChatSn;
    data += "&main=" + YFN_GetCookie(YGV_CookMain);
    data += "&sub=" + YFN_GetCookie(YGV_CookSub);
    //document.location.href = reqUrl + "?" + data;

    YFN_ChatXhpMonitoring();
    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: YFN_ChatView,
            onFailure: YFN_ChatXhpError
        }
    );
    YGV_ChatXmlHttp = ajax.transport;
    YGV_ChatTimeId = setTimeout("YFN_ChatRequest()", YGV_ChatInterval);
}

function YFN_ChatXhpMonitoring()
{
    if (YGV_ChatXmlHttp)
    {
        YGV_ChatXmlHttp.onreadystatechange = function() {};
        YGV_ChatXmlHttp.abort();
    }
}

function YFN_ChatXhpError(argXml)
{
    //var str = "<div class=\"y_chat_alert\">" + argXml.status + "</div>";
    //YFN_ChatUserAlert(str);
    //YFN_ChatScrollMove();
}

function YFN_ChatView(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            // display
            YFN_ChatShow();

            // chat user list
            var chatUser = xml.getElementsByTagName("chatuserinfo");
            YFN_FillupChatUser(chatUser);

            // check in/out
            YFN_CheckChatUserInOut(chatUser);

            // chat log
            YFN_FillupChatLog(xml);

            YFN_ChatAlertClear();
            YGV_ChatCnt        = 1;
            YGV_ChatXmlHttp    = null;
        }
        else if (result == "cc overflow")
        {
            YFN_ChatOverflow();
        }
        else
        {
            $("y_dv_alert").style.display     = "block";
            $("y_dv_alert_content").innerHTML = result;
        }
    }
    catch (e)
    {
        $("y_dv_alert").style.display     = "block";
        $("y_dv_alert_content").innerHTML = e;
    }
}

function YFN_ChatOverflow()
{
    clearTimeout(YGV_ChatTimeId);
    YFN_SetCookie(YGV_CookChatStart, "N", "/", "");
    $("y_img_vc_chat").src = YGV_SkinPath + "/vc_close.gif";
    alert("대화방 최대 참여자 수가 초과되었습니다.");
}

function YFN_ChatAlertClear()
{
    YGV_ChatJoinSelfAlert = "";
    YGV_ChatJoinUserAlert = "";
    YGV_ChatOutUserAlert  = "";
}

function YFN_ChatArea()
{
    var str = "";
    str += "<div id=\"y_dv_chat\">";
    str += "<form onsubmit='return false;'>";
    str += "    <div id=\"y_dv_chat_body\">";
    str += "        <div id=\"y_dv_chat_body_left\">";
    str += YGV_TableInnerTop;
    str += "            <div id=\"y_dv_chat_frame\"></div>";
    str += YGV_TableInnerBottom;
    str += "        </div>";
    str += "        <div id=\"y_dv_chat_body_right\">";
    str += YGV_TableInnerTop;
    str += "            <div id=\"y_dv_chat_user\">";
    str += "                <div id=\"y_dv_chat_usercnt\">현재 <span id=\"y_sp_chat_usercnt\"></span>&nbsp;/&nbsp;<span id=\"y_sp_chat_usermax\"></span>&nbsp;명 참여</div>";
    str += "                <div id=\"y_dv_chat_user_self\"></div>";
    str += "                <div id=\"y_dv_chat_user_guest\"></div>";
    str += "            </div>";
    str += YGV_TableInnerBottom;
    str += "        </div>";
    str += "        <div id=\"y_dv_chat_body_bottom\">";
    str += "            <div id=\"y_dv_chat_mynick\">";
    str += "                대화명 <input type=\"text\" id=\"y_tx_chat_mynick\" maxlength=\"" + YGV_NickMaxLen + "\" onkeypress=\"YFN_NickKeypress(event);\">";
    str += "                <img src=\"" + YGV_SkinPath + "/change_01.gif\" width=\"43\" height=\"20\" border=\"0\" alt=\"변경\" onclick=\"YFN_NickCheck($('y_tx_chat_mynick'));\" onmouseover=\"YFN_TextDecoration(this, 'u'); YFN_ImgOverOut(this, 'change_02.gif');\" onmouseout=\"YFN_TextDecoration(this, 'n'); YFN_ImgOverOut(this, 'change_01.gif');\" />";
    str += "            </div>";
    str += YGV_TableInnerTop;
    str += "            <div>";
    str += "                <div id=\"y_dv_chat_write\"><textarea id=\"y_txa_chat\" onkeydown=\"YFN_ChatKeyDown(event);\"></textarea></div>";
    str += "                <div id=\"y_dv_chat_send\"><img src=\"" + YGV_SkinPath + "/chat_send_01.gif\" width=\"42\" height=\"40\" border=\"0\" alt=\"보내기\" onclick=\"YFN_ChatWriteCheck();\" onmouseover=\"YFN_TextDecoration(this, 'u'); YFN_ImgOverOut(this, 'chat_send_02.gif');\" onmouseout=\"YFN_TextDecoration(this, 'n'); YFN_ImgOverOut(this, 'chat_send_01.gif');\" /></div>";
    str += "            </div>";
    str += YGV_TableInnerBottom;
    str += "        </div>";
    str += "    </div>";
    str += "</form>";
    str += "</div>";
    return str;
}

function YFN_ChatShow()
{
    if (!YGV_WinChatRoom)
    {
        var titStr = "";
        titStr += "<a href=\"http://www.yagne.com/\" target=\"_blank\">";
        titStr += "<img src=\"" + YGV_SkinPath + "/yag_logo_s.gif\" width=\"32\" height=\"21\" border=\"0\" alt=\"yag\"/>";
        titStr += "</a>";
        titStr += "<span style='padding-left:10px;'>대화방</span>";

        var win = new Window("winChatRoom", {className: "dialog", title: titStr,
                                           top: YGV_ChatRoomTop, left: YGV_ChatRoomLeft, width: YGV_ChatRoomBW, height: YGV_ChatRoomBH, minWidth: YGV_ChatRoomMW, minHeight: YGV_ChatRoomMH,
                                           resizable: true, closable: true, minimizable:true, maximizable: true, draggable: true,
                                           showEffectOptions: {duration: 0}, hideEffectOptions: {duration: 0}});
        win.getContent().innerHTML = YFN_ChatArea();
        YFN_ResizeChatRoom(win);
        win.toFront();
        win.showCenter();
        setTimeout("$('y_txa_chat').focus()", 100);

        var winTop  = parseInt(YGV_WinChatRoom.getLocation().top);
        var winLeft = parseInt(YGV_WinChatRoom.getLocation().left);
        var scrTop  = parseInt(WindowUtilities.getWindowScroll().top);
        var scrLeft = parseInt(WindowUtilities.getWindowScroll().left);
        YGV_ChatRoomSpaceH = winTop - scrTop;
        YGV_ChatRoomSpaceW = winLeft - scrLeft;
        YFN_ChatMagicFollow();
    }
}

function YFN_ChatMagicFollow()
{
    var interval = 500;
    var winTop, winLeft, scrTop, scrLeft, tempSpaceW, tempSpaceH, disW, disH;

    if (YGV_WinChatRoom)
    {
        if (YGV_ChatRoomMagic == "Y")
        {
            winTop     = parseInt(YGV_WinChatRoom.getLocation().top);
            winLeft    = parseInt(YGV_WinChatRoom.getLocation().left);
            scrTop     = parseInt(WindowUtilities.getWindowScroll().top);
            scrLeft    = parseInt(WindowUtilities.getWindowScroll().left);
            tempSpaceH = winTop - scrTop;
            tempSpaceW = winLeft - scrLeft;

            if ((YGV_ChatRoomSpaceH != tempSpaceH) || (YGV_ChatRoomSpaceW != tempSpaceW))
            {
                disH = Math.ceil(Math.abs(YGV_ChatRoomSpaceH - tempSpaceH) / 2);
                disW = Math.ceil(Math.abs(YGV_ChatRoomSpaceW - tempSpaceW) / 2);

                if (YGV_ChatRoomSpaceH < tempSpaceH)
                {
                    disH = -disH;
                }

                if (YGV_ChatRoomSpaceW < tempSpaceW)
                {
                    disW = -disW;
                }

                disW = 0; // do not follow by horizontal scroll

                YGV_WinChatRoom.setLocation(winTop + disH, winLeft + disW);
                interval = 20;
            }
        }

        YGV_ChatMagicTimeId = setTimeout("YFN_ChatMagicFollow()", interval);
    }
}

function YFN_FillupChatUser(argList)
{
    var cnt = argList.length;

    // fillup count
    $("y_sp_chat_usercnt").innerHTML = cnt + 1;
    $("y_sp_chat_usermax").innerHTML = YGV_MaxChat;
    $("y_sp_chatcnt").innerHTML = cnt + 1;
    $("y_sp_chatmax").innerHTML = YGV_MaxChat;

    // fillup self
    var s_mainid, s_nick;
    s_mainid = YFN_GetCookie(YGV_CookMain);
    s_nick   = YFN_GetCookie(YGV_CookNick);

    if (s_nick == "")
    {
        s_nick = "나";
    }
    $("y_dv_chat_user_self").innerHTML = "<img src=\"" + YGV_SkinPath + "/i.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"나\" /> " + s_nick + " (" + s_mainid.substr(0, 4) + ")";

    if (YGV_ChatCnt == 0)
    {
        YGV_ChatJoinSelfAlert += "<div class=\"y_chat_alert\">" + new Date().toLocaleString() + "</div>";
    }

    // fillup chat user
    var u_mainid, u_subid, u_nick;
    var str = "";
    var icon, adm_nick;

    for (var i = 0; i < cnt; i++)
    {
        u_mainid = argList[i].childNodes[0].firstChild.nodeValue;
        u_subid  = argList[i].childNodes[1].firstChild.nodeValue;
        u_nick   = argList[i].childNodes[2].firstChild.nodeValue;

        if (YGV_AdmMid != "" && u_mainid == YGV_AdmMid)
        {
            icon = "<img src=\"" + YGV_SkinPath + "/sysop.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"사이트지기\" />";
            if (u_nick == "" || u_nick == "손님")
            {
                u_nick = "사이트지기";
            }
        }
        else
        {
            icon = "<img src=\"" + YGV_SkinPath + "/guest.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"손님\" />";
        }

        str += "<div>";
        str += "<span>" + icon + "</span>&nbsp;";
        str += "<span onclick=\"YFN_WriteMemoShow(\'" + u_mainid + "\', \'" + u_subid + "\', \'" + u_nick + "\');\" onmouseover=\"YFN_TextDecoration(this, \'u\');\" onmouseout=\"YFN_TextDecoration(this, \'n\');\" title=\"쪽지보내기\">";
        str += u_nick + " (" + u_mainid.substr(0, 4) + ")";
        str += "</span> ";

        if (YFN_CheckDenyChatUser(u_mainid))
        {
            str += "<img src=\"" + YGV_SkinPath + "/speak_on.gif\" width=\"9\" height=\"9\" border=\"0\" onclick=\"YFN_DenyChatUserChange(\'" + u_mainid + "\', this);\" onmouseover=\"YFN_TextDecoration(this, \'u\');\" onmouseout=\"YFN_TextDecoration(this, \'n\');\" />";
        }
        else
        {
            str += "<img src=\"" + YGV_SkinPath + "/speak_off.gif\" width=\"9\" height=\"9\" border=\"0\" onclick=\"YFN_DenyChatUserChange(\'" + u_mainid + "\', this);\" onmouseover=\"YFN_TextDecoration(this, \'u\');\" onmouseout=\"YFN_TextDecoration(this, \'n\');\" />";
        }
        str += "</div>";
    }
    $("y_dv_chat_user_guest").innerHTML = str;
}

function YFN_CheckDenyChatUser(argMainId)
{
    var len = YGV_ChatDenyUserArray.length;

    for (var i = 0; i < len; i++)
    {
        if (argMainId == YGV_ChatDenyUserArray[i])
        {
            return false;
        }
    }
    return true;
}

function YFN_DenyChatUserChange(argMainId, argObj)
{
    var len = YGV_ChatDenyUserArray.length;
    var deny = "N";

    for (var i = 0; i < len; i++)
    {
        if (argMainId == YGV_ChatDenyUserArray[i])
        {
            deny = "Y";
            break;
        }
    }

    if (deny == "Y")
    {
        argObj.src = YGV_SkinPath + "/speak_on.gif"
        YFN_DenyChatUserReInit(argMainId);
    }
    else if (deny == "N")
    {
        argObj.src = YGV_SkinPath + "/speak_off.gif"
        YGV_ChatDenyUserArray[len] = argMainId;
    }
}

function YFN_DenyChatUserReInit(argMainId)
{
    var tmp = new Array();
    var len = YGV_ChatDenyUserArray.length;

    for (var i = 0; i < len; i++)
    {
        if (YGV_ChatDenyUserArray[i] == argMainId)
        {
            YGV_ChatDenyUserArray[i] = "";
        }

        if (YGV_ChatDenyUserArray[i] != "")
        {
            tmp[tmp.length] = YGV_ChatDenyUserArray[i];
        }
    }

    YGV_ChatDenyUserArray = tmp;
}

function YFN_CheckChatUserInOut(argList)
{
    var cnt = argList.length;
    var _inout, u_mainid, u_subid, u_nick, a_mainid, a_nick;
    var tmp = new Array();
    var len = YGV_ChatJoinUserArray.length;
    var sep = "[##]";
    var str = "";

    // chat user in check
    for (var i = 0; i < cnt; i++)
    {
        u_mainid = argList[i].childNodes[0].firstChild.nodeValue;
        u_subid  = argList[i].childNodes[1].firstChild.nodeValue;
        u_nick   = argList[i].childNodes[2].firstChild.nodeValue;

        tmp[tmp.length] = u_mainid + sep + u_nick;

        _inout  = "in";
        _change = "N";

        for (var j = 0; j < len; j++)
        {
            a_mainid = String(YGV_ChatJoinUserArray[j]).split(sep)[0];
            a_nick   = String(YGV_ChatJoinUserArray[j]).split(sep)[1];

            if (u_mainid == a_mainid)
            {
                _inout = "";

                if (u_nick != a_nick)
                {
                    _change = "Y";
                }
                break;
            }
        }

        if (_inout == "in")
        {
            YGV_ChatJoinUserAlert += "<div class=\"y_chat_alert\">입장: " + u_nick + " (" + u_mainid.substr(0, 4) + ") 님</div>";
        }

        if (_change == "Y")
        {
            YGV_ChatJoinUserAlert += "<div class=\"y_chat_alert\">변경: " + a_nick + " (" + u_mainid.substr(0, 4) + ") 님 → " + u_nick + "</div>";
        }
    }

    // chat user out check
    for (var i = 0; i < len; i++)
    {
        _inout   = "out";
        a_mainid = String(YGV_ChatJoinUserArray[i]).split(sep)[0];
        a_nick   = String(YGV_ChatJoinUserArray[i]).split(sep)[1];

        for (var j = 0; j < cnt; j++)
        {
            u_mainid = argList[j].childNodes[0].firstChild.nodeValue;
            u_subid  = argList[j].childNodes[1].firstChild.nodeValue;
            u_nick   = argList[j].childNodes[2].firstChild.nodeValue;

            if (a_mainid == u_mainid)
            {
                _inout = "";
                break;
            }
        }

        if (_inout == "out")
        {
            YGV_ChatOutUserAlert += "<div class=\"y_chat_alert\">퇴장: " + a_nick + " (" + a_mainid.substr(0, 4) + ") 님</div>";
        }
    }

    YGV_ChatJoinUserArray = tmp;
}

function YFN_FillupChatLog(argXml)
{
    var c_log, c_cnt, obj, len, denyUser;
    var sn, u_mainid, u_subid, u_nick, msg;
    var chatframe = $("y_dv_chat_frame");
    var scroll = "N";
    var d_len = YGV_ChatDenyUserArray.length;

    if (YGV_ChatJoinUserAlert != "" && YGV_ChatCnt != 0)
    {
        YFN_ChatUserAlert(YGV_ChatJoinUserAlert);
        scroll = "Y";
    }

    if (argXml.getElementsByTagName("newlog")[0].firstChild.nodeValue == "Y")
    {
        c_log = argXml.getElementsByTagName("chatloginfo");
        c_cnt = c_log.length;

        for (var i = 0; i < c_cnt; i++)
        {
            sn       = c_log[i].childNodes[0].firstChild.nodeValue;
            u_mainid = c_log[i].childNodes[1].firstChild.nodeValue;
            u_subid  = c_log[i].childNodes[2].firstChild.nodeValue;
            u_nick   = c_log[i].childNodes[3].firstChild.nodeValue;
            msg      = c_log[i].childNodes[4].firstChild.nodeValue;

            denyUser = "N";
            for (var j = 0; j < d_len; j++)
            {
                if (u_mainid == YGV_ChatDenyUserArray[j])
                {
                    denyUser = "Y";
                    break;
                }
            }

            if (denyUser != "Y")
            {
                if (YGV_AdmMid != "" && u_mainid == YGV_AdmMid)
                {
                    if (u_nick == "" || u_nick == "손님")
                    {
                        u_nick = "사이트지기";
                    }
                }
                obj = document.createElement("div");
                obj.innerHTML = "<div class=\"y_sp_chat_loger\">" + u_nick + "&nbsp;(" + u_mainid.substr(0, 4) + ") 님의 말 : </div><div class=\"y_sp_chat_logtext\">" + YFN_HtmlReg(msg) + "</div>";
                chatframe.appendChild(obj);
                scroll = "Y";
            }
        }
    }

    YGV_ChatSn = argXml.getElementsByTagName("chatmaxsn")[0].firstChild.nodeValue;

    if (YGV_ChatOutUserAlert != "" && YGV_ChatCnt != 0)
    {
        YFN_ChatUserAlert(YGV_ChatOutUserAlert);
        scroll = "Y";
    }

    if (YGV_ChatJoinSelfAlert != "")
    {
        YFN_ChatUserAlert(YGV_ChatJoinSelfAlert);
        scroll = "Y";
    }

    if (scroll == "Y")
    {
        YFN_ChatScrollMove();
    }
}

function YFN_ChatUserAlert(argStr)
{
    var obj = document.createElement("div");
    obj.innerHTML = argStr;
    $("y_dv_chat_frame").appendChild(obj);
}

function YFN_ChatScrollMove()
{
    var chatframe = $("y_dv_chat_frame");
    chatframe.scrollTop = chatframe.scrollHeight;
}

function YFN_ChatCloseSend()
{
    var reqUrl = YGV_Path + "/chat_proc.php";
    var data   = "";
    data  = "";
    data += "sid=" + YGV_Site;
    data += "&flag=close";
    data += "&main=" + YFN_GetCookie(YGV_CookMain);
    data += "&sub=" + YFN_GetCookie(YGV_CookSub);
    //document.location.href = reqUrl + "?" + data;

    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: YFN_ChatCloseAction
        }
    );
}

function YFN_ChatCloseAction(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
            YFN_ChatClose();
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}

function YFN_ChatClose()
{
    clearTimeout(YGV_ChatTimeId);
    YGV_ChatCnt = 0;
    YGV_ChatSn  = 0;
    YFN_ChatAlertClear();
    YFN_SetCookie(YGV_CookChatStart, "N", "/", "");

    $("y_dv_chat_frame").innerHTML = "";
    $("y_txa_chat").value          = "";
    $("y_dv_chat").style.display   = "none";
    $("y_sp_chatcnt").innerHTML    = parseInt($("y_sp_chatcnt").innerHTML) - 1;
    $("y_img_vc_chat").src         = YGV_SkinPath + "/vc_close.gif";

    clearTimeout(YGV_ChatMagicTimeId);
    YGV_ChatRoomTop    = 0;
    YGV_ChatRoomLeft   = 0;
    YGV_ChatRoomSpaceH = 0;
    YGV_ChatRoomSpaceW = 0;

    if (YGV_WinChatRoom)
    {
        YGV_WinChatRoom.destroy();
        YGV_WinChatRoom = null;
    }
}

function YFN_ChatKeyDown(argEvent)
{
    if (argEvent.keyCode == 13)
    {
        YFN_ChatWriteCheck();
    }
}

function YFN_ChatWriteCheck()
{
    var obj = $("y_txa_chat");
    var str = YFN_ContentCheck(obj);

    if (str != "")
    {
        YFN_ChatWriteSend(str);
    }

    obj.blur();
    obj.value = "";
    setTimeout("$('y_txa_chat').focus()", 10);
}

function YFN_ChatWriteSend(argStr)
{
    var u_mainid, u_subid, u_nick;
    u_mainid = YFN_GetCookie(YGV_CookMain);
    u_subid  = YFN_GetCookie(YGV_CookSub);
    u_nick   = YFN_GetCookie(YGV_CookNick);

    var reqUrl = YGV_Path + "/chat_proc.php";
    var data   = "";
    data  = "";
    data += "sid=" + YGV_Site;
    data += "&flag=write";
    data += "&main=" + u_mainid;
    data += "&sub=" + u_subid;
    data += "&msg=" + encodeURIComponent(argStr);
    //document.location.href = reqUrl + "?" + data;

    var ajax = new Ajax.Request(
        reqUrl,
        {
            method: 'post',
            asynchronous: true,
            postBody: data,
            requestHeaders: ["Content-type", "application/x-www-form-urlencoded; charset=utf-8"],
            onSuccess: YFN_ChatWriteAction
        }
    );

    if (u_nick == "")
    {
        u_nick = "나";
    }

    var obj = document.createElement("div");
    obj.innerHTML = "<div class=\"y_sp_chat_loger\">" + u_nick + "&nbsp;(" + u_mainid.substr(0, 4) + ") 님의 말 : </div><div class=\"y_sp_chat_logtext\">" + YFN_HtmlReg(argStr) + "</div>";
    $("y_dv_chat_frame").appendChild(obj);
    YFN_ChatScrollMove();
}

function YFN_ChatWriteAction(argXml)
{
    try
    {
        var xml    = argXml.responseXML;
        var result = xml.getElementsByTagName("result")[0].firstChild.nodeValue;

        if (result == "ok")
        {
        }
        else
        {
            alert(result);
        }
    }
    catch (e)
    {
        alert(e);
    }
}

/* notice */
function YFN_FillupNotice(argNotice)
{
    if (argNotice != "")
    {
        $("y_dv_notice").style.display = "block";
        $("y_dv_notice_title").innerHTML = "<img src=\"" +  YGV_SkinPath + "/notice.gif\" width=\"18\" height=\"15\" border=\"0\" alt=\"공지\">" + YFN_HtmlReg(argNotice);
        $("y_dv_notice_content").innerHTML = "<div>" + YFN_HtmlReg(argNotice) + "</div>";
    }
    else
    {
        YFN_NoticeClose();
    }
}

function YFN_NoticeShow()
{
    if (YGV_NoticeShow)
    {
        $("y_dv_notice_content").style.borderTop = "1px none";
        try
        {
            Effect.SlideUp("y_dv_notice_content", {duration:0.1});
        }
        catch (e)
        {
        }
        $("y_dv_notice_show").innerHTML = "<img src=\"" + YGV_SkinPath + "/down.gif\" width=\"11\" height=\"12\" border=\"0\">";
        YGV_NoticeShow = false;
    }
    else
    {
        $("y_dv_notice_content").style.borderTop = "1px dotted";
        try
        {
            Effect.SlideDown("y_dv_notice_content", {duration:0.1});
        }
        catch (e)
        {
        }
        $("y_dv_notice_show").innerHTML = "<img src=\"" + YGV_SkinPath + "/up.gif\" width=\"11\" height=\"12\" border=\"0\">";
        YGV_NoticeShow = true;
    }
}

function YFN_NoticeClose()
{
    $("y_dv_notice").style.display = "none";
    YGV_NoticeShow = false
}

/* cookie */
function YFN_GetCookie(argName)
{
    var value   = "";
    var search  = argName + "=";
    var i_start, i_end;
    var cKey;

    if (document.cookie.length > 0)
    {
        i_start = document.cookie.indexOf(search);

        if (i_start != -1)
        {
            i_start = i_start + search.length;
            i_end = document.cookie.indexOf(";", i_start);

            if (i_end == -1)
            {
                i_end = document.cookie.length;
            }

            value = unescape(document.cookie.substring(i_start, i_end));
        }
    }

    if (value == "")
    {
        // Main/Sub cookie create
        if (argName == YGV_CookMain || argName == YGV_CookSub)
        {
            cKey = YFN_MakeKey();
            cKey = cKey.replace(/\s/g, "");
            if (argName == YGV_CookMain)
            {
                YFN_SetCookie(argName, cKey, "/", 7);
            }
            else
            {
                YFN_SetCookie(argName, cKey, "/", "");
            }
            value = cKey;
        }
    }

    return value;
}

function YFN_MakeKey()
{
    var rand = parseInt(Math.random() * 100000000).toString();
    var key  = hex_md5(new Date().toGMTString() + rand);

    return key;
}

function YFN_SetCookie(argName, argValue, argPath, argExpireDays)
{
    var cookStr = "";

    cookStr += argName + "=" + escape(argValue) + "; "

    if (argPath != "")
    {
        cookStr += "path=" + argPath + "; ";
    }

    if (argExpireDays != "")
    {
        var todayDate = new Date();
        todayDate.setDate(todayDate.getDate() + argExpireDays);

        cookStr += "expires=" + todayDate.toGMTString() + "; ";
    }

    document.cookie = cookStr;
}


/* util */
function YFN_GetReferUrl()
{
    return document.referrer.toString().toLowerCase();
}

function YFN_GetCurUrl()
{
    return document.location.href.toLowerCase();
}

function YFN_TextDecoration(argObj, argDec)
{
    switch(argDec)
    {
        case "u":
            argObj.style.textDecoration = "underline";
            argObj.style.cursor         = "pointer";
            break;
        case "n":
            argObj.style.textDecoration = "none";
            break;
        default:
            break;
    }
}

function YFN_ImgOverOut(argObj, argFileName)
{
    var strSrc  = argObj.src.toLowerCase();
    var fileDir = strSrc.substr(0, strSrc.lastIndexOf("/") + 1);
    argObj.src  = fileDir + argFileName;
}

function YFN_ContentCheck(argObject)
{
    var maxlen = 500;
    var con = "";

    if (argObject)
    {
        con = argObject.value;
        con = con.replace(/(^\s*)|(\s*$)/g, "");

        if (con.length > maxlen)
        {
            con = con.substr(0, maxlen);
        }
    }

    return con;
}

function YFN_HtmlReg(argStr)
{
    var rtn = argStr;
    var regEx1 = /</g;
    var regEx2 = /http:\/\/\w+\.+\w+\S*/;

    rtn = rtn.replace(regEx1, "&lt;");
    var tmp = regEx2.exec(rtn);

    if (tmp != null)
    {
        rtn = rtn.replace(regEx2, "<a href=\"" + tmp + "\" target=\"_blank\">" + tmp + "</a>");
    }

    return rtn;
}

function YFN_UriEncode(argUri)
{
    var rtnUri = "";

    try
    {
        rtnUri = encodeURIComponent(decodeURIComponent(argUri));
    }
    catch (e)
    {
        rtnUri = encodeURIComponent(argUri);
    }

    return rtnUri;
}


/* window */
function YFN_ShowByObserver(eventName, win)
{
    var id = win.getId();

    switch (id)
    {
        case "winWriteMemo":
            YGV_WinWriteMemo = win;
            break;
        case "winReceiveMemo":
            YGV_WinReceiveMemo = win;
            break;
        case "winChatRoom":
            YGV_WinChatRoom = win;
            break;
        default:
            break;
    }
}

function YFN_CloseByObserver(eventName, win)
{
    var id = win.getId();

    switch (id)
    {
        case "winWriteMemo":
            YFN_WriteMemoClose();
            break;
        case "winReceiveMemo":
            YFN_ReceiveMemoCloseSend();
            break;
        case "winChatRoom":
            YFN_ChatCloseSend();
            break;
        default:
            break;
    }
}

function YFN_ResizeByObserver(eventName, win)
{
    var id = win.getId();

    switch (id)
    {
        case "winWriteMemo":
            YFN_ResizeWriteMemo(win);

            if (eventName == "onMaximize")
            {
                if (YGV_WriteMemoMagic == "Y") // normal --> max
                {
                    YGV_WriteMemoMagic = "N";
                }
                else if (YGV_WriteMemoMagic == "N") // max --> normal
                {
                    YGV_WriteMemoMagic = "Y";
                }
            }

            break;
        case "winReceiveMemo":
            YFN_ResizeReceiveMemo(win);

            if (eventName == "onMaximize")
            {
                if (YGV_ReceiveMemoMagic == "Y") // normal --> max
                {
                    YGV_ReceiveMemoMagic = "N";
                }
                else if (YGV_ReceiveMemoMagic == "N") // max --> normal
                {
                    YGV_ReceiveMemoMagic = "Y";
                }
            }

            break;
        case "winChatRoom":
            YFN_ResizeChatRoom(win);

            if (eventName == "onMaximize")
            {
                if (YGV_ChatRoomMagic == "Y") // normal --> max
                {
                    YGV_ChatRoomMagic = "N";
                }
                else if (YGV_ChatRoomMagic == "N") // max --> normal
                {
                    YGV_ChatRoomMagic = "Y";
                }
            }

            break;
        default:
            break;
    }
}

function YFN_MoveByObserver(eventName, win)
{
    var id = win.getId();

    switch (eventName)
    {
        case "onStartMove":
            switch (id)
            {
                case "winWriteMemo":
                    YGV_WriteMemoMagic = "N";
                    break;
                case "winReceiveMemo":
                    YGV_ReceiveMemoMagic = "N";
                    break;
                case "winChatRoom":
                    YGV_ChatRoomMagic = "N";
                    break;
                default:
                    break;
            }
            break;
        case "onEndMove":
            switch (id)
            {
                case "winWriteMemo":
                    var winTop  = parseInt(win.getLocation().top);
                    var winLeft = parseInt(win.getLocation().left);
                    var scrTop  = parseInt(WindowUtilities.getWindowScroll().top);
                    var scrLeft = parseInt(WindowUtilities.getWindowScroll().left);

                    YGV_WriteMemoTop    = winTop;
                    YGV_WriteMemoLeft   = winLeft;
                    YGV_WriteMemoSpaceH = winTop - scrTop;
                    YGV_WriteMemoSpaceW = winLeft - scrLeft;
                    YGV_WriteMemoMagic  = "Y";
                    break;
                case "winReceiveMemo":
                    var winTop  = parseInt(win.getLocation().top);
                    var winLeft = parseInt(win.getLocation().left);
                    var scrTop  = parseInt(WindowUtilities.getWindowScroll().top);
                    var scrLeft = parseInt(WindowUtilities.getWindowScroll().left);

                    YGV_ReceiveMemoTop    = winTop;
                    YGV_ReceiveMemoLeft   = winLeft;
                    YGV_ReceiveMemoSpaceH = winTop - scrTop;
                    YGV_ReceiveMemoSpaceW = winLeft - scrLeft;
                    YGV_ReceiveMemoMagic  = "Y";
                    break;
                case "winChatRoom":
                    var winTop  = parseInt(win.getLocation().top);
                    var winLeft = parseInt(win.getLocation().left);
                    var scrTop  = parseInt(WindowUtilities.getWindowScroll().top);
                    var scrLeft = parseInt(WindowUtilities.getWindowScroll().left);

                    YGV_ChatRoomTop    = winTop;
                    YGV_ChatRoomLeft   = winLeft;
                    YGV_ChatRoomSpaceH = winTop - scrTop;
                    YGV_ChatRoomSpaceW = winLeft - scrLeft;
                    YGV_ChatRoomMagic  = "Y";
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
}

function YFN_ResizeWriteMemo(argWin)
{
    var w = argWin.getSize().width;
    var h = argWin.getSize().height;

    $("y_txa_write").style.width  = (w - 20) + "px";
    $("y_txa_write").style.height = (h - 73) + "px";

    YGV_WriteMemoBW = w;
    YGV_WriteMemoBH = h;
}

function YFN_ResizeReceiveMemo(argWin)
{
    var w = argWin.getSize().width;
    var h = argWin.getSize().height;
    var h1 = parseInt(h - 96);
    var h2 = parseInt(h1 / 2);

    $("y_dv_rcv_msg").style.width  = (w - 20) + "px";
    $("y_dv_rcv_msg").style.height = (h1 - h2) + "px";
    $("y_txa_rcv").style.width  = (w - 20) + "px";
    $("y_txa_rcv").style.height = (h1 - h2) + "px";

    YGV_ReceiveMemoBW = w;
    YGV_ReceiveMemoBH = h;
}

function YFN_ResizeChatRoom(argWin)
{
    var w = argWin.getSize().width;
    var h = argWin.getSize().height;
    var w1 = parseInt((w / 3) / 2) * 2;

    $("y_dv_chat_body_left").style.width  = (w1 * 2 - 5) + "px";
    $("y_dv_chat_frame").style.width  = (w1 * 2 - 20) + "px";
    $("y_dv_chat_frame").style.height  = (h - 102) + "px";
    $("y_dv_chat_body_right").style.width = w1 + "px";
    $("y_dv_chat_user").style.height = (h - 102) + "px";
    $("y_txa_chat").style.width  = (w - 65) + "px";
    $("y_txa_chat").style.height = "40px";

    YGV_ChatRoomBW = w;
    YGV_ChatRoomBH = h;

    YFN_ChatScrollMove();
}