function toggleVisualEditorMode()
{
	if (g_bVisualEditor)
	{
		setVisualEditorMode(false);
	}
	else
	{
		setVisualEditorMode(true);
	}
	g_bVisualEditor = !g_bVisualEditor;
}

function setVisualEditorMode(bVisual)
{
	var o1 = document.getElementById(g_sVisualEditor);
	var o2 = document.getElementById(g_sVisualEditor+"_code");

	if (bVisual)
	{
		o1.innerHTML = o2.value;
		show(o1);
		show(divToolbarsVisualTags);
		hide(o2);
		o1.focus();
	}
	else
	{
		o2.value = o1.innerHTML;
		hide(o1);
		hide(divToolbarsVisualTags);
		show(o2);
		o2.focus();
	}
}



function finalizeVisualEditor()
{
	var o1 = document.getElementById(g_sVisualEditor);
	var o2 = document.getElementById(g_sVisualEditor+"_code");

	if (g_bVisualEditor==true)
	{
		var sHTML = o1.innerHTML;
	}
	else
	{
		var sHTML = o2.value;
	}
	DivVisualEditorChecker.innerHTML = sHTML;
	o2.value = DivVisualEditorChecker.innerHTML;
}


function captureEnterKey()
{
    if (event.keyCode == 13)
	{
        if (event.shiftKey == false)
		{
            var sel = document.selection.createRange();
            sel.pasteHTML('<br>');
            event.cancelBubble = true;
            event.returnValue = false;
            sel.select();
            sel.moveEnd("character", 1);
            sel.moveStart("character", 1);
            sel.collapse(false);
            return false;
        }
        else
		{
            return event.keyCode = 13;
		}
    }
}


function fx(nNewPadding)
{
	var el = event.srcElement;
	while (el.tagName!="TD")
		el = el.parentElement;
	var nPadding = parseInt(el.getAttribute("nPadding"));
	el.style.paddingTop=nPadding+nNewPadding;
}

function defx()
{
	var el = event.srcElement;
	while (el.tagName!="TD")
		el = el.parentElement;
	var nPadding = parseInt(el.getAttribute("nPadding"));
	el.style.paddingTop = nPadding;
}


function show(obj)
{
	obj.style.display = "";
}


function toggle(obj)
{
	if (obj.style.display == 'none')
		obj.style.display = '';
	else
		obj.style.display = 'none';
}


function hide(obj)
{
	obj.style.display = "none";
}

function visualTag(sTag,obj)
{
	obj.focus();
	var rng = obj.document.selection.createRange();
	switch(sTag)
	{
		case "bold":
			obj.document.execCommand("Bold",false,null);
			obj.focus();
			break;

		case "italic":
			obj.document.execCommand("Italic",false,null);
			obj.focus();
			break;

		case "underline":
			obj.document.execCommand("Underline",false,null);
			obj.focus();
			break;

		case "strike":
			obj.document.execCommand("StrikeThrough",false,null);
			obj.focus();
			break;

		case "insertImage":
			var rnd = Math.random();
			window.showModalDialog("../../aminiwini/miniwini.visualEditor.dialogInsertImage.php?rnd="+rnd,obj,"status:no;dialogWidth:460px;dialogHeight:350px");
			break;

		case "color":
			var sColor = getColorFromColorDlg();
			obj.document.execCommand("ForeColor",false,sColor);
			obj.focus();
			break;

		case "bgcolor":
			var sColor = getColorFromColorDlg();
			obj.document.execCommand("BackColor",false,sColor);
			obj.focus();
			break;

		case "hilite":
			obj.document.execCommand("BackColor",false,"FFFF00");
			obj.document.execCommand("ForeColor",false,"000000");
			break;

		case "sup":
			obj.document.execCommand("Superscript",false,null);
			obj.focus();
			break;

		case "createLink":
			var rnd = Math.random();
			window.showModalDialog("../../aminiwini/miniwini.visualEditor.dialogCreateLink.php?rnd="+rnd,obj,"status:no;dialogWidth:540px;dialogHeight:500px");
			break;

		case "insertEmoticons":
			var rnd = Math.random();
			window.showModalDialog("../../aminiwini/miniwini.visualEditor.dialogInsertEmoticons.php?rnd="+rnd,obj,"status:no;dialogWidth:500px;dialogHeight:400px");
			break;
	}
}



function setImgAlignType(sAlign)
{
	document.all.imgAlign1.className = "imgAlign";
	document.all.imgAlign2.className = "imgAlign";
	document.all.imgAlign3.className = "imgAlign";

	event.srcElement.className = "imgAlignOn";
	g_sAlign = sAlign;
}


function detectAgentVersion()
{
    var ua = window.navigator.userAgent
    var msie = ua.indexOf ("MSIE ")
    
    if ( msie > 0 )
        return parseFloat(ua.substring(msie+5,ua.indexOf(";", msie)))
    else
        return 0
}


function changeBorderColor(obj)
{
	if (detectAgentVersion()>=6)
	{
		var sColor = getColorFromColorDlg();
		obj.style.backgroundColor = sColor;
		g_sBorderColor = "#"+sColor;
	}
	else
		return;
}





function getColorFromColorDlg()
{
	var dlgHelper = document.getElementById("dlgHelper");
	if (detectAgentVersion()>=6)
	{
		sInitColor = null;
		var sColor = dlgHelper.ChooseColorDlg(sInitColor);

		sColor = sColor.toString(16);

		if (sColor.length < 6)
		{
			var sTempString = "000000".substring(0,6-sColor.length);
			sColor = sTempString.concat(sColor);
		}
		return sColor;
	}
}

function playMultimediaFile(sUri,obj)
{
        var nPlayState = obj.getAttribute("isPlaying");
        if (nPlayState==0)
        {
                el = obj.previousSibling;
                while (el.tagName!="A")
                        el = el.previousSibling;

                var oMedia = document.createElement("EMBED");
                oMedia.style.display = "block";
                oMedia.src = sUri;
                oMedia.autostart = true;
                obj.parentNode.appendChild(oMedia);

                obj.setAttribute("isPlaying",1);
        }
        else
        {
                alert("̹ Դϴ");
                return;
        }
}
