var eTime = 0.1;
var timer;
var ing = false;
var laneWidth;
var finish = false;

$(function() {
	laneWidth = $( "#laneWrap" ).width();

	$( "#runBtn" ).click(function() {
		if (!ing) {
			if ($( "#laneWrap .carWrap.choice" ).data( "num" )) {
				ing = true;
				eTime = 0.1;
				$( "#timer" ).html( "" );

				$( "#laneWrap .laneE > span" ).html( "" );
				$( "#laneWrap .laneE > span" ).removeClass( "myCar" );;
				$( "#lane"+$( "#laneWrap .carWrap.choice" ).data( "num" )+" > .laneE > SPAN" ).addClass( "myCar" );
				$( "#ready" ).css("opacity", "0");

				if (finish) {
					$( "#laneWrap .carWrap" ).animate({
						left: laneWidth+"px"
					}, 1000, "linear", function(){
						$( "#laneWrap .carWrap" ).css({
							"left": "-60px"
						});
					});

					finish = false;

					setTimeout(function() {
						car_run( $( "#laneWrap .carWrap.choice" ).data( "num" ) );
					}, 1000);
				}
				else {
					car_run( $( "#laneWrap .carWrap.choice" ).data( "num" ) );
				}
			}
			else {
				alert( "자동차를 선택하세요." );
			}
		}
	});

	$( "#selectCar > .carWrap" ).click(function(){
		if (!ing) {
			$( "#setZone .carWrap" ).removeClass( "choice" ).children( "span.choiceMark" ).html( "" );
			$( "#laneWrap .carWrap" ).removeClass( "choice" ).children( "span.choiceMark" ).html( "" );

			$( this ).addClass( "choice" ).children( "span.choiceMark" ).html( "*" );
			$( "#laneWrap .carWrap[data-num="+$( this ).data( "num" )+"]" ).addClass( "choice" ).children( "span.choiceMark" ).html( "*" );
		}
	});

});

function car_run(num) {
	$.ajax({
        url: "ajax/run.ajax.php",
		data : "proc="+"car_run"+"&num="+num,
        type: "POST",
		timeout : 10000,
        dataType: "json",
        async: false,
        cache: false,
        success: function(data) {
			if (data.msg == "OC") {
				race_ready(data.car);
			}
			else {
				alert(data.msg);
				ing = false;
			}
        },
		error: function(data) {
			alert("서버와의 연결에 문제가 있습니다.");
			ing = false;
        }
    });

	return;
}

function race_ready(car_arr) {
	$( "#ready" ).html( "Ready!" ).animate({
		opacity: "0.2"
	}, 500, "linear");

	setTimeout(function() {
		$( "#laneWrap .carWrap" ).animate({
			left: "0"
			}, 1500, "linear"
		);
	}, 500);

	setTimeout(function() {
		$( "#ready" ).animate({
			opacity: "0"
		}, 500, "linear", function(){
			$(this).html( "3" ).animate({
				opacity: "0.2"
			}, 500, "linear");
		});
	}, 1500);

	setTimeout(function() {
		$( "#ready" ).animate({
			opacity: "0"
		}, 500, "linear", function(){
			$(this).html( "2" ).animate({
				opacity: "0.2"
			}, 500, "linear");
		});
	}, 2800);

	setTimeout(function() {
		$( "#ready" ).animate({
			opacity: "0"
		}, 500, "linear", function(){
			$(this).html( "1" ).animate({
				opacity: "0.2"
			}, 500, "linear");
		});
	}, 4100);

	setTimeout(function() {
		$( "#ready" ).animate({
			opacity: "0"
		}, 500, "linear", function(){
			$(this).html( "Go!" ).animate({
				opacity: "0.2"
			}, 500, "linear");
		});
	}, 5400);

	setTimeout(function() {
		$( "#ready" ).animate({
			opacity: "0"
		}, 500, "linear", function(){
			$(this).html( "" );
			race_start(car_arr);
		});
	}, 6700);

	return;
}

function race_start(car_arr) {
	$( "#timer" ).html(eTime.toFixed(1));
	timer = setInterval("timerWrite()", 100);

	for (i=1; i<=8; i++) {
		car_ani(car_arr[i]);
	}

	return;
}

function car_ani(car) {

	$car = $( "#lane"+car.num+" > .carWrap" );

	car_move($car, car, 1);
	
	return;
}

function car_move($car, car, turn) {
	var moveWidth = (laneWidth-60)/10*turn;

	$car.animate({
		left: moveWidth+"px"
	}, car.move[turn].speed, "linear", function(){
		if (turn < 10) {
			car_move($car, car, turn+1);
		}
		else {
			$car.siblings( ".laneE" ).children( ".record" ).html( car.record.toFixed(2)+"s" );
			$car.siblings( ".laneE" ).children( ".rank" ).html( car.rank );

			if (car.rank == 8) {
				clearInterval(timer);

				$("#timer").html("");
				ing = false;

				$( "#ready" ).html( $( "#laneWrap .carWrap.choice" ).siblings( ".laneE" ).children( ".rank" ).html()+"위" ).css("opacity", "0.2");

				finish = true;
			}
		}
	});

	return;
}

function timerWrite() {
	$( "#timer" ).html(eTime.toFixed(1));
	eTime += 0.1;

	return;
}