/**********************************************************************
jQuery PopupLayer v1.0.00 - Development (Full) version

(c) 2012 Shin-lib, Kang - shinlib@naver.com
**********************************************************************/
;(function($) {
	$.extend({
		popupLayer: function(options){
			var popup_today = new Date();
			var popup_year = popup_today.getFullYear();
			var popup_month = popup_today.getMonth()+1;
			var popup_day = popup_today.getDate();
			var popup_date = popup_year+'-'+(parseInt(popup_month)<10?'0'+popup_month:popup_month)+'-'+(parseInt(popup_day)<10?'0'+popup_day:popup_day);

			options = $.extend({}, $.popupLayout.defaults, {
				date: popup_date,
				speed: options && options.speed ? options.speed : $.popupLayout.defaults.speed,
				cookie: options && options.cookie ? options.cookie : $.popupLayout.defaults.cookie,
				today: options && options.today ? options.today : $.popupLayout.defaults.today,
				close: options && options.close ? options.close : $.popupLayout.defaults.close,
				src: options && options.src ? options.src : $.popupLayout.defaults.src,
				width: options && options.width ? options.width : $.popupLayout.defaults.width,
				height: options && options.height ? options.height : $.popupLayout.defaults.height
			}, options);

			return new $.popupLayout(document.body, options);
		}
	});

	$.popupLayout = function(_obj, options){
		if($.popupLayout.getCookie(options.cookie) && $.popupLayout.getCookie(options.cookie)==options.date) return;

		var popup_layer = $('<div class="popup_layer" />');
		$(popup_layer).prependTo($(_obj));

		var popup_base = $('<ul />').prependTo($(popup_layer));
		var popup_img_area = $('<li />').prependTo($(popup_base));
		var popup_img = $('<img />').attr({'src':options.src});

		$(popup_img).prependTo($(popup_img_area)).bind('load', function(){
			var imgWidth = $(this).width();
			var imgHeight = $(this).height();

			$(popup_img).each(function(index, item){
				imgWidth += item.width;
				imgHeight += item.height;
			});

			$(this).css({'width':(options.width>0?options.width:imgWidth)+'px', 'height':(options.height>0?options.height:imgHeight)+'px'});

			var popup_today_area = $("<li class=\"popup_today\"><input type=\"checkbox\" id=\"block_today\" name=\"block_today\" style=\"vertical-align:-2px;\" /><label for=\"block_today\" style=\"cursor:pointer;\">"+options.today+"</label></li>").appendTo($(popup_base));
			var popup_close_area = $("<li class=\"popup_close\"><span>"+options.close+"</span></li>").appendTo($(popup_base));

			$.popupLayout.getWinSize(options);
			$.popupLayout.popupResize(popup_layer, options);

			$(window).bind('scroll', function(){
				$.popupLayout.getWinSize(options);
				$.popupLayout.popupResize(popup_layer, options, true);
			});

			$(window).bind('resize', function(){
				$.popupLayout.getWinSize(options);
				$.popupLayout.popupResize(popup_layer, options, true);
			});

			$('li.popup_today>:checkbox').bind('click', function(){
				$.popupLayout.hidePopupToday(popup_layer, options);
			});

			$('li.popup_close>span').bind('click', function(){
				$.popupLayout.popupClose(popup_layer, options);
			});
		});
	}

	$.popupLayout.getWinSize = function(options)
	{
		options.winWidth = $(window).width();
		options.winHeight = $(window).height();
		options.winScrollTop = $(window).scrollTop();
	}

	$.popupLayout.popupResize = function(_layer, options, _flag)
	{
		$(_layer).width($(_layer).find('ul>li:first>img').width()).css({'top':(options.winHeight/2)-($(_layer).height()/2)+options.winScrollTop, 'left':(options.winWidth/2)-($(_layer).width()/2)});
		if(!(_flag!=undefined)) $(_layer).animate({opacity:0}, 1, function(){$(this).css({'display':'block'}).animate({opacity:1}, options.speed);});
	}

	$.popupLayout.hidePopupToday = function(_layer, options)
	{
		$.popupLayout.setCookie(options.cookie, options.date);
		$.popupLayout.popupClose(_layer, options);
	}

	$.popupLayout.popupClose = function(_layer, options)
	{
		$(_layer).animate({opacity:0}, options.speed, function(){$(this).css({'display':'none'});});
	}

	$.popupLayout.setCookie = function(_name, _value)
	{
		var today = new Date();
		today.setDate(today.getDate()+1);
		document.cookie = _name+"="+escape(_value)+"; path=/; expires="+today.toGMTString();
	}

	$.popupLayout.getCookie = function(_name)
	{
		var cookies = document.cookie;
		var start = cookies.indexOf(_name+'=');
		var end = cookies.indexOf(';', start);
		if(start!=-1){
			start += _name.length+1;
			if(end!=-1) return cookies.substring(start, end);
			else return cookies.substring(start);
		}else{
			return '';
		}
	}

	$.popupLayout.defaults = {
		date: '0000-00-00',
		speed: 500,
		cookie: 'popupToday',
		today: '오늘 하루 이 창을 열지 않음',
		close: '[닫기]',
		src: '',
		width: 0,
		height: 0,
		winWidth: 0,
		winHeight: 0,
		winScrollTop: 0
	}
})(jQuery);