var harogi = {};
harogi.xhr = {};

harogi.xhr.Request = function(url, params, callback, method) {
	this.url = url;
	this.params = params;
	this.callback = callback;
	this.method = method;
	this.send();
}
harogi.xhr.Request.prototype = {
	getXMLHttpRequest: function() {
		if (window.ActiveXObject) {
			try {
				return new ActiveXObject("Msxml2.XMLHTTP");
			} catch(e) {
				try {
					return new ActiveXObject("Microsoft.XMLHTTP");
				} catch(e1) { return null; }
			}
		} else if (window.XMLHttpRequest) {
			return new XMLHttpRequest();
		} else {
			return null;
		}		
	},
	send: function() {
		this.req = this.getXMLHttpRequest();
		
		var httpMethod = this.method ? this.method : 'GET';
		if (httpMethod != 'GET' && httpMethod != 'POST') {
			httpMethod = 'GET';
		}
		var httpParams = (this.params == null || this.params == '') ? 
		                 null : this.params;
		var httpUrl = this.url;
		if (httpMethod == 'GET' && httpParams != null) {
			httpUrl = httpUrl + "?" + httpParams;
		}
		this.req.open(httpMethod, httpUrl, true);
		this.req.setRequestHeader(
			'Content-Type', 'application/x-www-form-urlencoded');
		var request = this;
		this.req.onreadystatechange = function() {
			request.onStateChange.call(request);
		}
		this.req.send(httpMethod == 'POST' ? httpParams : null);
	},
	onStateChange: function() {
		this.callback(this.req);
	}
}

harogi.Event = {};
harogi.Event.addListener = function(element, name, observer, useCapture) {
    useCapture = useCapture || false;

	if (element.addEventListener) {
		element.addEventListener(name, observer, useCapture);
	} else if (element.attachEvent) {
		element.attachEvent('on' + name, observer);
	}
}
harogi.Event.removeListener = function(element, name, observer, useCapture) {
	useCapture = useCapture || false;
	
	if (element.removeEventListener) {
		element.removeEventListener(name, observer, useCapture);
	} else if (element.detachEvent) {
		element.detachEvent('on' + name, observer);
	}
}
harogi.Event.getTarget = function(event) {
	if (event == null) return null;
	if (event.target) return event.target;
	else if (event.srcElement) return event.srcElement;
	return null;
}
harogi.Event.getMouseXY = function(event) {
	var mouseX = event.clientX;
	var mouseY = event.clientY;
	
	var dd = document.documentElement;
	var db = document.body;
	if (dd) {
		mouseX += dd.scrollLeft;
		mouseY += dd.scrollTop;
	} else if (db) {
		mouseX += db.scrollLeft;
		mouseY += db.scrollTop;
	}
	return {x: mouseX, y: mouseY};
}
harogi.Event.isLeftButton= function(event) {
	return (event.which) ? 
	       event.which == 1 && event.button == 0 :
	       (event.type == 'click') ? event.button == 0 : event.button == 1;
}
harogi.Event.isRightButton = function(event) {
	return event.button == 2;
}
harogi.Event.stopPropagation = function(event) {
	if (event.stopPropagation) {
	    event.stopPropagation();
	} else {
	    event.cancelBubble = true;
	}
}
harogi.Event.preventDefault = function(event) {
	if (event.preventDefault) {
	    event.preventDefault();
	} else {
	    event.returnValue = false;
	}
}
harogi.Event.stopEvent = function(event) {
	harogi.Event.stopPropagation(event);
	harogi.Event.preventDefault(event);
}
harogi.Event.bindAsListener = function(func, obj) {
	return function() {
		return func.apply(obj, arguments);
	}
}

harogi.GUI = {};
harogi.GUI.setOpacity = function(el, opacity) {
	if (el.filters) {
		el.style.filter = 'alpha(opacity=' + opacity * 100 + ')';
	} else {
		el.style.opacity = opacity;
	}
}
harogi.GUI.getStyle = function(el, property) {
	var value = null;
	var dv = document.defaultView;
	
	if (property == 'opacity' && el.filters) {// IE opacity
		value = 1;
		try {
			value = el.filters.item('alpha').opacity / 100;
		} catch(e) {}
	} else if (el.style[property]) {
		value = el.style[property];
	} else if (el.currentStyle && el.currentStyle[property]) {
		value = el.currentStyle[property];
	} else if ( dv && dv.getComputedStyle ) {
		// 빮ڸ ҹڷ ȯϰ  տ '-' δ.
		var converted = '';
		for(i = 0, len = property.length;i < len; ++i) {
			if (property.charAt(i) == property.charAt(i).toUpperCase()) {
				converted = converted + '-' + 
				            property.charAt(i).toLowerCase();
			} else {
				converted = converted + property.charAt(i);
			}
		}
		if (dv.getComputedStyle(el, '').getPropertyValue(converted)) {
			value = dv.getComputedStyle(el, '').getPropertyValue(converted);
		}
	}
	return value;
}

harogi.GUI.getXY = function(el) {
	// el  ԵǾ ־ ϰ, ȭ鿡  Ѵ.
	if (el.parentNode === null || el.style.display == 'none') {
		return false;
	}
	
	var parent = null;
	var pos = [];
	var box;
	
	if (document.getBoxObjectFor) { // gecko  
		box = document.getBoxObjectFor(el);
		pos = [box.x, box.y];
	} else { // Ÿ 
		pos = [el.offsetLeft, el.offsetTop];
		parent = el.offsetParent;
		if (parent != el) {
			while (parent) {
				pos[0] += parent.offsetLeft;
				pos[1] += parent.offsetTop;
				parent = parent.offsetParent;
			}
		}
		//  ĸ 'absolute' postion 
		// body offsetTop ߸ ϹǷ ؾ Ѵ.
		var ua = navigator.userAgent.toLowerCase();
		if (
			ua.indexOf('opera') != -1
			|| ( ua.indexOf('safari') != -1 && this.getStyle(el, 'position') == 'absolute' )
		) {
			pos[1] -= document.body.offsetTop;
		}
	}
	
	if (el.parentNode) { parent = el.parentNode; }
	else { parent = null; }
	
	// body Ǵ html ̿ θ  ߿ ũѵǾ ִ
	//  ִٸ ˸° óѴ.
	while (parent && parent.tagName != 'BODY' && parent.tagName != 'HTML') {
		pos[0] -= parent.scrollLeft;
		pos[1] -= parent.scrollTop;
		
		if (parent.parentNode) { parent = parent.parentNode; }
		else { parent = null; }
	}
	return {x: pos[0], y: pos[1]};
}
harogi.GUI.getX = function(el) {
	return harogi.GUI.getXY(el).x;
}
harogi.GUI.getY = function(el) {
	return harogi.GUI.getXY(el).y;
}
harogi.GUI.getBounds = function(el) {
	var xy = harogi.GUI.getXY(el);
	return {
		x: xy.x,
		y: xy.y,
		width: el.offsetWidth,
		height: el.offsetHeight
	};
}
harogi.GUI.setXY = function(el, x, y) {
	var pageXY = harogi.GUI.getXY(el);
	if (pageXY === false) { return false; }
	var position = harogi.GUI.getStyle(el, 'position');
	if (!position || position == 'static') {
		el.style.position = 'relative';
	}
	var delta = {
		x: parseInt( harogi.GUI.getStyle(el, 'left'), 10 ),
		y: parseInt( harogi.GUI.getStyle(el, 'top'), 10 )
	};
	if ( isNaN(delta.x) ) { delta.x = 0; }
	if ( isNaN(delta.y) ) { delta.y = 0; }
	
	if (x != null) {
		el.style.left = (x - pageXY.x + delta.x) + 'px';
	}
	if (y != null) {
		el.style.top = (y - pageXY.y + delta.y) + 'px';
	}
	
	return true;
}

harogi.dnd = {};

harogi.dnd.SimpleDragSource = function(elementId) {
	this.element = document.getElementById(elementId);
	this.dragging = false; //  巡  ǥ
	this.selected = false; //  콺ٿ  ǥ
	this.diff = null; // 콺 ġ ü ġ
	
	this.mouseDown = harogi.Event.bindAsListener(this.doMouseDown, this);
	this.mouseMove = harogi.Event.bindAsListener(this.doMouseMove, this);
	this.mouseUp = harogi.Event.bindAsListener(this.doMouseUp, this);
	
	harogi.Event.addListener(
		this.element, "mousedown", this.mouseDown);
}
harogi.dnd.SimpleDragSource.prototype = {
	doMouseDown: function(e) {
		var event = window.event || e;
		if (!harogi.Event.isLeftButton(event)) return;
		
		this.selected = true;
		
		var elementXY = harogi.GUI.getXY(this.element);
		var mouseXY = harogi.Event.getMouseXY(event);
		this.diff = {
			x: mouseXY.x - elementXY.x,
			y: mouseXY.y - elementXY.y
		};
		
		harogi.Event.addListener(document, "mousemove", this.mouseMove);
		harogi.Event.addListener(document, "mouseup", this.mouseUp);
		harogi.Event.stopEvent(event);
	},
	doMouseMove: function(e) {
		if (!this.selected) return false;
		
		if (!this.dragging) {
			this.dragging = true;
			harogi.GUI.setOpacity(this.element, 0.60);
		}
		
		var event = window.event || e;
		var mouseXY = harogi.Event.getMouseXY(event);
		var newXY = {
			x: mouseXY.x - this.diff.x,
			y: mouseXY.y - this.diff.y
		}
		harogi.GUI.setXY(this.element, newXY.x, newXY.y);
		
		harogi.Event.stopEvent(event);
	},
	doMouseUp: function(e) {
		if (!this.selected) return;
		
		this.selected = false;
		this.diff = null;
		
		var event = window.event || e;
		if (this.dragging) {
			this.dragging = false;
			harogi.GUI.setOpacity(this.element, 1.0);
		}
		harogi.Event.removeListener(
			document, "mousemove", this.mouseMove);
		harogi.Event.removeListener(
			document, "mouseup", this.mouseUp);
		harogi.Event.stopEvent(event);
	}
}



harogi.dnd.DNDManager = function() {
	this.dropTargetList = new Array();
	this.dragSourceList = new Array();
	
	this.mouseDown = harogi.Event.bindAsListener(this.doMouseDown, this);
	this.mouseMove = harogi.Event.bindAsListener(this.doMouseMove, this);
	this.mouseUp = harogi.Event.bindAsListener(this.doMouseUp, this);
	
	this.selectedDragSource = null;
}
harogi.dnd.DNDManager.prototype = {
	addDropTarget: function(dropTarget) {
		this.dropTargetList[this.dropTargetList.length] = dropTarget;
	},
	removeDropTarget: function(dropTarget) {
		var newList = new Array();
		for (var i = 0 ; i < this.dropTargetList.length ; i++) {
			if (this.dropTargetList[i] != dropTarget) {
				newList[newList.length] = this.dropTargetList[i];
			}
		}
		this.dropTargetList = newList;
	},
	addDragSource: function(dragSource) {
		this.dragSourceList[this.dragSourceList.length] = dragSource;
		harogi.Event.addListener(dragSource.getElement(),
		                       "mousedown", this.mouseDown);
	},
	removeDragSource: function(dragSource) {
		var newList = new Array();
		for (var i = 0 ; i < this.dropTargetList.length ; i++) {
			if (this.dragSourceList[i] != dragSource) {
				newList[newList.length] = this.dragSourceList[i];
			} else {
				harogi.Event.removeListener(
					dragSource.getElement(),
					"mousedown", this.mouseDown);
			}
		}
		this.dragSourceList = newList;
	},
	doMouseDown: function(e) {
		var event = window.event || e;
		if (!harogi.Event.isLeftButton(event)) return;
		
		var target = harogi.Event.getTarget(event);
		
		while (target && !target.dragSource) {
			target = target.parentNode;
		}
		this.selectedDragSource = target.dragSource;
		this.selectedDragSource.selectDrag(event);
		
		harogi.Event.addListener(document, "mousemove", this.mouseMove);
		harogi.Event.addListener(document, "mouseup", this.mouseUp);
		harogi.Event.stopEvent(event);
	},
	doMouseMove: function(e) {
		if (!this.selectedDragSource) return;

		var event = window.event || e;
		if (!this.selectedDragSource.isDragging()) {
			this.selectedDragSource.startDrag();
		}
		
		this.selectedDragSource.moveDrag(event);
		
		harogi.Event.stopEvent(event);
	},
	doMouseUp: function(e) {
		if (!this.selectedDragSource) return;
		
		var dragSource = this.selectedDragSource;
		this.selectedDragSource = null;
		
		var event = window.event || e;
		
		dragSource.deselectDrag(event);
		
		if (dragSource.isDragging()) {
			var mouseXY = harogi.Event.getMouseXY(event);
			
			var dropTarget = null;
			for (var i = 0 ; i < this.dropTargetList.length ; i++) {
				var droppable = this.dropTargetList[i].checkInDropTarget(
					dragSource, mouseXY);
				if (droppable) {
					dropTarget = this.dropTargetList[i];
					break;
				}
			}
			if (dropTarget) {
				dragSource.endDrag(event);
				dropTarget.drop(dragSource);
			} else {
				dragSource.cancelDrag(event);
			}
		}
		harogi.Event.removeListener(
			document, "mousemove", this.mouseMove);
		harogi.Event.removeListener(
			document, "mouseup", this.mouseUp);
		harogi.Event.stopEvent(event);
	}
}

harogi.dnd.DropTarget = function(elementId) {
	this.element = document.getElementById(elementId);
}
harogi.dnd.DropTarget.prototype = {
	checkInDropTarget: function(dragSource, mouseXY) {
		var bounds = harogi.GUI.getBounds(this.element);
		return bounds.x <= mouseXY.x && bounds.x + bounds.width >= mouseXY.x &&
		       bounds.y <= mouseXY.y && bounds.y + bounds.height >= mouseXY.y;
	},
	drop: function(dragSource) {
		var element = dragSource.getElement();
		this.element.appendChild(element);
	}
}

harogi.dnd.DragSource = function(elementId) {
	this.element = document.getElementById(elementId);
	this.element.dragSource = this;
	this.selected = false;
	this.dragging = false;
	this.diff = null;
}
harogi.dnd.DragSource.prototype = {
	getElement: function() {
		return this.element;
	},
	selectDrag: function(event) {
		this.selected = true;
		
		var elementXY = harogi.GUI.getBounds(this.element);
		var mouseXY = harogi.Event.getMouseXY(event);
		this.diff = {
			x: mouseXY.x - elementXY.x,
			y: mouseXY.y - elementXY.y
		};
	},
	deselectDrag: function(event) {
		this.selected = false;
		this.diff = null;
	},
	startDrag: function(event) {
		this.dragging = true;
		
		var elementXY = harogi.GUI.getBounds(this.element);
		this.element.style.position = "absolute";
		harogi.GUI.setOpacity(this.element, 0.60);
	},
	isDragging: function() {
		return this.dragging;
	},
	moveDrag: function(event) {
		var mouseXY = harogi.Event.getMouseXY(event);
		var newXY = {
			x: mouseXY.x - this.diff.x,
			y: mouseXY.y - this.diff.y
		}
		harogi.GUI.setXY(this.element, newXY.x, newXY.y);
	},
	endDrag: function(event) {
		this.dragging = false;
		this.element.style.position = "";
		harogi.GUI.setOpacity(this.element, 1.0);
		this.element.parentNode.removeChild(this.element);
	},
	cancelDrag: function(event) {
		this.dragging = false;
		this.element.style.position = "";
		harogi.GUI.setOpacity(this.element, 1.0);
	}
}
