<?php
/**
 * 다운로드 광고 플러그인 플러그인 
 *
 * @package net.lovelyus.g4.plugin.download_ads
 * @author Chongmyung Park <byfun@byfun.com>
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 */
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

$luDownload_ads = new LUDownload_ads();
$luDownload_ads->hook($gp_scope);

/**
 * 
 * 
 * @author Chongmyung Park <byfun@byfun.com> 
 * @copyright Chongmyung Park
 * @license GPLv2 License http://www.gnu.org/licenses/gpl-2.0.html
 * @link http://lovelyus.net
 */
class LUDownload_ads
{
  var $id;
  var $scope;
  var $plugin_url;
  var $plugin_path;
  var $do_url;

  /**
   * hook : gpf 후킹
   * 
   * @access public
   * @return void
   */
	function hook($gp_scope)
	{ 
		$this->scope = $gp_scope;
		$this->id = gp_plugin_id(__FILE__);
    $this->plugin_path = dirname(__FILE__);
    $this->plugin_url = gp_plugin_url(__FILE__);

		$this->do_url = GP_URL . '/do.php?scope='.$this->scope.'&bo_table='.$bo_table.'&wr_id='.$wr_id.'&id='.$this->id.'&act=';

		gp_add_filter('gpa_settings', array($this, 'plugin_setting'), 10);
		gp_add_action('pxa_save_setting', array($this, 'plugin_save_setting'));
		gp_add_filter('gpa_menu_plugin_'.$this->id, array($this, 'plugin_menu'));
		gp_add_action('pxa_install', array($this, 'plugin_install'));
		gp_add_action('pxa_uninstall', array($this, 'plugin_uninstall'));

    gp_add_action('pre_download.tail', array($this, 'on_download'));
	}

  function on_download()
  {
    global $bo_table, $wr_id, $dn_token;
    $sess_name = 'ss_down_ads_'.$bo_table.'_'.$wr_id;
    $sess_token = get_session($sess_name);
    if(!empty($sess_token) && $sess_token == $dn_token) {
      set_session($sess_name, false);
      return;
    }
    set_session($sess_name, $token = uniqid(time()));
    extract($GLOBALS);
    $target_id = ($this->scope == GP_SCOPE_BOARD ? 'board/'.$bo_table : 'group/'.$gr_id);
    $plugin_config = sql_fetch(" SELECT * FROM gpf_download_ads WHERE target_id = '{$target_id}' ");
    include_once $this->plugin_path.DS.'tpl'.DS.'download.ad.php';
    exit;
  }

  /**
   * 설정페이지에 항목 추가
   * 
   * @param mixed $gpa_settings 
   * @access public
   * @return void
   */
	function plugin_setting($gpa_settings)
	{
		array_push($gpa_settings, array('ID'=>$this->id, 'title'=>'다운로드 광고', 'print_contents'=>array($this, 'plugin_config_contents'), 'order'=>10) );
		return $gpa_settings;
	}

	
  /**
   * 플러그인 설정 페이지
   * 
   * @access public
   * @return void
   */
	function plugin_config_contents()
	{
    global $bo_table, $gr_id;
		$plugin_id = $this->id;
		$plugin_path = $this->plugin_path;
		$plugin_url = $this->plugin_url;
    $target_id = ($bo_table ? 'board/'.$bo_table : 'group/'.$gr_id);
    $plugin_config = sql_fetch(" SELECT * FROM gpf_download_ads WHERE target_id = '{$target_id}' ");
		include_once $this->plugin_path."/tpl/config.form.php";
	}

  /**
   * 설정 저장
   * 
   * @access public
   * @return void
   */
	function plugin_save_setting()
  {
    $cfg = $_REQUEST['plugin_config'];
    $bo_table = $_REQUEST['bo_table'];
    $gr_id = $_REQUEST['gr_id'];

    $target_id = ($bo_table ? 'board/'.$bo_table : 'group/'.$gr_id);

    if(empty($cfg['ad1']) && empty($cfg['ad2']) )
    {
      sql_query(" DELETE FROM gpf_download_ads WHERE target_id = '{$target_id}' ");
    } else {
      $ex = sql_fetch(" SELECT * FROM gpf_download_ads WHERE target_id = '{$target_id}' ");
      if($ex) {
        sql_query(" UPDATE gpf_download_ads SET ad1='{$cfg['ad1']}', ad2='{$cfg['ad2']}' WHERE target_id='{$target_id}' ");
      } else {
        sql_query(" INSERT INTO gpf_download_ads SET target_id='{$target_id}', ad1='{$cfg['ad1']}', ad2='{$cfg['ad2']}', reg_date='".G4_TIME_YMDHIS."'");
      }
    }
		alert('다운로드 광고 플러그인 플러그인 설정 저장 완료');
	}


  /**
   * plugins 페이지에 메뉴 추가
   * 
   * @param mixed $menus 
   * @access public
   * @return void
   */
	function plugin_menu($menus)
	{
		global $bo_table;

		if(gp_table_exists('gpf_download_ads')) 
		{
		  array_push($menus, array('href'=>gp_url('setting.php', $this->scope, $noqm=false, $this->id), 'text'=>'설정'));
			array_push($menus, array('href'=>gp_url('admin_do.php', $this->scope).'&id='.$this->id.'&act=uninstall', 'attr'=>'onclick="return confirm(\'등록된 모든 DB 정보가 삭제됩니다.\\n진행하시겠습니까?\');"', 'text'=>'DB삭제'));
		} else {
			array_push($menus, array('href'=>gp_url('admin_do.php', $this->scope).'&id='.$this->id.'&act=install', 'text'=>'DB생성', 'attr'=>''));
		}
		return $menus;
	}

	
  /**
   * 플러그인 설치
   * 
   * @access public
   * @return void
   */
	function plugin_install()
	{
		$install_script =<<<EOF
		CREATE TABLE IF NOT EXISTS `gpf_download_ads` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `target_id` varchar(50) NOT NULL,
		  `ad1` text NOT NULL,
		  `ad2` text NOT NULL,
		  `reg_date` datetime NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;
;
EOF;
		$f = explode(";", $install_script);
		for ($i=0; $i<count($f); $i++) {
			if (trim($f[$i]) == "") continue;
			sql_query($f[$i]);
		}
		goto_url(gp_url('plugins.php', $this->scope));
	}

	
  /**
   * 플러그인 제거
   * 
   * @access public
   * @return void
   */
	function plugin_uninstall()
	{
		sql_query("DROP TABLE gpf_download_ads", false);
		gp_deactivate_plugin($this->id, $this->scope);
		goto_url(gp_url('plugins.php', $this->scope));
	}
}
?>
