<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

$res = sql_query("SELECT * FROM gpf_pointer ORDER BY reg_date DESC");
$list = array();
while($row = sql_fetch_array($res))
{
  $row['bo_tables'] = array();

  if($row['evt_type'] != 'login')
  {
    $res2 = sql_query("SELECT * FROM gpf_pointer_tables WHERE evt_id = '{$row['id']}'");
    while($row2 = sql_fetch_array($res2))
    {
      array_push($row['bo_tables'], $row2['bo_table']);
      if($row2['bo_table'] == '*') 
      {
        $row['bo_tables'] = array('*');
        break;   
      }
    }
  } 
  array_push($list, $row);
}

function ptr_time($time)
{
  return substr($time, 0, 2).'시 '. substr($time, 3, 2).'분';
}
include_once dirname(__FILE__).'/_head.php';
?>

<h2>이벤트 포인트</h2>
<div class="ptr_right">
  <a href="<?php echo $px_url; ?>&act=ptr_event_point_add" class="ptr_btn">이벤트 추가하기</a>
</div>

<?php 
$type_string = array('login' => '로그인', 'write'=>'글을 작성', 'write_comment'=>'댓글을 작성');
$total = count($list);
foreach($list as $k=>$row) { 
?>
<div class="ptr_event">
  <div class="evt_num"><?php echo ($total-$k); ?></div>
  <div class="evt_body">
    <div class="evt_name"><?php echo $row['evt_name']; ?></div>
    회원 레벨 
    <span class="evt_level_from"><?php echo $row['mb_level_from']; ?></span>~<span class="evt_level_to"><?php echo $row['mb_level_to']; ?></span>인 회원들이
    <span class="evt_date_from"><?php echo date("Y년 m월 d일", strtotime($row['date_from'])); ?></span>부터
    <span class="evt_date_to"><?php echo date("Y년 m월 d일", strtotime($row['date_to'])); ?></span>,
    <span class="evt_time_from"><?php echo ptr_time($row['time_from']); ?></span>~
    <span class="evt_time_to"><?php echo ptr_time($row['time_to']); ?></span> 사이에 
    <?php if($row['evt_type'] != 'login') { 
      $tbls = implode(", ", $row['bo_tables']);
      if($tbls == "*") $tbls = '모든';
    ?>
      <span class="evt_bo_tables"><?php echo $tbls; ?></span> 게시판에
    <?php } ?>
    <span class="evt_type"><?php echo $type_string[$row['evt_type']]; ?></span> 하면
    <span class="evt_point"><?php echo number_format($row['point']); ?></span> 포인트를 
    <?php if($row['cutline_gives'] > 0) { ?>
    선착순 <span class="evt_gives"><?php echo number_format($row['cutline_gives']); ?></span>명의 회원에게
    <?php } ?>
    <span class="evt_prob"><?php echo $row['probability']; ?>%</span> 확률로 지급합니다.<br/>
    포인트 지급 내역에는 
    '<span class="evt_content"><?php echo $row['content']; ?></span>' 로 기록합니다. 
  </div>
  <div class="evt_delete">
    <a href="<?php echo $px_url; ?>&act=ptr_event_point_add&eid=<?php echo $row['id']; ?>" class="ptr_btn">수정</a>
    <a href="javascript:ptr_delete_event('<?php echo $row['id']; ?>');" class="ptr_btn">삭제</a>
  </div>
</div>
<?php
}
if(empty($list)) echo '<div class="ptr_noevent">등록된 이벤트가 없습니다.</div>';
?>

<script type="text/javascript">
function ptr_delete_event(eid)
{
  if(!confirm('이벤트를 삭제 하시겠습니까?')) return;
  location.href = '<?php echo $px_url; ?>&act=ptr_event_point_exe&md=ptr_delete_event&eid='+eid;
}
</script>

<?php
include_once dirname(__FILE__).'/_tail.php';
?>
